/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.function.Supplier;
import org.hibernate.MappingException;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.resource.beans.spi.ManagedBean;
import org.hibernate.usertype.UserCollectionType;

public abstract class IdentifierCollection
extends Collection {
    public static final String DEFAULT_IDENTIFIER_COLUMN_NAME = "id";
    private KeyValue identifier;

    public IdentifierCollection(MetadataBuildingContext buildingContext, PersistentClass owner) {
        super(buildingContext, owner);
    }

    public IdentifierCollection(Supplier<ManagedBean<? extends UserCollectionType>> customTypeBeanResolver, PersistentClass owner, MetadataBuildingContext buildingContext) {
        super(customTypeBeanResolver, owner, buildingContext);
    }

    public KeyValue getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(KeyValue identifier) {
        this.identifier = identifier;
    }

    @Override
    public final boolean isIdentified() {
        return true;
    }

    @Override
    public boolean isSame(Collection other) {
        return other instanceof IdentifierCollection && this.isSame((IdentifierCollection)other);
    }

    public boolean isSame(IdentifierCollection other) {
        return super.isSame(other) && IdentifierCollection.isSame(this.identifier, other.identifier);
    }

    @Override
    void createPrimaryKey() {
        if (!this.isOneToMany()) {
            PrimaryKey pk = new PrimaryKey(this.getCollectionTable());
            pk.addColumns(this.getIdentifier());
            this.getCollectionTable().setPrimaryKey(pk);
        }
    }

    @Override
    public void validate(Mapping mapping) throws MappingException {
        super.validate(mapping);
        assert (this.getElement() != null) : "IdentifierCollection identifier not bound : " + this.getRole();
        if (!this.getIdentifier().isValid(mapping)) {
            throw new MappingException("collection id mapping has wrong number of columns: " + this.getRole() + " type: " + this.getIdentifier().getType().getName());
        }
    }
}

