/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.ArrayList;
import java.util.Map;
import org.hibernate.MappingException;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.MappingHelper;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.ValueVisitor;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;

public class ManyToOne
extends ToOne {
    private boolean ignoreNotFound;
    private boolean isLogicalOneToOne;
    private Type resolvedType;

    public ManyToOne(MetadataBuildingContext buildingContext, Table table) {
        super(buildingContext, table);
    }

    @Override
    public Type getType() throws MappingException {
        if (this.resolvedType == null) {
            this.resolvedType = MappingHelper.manyToOne(this.getReferencedEntityName(), this.isReferenceToPrimaryKey(), this.getReferencedPropertyName(), this.getPropertyName(), this.isLogicalOneToOne(), this.isLazy(), this.isUnwrapProxy(), this.isIgnoreNotFound(), this.getBuildingContext());
        }
        return this.resolvedType;
    }

    @Override
    public void createForeignKey() {
        this.sortProperties();
        if (this.referencedPropertyName == null && !this.hasFormula()) {
            this.createForeignKeyOfEntity(((EntityType)this.getType()).getAssociatedEntityName());
        }
    }

    @Override
    public void createUniqueKey() {
        if (!this.hasFormula()) {
            this.getTable().createUniqueKey(this.getConstraintColumns());
        }
    }

    public void createPropertyRefConstraints(Map<String, PersistentClass> persistentClasses) {
        if (this.referencedPropertyName != null) {
            this.sortProperties();
            PersistentClass pc = persistentClasses.get(this.getReferencedEntityName());
            Property property = pc.getReferencedProperty(this.getReferencedPropertyName());
            if (property == null) {
                throw new MappingException("Could not find property " + this.getReferencedPropertyName() + " on " + this.getReferencedEntityName());
            }
            if (property.getValue() instanceof Component) {
                ((Component)property.getValue()).sortProperties();
            }
            if (!this.hasFormula() && !"none".equals(this.getForeignKeyName())) {
                ForeignKey fk = this.getTable().createForeignKey(this.getForeignKeyName(), this.getConstraintColumns(), ((EntityType)this.getType()).getAssociatedEntityName(), this.getForeignKeyDefinition(), new ArrayList<Column>(property.getColumns()));
                fk.setCascadeDeleteEnabled(this.isCascadeDeleteEnabled());
            }
        }
    }

    @Override
    public Object accept(ValueVisitor visitor) {
        return visitor.accept(this);
    }

    public boolean isIgnoreNotFound() {
        return this.ignoreNotFound;
    }

    public void setIgnoreNotFound(boolean ignoreNotFound) {
        this.ignoreNotFound = ignoreNotFound;
    }

    public void markAsLogicalOneToOne() {
        this.isLogicalOneToOne = true;
    }

    public boolean isLogicalOneToOne() {
        return this.isLogicalOneToOne;
    }
}

