/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.function.Supplier;
import org.hibernate.MappingException;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.mapping.IndexedCollection;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.ValueVisitor;
import org.hibernate.resource.beans.spi.ManagedBean;
import org.hibernate.type.CollectionType;
import org.hibernate.type.MapType;
import org.hibernate.type.OrderedMapType;
import org.hibernate.type.SortedMapType;
import org.hibernate.usertype.UserCollectionType;

public class Map
extends IndexedCollection {
    private String mapKeyPropertyName;

    public Map(MetadataBuildingContext buildingContext, PersistentClass owner) {
        super(buildingContext, owner);
    }

    public Map(Supplier<ManagedBean<? extends UserCollectionType>> customTypeBeanResolver, PersistentClass owner, MetadataBuildingContext buildingContext) {
        super(customTypeBeanResolver, owner, buildingContext);
    }

    @Override
    public boolean isMap() {
        return true;
    }

    public String getMapKeyPropertyName() {
        return this.mapKeyPropertyName;
    }

    public void setMapKeyPropertyName(String mapKeyPropertyName) {
        this.mapKeyPropertyName = mapKeyPropertyName;
    }

    @Override
    public CollectionType getDefaultCollectionType() {
        if (this.isSorted()) {
            return new SortedMapType(this.getRole(), this.getReferencedPropertyName(), this.getComparator());
        }
        if (this.hasOrder()) {
            return new OrderedMapType(this.getRole(), this.getReferencedPropertyName());
        }
        return new MapType(this.getRole(), this.getReferencedPropertyName());
    }

    @Override
    public void createAllKeys() throws MappingException {
        super.createAllKeys();
        if (!this.isInverse()) {
            this.getIndex().createForeignKey();
        }
    }

    @Override
    public Object accept(ValueVisitor visitor) {
        return visitor.accept(this);
    }
}

