/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.internal;

import java.util.function.Supplier;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.metamodel.RepresentationMode;
import org.hibernate.metamodel.internal.EmbeddableRepresentationStrategyMap;
import org.hibernate.metamodel.internal.EmbeddableRepresentationStrategyPojo;
import org.hibernate.metamodel.internal.EntityRepresentationStrategyMap;
import org.hibernate.metamodel.internal.EntityRepresentationStrategyPojoStandard;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.spi.EmbeddableInstantiator;
import org.hibernate.metamodel.spi.EmbeddableRepresentationStrategy;
import org.hibernate.metamodel.spi.EntityRepresentationStrategy;
import org.hibernate.metamodel.spi.ManagedTypeRepresentationResolver;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;

public class ManagedTypeRepresentationResolverStandard
implements ManagedTypeRepresentationResolver {
    public static final ManagedTypeRepresentationResolverStandard INSTANCE = new ManagedTypeRepresentationResolverStandard();

    @Override
    public EntityRepresentationStrategy resolveStrategy(PersistentClass bootDescriptor, EntityPersister runtimeDescriptor, RuntimeModelCreationContext creationContext) {
        RepresentationMode representation = null;
        if (representation == null) {
            representation = bootDescriptor.getMappedClass() == null ? RepresentationMode.MAP : RepresentationMode.POJO;
        }
        if (representation == RepresentationMode.MAP) {
            return new EntityRepresentationStrategyMap(bootDescriptor, creationContext);
        }
        return new EntityRepresentationStrategyPojoStandard(bootDescriptor, runtimeDescriptor, creationContext);
    }

    @Override
    public EmbeddableRepresentationStrategy resolveStrategy(Component bootDescriptor, Supplier<EmbeddableMappingType> runtimeDescriptorAccess, RuntimeModelCreationContext creationContext) {
        EmbeddableInstantiator customInstantiator;
        RepresentationMode representation = null;
        if (representation == null) {
            representation = bootDescriptor.getComponentClassName() == null ? RepresentationMode.MAP : RepresentationMode.POJO;
        }
        if (bootDescriptor.getCustomInstantiator() != null) {
            Class<? extends EmbeddableInstantiator> customInstantiatorImpl = bootDescriptor.getCustomInstantiator();
            customInstantiator = creationContext.getBootstrapContext().getServiceRegistry().getService(ManagedBeanRegistry.class).getBean(customInstantiatorImpl).getBeanInstance();
        } else {
            customInstantiator = null;
        }
        if (representation == RepresentationMode.MAP) {
            return new EmbeddableRepresentationStrategyMap(bootDescriptor, runtimeDescriptorAccess, customInstantiator, creationContext);
        }
        return new EmbeddableRepresentationStrategyPojo(bootDescriptor, runtimeDescriptorAccess, customInstantiator, creationContext);
    }
}

