/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.function.BiConsumer;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.mapping.IndexedConsumer;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.CollectionIdentifierDescriptor;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.query.spi.NavigablePath;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchOptions;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.basic.BasicFetch;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaType;

public class CollectionIdentifierDescriptorImpl
implements CollectionIdentifierDescriptor,
FetchOptions {
    private final NavigableRole navigableRole;
    private final CollectionPersister collectionDescriptor;
    private final String containingTableName;
    private final String columnName;
    private final BasicType<?> type;

    public CollectionIdentifierDescriptorImpl(CollectionPersister collectionDescriptor, String containingTableName, String columnName, BasicType<?> type) {
        this.navigableRole = collectionDescriptor.getNavigableRole().append(CollectionPart.Nature.ID.getName());
        this.collectionDescriptor = collectionDescriptor;
        this.containingTableName = containingTableName;
        this.columnName = columnName;
        this.type = type;
    }

    @Override
    public CollectionPart.Nature getNature() {
        return CollectionPart.Nature.ID;
    }

    @Override
    public String getContainingTableExpression() {
        return this.containingTableName;
    }

    @Override
    public String getSelectionExpression() {
        return this.columnName;
    }

    @Override
    public boolean isFormula() {
        return false;
    }

    @Override
    public String getCustomReadExpression() {
        return null;
    }

    @Override
    public String getCustomWriteExpression() {
        return null;
    }

    @Override
    public MappingType getPartMappingType() {
        return this.type;
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.type;
    }

    @Override
    public MappingType getMappedType() {
        return this.type;
    }

    @Override
    public JavaType<?> getJavaType() {
        return this.getMappedType().getMappedJavaType();
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.navigableRole;
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        return this.collectionDescriptor.getAttributeMapping().createDomainResult(navigablePath, tableGroup, resultVariable, creationState);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        this.collectionDescriptor.getAttributeMapping().applySqlSelections(navigablePath, tableGroup, creationState);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState, BiConsumer<SqlSelection, JdbcMapping> selectionConsumer) {
        this.collectionDescriptor.getAttributeMapping().applySqlSelections(navigablePath, tableGroup, creationState, selectionConsumer);
    }

    @Override
    public void breakDownJdbcValues(Object domainValue, ModelPart.JdbcValueConsumer valueConsumer, SharedSessionContractImplementor session) {
        valueConsumer.consume(domainValue, this);
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        return this.collectionDescriptor.getAttributeMapping().findContainingEntityMapping();
    }

    @Override
    public String getFetchableName() {
        return null;
    }

    @Override
    public FetchOptions getMappedFetchOptions() {
        return this;
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        action.accept(offset, this.getJdbcMapping());
        return this.getJdbcTypeCount();
    }

    @Override
    public Fetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, String resultVariable, DomainResultCreationState creationState) {
        FromClauseAccess fromClauseAccess = creationState.getSqlAstCreationState().getFromClauseAccess();
        TableGroup tableGroup = fromClauseAccess.getTableGroup(fetchablePath.getParent());
        SqlAstCreationState astCreationState = creationState.getSqlAstCreationState();
        SqlAstCreationContext astCreationContext = astCreationState.getCreationContext();
        SessionFactoryImplementor sessionFactory = astCreationContext.getSessionFactory();
        SqlExpressionResolver sqlExpressionResolver = astCreationState.getSqlExpressionResolver();
        SqlSelection sqlSelection = sqlExpressionResolver.resolveSqlSelection(sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableGroup.getPrimaryTableReference(), this.columnName), p -> new ColumnReference(tableGroup.getPrimaryTableReference().getIdentificationVariable(), this.columnName, false, null, null, this.type, sessionFactory)), this.type.getJavaTypeDescriptor(), sessionFactory.getTypeConfiguration());
        return new BasicFetch(sqlSelection.getValuesArrayPosition(), fetchParent, fetchablePath, this, null, FetchTiming.IMMEDIATE, creationState);
    }

    public DomainResult<?> createDomainResult(NavigablePath collectionPath, TableGroup tableGroup, DomainResultCreationState creationState) {
        SqlAstCreationState astCreationState = creationState.getSqlAstCreationState();
        SqlAstCreationContext astCreationContext = astCreationState.getCreationContext();
        SessionFactoryImplementor sessionFactory = astCreationContext.getSessionFactory();
        SqlExpressionResolver sqlExpressionResolver = astCreationState.getSqlExpressionResolver();
        SqlSelection sqlSelection = sqlExpressionResolver.resolveSqlSelection(sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableGroup.getPrimaryTableReference(), this.columnName), p -> new ColumnReference(tableGroup.getPrimaryTableReference().getIdentificationVariable(), this.columnName, false, null, null, this.type, sessionFactory)), this.type.getJavaTypeDescriptor(), sessionFactory.getTypeConfiguration());
        return new BasicResult(sqlSelection.getValuesArrayPosition(), null, this.type.getJavaTypeDescriptor(), collectionPath);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.collectionDescriptor.getRole() + ")";
    }

    @Override
    public FetchStyle getStyle() {
        return FetchStyle.JOIN;
    }

    @Override
    public FetchTiming getTiming() {
        return FetchTiming.IMMEDIATE;
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        return this.type.disassemble(value, session);
    }

    @Override
    public int forEachDisassembledJdbcValue(Object value, Clause clause, int offset, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        return this.type.forEachDisassembledJdbcValue(value, clause, offset, valuesConsumer, session);
    }
}

