/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.function.BiConsumer;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.mapping.IndexedConsumer;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.EntityRowIdMapping;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.query.spi.NavigablePath;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaType;

public class EntityRowIdMappingImpl
implements EntityRowIdMapping,
SelectableMapping {
    private final String rowIdName;
    private final EntityMappingType declaringType;
    private final String tableExpression;
    private final BasicType<Object> rowIdType;

    public EntityRowIdMappingImpl(String rowIdName, String tableExpression, EntityMappingType declaringType) {
        this.rowIdName = rowIdName;
        this.tableExpression = tableExpression;
        this.declaringType = declaringType;
        this.rowIdType = declaringType.getEntityPersister().getFactory().getTypeConfiguration().getBasicTypeForJavaType(Object.class);
    }

    @Override
    public String getRowIdName() {
        return this.rowIdName;
    }

    @Override
    public MappingType getPartMappingType() {
        return this.rowIdType;
    }

    @Override
    public JavaType<?> getJavaType() {
        return this.rowIdType.getJavaTypeDescriptor();
    }

    @Override
    public String getPartName() {
        return this.rowIdName;
    }

    @Override
    public NavigableRole getNavigableRole() {
        return null;
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        return this.declaringType;
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        SqlExpressionResolver sqlExpressionResolver = sqlAstCreationState.getSqlExpressionResolver();
        TableReference columnTableReference = tableGroup.resolveTableReference(navigablePath, this.tableExpression);
        SqlSelection sqlSelection = sqlExpressionResolver.resolveSqlSelection(sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(columnTableReference, this.rowIdName), sqlAstProcessingState -> new ColumnReference(columnTableReference, this.rowIdName, false, null, null, this.rowIdType, sqlAstCreationState.getCreationContext().getSessionFactory())), this.rowIdType.getJavaTypeDescriptor(), sqlAstCreationState.getCreationContext().getSessionFactory().getTypeConfiguration());
        return new BasicResult<Object>(sqlSelection.getValuesArrayPosition(), resultVariable, this.rowIdType.getJavaTypeDescriptor(), navigablePath);
    }

    @Override
    public int getJdbcTypeCount() {
        return 1;
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        return this.rowIdType.disassemble(value, session);
    }

    @Override
    public int forEachDisassembledJdbcValue(Object value, Clause clause, int offset, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        return this.rowIdType.forEachDisassembledJdbcValue(value, clause, offset, valuesConsumer, session);
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        action.accept(offset, this.getJdbcMapping());
        return this.getJdbcTypeCount();
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState, BiConsumer<SqlSelection, JdbcMapping> selectionConsumer) {
    }

    @Override
    public void breakDownJdbcValues(Object domainValue, ModelPart.JdbcValueConsumer valueConsumer, SharedSessionContractImplementor session) {
        valueConsumer.consume(domainValue, this);
    }

    @Override
    public String getContainingTableExpression() {
        return this.tableExpression;
    }

    @Override
    public String getSelectionExpression() {
        return this.rowIdName;
    }

    @Override
    public String getCustomReadExpression() {
        return this.rowIdName;
    }

    @Override
    public String getCustomWriteExpression() {
        return null;
    }

    @Override
    public boolean isFormula() {
        return true;
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.rowIdType.getJdbcMapping();
    }
}

