/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import org.hibernate.FetchMode;
import org.hibernate.MappingException;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.SharedSessionContract;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.collection.internal.StandardArraySemantics;
import org.hibernate.collection.internal.StandardBagSemantics;
import org.hibernate.collection.internal.StandardIdentifierBagSemantics;
import org.hibernate.collection.internal.StandardListSemantics;
import org.hibernate.collection.spi.CollectionSemantics;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Any;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.IndexedCollection;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.Map;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.OneToOne;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Resolvable;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.SortableValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.hibernate.metamodel.CollectionClassification;
import org.hibernate.metamodel.MappingMetamodel;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.CollectionMappingType;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.CompositeIdentifierMapping;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.MappingModelCreationLogger;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.PropertyBasedMapping;
import org.hibernate.metamodel.mapping.Queryable;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SelectableMappings;
import org.hibernate.metamodel.mapping.StateArrayContributorMetadata;
import org.hibernate.metamodel.mapping.StateArrayContributorMetadataAccess;
import org.hibernate.metamodel.mapping.VirtualModelPart;
import org.hibernate.metamodel.mapping.internal.AbstractAttributeMapping;
import org.hibernate.metamodel.mapping.internal.BasicAttributeMapping;
import org.hibernate.metamodel.mapping.internal.BasicValuedCollectionPart;
import org.hibernate.metamodel.mapping.internal.CollectionIdentifierDescriptorImpl;
import org.hibernate.metamodel.mapping.internal.DiscriminatedCollectionPart;
import org.hibernate.metamodel.mapping.internal.EmbeddableMappingTypeImpl;
import org.hibernate.metamodel.mapping.internal.EmbeddedAttributeMapping;
import org.hibernate.metamodel.mapping.internal.EmbeddedCollectionPart;
import org.hibernate.metamodel.mapping.internal.EmbeddedForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.internal.EmbeddedIdentifierMappingImpl;
import org.hibernate.metamodel.mapping.internal.EntityCollectionPart;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.mapping.internal.NonAggregatedIdentifierMappingImpl;
import org.hibernate.metamodel.mapping.internal.PluralAttributeMappingImpl;
import org.hibernate.metamodel.mapping.internal.SelectableMappingImpl;
import org.hibernate.metamodel.mapping.internal.SelectableMappingsImpl;
import org.hibernate.metamodel.mapping.internal.SimpleForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.metamodel.mapping.internal.VirtualEmbeddedAttributeMapping;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.collection.SQLLoadableCollection;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.persister.walking.internal.FetchOptionsHelper;
import org.hibernate.property.access.internal.ChainedPropertyAccessImpl;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.sql.ast.spi.SqlAliasStemHelper;
import org.hibernate.sql.ast.tree.from.TableGroupProducer;
import org.hibernate.tuple.ValueGeneration;
import org.hibernate.type.AssociationType;
import org.hibernate.type.BasicType;
import org.hibernate.type.ComponentType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.EntityType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.spi.JavaTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class MappingModelCreationHelper {
    private MappingModelCreationHelper() {
    }

    public static EntityIdentifierMapping buildEncapsulatedCompositeIdentifierMapping(EntityPersister entityPersister, Property bootProperty, String attributeName, String rootTableName, String[] rootTableKeyColumnNames, CompositeType cidType, MappingModelCreationProcess creationProcess) {
        PersistentClass bootEntityDescriptor = creationProcess.getCreationContext().getBootModel().getEntityBinding(entityPersister.getEntityName());
        PropertyAccess propertyAccess = entityPersister.getRepresentationStrategy().resolvePropertyAccess(bootEntityDescriptor.getIdentifierProperty());
        EmbeddableMappingTypeImpl embeddableMappingType = EmbeddableMappingTypeImpl.from((Component)bootProperty.getValue(), cidType, rootTableName, rootTableKeyColumnNames, embeddable -> new EmbeddedIdentifierMappingImpl(entityPersister, attributeName, (EmbeddableMappingType)embeddable, propertyAccess, rootTableName, creationProcess), creationProcess);
        return (EmbeddedIdentifierMappingImpl)embeddableMappingType.getEmbeddedValueMapping();
    }

    public static CompositeIdentifierMapping buildNonEncapsulatedCompositeIdentifierMapping(EntityPersister entityPersister, String rootTableName, String[] rootTableKeyColumnNames, PersistentClass bootEntityDescriptor, MappingModelCreationProcess creationProcess) {
        return new NonAggregatedIdentifierMappingImpl(entityPersister, bootEntityDescriptor.getRootClass(), rootTableName, rootTableKeyColumnNames, creationProcess);
    }

    public static BasicAttributeMapping buildBasicAttributeMapping(String attrName, NavigableRole navigableRole, int stateArrayPosition, final Property bootProperty, ManagedMappingType declaringType, BasicType attrType, String tableExpression, String attrColumnName, boolean isAttrFormula, String readExpr, String writeExpr, final PropertyAccess propertyAccess, final CascadeStyle cascadeStyle, MappingModelCreationProcess creationProcess) {
        FetchStyle fetchStyle;
        FetchTiming fetchTiming;
        final Value value = bootProperty.getValue();
        final BasicValue.Resolution<?> resolution = ((Resolvable)((Object)value)).resolve();
        BasicValueConverter valueConverter = resolution.getValueConverter();
        StateArrayContributorMetadataAccess attributeMetadataAccess = entityMappingType -> new StateArrayContributorMetadata(){
            private final MutabilityPlan mutabilityPlan;
            private final boolean nullable;
            private final boolean insertable;
            private final boolean updateable;
            private final boolean includeInOptimisticLocking;
            {
                this.mutabilityPlan = resolution.getMutabilityPlan();
                this.nullable = value.isNullable();
                this.insertable = bootProperty.isInsertable();
                this.updateable = bootProperty.isUpdateable();
                this.includeInOptimisticLocking = bootProperty.isOptimisticLocked();
            }

            @Override
            public PropertyAccess getPropertyAccess() {
                return propertyAccess;
            }

            @Override
            public MutabilityPlan getMutabilityPlan() {
                return this.mutabilityPlan;
            }

            @Override
            public boolean isNullable() {
                return this.nullable;
            }

            @Override
            public boolean isInsertable() {
                return this.insertable;
            }

            @Override
            public boolean isUpdatable() {
                return this.updateable;
            }

            @Override
            public boolean isIncludedInDirtyChecking() {
                return this.updateable;
            }

            @Override
            public boolean isIncludedInOptimisticLocking() {
                return this.includeInOptimisticLocking;
            }

            @Override
            public CascadeStyle getCascadeStyle() {
                return cascadeStyle;
            }
        };
        if (declaringType instanceof EmbeddableMappingType) {
            if (bootProperty.isLazy()) {
                MappingModelCreationLogger.LOGGER.debugf("Attribute was declared lazy, but is part of an embeddable - `%s#%s` - LAZY will be ignored", declaringType.getNavigableRole().getFullPath(), bootProperty.getName());
            }
            fetchTiming = FetchTiming.IMMEDIATE;
            fetchStyle = FetchStyle.JOIN;
        } else {
            fetchTiming = bootProperty.isLazy() ? FetchTiming.DELAYED : FetchTiming.IMMEDIATE;
            fetchStyle = bootProperty.isLazy() ? FetchStyle.SELECT : FetchStyle.JOIN;
        }
        ValueGeneration valueGeneration = bootProperty.getValueGenerationStrategy();
        if (valueConverter != null) {
            assert (valueConverter.getRelationalJavaType() == resolution.getRelationalJavaType());
            BasicType mappingBasicType = creationProcess.getCreationContext().getDomainModel().getTypeConfiguration().getBasicTypeRegistry().resolve(valueConverter.getRelationalJavaType(), resolution.getJdbcType());
            return new BasicAttributeMapping(attrName, navigableRole, stateArrayPosition, attributeMetadataAccess, fetchTiming, fetchStyle, tableExpression, attrColumnName, isAttrFormula, null, null, valueConverter, mappingBasicType.getJdbcMapping(), declaringType, propertyAccess, valueGeneration);
        }
        return new BasicAttributeMapping(attrName, navigableRole, stateArrayPosition, attributeMetadataAccess, fetchTiming, fetchStyle, tableExpression, attrColumnName, isAttrFormula, readExpr, writeExpr, null, attrType, declaringType, propertyAccess, valueGeneration);
    }

    public static EmbeddedAttributeMapping buildEmbeddedAttributeMapping(String attrName, int stateArrayPosition, Property bootProperty, ManagedMappingType declaringType, CompositeType attrType, String tableExpression, String[] rootTableKeyColumnNames, PropertyAccess propertyAccess, CascadeStyle cascadeStyle, MappingModelCreationProcess creationProcess) {
        StateArrayContributorMetadataAccess attributeMetadataAccess = MappingModelCreationHelper.getStateArrayContributorMetadataAccess(bootProperty, attrType, propertyAccess, cascadeStyle, creationProcess);
        Component component = (Component)bootProperty.getValue();
        EmbeddableMappingTypeImpl embeddableMappingType = EmbeddableMappingTypeImpl.from(component, attrType, tableExpression, rootTableKeyColumnNames, attributeMappingType -> {
            if (component.isEmbedded()) {
                return new VirtualEmbeddedAttributeMapping(attrName, declaringType.getNavigableRole().append(attrName), stateArrayPosition, tableExpression, attributeMetadataAccess, component.getParentProperty(), FetchTiming.IMMEDIATE, FetchStyle.JOIN, (EmbeddableMappingType)attributeMappingType, declaringType, propertyAccess, bootProperty.getValueGenerationStrategy());
            }
            return new EmbeddedAttributeMapping(attrName, declaringType.getNavigableRole().append(attrName), stateArrayPosition, tableExpression, attributeMetadataAccess, component.getParentProperty(), FetchTiming.IMMEDIATE, FetchStyle.JOIN, (EmbeddableMappingType)attributeMappingType, declaringType, propertyAccess, bootProperty.getValueGenerationStrategy());
        }, creationProcess);
        return (EmbeddedAttributeMapping)embeddableMappingType.getEmbeddedValueMapping();
    }

    protected static StateArrayContributorMetadataAccess getStateArrayContributorMetadataAccess(final Property bootProperty, final Type attrType, final PropertyAccess propertyAccess, final CascadeStyle cascadeStyle, final MappingModelCreationProcess creationProcess) {
        return entityMappingType -> new StateArrayContributorMetadata(){
            private final boolean nullable;
            private final boolean insertable;
            private final boolean updateable;
            private final boolean includeInOptimisticLocking;
            private final MutabilityPlan mutabilityPlan;
            {
                this.nullable = bootProperty.getValue().isNullable();
                this.insertable = bootProperty.isInsertable();
                this.updateable = bootProperty.isUpdateable();
                this.includeInOptimisticLocking = bootProperty.isOptimisticLocked();
                this.mutabilityPlan = this.updateable ? new MutabilityPlan(){

                    @Override
                    public boolean isMutable() {
                        return true;
                    }

                    public Object deepCopy(Object value) {
                        if (value == null) {
                            return null;
                        }
                        return attrType.deepCopy(value, creationProcess.getCreationContext().getSessionFactory());
                    }

                    public Serializable disassemble(Object value, SharedSessionContract session) {
                        throw new NotYetImplementedFor6Exception(this.getClass());
                    }

                    public Object assemble(Serializable cached, SharedSessionContract session) {
                        throw new NotYetImplementedFor6Exception(this.getClass());
                    }
                } : ImmutableMutabilityPlan.INSTANCE;
            }

            @Override
            public PropertyAccess getPropertyAccess() {
                return propertyAccess;
            }

            @Override
            public MutabilityPlan getMutabilityPlan() {
                return this.mutabilityPlan;
            }

            @Override
            public boolean isNullable() {
                return this.nullable;
            }

            @Override
            public boolean isInsertable() {
                return this.insertable;
            }

            @Override
            public boolean isUpdatable() {
                return this.updateable;
            }

            @Override
            public boolean isIncludedInDirtyChecking() {
                return this.updateable;
            }

            @Override
            public boolean isIncludedInOptimisticLocking() {
                return this.includeInOptimisticLocking;
            }

            @Override
            public CascadeStyle getCascadeStyle() {
                return cascadeStyle;
            }
        };
    }

    public static StateArrayContributorMetadataAccess getStateArrayContributorMetadataAccess(final PropertyAccess propertyAccess) {
        return new StateArrayContributorMetadataAccess(){
            final StateArrayContributorMetadata contributorMetadata = new StateArrayContributorMetadata(){
                private final MutabilityPlan mutabilityPlan = ImmutableMutabilityPlan.INSTANCE;

                @Override
                public PropertyAccess getPropertyAccess() {
                    return propertyAccess;
                }

                @Override
                public MutabilityPlan getMutabilityPlan() {
                    return this.mutabilityPlan;
                }

                @Override
                public boolean isNullable() {
                    return false;
                }

                @Override
                public boolean isInsertable() {
                    return true;
                }

                @Override
                public boolean isUpdatable() {
                    return false;
                }

                @Override
                public boolean isIncludedInDirtyChecking() {
                    return false;
                }

                @Override
                public boolean isIncludedInOptimisticLocking() {
                    return true;
                }

                @Override
                public CascadeStyle getCascadeStyle() {
                    return null;
                }
            };

            @Override
            public StateArrayContributorMetadata resolveAttributeMetadata(EntityMappingType entityMappingType) {
                return this.contributorMetadata;
            }
        };
    }

    public static PluralAttributeMapping buildPluralAttributeMapping(String attrName, int stateArrayPosition, final Property bootProperty, ManagedMappingType declaringType, final PropertyAccess propertyAccess, final CascadeStyle cascadeStyle, FetchMode fetchMode, MappingModelCreationProcess creationProcess) {
        CollectionPart indexDescriptor;
        CollectionMappingTypeImpl collectionMappingType;
        org.hibernate.mapping.Collection bootValueMapping = (org.hibernate.mapping.Collection)bootProperty.getValue();
        RuntimeModelCreationContext creationContext = creationProcess.getCreationContext();
        SessionFactoryImplementor sessionFactory = creationContext.getSessionFactory();
        SqlStringGenerationContext sqlStringGenerationContext = sessionFactory.getSqlStringGenerationContext();
        Dialect dialect = sqlStringGenerationContext.getDialect();
        MappingMetamodel domainModel = creationContext.getDomainModel();
        CollectionPersister collectionDescriptor = domainModel.findCollectionDescriptor(bootValueMapping.getRole());
        assert (collectionDescriptor != null);
        String tableExpression = ((Joinable)((Object)collectionDescriptor)).getTableName();
        String sqlAliasStem = SqlAliasStemHelper.INSTANCE.generateStemFromAttributeName(bootProperty.getName());
        JavaTypeRegistry jtdRegistry = creationContext.getJavaTypeRegistry();
        CollectionPart elementDescriptor = MappingModelCreationHelper.interpretElement(bootValueMapping, tableExpression, collectionDescriptor, sqlAliasStem, dialect, creationProcess);
        CollectionIdentifierDescriptorImpl identifierDescriptor = null;
        CollectionSemantics<?, ?> collectionSemantics = collectionDescriptor.getCollectionSemantics();
        switch (collectionSemantics.getCollectionClassification()) {
            case ARRAY: {
                collectionMappingType = new CollectionMappingTypeImpl(jtdRegistry.getDescriptor((java.lang.reflect.Type)((Object)Object[].class)), StandardArraySemantics.INSTANCE);
                BasicValue index = (BasicValue)((IndexedCollection)bootValueMapping).getIndex();
                SelectableMapping selectableMapping = SelectableMappingImpl.from(tableExpression, index.getSelectables().get(0), creationContext.getTypeConfiguration().getBasicTypeForJavaType(Integer.class), dialect, creationProcess.getSqmFunctionRegistry());
                indexDescriptor = new BasicValuedCollectionPart(collectionDescriptor, CollectionPart.Nature.INDEX, null, selectableMapping);
                break;
            }
            case BAG: {
                collectionMappingType = new CollectionMappingTypeImpl(jtdRegistry.getDescriptor((java.lang.reflect.Type)((Object)Collection.class)), StandardBagSemantics.INSTANCE);
                indexDescriptor = null;
                break;
            }
            case ID_BAG: {
                collectionMappingType = new CollectionMappingTypeImpl(jtdRegistry.getDescriptor((java.lang.reflect.Type)((Object)Collection.class)), StandardIdentifierBagSemantics.INSTANCE);
                indexDescriptor = null;
                assert (collectionDescriptor instanceof SQLLoadableCollection);
                SQLLoadableCollection loadableCollection = (SQLLoadableCollection)collectionDescriptor;
                String identifierColumnName = loadableCollection.getIdentifierColumnName();
                assert (identifierColumnName != null);
                identifierDescriptor = new CollectionIdentifierDescriptorImpl(collectionDescriptor, tableExpression, identifierColumnName, (BasicType)loadableCollection.getIdentifierType());
                break;
            }
            case LIST: {
                BasicValue index = (BasicValue)((IndexedCollection)bootValueMapping).getIndex();
                SelectableMapping selectableMapping = SelectableMappingImpl.from(tableExpression, index.getSelectables().get(0), creationContext.getTypeConfiguration().getBasicTypeForJavaType(Integer.class), dialect, creationProcess.getSqmFunctionRegistry());
                indexDescriptor = new BasicValuedCollectionPart(collectionDescriptor, CollectionPart.Nature.INDEX, null, selectableMapping);
                collectionMappingType = new CollectionMappingTypeImpl(jtdRegistry.getDescriptor((java.lang.reflect.Type)((Object)List.class)), StandardListSemantics.INSTANCE);
                break;
            }
            case MAP: 
            case ORDERED_MAP: 
            case SORTED_MAP: {
                Class mapJavaType = collectionSemantics.getCollectionClassification() == CollectionClassification.SORTED_MAP ? SortedMap.class : java.util.Map.class;
                collectionMappingType = new CollectionMappingTypeImpl(jtdRegistry.getDescriptor((java.lang.reflect.Type)((Object)mapJavaType)), collectionSemantics);
                String mapKeyTableExpression = bootValueMapping instanceof Map && ((Map)bootValueMapping).getMapKeyPropertyName() != null ? MappingModelCreationHelper.getTableIdentifierExpression(((Map)bootValueMapping).getIndex().getTable(), creationProcess) : tableExpression;
                indexDescriptor = MappingModelCreationHelper.interpretMapKey(bootValueMapping, collectionDescriptor, mapKeyTableExpression, sqlAliasStem, dialect, creationProcess);
                break;
            }
            case SET: 
            case ORDERED_SET: 
            case SORTED_SET: {
                Class setJavaType = collectionSemantics.getCollectionClassification() == CollectionClassification.SORTED_MAP ? SortedSet.class : Set.class;
                collectionMappingType = new CollectionMappingTypeImpl(jtdRegistry.getDescriptor((java.lang.reflect.Type)((Object)setJavaType)), collectionSemantics);
                indexDescriptor = null;
                break;
            }
            default: {
                throw new MappingException("Unexpected CollectionClassification : " + collectionSemantics.getCollectionClassification());
            }
        }
        StateArrayContributorMetadata contributorMetadata = new StateArrayContributorMetadata(){

            @Override
            public PropertyAccess getPropertyAccess() {
                return propertyAccess;
            }

            @Override
            public MutabilityPlan getMutabilityPlan() {
                return ImmutableMutabilityPlan.instance();
            }

            @Override
            public boolean isNullable() {
                return bootProperty.isOptional();
            }

            @Override
            public boolean isInsertable() {
                return bootProperty.isInsertable();
            }

            @Override
            public boolean isUpdatable() {
                return bootProperty.isUpdateable();
            }

            @Override
            public boolean isIncludedInDirtyChecking() {
                return false;
            }

            @Override
            public boolean isIncludedInOptimisticLocking() {
                return bootProperty.isOptimisticLocked();
            }

            @Override
            public CascadeStyle getCascadeStyle() {
                return cascadeStyle;
            }
        };
        FetchStyle style = FetchOptionsHelper.determineFetchStyleByMetadata(fetchMode, collectionDescriptor.getCollectionType(), sessionFactory);
        FetchTiming timing = FetchOptionsHelper.determineFetchTiming(style, collectionDescriptor.getCollectionType(), sessionFactory);
        PluralAttributeMappingImpl pluralAttributeMapping = new PluralAttributeMappingImpl(attrName, bootValueMapping, propertyAccess, entityMappingType -> contributorMetadata, collectionMappingType, stateArrayPosition, elementDescriptor, indexDescriptor, identifierDescriptor, timing, style, cascadeStyle, declaringType, collectionDescriptor);
        creationProcess.registerInitializationCallback("PluralAttributeMapping(" + bootValueMapping.getRole() + ")#finishInitialization", () -> {
            pluralAttributeMapping.finishInitialization(bootProperty, bootValueMapping, creationProcess);
            return true;
        });
        creationProcess.registerInitializationCallback("PluralAttributeMapping(" + bootValueMapping.getRole() + ") - key descriptor", () -> {
            MappingModelCreationHelper.interpretPluralAttributeMappingKeyDescriptor(pluralAttributeMapping, bootValueMapping, collectionDescriptor, declaringType, dialect, creationProcess);
            return true;
        });
        return pluralAttributeMapping;
    }

    private static void interpretPluralAttributeMappingKeyDescriptor(PluralAttributeMappingImpl attributeMapping, org.hibernate.mapping.Collection bootValueMapping, CollectionPersister collectionDescriptor, ManagedMappingType declaringType, Dialect dialect, MappingModelCreationProcess creationProcess) {
        ModelPart attributeMappingSubPart = null;
        if (!StringHelper.isEmpty(collectionDescriptor.getMappedByProperty())) {
            attributeMappingSubPart = ((ModelPartContainer)((Object)attributeMapping.getElementDescriptor().getPartMappingType())).findSubPart(collectionDescriptor.getMappedByProperty(), null);
        }
        if (attributeMappingSubPart instanceof ToOneAttributeMapping) {
            ToOneAttributeMapping referencedAttributeMapping = (ToOneAttributeMapping)attributeMappingSubPart;
            MappingModelCreationHelper.setReferencedAttributeForeignKeyDescriptor(attributeMapping, referencedAttributeMapping, referencedAttributeMapping.findContainingEntityMapping().getEntityPersister(), collectionDescriptor.getMappedByProperty(), dialect, creationProcess);
            return;
        }
        KeyValue bootValueMappingKey = bootValueMapping.getKey();
        Type keyType = bootValueMappingKey.getType();
        String lhsPropertyName = collectionDescriptor.getCollectionType().getLHSPropertyName();
        boolean isReferenceToPrimaryKey = lhsPropertyName == null;
        ManagedMappingType keyDeclaringType = collectionDescriptor.getElementType().isEntityType() ? ((QueryableCollection)collectionDescriptor).getElementPersister() : declaringType;
        ModelPart fkTarget = isReferenceToPrimaryKey ? collectionDescriptor.getOwnerEntityPersister().getIdentifierMapping() : declaringType.findAttributeMapping(lhsPropertyName);
        if (keyType instanceof BasicType) {
            assert (bootValueMappingKey.getColumnSpan() == 1);
            assert (fkTarget instanceof BasicValuedModelPart);
            BasicValuedModelPart simpleFkTarget = (BasicValuedModelPart)fkTarget;
            String tableExpression = MappingModelCreationHelper.getTableIdentifierExpression(bootValueMappingKey.getTable(), creationProcess);
            SelectableMapping keySelectableMapping = SelectableMappingImpl.from(tableExpression, bootValueMappingKey.getSelectables().get(0), (JdbcMapping)((Object)keyType), dialect, creationProcess.getSqmFunctionRegistry());
            attributeMapping.setForeignKeyDescriptor(new SimpleForeignKeyDescriptor(keyDeclaringType, simpleFkTarget, null, keySelectableMapping, simpleFkTarget, isReferenceToPrimaryKey, ((SimpleValue)bootValueMappingKey).isConstrained()));
        } else if (fkTarget instanceof EmbeddableValuedModelPart) {
            EmbeddedForeignKeyDescriptor embeddedForeignKeyDescriptor = MappingModelCreationHelper.buildEmbeddableForeignKeyDescriptor((EmbeddableValuedModelPart)fkTarget, bootValueMapping, keyDeclaringType, collectionDescriptor.getAttributeMapping(), false, dialect, creationProcess);
            attributeMapping.setForeignKeyDescriptor(embeddedForeignKeyDescriptor);
        } else {
            throw new NotYetImplementedFor6Exception("Support for " + fkTarget.getClass() + " foreign keys not yet implemented: " + bootValueMapping.getRole());
        }
    }

    public static boolean interpretToOneKeyDescriptor(ToOneAttributeMapping attributeMapping, Property bootProperty, ToOne bootValueMapping, PropertyAccess inversePropertyAccess, Dialect dialect, MappingModelCreationProcess creationProcess) {
        String referencedPropertyName;
        if (attributeMapping.getForeignKeyDescriptor() != null) {
            return true;
        }
        String tableName = MappingModelCreationHelper.getTableIdentifierExpression(bootValueMapping.getTable(), creationProcess);
        attributeMapping.setIdentifyingColumnsTableExpression(tableName);
        EntityPersister referencedEntityDescriptor = creationProcess.getEntityPersister(bootValueMapping.getReferencedEntityName());
        boolean swapDirection = false;
        if (bootValueMapping instanceof OneToOne) {
            OneToOne oneToOne = (OneToOne)bootValueMapping;
            swapDirection = oneToOne.getForeignKeyType() == ForeignKeyDirection.TO_PARENT;
            referencedPropertyName = oneToOne.getMappedByProperty();
            if (referencedPropertyName == null) {
                referencedPropertyName = oneToOne.getReferencedPropertyName();
            }
        } else {
            referencedPropertyName = null;
        }
        if (referencedPropertyName != null) {
            if (referencedPropertyName.indexOf(".") > 0) {
                return MappingModelCreationHelper.interpretNestedToOneKeyDescriptor(referencedEntityDescriptor, referencedPropertyName, attributeMapping);
            }
            ModelPart modelPart = referencedEntityDescriptor.findSubPart(referencedPropertyName);
            if (modelPart instanceof ToOneAttributeMapping) {
                MappingModelCreationHelper.setReferencedAttributeForeignKeyDescriptor(attributeMapping, (ToOneAttributeMapping)modelPart, referencedEntityDescriptor, referencedPropertyName, dialect, creationProcess);
            } else if (modelPart instanceof EmbeddableValuedModelPart) {
                EmbeddedForeignKeyDescriptor embeddedForeignKeyDescriptor = MappingModelCreationHelper.buildEmbeddableForeignKeyDescriptor((EmbeddableValuedModelPart)modelPart, bootValueMapping, attributeMapping.getDeclaringType(), attributeMapping.findContainingEntityMapping(), true, dialect, creationProcess);
                attributeMapping.setForeignKeyDescriptor(embeddedForeignKeyDescriptor);
            } else {
                if (modelPart == null) {
                    throw new IllegalArgumentException("Unable to find attribute " + bootProperty.getPersistentClass().getEntityName() + " -> " + bootProperty.getName());
                }
                throw new NotYetImplementedFor6Exception("Support for foreign-keys based on `" + modelPart + "` not yet implemented: " + bootProperty.getPersistentClass().getEntityName() + " -> " + bootProperty.getName());
            }
            return true;
        }
        ModelPart fkTarget = bootValueMapping.isReferenceToPrimaryKey() ? referencedEntityDescriptor.getIdentifierMapping() : referencedEntityDescriptor.findAttributeMapping(bootValueMapping.getReferencedPropertyName());
        if (fkTarget instanceof BasicValuedModelPart) {
            PropertyAccess declaringKeyPropertyAccess;
            BasicValuedModelPart declaringKeyPart;
            BasicValuedModelPart simpleFkTarget = (BasicValuedModelPart)fkTarget;
            Iterator<Selectable> columnIterator = bootValueMapping.getColumnIterator();
            Table table = bootValueMapping.getTable();
            String tableExpression = MappingModelCreationHelper.getTableIdentifierExpression(table, creationProcess);
            if (inversePropertyAccess == null) {
                if (bootValueMapping instanceof OneToOne) {
                    declaringKeyPart = simpleFkTarget;
                    EntityIdentifierMapping identifierMapping = attributeMapping.findContainingEntityMapping().getIdentifierMapping();
                    declaringKeyPropertyAccess = ((PropertyBasedMapping)((Object)identifierMapping)).getPropertyAccess();
                } else {
                    declaringKeyPart = simpleFkTarget;
                    declaringKeyPropertyAccess = new ChainedPropertyAccessImpl(attributeMapping.getPropertyAccess(), ((PropertyBasedMapping)((Object)declaringKeyPart)).getPropertyAccess());
                }
            } else {
                declaringKeyPart = simpleFkTarget;
                declaringKeyPropertyAccess = new ChainedPropertyAccessImpl(inversePropertyAccess, ((PropertyBasedMapping)((Object)simpleFkTarget)).getPropertyAccess());
            }
            SelectableMapping keySelectableMapping = columnIterator.hasNext() ? SelectableMappingImpl.from(tableExpression, columnIterator.next(), simpleFkTarget.getJdbcMapping(), dialect, creationProcess.getSqmFunctionRegistry()) : SelectableMappingImpl.from(tableExpression, table.getColumn(0), simpleFkTarget.getJdbcMapping(), dialect, creationProcess.getSqmFunctionRegistry());
            SimpleForeignKeyDescriptor foreignKeyDescriptor = new SimpleForeignKeyDescriptor(attributeMapping.getDeclaringType(), declaringKeyPart, declaringKeyPropertyAccess, keySelectableMapping, simpleFkTarget, bootValueMapping.isReferenceToPrimaryKey(), bootValueMapping.isConstrained(), swapDirection);
            attributeMapping.setForeignKeyDescriptor(foreignKeyDescriptor);
        } else if (fkTarget instanceof EmbeddableValuedModelPart) {
            EmbeddedForeignKeyDescriptor embeddedForeignKeyDescriptor = MappingModelCreationHelper.buildEmbeddableForeignKeyDescriptor((EmbeddableValuedModelPart)fkTarget, bootValueMapping, attributeMapping.getDeclaringType(), attributeMapping.findContainingEntityMapping(), swapDirection, dialect, creationProcess);
            attributeMapping.setForeignKeyDescriptor(embeddedForeignKeyDescriptor);
        } else {
            throw new NotYetImplementedFor6Exception("Support for " + fkTarget.getClass() + " foreign-keys not yet implemented: " + bootProperty.getPersistentClass().getEntityName() + " -> " + bootProperty.getName());
        }
        return true;
    }

    private static boolean interpretNestedToOneKeyDescriptor(EntityPersister referencedEntityDescriptor, String referencedPropertyName, ToOneAttributeMapping attributeMapping) {
        String[] propertyPath = StringHelper.split(".", referencedPropertyName);
        Queryable lastEmbeddableModelPart = null;
        for (int i = 0; i < propertyPath.length; ++i) {
            String path = propertyPath[i];
            ModelPart modelPart = i == 0 ? referencedEntityDescriptor.findSubPart(path) : lastEmbeddableModelPart.findSubPart(path, null);
            if (modelPart == null) {
                return false;
            }
            if (modelPart instanceof ToOneAttributeMapping) {
                ToOneAttributeMapping referencedAttributeMapping = (ToOneAttributeMapping)modelPart;
                ForeignKeyDescriptor foreignKeyDescriptor = referencedAttributeMapping.getForeignKeyDescriptor();
                if (foreignKeyDescriptor == null) {
                    return false;
                }
                attributeMapping.setForeignKeyDescriptor(foreignKeyDescriptor);
                return true;
            }
            if (!(modelPart instanceof EmbeddableValuedModelPart)) {
                return false;
            }
            lastEmbeddableModelPart = (EmbeddableValuedModelPart)modelPart;
        }
        return false;
    }

    public static EmbeddedForeignKeyDescriptor buildEmbeddableForeignKeyDescriptor(EmbeddableValuedModelPart embeddableValuedModelPart, Value bootValueMapping, ManagedMappingType keyDeclaringType, TableGroupProducer keyDeclaringTableGroupProducer, boolean inverse, Dialect dialect, MappingModelCreationProcess creationProcess) {
        SelectableMappings keySelectableMappings;
        String keyTableExpression;
        boolean hasConstraint;
        if (bootValueMapping instanceof org.hibernate.mapping.Collection) {
            org.hibernate.mapping.Collection collectionBootValueMapping = (org.hibernate.mapping.Collection)bootValueMapping;
            hasConstraint = ((SimpleValue)collectionBootValueMapping.getKey()).isConstrained();
            keyTableExpression = MappingModelCreationHelper.getTableIdentifierExpression(collectionBootValueMapping.getCollectionTable(), creationProcess);
            keySelectableMappings = SelectableMappingsImpl.from(keyTableExpression, collectionBootValueMapping.getKey(), MappingModelCreationHelper.getPropertyOrder(bootValueMapping, creationProcess), creationProcess.getCreationContext().getSessionFactory(), dialect, creationProcess.getSqmFunctionRegistry());
        } else {
            hasConstraint = bootValueMapping instanceof OneToMany ? !bootValueMapping.isNullable() : ((SimpleValue)bootValueMapping).isConstrained();
            keyTableExpression = MappingModelCreationHelper.getTableIdentifierExpression(bootValueMapping.getTable(), creationProcess);
            keySelectableMappings = SelectableMappingsImpl.from(keyTableExpression, bootValueMapping, MappingModelCreationHelper.getPropertyOrder(bootValueMapping, creationProcess), creationProcess.getCreationContext().getSessionFactory(), dialect, creationProcess.getSqmFunctionRegistry());
        }
        if (inverse) {
            return new EmbeddedForeignKeyDescriptor(embeddableValuedModelPart, MappingModelCreationHelper.createInverseModelPart(embeddableValuedModelPart, keyDeclaringType, keyDeclaringTableGroupProducer, keySelectableMappings, creationProcess), embeddableValuedModelPart.getContainingTableExpression(), embeddableValuedModelPart.getEmbeddableTypeDescriptor(), keyTableExpression, keySelectableMappings, hasConstraint, creationProcess);
        }
        return new EmbeddedForeignKeyDescriptor(MappingModelCreationHelper.createInverseModelPart(embeddableValuedModelPart, keyDeclaringType, keyDeclaringTableGroupProducer, keySelectableMappings, creationProcess), embeddableValuedModelPart, keyTableExpression, keySelectableMappings, embeddableValuedModelPart.getContainingTableExpression(), embeddableValuedModelPart.getEmbeddableTypeDescriptor(), hasConstraint, creationProcess);
    }

    private static int[] getPropertyOrder(Value bootValueMapping, MappingModelCreationProcess creationProcess) {
        boolean sorted;
        ComponentType componentType;
        if (bootValueMapping instanceof org.hibernate.mapping.Collection) {
            org.hibernate.mapping.Collection collectionBootValueMapping = (org.hibernate.mapping.Collection)bootValueMapping;
            componentType = (ComponentType)collectionBootValueMapping.getKey().getType();
            assert (((SortableValue)((Object)collectionBootValueMapping.getKey())).isSorted());
            sorted = ((SortableValue)((Object)collectionBootValueMapping.getKey())).isSorted();
        } else {
            EntityType entityType = (EntityType)bootValueMapping.getType();
            Type identifierOrUniqueKeyType = entityType.getIdentifierOrUniqueKeyType(creationProcess.getCreationContext().getSessionFactory());
            if (identifierOrUniqueKeyType instanceof ComponentType) {
                componentType = (ComponentType)identifierOrUniqueKeyType;
                if (bootValueMapping instanceof ToOne) {
                    assert (((ToOne)bootValueMapping).isSorted());
                    sorted = ((ToOne)bootValueMapping).isSorted();
                } else {
                    sorted = true;
                }
            } else {
                return new int[]{0};
            }
        }
        if (!sorted && componentType.getOriginalPropertyOrder() != null) {
            return componentType.getOriginalPropertyOrder();
        }
        int columnSpan = componentType.getColumnSpan(creationProcess.getCreationContext().getBootModel());
        int[] propertyReordering = new int[columnSpan];
        for (int i = 0; i < columnSpan; ++i) {
            propertyReordering[i] = i;
        }
        return propertyReordering;
    }

    private static void setReferencedAttributeForeignKeyDescriptor(AbstractAttributeMapping attributeMapping, ToOneAttributeMapping referencedAttributeMapping, EntityPersister referencedEntityDescriptor, String referencedPropertyName, Dialect dialect, MappingModelCreationProcess creationProcess) {
        ForeignKeyDescriptor foreignKeyDescriptor = referencedAttributeMapping.getForeignKeyDescriptor();
        if (foreignKeyDescriptor == null) {
            PersistentClass entityBinding = creationProcess.getCreationContext().getBootModel().getEntityBinding(referencedEntityDescriptor.getEntityName());
            Property property = entityBinding.getProperty(referencedPropertyName);
            MappingModelCreationHelper.interpretToOneKeyDescriptor(referencedAttributeMapping, property, (ToOne)property.getValue(), referencedAttributeMapping.getPropertyAccess(), dialect, creationProcess);
            attributeMapping.setForeignKeyDescriptor(referencedAttributeMapping.getForeignKeyDescriptor());
        } else {
            attributeMapping.setForeignKeyDescriptor(foreignKeyDescriptor);
        }
    }

    public static String getTableIdentifierExpression(Table table, MappingModelCreationProcess creationProcess) {
        return MappingModelCreationHelper.getTableIdentifierExpression(table, creationProcess.getCreationContext().getSessionFactory());
    }

    public static String getTableIdentifierExpression(Table table, SessionFactoryImplementor sessionFactory) {
        if (table.getSubselect() != null) {
            return "( " + table.getSubselect() + " )";
        }
        return sessionFactory.getSqlStringGenerationContext().format(table.getQualifiedTableName());
    }

    private static CollectionPart interpretMapKey(org.hibernate.mapping.Collection bootValueMapping, CollectionPersister collectionDescriptor, String tableExpression, String sqlAliasStem, Dialect dialect, MappingModelCreationProcess creationProcess) {
        assert (bootValueMapping instanceof IndexedCollection);
        IndexedCollection indexedCollection = (IndexedCollection)bootValueMapping;
        Value bootMapKeyDescriptor = indexedCollection.getIndex();
        if (bootMapKeyDescriptor instanceof BasicValue) {
            BasicValue basicValue = (BasicValue)bootMapKeyDescriptor;
            SelectableMapping selectableMapping = SelectableMappingImpl.from(tableExpression, basicValue.getSelectables().get(0), basicValue.resolve().getJdbcMapping(), dialect, creationProcess.getSqmFunctionRegistry());
            return new BasicValuedCollectionPart(collectionDescriptor, CollectionPart.Nature.INDEX, basicValue.resolve().getValueConverter(), selectableMapping);
        }
        if (bootMapKeyDescriptor instanceof Component) {
            Component component = (Component)bootMapKeyDescriptor;
            CompositeType compositeType = (CompositeType)component.getType();
            EmbeddableMappingTypeImpl mappingType = EmbeddableMappingTypeImpl.from(component, compositeType, inflightDescriptor -> new EmbeddedCollectionPart(collectionDescriptor, CollectionPart.Nature.INDEX, (EmbeddableMappingType)inflightDescriptor, component.getParentProperty(), tableExpression, sqlAliasStem), creationProcess);
            return (CollectionPart)((Object)mappingType.getEmbeddedValueMapping());
        }
        if (bootMapKeyDescriptor instanceof OneToMany || bootMapKeyDescriptor instanceof ToOne) {
            EntityType indexEntityType = (EntityType)collectionDescriptor.getIndexType();
            EntityPersister associatedEntity = creationProcess.getEntityPersister(indexEntityType.getAssociatedEntityName());
            EntityCollectionPart indexDescriptor = new EntityCollectionPart(collectionDescriptor, CollectionPart.Nature.INDEX, bootMapKeyDescriptor, associatedEntity, creationProcess);
            creationProcess.registerInitializationCallback("PluralAttributeMapping( " + bootValueMapping.getRole() + ") - index descriptor", () -> {
                indexDescriptor.finishInitialization(collectionDescriptor, bootValueMapping, indexEntityType.getRHSUniqueKeyPropertyName(), creationProcess);
                return true;
            });
            return indexDescriptor;
        }
        throw new NotYetImplementedFor6Exception("Support for plural attributes with index type [" + bootMapKeyDescriptor + "] not yet implemented");
    }

    private static CollectionPart interpretElement(org.hibernate.mapping.Collection bootDescriptor, String tableExpression, CollectionPersister collectionDescriptor, String sqlAliasStem, Dialect dialect, MappingModelCreationProcess creationProcess) {
        Value element = bootDescriptor.getElement();
        if (element instanceof BasicValue) {
            BasicValue basicElement = (BasicValue)element;
            SelectableMapping selectableMapping = SelectableMappingImpl.from(tableExpression, basicElement.getSelectables().get(0), basicElement.resolve().getJdbcMapping(), dialect, creationProcess.getSqmFunctionRegistry());
            return new BasicValuedCollectionPart(collectionDescriptor, CollectionPart.Nature.ELEMENT, basicElement.resolve().getValueConverter(), selectableMapping);
        }
        if (element instanceof Component) {
            Component component = (Component)element;
            CompositeType compositeType = (CompositeType)collectionDescriptor.getElementType();
            EmbeddableMappingTypeImpl mappingType = EmbeddableMappingTypeImpl.from(component, compositeType, embeddableMappingType -> new EmbeddedCollectionPart(collectionDescriptor, CollectionPart.Nature.ELEMENT, (EmbeddableMappingType)embeddableMappingType, component.getParentProperty(), tableExpression, sqlAliasStem), creationProcess);
            return (CollectionPart)((Object)mappingType.getEmbeddedValueMapping());
        }
        if (element instanceof Any) {
            Any anyBootMapping = (Any)element;
            SessionFactoryImplementor sessionFactory = creationProcess.getCreationContext().getSessionFactory();
            TypeConfiguration typeConfiguration = sessionFactory.getTypeConfiguration();
            JavaTypeRegistry jtdRegistry = typeConfiguration.getJavaTypeRegistry();
            JavaType<Object> baseJtd = jtdRegistry.getDescriptor((java.lang.reflect.Type)((Object)Object.class));
            return new DiscriminatedCollectionPart(CollectionPart.Nature.ELEMENT, collectionDescriptor, baseJtd, anyBootMapping, anyBootMapping.getType(), creationProcess);
        }
        if (element instanceof OneToMany || element instanceof ToOne) {
            EntityType elementEntityType = (EntityType)collectionDescriptor.getElementType();
            EntityPersister associatedEntity = creationProcess.getEntityPersister(elementEntityType.getAssociatedEntityName());
            EntityCollectionPart elementDescriptor = new EntityCollectionPart(collectionDescriptor, CollectionPart.Nature.ELEMENT, bootDescriptor.getElement(), associatedEntity, creationProcess);
            creationProcess.registerInitializationCallback("PluralAttributeMapping( " + elementDescriptor.getNavigableRole() + ") - index descriptor", () -> {
                elementDescriptor.finishInitialization(collectionDescriptor, bootDescriptor, elementEntityType.getRHSUniqueKeyPropertyName(), creationProcess);
                return true;
            });
            return elementDescriptor;
        }
        throw new NotYetImplementedFor6Exception("Support for plural attributes with element type [" + element + "] not yet implemented");
    }

    public static EmbeddableValuedModelPart createInverseModelPart(EmbeddableValuedModelPart modelPart, ManagedMappingType keyDeclaringType, TableGroupProducer declaringTableGroupProducer, SelectableMappings selectableMappings, MappingModelCreationProcess creationProcess) {
        EmbeddableMappingType embeddableTypeDescriptor = modelPart instanceof CompositeIdentifierMapping ? ((CompositeIdentifierMapping)((Object)modelPart)).getMappedIdEmbeddableTypeDescriptor() : modelPart.getEmbeddableTypeDescriptor();
        if (modelPart instanceof VirtualModelPart) {
            return new VirtualEmbeddedAttributeMapping(keyDeclaringType, declaringTableGroupProducer, selectableMappings, modelPart, embeddableTypeDescriptor, creationProcess);
        }
        return new EmbeddedAttributeMapping(keyDeclaringType, declaringTableGroupProducer, selectableMappings, modelPart, embeddableTypeDescriptor, creationProcess);
    }

    public static ToOneAttributeMapping buildSingularAssociationAttributeMapping(String attrName, NavigableRole navigableRole, int stateArrayPosition, Property bootProperty, ManagedMappingType declaringType, EntityPersister declaringEntityPersister, EntityType attrType, PropertyAccess propertyAccess, CascadeStyle cascadeStyle, MappingModelCreationProcess creationProcess) {
        if (bootProperty.getValue() instanceof ToOne) {
            ToOne value = (ToOne)bootProperty.getValue();
            EntityPersister entityPersister = creationProcess.getEntityPersister(value.getReferencedEntityName());
            StateArrayContributorMetadataAccess stateArrayContributorMetadataAccess = MappingModelCreationHelper.getStateArrayContributorMetadataAccess(bootProperty, attrType, propertyAccess, cascadeStyle, creationProcess);
            SessionFactoryImplementor sessionFactory = creationProcess.getCreationContext().getSessionFactory();
            AssociationType type = (AssociationType)bootProperty.getType();
            FetchStyle fetchStyle = FetchOptionsHelper.determineFetchStyleByMetadata(bootProperty.getValue().getFetchMode(), type, sessionFactory);
            boolean lazy = value.isLazy();
            FetchTiming fetchTiming = lazy && entityPersister.getBytecodeEnhancementMetadata().isEnhancedForLazyLoading() ? (value.isUnwrapProxy() ? FetchOptionsHelper.determineFetchTiming(fetchStyle, type, sessionFactory) : (value instanceof ManyToOne && value.isNullable() && ((ManyToOne)value).isIgnoreNotFound() ? FetchTiming.IMMEDIATE : FetchOptionsHelper.determineFetchTiming(fetchStyle, type, sessionFactory))) : (fetchStyle == FetchStyle.JOIN || !lazy || value instanceof OneToOne && value.isNullable() || value instanceof ManyToOne && value.isNullable() && ((ManyToOne)value).isIgnoreNotFound() ? FetchTiming.IMMEDIATE : FetchOptionsHelper.determineFetchTiming(fetchStyle, type, sessionFactory));
            ToOneAttributeMapping attributeMapping = new ToOneAttributeMapping(attrName, navigableRole, stateArrayPosition, (ToOne)bootProperty.getValue(), stateArrayContributorMetadataAccess, fetchTiming, fetchStyle, entityPersister, declaringType, declaringEntityPersister, propertyAccess);
            creationProcess.registerForeignKeyPostInitCallbacks("To-one key - " + navigableRole, () -> {
                Dialect dialect = creationProcess.getCreationContext().getSessionFactory().getJdbcServices().getDialect();
                return MappingModelCreationHelper.interpretToOneKeyDescriptor(attributeMapping, bootProperty, (ToOne)bootProperty.getValue(), null, dialect, creationProcess);
            });
            return attributeMapping;
        }
        throw new NotYetImplementedFor6Exception("AnyType support has not yet been implemented");
    }

    private static class CollectionMappingTypeImpl
    implements CollectionMappingType {
        private final JavaType<?> collectionJtd;
        private final CollectionSemantics<?, ?> semantics;

        public CollectionMappingTypeImpl(JavaType<?> collectionJtd, CollectionSemantics<?, ?> semantics) {
            this.collectionJtd = collectionJtd;
            this.semantics = semantics;
        }

        public CollectionSemantics<?, ?> getCollectionSemantics() {
            return this.semantics;
        }

        @Override
        public JavaType<?> getMappedJavaType() {
            return this.collectionJtd;
        }
    }
}

