/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.Type;
import java.io.ObjectStreamException;
import java.io.Serializable;
import org.hibernate.graph.internal.SubGraphImpl;
import org.hibernate.graph.spi.SubGraphImplementor;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.metamodel.UnsupportedMappingException;
import org.hibernate.metamodel.mapping.EntityDiscriminatorMapping;
import org.hibernate.metamodel.model.domain.AbstractIdentifiableType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.IdentifiableDomainType;
import org.hibernate.metamodel.model.domain.JpaMetamodel;
import org.hibernate.metamodel.model.domain.PersistentAttribute;
import org.hibernate.metamodel.model.domain.SingularPersistentAttribute;
import org.hibernate.metamodel.model.domain.internal.DiscriminatorSqmPathSource;
import org.hibernate.persister.entity.DiscriminatorMetadata;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.type.BasicType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.java.JavaType;

public class EntityTypeImpl<J>
extends AbstractIdentifiableType<J>
implements EntityDomainType<J>,
Serializable {
    private final String jpaEntityName;
    private final SqmPathSource<?> discriminatorPathSource;

    public EntityTypeImpl(JavaType<J> javaType, IdentifiableDomainType<? super J> superType, PersistentClass persistentClass, JpaMetamodel jpaMetamodel) {
        super(persistentClass.getEntityName(), javaType, superType, persistentClass.getDeclaredIdentifierMapper() != null || superType != null && superType.hasIdClass(), persistentClass.hasIdentifierProperty(), persistentClass.isVersioned(), jpaMetamodel);
        this.jpaEntityName = persistentClass.getJpaEntityName();
        Queryable entityDescriptor = (Queryable)jpaMetamodel.getTypeConfiguration().getSessionFactory().getRuntimeMetamodels().getMappingMetamodel().getEntityDescriptor(this.getHibernateEntityName());
        DiscriminatorMetadata discriminatorMetadata = entityDescriptor.getTypeDiscriminatorMetadata();
        BasicType<String> discriminatorType = discriminatorMetadata != null ? (BasicType<String>)discriminatorMetadata.getResolutionType() : jpaMetamodel.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.STRING);
        this.discriminatorPathSource = new DiscriminatorSqmPathSource<String>(discriminatorType, this, entityDescriptor);
    }

    public String getName() {
        return this.jpaEntityName;
    }

    @Override
    public String getHibernateEntityName() {
        return super.getTypeName();
    }

    @Override
    public String getPathName() {
        return this.getHibernateEntityName();
    }

    @Override
    public EntityDomainType<J> getSqmPathType() {
        return this;
    }

    @Override
    public SqmPathSource<?> findSubPathSource(String name) {
        PersistentAttribute<J, ?> attribute = this.findAttribute(name);
        if (attribute != null) {
            return (SqmPathSource)((Object)attribute);
        }
        if ("id".equalsIgnoreCase(name) && this.hasIdClass()) {
            return this.getIdentifierDescriptor();
        }
        if (EntityDiscriminatorMapping.matchesRoleName(name)) {
            return this.discriminatorPathSource;
        }
        return null;
    }

    @Override
    public PersistentAttribute<? super J, ?> findAttribute(String name) {
        SingularPersistentAttribute idAttribute;
        PersistentAttribute attribute = super.findAttribute(name);
        if (attribute != null) {
            return attribute;
        }
        if (("id".equalsIgnoreCase(name) || "{id}".equals(name)) && (idAttribute = this.findIdAttribute()) != null) {
            return idAttribute;
        }
        return null;
    }

    public Bindable.BindableType getBindableType() {
        return Bindable.BindableType.ENTITY_TYPE;
    }

    public Type.PersistenceType getPersistenceType() {
        return Type.PersistenceType.ENTITY;
    }

    @Override
    public IdentifiableDomainType<? super J> getSuperType() {
        return super.getSuperType();
    }

    @Override
    public <S extends J> SubGraphImplementor<S> makeSubGraph(Class<S> subType) {
        if (!this.getBindableJavaType().isAssignableFrom(subType)) {
            throw new IllegalArgumentException(String.format("Entity type [%s] cannot be treated as requested sub-type [%s]", this.getName(), subType.getName()));
        }
        return new SubGraphImpl(this, true, this.jpaMetamodel());
    }

    @Override
    public SubGraphImplementor<J> makeSubGraph() {
        return this.makeSubGraph(this.getBindableJavaType());
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public SqmPath<J> createSqmPath(SqmPath<?> lhs, SqmPathSource<?> intermediatePathSource) {
        throw new UnsupportedMappingException("EntityType cannot be used to create an SqmPath - that would be an SqmFrom which are created directly");
    }

    @Override
    protected Object writeReplace() throws ObjectStreamException {
        return new SerialForm(this.jpaMetamodel(), this.getHibernateEntityName());
    }

    private static class SerialForm
    implements Serializable {
        private final JpaMetamodel jpaMetamodel;
        private final String hibernateEntityName;

        public SerialForm(JpaMetamodel jpaMetamodel, String hibernateEntityName) {
            this.jpaMetamodel = jpaMetamodel;
            this.hibernateEntityName = hibernateEntityName;
        }

        private Object readResolve() {
            return this.jpaMetamodel.entity(this.hibernateEntityName);
        }
    }
}

