/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import jakarta.persistence.metamodel.EmbeddableType;
import jakarta.persistence.metamodel.ManagedType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.hibernate.EntityNameResolver;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.UnknownEntityTypeException;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.cache.spi.CacheImplementor;
import org.hibernate.cache.spi.access.CollectionDataAccess;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.access.NaturalIdDataAccess;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.graph.RootGraph;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.internal.EntityManagerMessageLogger;
import org.hibernate.internal.HEMLogging;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.jpa.spi.JpaCompliance;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.MappedSuperclass;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.metamodel.MappingMetamodel;
import org.hibernate.metamodel.internal.JpaMetaModelPopulationSetting;
import org.hibernate.metamodel.internal.JpaStaticMetaModelPopulationSetting;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.model.domain.EmbeddableDomainType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.metamodel.model.domain.TupleType;
import org.hibernate.metamodel.model.domain.internal.BasicSqmPathSource;
import org.hibernate.metamodel.model.domain.internal.CompositeSqmPathSource;
import org.hibernate.metamodel.model.domain.internal.EmbeddableTypeImpl;
import org.hibernate.metamodel.model.domain.internal.JpaMetamodelImpl;
import org.hibernate.metamodel.model.domain.internal.TupleMappingModelExpressible;
import org.hibernate.metamodel.model.domain.spi.JpaMetamodelImplementor;
import org.hibernate.metamodel.spi.EntityRepresentationStrategy;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.metamodel.spi.MetamodelImplementor;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.persister.spi.PersisterFactory;
import org.hibernate.query.BindableType;
import org.hibernate.query.spi.NavigablePath;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.expression.SqmFieldLiteral;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.type.BasicType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.spi.TypeConfiguration;

public class MappingMetamodelImpl
implements MappingMetamodelImplementor,
MetamodelImplementor,
Serializable {
    private static final EntityManagerMessageLogger log = HEMLogging.messageLogger(MappingMetamodelImpl.class);
    private static final String[] EMPTY_IMPLEMENTORS = ArrayHelper.EMPTY_STRING_ARRAY;
    private final SessionFactoryImplementor sessionFactory;
    private final JpaMetamodelImplementor jpaMetamodel;
    private final Map<Class<?>, String> entityProxyInterfaceMap = new ConcurrentHashMap();
    private final Map<String, EntityPersister> entityPersisterMap = new ConcurrentHashMap<String, EntityPersister>();
    private final Map<String, CollectionPersister> collectionPersisterMap = new ConcurrentHashMap<String, CollectionPersister>();
    private final Map<String, Set<String>> collectionRolesByEntityParticipant = new ConcurrentHashMap<String, Set<String>>();
    private final Set<EntityNameResolver> entityNameResolvers = new HashSet<EntityNameResolver>();
    private final TypeConfiguration typeConfiguration;
    private final Map<String, String[]> implementorsCache = new ConcurrentHashMap<String, String[]>();
    private final Map<TupleType<?>, MappingModelExpressible<?>> tupleTypeCache = new ConcurrentHashMap();

    public MappingMetamodelImpl(SessionFactoryImplementor sessionFactory, TypeConfiguration typeConfiguration) {
        this.sessionFactory = sessionFactory;
        this.typeConfiguration = typeConfiguration;
        this.jpaMetamodel = new JpaMetamodelImpl(typeConfiguration, sessionFactory.getSessionFactoryOptions().getJpaCompliance());
    }

    public JpaMetamodelImplementor getJpaMetamodel() {
        return this.jpaMetamodel;
    }

    public void finishInitialization(final MetadataImplementor bootModel, final BootstrapContext bootstrapContext, final SessionFactoryImplementor sessionFactory) {
        RuntimeModelCreationContext runtimeModelCreationContext = new RuntimeModelCreationContext(){

            @Override
            public BootstrapContext getBootstrapContext() {
                return bootstrapContext;
            }

            @Override
            public SessionFactoryImplementor getSessionFactory() {
                return sessionFactory;
            }

            @Override
            public MetadataImplementor getBootModel() {
                return bootModel;
            }

            @Override
            public MappingMetamodel getDomainModel() {
                return MappingMetamodelImpl.this;
            }
        };
        PersisterFactory persisterFactory = sessionFactory.getServiceRegistry().getService(PersisterFactory.class);
        JpaStaticMetaModelPopulationSetting jpaStaticMetaModelPopulationSetting = JpaStaticMetaModelPopulationSetting.determineJpaStaticMetaModelPopulationSetting(sessionFactory.getProperties());
        JpaMetaModelPopulationSetting jpaMetaModelPopulationSetting = JpaMetaModelPopulationSetting.determineJpaMetaModelPopulationSetting(sessionFactory.getProperties());
        bootModel.visitRegisteredComponents(Component::prepareForMappingModel);
        bootModel.getMappedSuperclassMappingsCopy().forEach(MappedSuperclass::prepareForMappingModel);
        bootModel.getEntityBindings().forEach(PersistentClass::prepareForMappingModel);
        this.processBootEntities(bootModel.getEntityBindings(), sessionFactory.getCache(), persisterFactory, runtimeModelCreationContext);
        this.processBootCollections(bootModel.getCollectionBindings(), sessionFactory.getCache(), persisterFactory, runtimeModelCreationContext);
        MappingModelCreationProcess.process(this.entityPersisterMap, sessionFactory.getQueryEngine().getSqmFunctionRegistry(), runtimeModelCreationContext);
        for (EntityPersister persister : this.entityPersisterMap.values()) {
            persister.postInstantiate();
            MappingMetamodelImpl.registerEntityNameResolvers(persister, this.entityNameResolvers);
        }
        this.collectionPersisterMap.values().forEach(CollectionPersister::postInstantiate);
        ((JpaMetamodelImpl)this.jpaMetamodel).processJpa(bootModel, this, this.entityProxyInterfaceMap, jpaStaticMetaModelPopulationSetting, jpaMetaModelPopulationSetting, bootModel.getNamedEntityGraphs().values(), runtimeModelCreationContext);
    }

    private void processBootEntities(Collection<PersistentClass> entityBindings, CacheImplementor cacheImplementor, PersisterFactory persisterFactory, RuntimeModelCreationContext modelCreationContext) {
        for (PersistentClass model : entityBindings) {
            NavigableRole rootEntityRole = new NavigableRole(model.getRootClass().getEntityName());
            EntityDataAccess accessStrategy = cacheImplementor.getEntityRegionAccess(rootEntityRole);
            NaturalIdDataAccess naturalIdAccessStrategy = cacheImplementor.getNaturalIdCacheRegionAccessStrategy(rootEntityRole);
            EntityPersister cp = persisterFactory.createEntityPersister(model, accessStrategy, naturalIdAccessStrategy, modelCreationContext);
            this.entityPersisterMap.put(model.getEntityName(), cp);
            if (cp.getConcreteProxyClass() == null || !cp.getConcreteProxyClass().isInterface() || Map.class.isAssignableFrom(cp.getConcreteProxyClass()) || cp.getMappedClass() == cp.getConcreteProxyClass()) continue;
            if (cp.getMappedClass().equals(cp.getConcreteProxyClass())) {
                if (!log.isDebugEnabled()) continue;
                log.debugf("Entity [%s] mapped same interface [%s] as class and proxy", cp.getEntityName(), cp.getMappedClass());
                continue;
            }
            String old = this.entityProxyInterfaceMap.put(cp.getConcreteProxyClass(), cp.getEntityName());
            if (old == null) continue;
            throw new HibernateException(String.format(Locale.ENGLISH, "Multiple entities [%s, %s] named the same interface [%s] as their proxy which is not supported", old, cp.getEntityName(), cp.getConcreteProxyClass().getName()));
        }
    }

    private void processBootCollections(Collection<org.hibernate.mapping.Collection> collectionBindings, CacheImplementor cacheImplementor, PersisterFactory persisterFactory, RuntimeModelCreationContext modelCreationContext) {
        for (org.hibernate.mapping.Collection model : collectionBindings) {
            Type elementType;
            NavigableRole navigableRole = new NavigableRole(model.getRole());
            CollectionDataAccess accessStrategy = cacheImplementor.getCollectionRegionAccess(navigableRole);
            CollectionPersister persister = persisterFactory.createCollectionPersister(model, accessStrategy, modelCreationContext);
            this.collectionPersisterMap.put(model.getRole(), persister);
            Type indexType = persister.getIndexType();
            if (indexType != null && indexType.isEntityType() && !indexType.isAnyType()) {
                String entityName = ((EntityType)indexType).getAssociatedEntityName();
                Set<String> roles = this.collectionRolesByEntityParticipant.get(entityName);
                if (roles == null) {
                    roles = new HashSet<String>();
                    this.collectionRolesByEntityParticipant.put(entityName, roles);
                }
                roles.add(persister.getRole());
            }
            if (!(elementType = persister.getElementType()).isEntityType() || elementType.isAnyType()) continue;
            String entityName = ((EntityType)elementType).getAssociatedEntityName();
            Set<String> roles = this.collectionRolesByEntityParticipant.get(entityName);
            if (roles == null) {
                roles = new HashSet<String>();
                this.collectionRolesByEntityParticipant.put(entityName, roles);
            }
            roles.add(persister.getRole());
        }
    }

    private static void registerEntityNameResolvers(EntityPersister persister, Set<EntityNameResolver> entityNameResolvers) {
        if (persister.getRepresentationStrategy() == null) {
            return;
        }
        MappingMetamodelImpl.registerEntityNameResolvers(persister.getRepresentationStrategy(), entityNameResolvers);
    }

    private static void registerEntityNameResolvers(EntityRepresentationStrategy representationStrategy, Set<EntityNameResolver> entityNameResolvers) {
        representationStrategy.visitEntityNameResolvers(entityNameResolvers::add);
    }

    @Override
    public Collection<EntityNameResolver> getEntityNameResolvers() {
        return this.entityNameResolvers;
    }

    @Override
    public TypeConfiguration getTypeConfiguration() {
        return this.typeConfiguration;
    }

    @Override
    public void forEachEntityDescriptor(Consumer<EntityPersister> action) {
        this.entityPersisterMap.values().forEach(action);
    }

    @Override
    public Stream<EntityPersister> streamEntityDescriptors() {
        return this.entityPersisterMap.values().stream();
    }

    @Override
    public EntityPersister resolveEntityDescriptor(EntityDomainType<?> entityDomainType) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public EntityPersister getEntityDescriptor(String entityName) {
        EntityPersister entityPersister = this.entityPersisterMap.get(entityName);
        if (entityPersister == null) {
            throw new UnknownEntityTypeException("Unable to locate persister: " + entityName);
        }
        return entityPersister;
    }

    @Override
    public EntityPersister getEntityDescriptor(NavigableRole name) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public EntityPersister findEntityDescriptor(String entityName) {
        return this.entityPersisterMap.get(entityName);
    }

    @Override
    public EntityPersister findEntityDescriptor(Class<?> entityJavaType) {
        return this.findEntityDescriptor(entityJavaType.getName());
    }

    @Override
    public boolean isEntityClass(Class<?> entityJavaType) {
        return this.entityPersisterMap.containsKey(entityJavaType.getName());
    }

    @Override
    public SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }

    @Override
    public EntityPersister getEntityDescriptor(Class<?> entityJavaType) {
        String mappedEntityName;
        EntityPersister entityPersister = this.entityPersisterMap.get(entityJavaType.getName());
        if (entityPersister == null && (mappedEntityName = this.entityProxyInterfaceMap.get(entityJavaType)) != null) {
            entityPersister = this.entityPersisterMap.get(mappedEntityName);
        }
        if (entityPersister == null) {
            throw new UnknownEntityTypeException("Unable to locate entity descriptor: " + entityJavaType.getName());
        }
        return entityPersister;
    }

    @Override
    public EntityPersister locateEntityDescriptor(Class<?> byClass) {
        String mappedEntityName;
        EntityPersister entityPersister = this.entityPersisterMap.get(byClass.getName());
        if (entityPersister == null && (mappedEntityName = this.entityProxyInterfaceMap.get(byClass)) != null) {
            entityPersister = this.entityPersisterMap.get(mappedEntityName);
        }
        if (entityPersister == null) {
            throw new UnknownEntityTypeException("Unable to locate persister: " + byClass.getName());
        }
        return entityPersister;
    }

    @Override
    public <X> EntityDomainType<X> entity(Class<X> cls) {
        return this.jpaMetamodel.entity((Class)cls);
    }

    @Override
    public <X> ManagedDomainType<X> managedType(Class<X> cls) {
        return this.jpaMetamodel.managedType((Class)cls);
    }

    @Override
    public <X> EmbeddableDomainType<X> embeddable(Class<X> cls) {
        return this.jpaMetamodel.embeddable((Class)cls);
    }

    @Override
    public Set<ManagedType<?>> getManagedTypes() {
        return this.jpaMetamodel.getManagedTypes();
    }

    @Override
    public Set<jakarta.persistence.metamodel.EntityType<?>> getEntities() {
        return this.jpaMetamodel.getEntities();
    }

    @Override
    public Set<EmbeddableType<?>> getEmbeddables() {
        return this.jpaMetamodel.getEmbeddables();
    }

    @Override
    public <X> EntityDomainType<X> entity(String entityName) {
        return this.jpaMetamodel.entity(entityName);
    }

    @Override
    public <X> EntityDomainType<X> getHqlEntityReference(String entityName) {
        return this.jpaMetamodel.getHqlEntityReference(entityName);
    }

    @Override
    public <X> EntityDomainType<X> resolveHqlEntityReference(String entityName) {
        return this.jpaMetamodel.resolveHqlEntityReference(entityName);
    }

    @Override
    public <X> ManagedDomainType<X> findManagedType(Class<X> cls) {
        return this.jpaMetamodel.findManagedType(cls);
    }

    @Override
    public <X> EntityDomainType<X> findEntityType(Class<X> cls) {
        return this.jpaMetamodel.findEntityType(cls);
    }

    @Override
    public String qualifyImportableName(String queryName) {
        return this.jpaMetamodel.qualifyImportableName(queryName);
    }

    @Override
    public Map<String, Map<Class<?>, Enum<?>>> getAllowedEnumLiteralTexts() {
        return this.jpaMetamodel.getAllowedEnumLiteralTexts();
    }

    @Override
    public String[] getImplementors(String className) throws MappingException {
        String[] implementors = this.implementorsCache.get(className);
        if (implementors != null) {
            return Arrays.copyOf(implementors, implementors.length);
        }
        try {
            Class clazz = this.getSessionFactory().getServiceRegistry().getService(ClassLoaderService.class).classForName(className);
            implementors = this.doGetImplementors(clazz);
            if (implementors.length > 0) {
                this.implementorsCache.putIfAbsent(className, implementors);
                return Arrays.copyOf(implementors, implementors.length);
            }
            return EMPTY_IMPLEMENTORS;
        }
        catch (ClassLoadingException e) {
            return new String[]{className};
        }
    }

    @Override
    public Map<String, EntityPersister> entityPersisters() {
        return this.entityPersisterMap;
    }

    @Override
    public CollectionPersister collectionPersister(String role) {
        CollectionPersister persister = this.collectionPersisterMap.get(role);
        if (persister == null) {
            throw new MappingException("Could not locate CollectionPersister for role : " + role);
        }
        return persister;
    }

    @Override
    public Map<String, CollectionPersister> collectionPersisters() {
        return this.collectionPersisterMap;
    }

    @Override
    public EntityPersister entityPersister(Class<?> entityClass) {
        return this.getEntityDescriptor(entityClass.getName());
    }

    @Override
    public EntityPersister entityPersister(String entityName) throws MappingException {
        EntityPersister result = this.entityPersisterMap.get(entityName);
        if (result == null) {
            throw new MappingException("Unknown entity: " + entityName);
        }
        return result;
    }

    @Override
    public EntityPersister locateEntityPersister(String byName) {
        EntityPersister entityPersister = this.entityPersisterMap.get(byName);
        if (entityPersister == null) {
            throw new UnknownEntityTypeException("Unable to locate persister: " + byName);
        }
        return entityPersister;
    }

    @Override
    public String getImportedName(String name) {
        String qualifiedName = this.jpaMetamodel.qualifyImportableName(name);
        return qualifiedName == null ? name : qualifiedName;
    }

    @Override
    public void forEachCollectionDescriptor(Consumer<CollectionPersister> action) {
        this.collectionPersisterMap.values().forEach(action);
    }

    @Override
    public Stream<CollectionPersister> streamCollectionDescriptors() {
        return this.collectionPersisterMap.values().stream();
    }

    @Override
    public CollectionPersister getCollectionDescriptor(String role) {
        CollectionPersister collectionPersister = this.collectionPersisterMap.get(role);
        if (collectionPersister == null) {
            throw new IllegalArgumentException("Unable to locate persister: " + role);
        }
        return collectionPersister;
    }

    @Override
    public CollectionPersister getCollectionDescriptor(NavigableRole role) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public CollectionPersister findCollectionDescriptor(NavigableRole role) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public CollectionPersister findCollectionDescriptor(String role) {
        return this.collectionPersisterMap.get(role);
    }

    @Override
    public Set<String> getCollectionRolesByEntityParticipant(String entityName) {
        return this.collectionRolesByEntityParticipant.get(entityName);
    }

    @Override
    public String[] getAllEntityNames() {
        return ArrayHelper.toStringArray(this.entityPersisterMap.keySet());
    }

    @Override
    public String[] getAllCollectionRoles() {
        return ArrayHelper.toStringArray(this.collectionPersisterMap.keySet());
    }

    @Override
    public <T> void addNamedEntityGraph(String graphName, RootGraphImplementor<T> entityGraph) {
        this.jpaMetamodel.addNamedEntityGraph(graphName, entityGraph);
    }

    @Override
    public <T> RootGraphImplementor<T> findEntityGraphByName(String name) {
        return this.jpaMetamodel.findEntityGraphByName(name);
    }

    @Override
    public <T> List<RootGraphImplementor<? super T>> findEntityGraphsByJavaType(Class<T> entityClass) {
        return this.jpaMetamodel.findEntityGraphsByJavaType(entityClass);
    }

    @Override
    public JpaCompliance getJpaCompliance() {
        return this.jpaMetamodel.getJpaCompliance();
    }

    @Override
    public RootGraph<?> findNamedGraph(String name) {
        return this.findEntityGraphByName(name);
    }

    @Override
    public void forEachNamedGraph(Consumer<RootGraph<?>> action) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public RootGraph<?> defaultGraph(String entityName) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public RootGraph<?> defaultGraph(Class entityJavaType) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public RootGraph<?> defaultGraph(EntityPersister entityDescriptor) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public RootGraph<?> defaultGraph(EntityDomainType<?> entityDomainType) {
        return null;
    }

    @Override
    public List<RootGraph<?>> findRootGraphsForType(Class baseEntityJavaType) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public List<RootGraph<?>> findRootGraphsForType(String baseEntityName) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public List<RootGraph<?>> findRootGraphsForType(EntityPersister baseEntityDescriptor) {
        return null;
    }

    @Override
    public void close() {
    }

    private String[] doGetImplementors(Class<?> clazz) throws MappingException {
        ArrayList<String> results = new ArrayList<String>();
        for (EntityPersister checkPersister : this.entityPersisters().values()) {
            boolean assignableSuperclass;
            if (!(checkPersister instanceof Queryable)) continue;
            Queryable checkQueryable = (Queryable)checkPersister;
            String checkQueryableEntityName = checkQueryable.getEntityName();
            boolean isMappedClass = clazz.getName().equals(checkQueryableEntityName);
            if (checkQueryable.isExplicitPolymorphism()) {
                if (!isMappedClass) continue;
                return new String[]{clazz.getName()};
            }
            if (isMappedClass) {
                results.add(checkQueryableEntityName);
                continue;
            }
            Class<?> mappedClass = checkQueryable.getMappedClass();
            if (mappedClass == null || !clazz.isAssignableFrom(mappedClass)) continue;
            if (checkQueryable.isInherited()) {
                Class<?> mappedSuperclass = this.getEntityDescriptor(checkQueryable.getMappedSuperclass()).getMappedClass();
                assignableSuperclass = clazz.isAssignableFrom(mappedSuperclass);
            } else {
                assignableSuperclass = false;
            }
            if (assignableSuperclass) continue;
            results.add(checkQueryableEntityName);
        }
        return results.toArray(ArrayHelper.EMPTY_STRING_ARRAY);
    }

    @Override
    public MappingModelExpressible<?> lenientlyResolveMappingExpressible(SqmExpressible<?> sqmExpressible, Function<NavigablePath, TableGroup> tableGroupLocator) {
        return this.resolveMappingExpressible(sqmExpressible, tableGroupLocator);
    }

    @Override
    public MappingModelExpressible<?> resolveMappingExpressible(SqmExpressible<?> sqmExpressible, Function<NavigablePath, TableGroup> tableGroupLocator) {
        if (sqmExpressible instanceof SqmPath) {
            SqmPath sqmPath = (SqmPath)((Object)sqmExpressible);
            NavigablePath navigablePath = sqmPath.getNavigablePath();
            if (navigablePath.getParent() != null) {
                TableGroup parentTableGroup = tableGroupLocator.apply(navigablePath.getParent());
                return parentTableGroup.getModelPart().findSubPart(navigablePath.getLocalName(), null);
            }
            return tableGroupLocator.apply(navigablePath.getParent()).getModelPart();
        }
        if (sqmExpressible instanceof BasicType) {
            return (BasicType)sqmExpressible;
        }
        if (sqmExpressible instanceof BasicSqmPathSource) {
            return this.getTypeConfiguration().getBasicTypeForJavaType(((BasicSqmPathSource)sqmExpressible).getJavaType());
        }
        if (sqmExpressible instanceof SqmFieldLiteral) {
            return this.getTypeConfiguration().getBasicTypeForJavaType(((SqmFieldLiteral)sqmExpressible).getJavaType());
        }
        if (sqmExpressible instanceof CompositeSqmPathSource) {
            throw new NotYetImplementedFor6Exception("Resolution of embedded-valued SqmExpressible nodes not yet implemented");
        }
        if (sqmExpressible instanceof EmbeddableTypeImpl) {
            return (MappingModelExpressible)((Object)sqmExpressible);
        }
        if (sqmExpressible instanceof EntityDomainType) {
            return this.getEntityDescriptor(((EntityDomainType)sqmExpressible).getHibernateEntityName());
        }
        if (sqmExpressible instanceof TupleType) {
            MappingModelExpressible<?> mappingModelExpressible = this.tupleTypeCache.get(sqmExpressible);
            if (mappingModelExpressible != null) {
                return mappingModelExpressible;
            }
            TupleType tupleType = (TupleType)sqmExpressible;
            MappingModelExpressible[] components = new MappingModelExpressible[tupleType.componentCount()];
            for (int i = 0; i < components.length; ++i) {
                components[i] = this.resolveMappingExpressible(tupleType.get(i), tableGroupLocator);
            }
            TupleMappingModelExpressible createdMappingModelExpressible = new TupleMappingModelExpressible(components);
            MappingModelExpressible existingMappingModelExpressible = this.tupleTypeCache.putIfAbsent(tupleType, createdMappingModelExpressible);
            return existingMappingModelExpressible == null ? createdMappingModelExpressible : existingMappingModelExpressible;
        }
        return null;
    }

    @Override
    public <T> BindableType<T> resolveQueryParameterType(Class<T> javaClass) {
        JdbcType recommendedJdbcType;
        BasicType<T> basicType = this.getTypeConfiguration().getBasicTypeForJavaType(javaClass);
        if (basicType != null || javaClass.isEnum()) {
            return basicType;
        }
        ManagedDomainType<T> managedType = this.jpaMetamodel.findManagedType(javaClass);
        if (managedType != null) {
            return managedType;
        }
        JavaType javaType = this.getTypeConfiguration().getJavaTypeRegistry().findDescriptor(javaClass);
        if (javaType != null && (recommendedJdbcType = javaType.getRecommendedJdbcType(this.getTypeConfiguration().getCurrentBaseSqlTypeIndicators())) != null) {
            return this.getTypeConfiguration().getBasicTypeRegistry().resolve(javaType, recommendedJdbcType);
        }
        return null;
    }
}

