/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results;

import java.util.function.BiFunction;
import org.hibernate.engine.FetchTiming;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.query.results.FetchBuilder;
import org.hibernate.query.results.dynamic.DynamicFetchBuilderLegacy;
import org.hibernate.query.results.implicit.ImplicitFetchBuilder;
import org.hibernate.query.spi.NavigablePath;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;

public class ImplicitAttributeFetchBuilder
implements FetchBuilder,
ImplicitFetchBuilder {
    private final NavigablePath navigablePath;
    private final AttributeMapping attributeMapping;

    public ImplicitAttributeFetchBuilder(NavigablePath navigablePath, AttributeMapping attributeMapping) {
        this.navigablePath = navigablePath;
        this.attributeMapping = attributeMapping;
    }

    @Override
    public FetchBuilder cacheKeyInstance() {
        return this;
    }

    @Override
    public Fetch buildFetch(FetchParent parent, NavigablePath fetchPath, JdbcValuesMetadata jdbcResultsMetadata, BiFunction<String, String, DynamicFetchBuilderLegacy> legacyFetchResolver, DomainResultCreationState domainResultCreationState) {
        assert (fetchPath.equals(this.navigablePath));
        return parent.generateFetchableFetch(this.attributeMapping, fetchPath, FetchTiming.IMMEDIATE, true, null, domainResultCreationState);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImplicitAttributeFetchBuilder that = (ImplicitAttributeFetchBuilder)o;
        return this.navigablePath.equals(that.navigablePath) && this.attributeMapping.equals(that.attributeMapping);
    }

    public int hashCode() {
        int result = this.navigablePath.hashCode();
        result = 31 * result + this.attributeMapping.hashCode();
        return result;
    }
}

