/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.spi;

import jakarta.persistence.TemporalType;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.BindableType;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.type.descriptor.converter.AttributeConverterTypeAdapter;
import org.hibernate.type.descriptor.java.JavaType;

public class QueryParameterBindingValidator {
    public static final QueryParameterBindingValidator INSTANCE = new QueryParameterBindingValidator();

    private QueryParameterBindingValidator() {
    }

    public void validate(BindableType<?> paramType, Object bind, SessionFactoryImplementor sessionFactory) {
        this.validate(paramType, bind, null, sessionFactory);
    }

    public void validate(BindableType<?> paramType, Object bind, TemporalType temporalPrecision, SessionFactoryImplementor sessionFactory) {
        Class<Object> parameterJavaType;
        AttributeConverterTypeAdapter converterTypeAdapter;
        JavaType domainJtd;
        if (bind == null || paramType == null) {
            return;
        }
        if (paramType instanceof AttributeConverterTypeAdapter && (domainJtd = (converterTypeAdapter = (AttributeConverterTypeAdapter)paramType).getDomainJtd()).getJavaTypeClass().isInstance(bind)) {
            return;
        }
        if (paramType.getBindableJavaType() != null) {
            parameterJavaType = paramType.getBindableJavaType();
        } else {
            SqmExpressible<?> sqmExpressible = paramType.resolveExpressible(sessionFactory);
            parameterJavaType = sqmExpressible.getBindableJavaType();
        }
        if (parameterJavaType == null) {
            return;
        }
        if (bind instanceof Collection && !Collection.class.isAssignableFrom(parameterJavaType)) {
            this.validateCollectionValuedParameterBinding(parameterJavaType, (Collection)bind, temporalPrecision);
        } else if (bind.getClass().isArray()) {
            this.validateArrayValuedParameterBinding(parameterJavaType, bind, temporalPrecision);
        } else if (!QueryParameterBindingValidator.isValidBindValue(parameterJavaType, bind, temporalPrecision)) {
            throw new IllegalArgumentException(String.format("Argument [%s] of type [%s] did not match parameter type [%s (%s)]", bind, bind.getClass().getName(), parameterJavaType.getName(), this.extractName(temporalPrecision)));
        }
    }

    private String extractName(TemporalType temporalType) {
        return temporalType == null ? "n/a" : temporalType.name();
    }

    private void validateCollectionValuedParameterBinding(Class<?> parameterType, Collection<?> value, TemporalType temporalType) {
        for (Object element : value) {
            if (QueryParameterBindingValidator.isValidBindValue(parameterType, element, temporalType)) continue;
            throw new IllegalArgumentException(String.format("Parameter value element [%s] did not match expected type [%s (%s)]", element, parameterType.getName(), this.extractName(temporalType)));
        }
    }

    private static boolean isValidBindValue(Class<?> expectedType, Object value, TemporalType temporalType) {
        if (expectedType.isPrimitive()) {
            if (expectedType == Boolean.TYPE) {
                return value instanceof Boolean;
            }
            if (expectedType == Character.TYPE) {
                return value instanceof Character;
            }
            if (expectedType == Byte.TYPE) {
                return value instanceof Byte;
            }
            if (expectedType == Short.TYPE) {
                return value instanceof Short;
            }
            if (expectedType == Integer.TYPE) {
                return value instanceof Integer;
            }
            if (expectedType == Long.TYPE) {
                return value instanceof Long;
            }
            if (expectedType == Float.TYPE) {
                return value instanceof Float;
            }
            if (expectedType == Double.TYPE) {
                return value instanceof Double;
            }
            return false;
        }
        if (value == null) {
            return true;
        }
        if (expectedType.isInstance(value)) {
            return true;
        }
        if (temporalType != null) {
            boolean parameterDeclarationIsTemporal = Date.class.isAssignableFrom(expectedType) || Calendar.class.isAssignableFrom(expectedType);
            boolean bindIsTemporal = value instanceof Date || value instanceof Calendar;
            return parameterDeclarationIsTemporal && bindIsTemporal;
        }
        return false;
    }

    private void validateArrayValuedParameterBinding(Class<?> parameterType, Object value, TemporalType temporalType) {
        if (!parameterType.isArray()) {
            throw new IllegalArgumentException(String.format("Encountered array-valued parameter binding, but was expecting [%s (%s)]", parameterType.getName(), this.extractName(temporalType)));
        }
        if (value.getClass().getComponentType().isPrimitive()) {
            if (!parameterType.getComponentType().isAssignableFrom(value.getClass().getComponentType())) {
                throw new IllegalArgumentException(String.format("Primitive array-valued parameter bind value type [%s] did not match expected type [%s (%s)]", value.getClass().getComponentType().getName(), parameterType.getName(), this.extractName(temporalType)));
            }
        } else {
            Object[] array;
            for (Object element : array = (Object[])value) {
                if (QueryParameterBindingValidator.isValidBindValue(parameterType.getComponentType(), element, temporalType)) continue;
                throw new IllegalArgumentException(String.format("Array-valued parameter value element [%s] did not match expected type [%s (%s)]", element, parameterType.getName(), this.extractName(temporalType)));
            }
        }
    }
}

