/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.produce.function;

import org.hibernate.query.sqm.function.FunctionKind;
import org.hibernate.query.sqm.function.NamedSqmFunctionDescriptor;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;
import org.hibernate.query.sqm.produce.function.ArgumentTypesValidator;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.query.sqm.produce.function.FunctionReturnTypeResolver;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.type.BasicType;

public class NamedFunctionDescriptorBuilder {
    private final SqmFunctionRegistry registry;
    private final String registrationKey;
    private final FunctionKind functionKind;
    private final String functionName;
    private ArgumentsValidator argumentsValidator;
    private FunctionReturnTypeResolver returnTypeResolver;
    private boolean useParenthesesWhenNoArgs = true;
    private String argumentListSignature;
    private SqlAstNodeRenderingMode argumentRenderingMode = SqlAstNodeRenderingMode.DEFAULT;

    public NamedFunctionDescriptorBuilder(SqmFunctionRegistry registry, String registrationKey, FunctionKind functionKind, String functionName) {
        this.registry = registry;
        this.registrationKey = registrationKey;
        this.functionKind = functionKind;
        this.functionName = functionName;
    }

    public NamedFunctionDescriptorBuilder setArgumentsValidator(ArgumentsValidator argumentsValidator) {
        this.argumentsValidator = argumentsValidator;
        return this;
    }

    public NamedFunctionDescriptorBuilder setArgumentCountBetween(int min, int max) {
        return this.setArgumentsValidator(StandardArgumentsValidators.between(min, max));
    }

    public NamedFunctionDescriptorBuilder setExactArgumentCount(int exactArgumentCount) {
        return this.setArgumentsValidator(StandardArgumentsValidators.exactly(exactArgumentCount));
    }

    public NamedFunctionDescriptorBuilder setMinArgumentCount(int min) {
        return this.setArgumentsValidator(StandardArgumentsValidators.min(min));
    }

    public NamedFunctionDescriptorBuilder setReturnTypeResolver(FunctionReturnTypeResolver returnTypeResolver) {
        this.returnTypeResolver = returnTypeResolver;
        return this;
    }

    public NamedFunctionDescriptorBuilder setInvariantType(BasicType<?> invariantType) {
        this.setReturnTypeResolver(StandardFunctionReturnTypeResolvers.invariant(invariantType));
        return this;
    }

    public NamedFunctionDescriptorBuilder setParameterTypes(FunctionParameterType ... types) {
        this.setArgumentsValidator(new ArgumentTypesValidator(this.argumentsValidator, types));
        return this;
    }

    public NamedFunctionDescriptorBuilder setUseParenthesesWhenNoArgs(boolean useParenthesesWhenNoArgs) {
        this.useParenthesesWhenNoArgs = useParenthesesWhenNoArgs;
        return this;
    }

    public NamedFunctionDescriptorBuilder setArgumentListSignature(String argumentListSignature) {
        this.argumentListSignature = argumentListSignature;
        return this;
    }

    public NamedFunctionDescriptorBuilder setArgumentRenderingMode(SqlAstNodeRenderingMode argumentRenderingMode) {
        this.argumentRenderingMode = argumentRenderingMode;
        return this;
    }

    public SqmFunctionDescriptor register() {
        return this.registry.register(this.registrationKey, this.descriptor());
    }

    public SqmFunctionDescriptor descriptor() {
        return new NamedSqmFunctionDescriptor(this.functionName, this.useParenthesesWhenNoArgs, this.argumentsValidator, this.returnTypeResolver, this.registrationKey, this.functionKind, this.argumentListSignature, this.argumentRenderingMode);
    }
}

