/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.produce.function;

import org.hibernate.query.sqm.function.FunctionKind;
import org.hibernate.query.sqm.function.PatternBasedSqmFunctionDescriptor;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;
import org.hibernate.query.sqm.produce.function.ArgumentTypesValidator;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.query.sqm.produce.function.FunctionReturnTypeResolver;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.query.sqm.produce.function.internal.PatternRenderer;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.type.BasicType;

public class PatternFunctionDescriptorBuilder {
    private final SqmFunctionRegistry registry;
    private final String registrationKey;
    private final FunctionKind functionKind;
    private final String pattern;
    private String argumentListSignature;
    private ArgumentsValidator argumentsValidator;
    private FunctionReturnTypeResolver returnTypeResolver;
    private SqlAstNodeRenderingMode argumentRenderingMode = SqlAstNodeRenderingMode.DEFAULT;

    public PatternFunctionDescriptorBuilder(SqmFunctionRegistry registry, String registrationKey, FunctionKind functionKind, String pattern) {
        this.registry = registry;
        this.registrationKey = registrationKey;
        this.functionKind = functionKind;
        this.pattern = pattern;
    }

    public PatternFunctionDescriptorBuilder setArgumentsValidator(ArgumentsValidator argumentsValidator) {
        this.argumentsValidator = argumentsValidator;
        return this;
    }

    public PatternFunctionDescriptorBuilder setParameterTypes(FunctionParameterType ... types) {
        this.setArgumentsValidator(new ArgumentTypesValidator(this.argumentsValidator, types));
        return this;
    }

    public PatternFunctionDescriptorBuilder setMinArgumentCount(int min) {
        return this.setArgumentsValidator(StandardArgumentsValidators.min(min));
    }

    public PatternFunctionDescriptorBuilder setExactArgumentCount(int exactArgumentCount) {
        return this.setArgumentsValidator(StandardArgumentsValidators.exactly(exactArgumentCount));
    }

    public PatternFunctionDescriptorBuilder setReturnTypeResolver(FunctionReturnTypeResolver returnTypeResolver) {
        this.returnTypeResolver = returnTypeResolver;
        return this;
    }

    public PatternFunctionDescriptorBuilder setInvariantType(BasicType invariantType) {
        this.setReturnTypeResolver(StandardFunctionReturnTypeResolvers.invariant(invariantType));
        return this;
    }

    public PatternFunctionDescriptorBuilder setArgumentListSignature(String argumentListSignature) {
        this.argumentListSignature = argumentListSignature;
        return this;
    }

    public PatternFunctionDescriptorBuilder setArgumentRenderingMode(SqlAstNodeRenderingMode argumentRenderingMode) {
        this.argumentRenderingMode = argumentRenderingMode;
        return this;
    }

    public SqmFunctionDescriptor register() {
        return this.registry.register(this.registrationKey, this.descriptor());
    }

    public SqmFunctionDescriptor descriptor() {
        return new PatternBasedSqmFunctionDescriptor(new PatternRenderer(this.pattern, this.argumentRenderingMode), this.argumentsValidator, this.returnTypeResolver, this.registrationKey, this.functionKind, this.argumentListSignature);
    }
}

