/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.cte;

import java.util.List;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.NullPrecedence;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SortOrder;
import org.hibernate.query.sqm.tree.AbstractSqmNode;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.SqmVisitableNode;
import org.hibernate.query.sqm.tree.cte.SqmCteContainer;
import org.hibernate.query.sqm.tree.cte.SqmCteTable;
import org.hibernate.query.sqm.tree.cte.SqmCteTableColumn;
import org.hibernate.query.sqm.tree.cte.SqmSearchClauseSpecification;
import org.hibernate.sql.ast.tree.cte.CteMaterialization;
import org.hibernate.sql.ast.tree.cte.CteSearchClauseKind;

public class SqmCteStatement<T>
extends AbstractSqmNode
implements SqmVisitableNode {
    private final SqmCteContainer cteContainer;
    private final SqmCteTable cteTable;
    private final CteMaterialization materialization;
    private final SqmStatement<?> cteDefinition;
    private final CteSearchClauseKind searchClauseKind;
    private final List<SqmSearchClauseSpecification> searchBySpecifications;
    private final List<SqmCteTableColumn> cycleColumns;
    private final SqmCteTableColumn cycleMarkColumn;
    private final char cycleValue;
    private final char noCycleValue;

    public SqmCteStatement(SqmCteTable cteTable, SqmStatement<?> cteDefinition, CteMaterialization materialization, NodeBuilder nodeBuilder) {
        super(nodeBuilder);
        this.cteTable = cteTable;
        this.cteDefinition = cteDefinition;
        this.materialization = materialization;
        this.cteContainer = null;
        this.searchClauseKind = null;
        this.searchBySpecifications = null;
        this.cycleColumns = null;
        this.cycleMarkColumn = null;
        this.cycleValue = '\u0000';
        this.noCycleValue = '\u0000';
    }

    public SqmCteStatement(SqmCteTable cteTable, SqmStatement<?> cteDefinition, CteMaterialization materialization, SqmCteContainer cteContainer) {
        super(cteContainer.nodeBuilder());
        this.cteTable = cteTable;
        this.cteDefinition = cteDefinition;
        this.materialization = materialization;
        this.cteContainer = cteContainer;
        this.searchClauseKind = null;
        this.searchBySpecifications = null;
        this.cycleColumns = null;
        this.cycleMarkColumn = null;
        this.cycleValue = '\u0000';
        this.noCycleValue = '\u0000';
    }

    public SqmCteTable getCteTable() {
        return this.cteTable;
    }

    public SqmStatement<?> getCteDefinition() {
        return this.cteDefinition;
    }

    public SqmCteContainer getCteContainer() {
        return this.cteContainer;
    }

    public CteMaterialization getMaterialization() {
        return this.materialization;
    }

    public CteSearchClauseKind getSearchClauseKind() {
        return this.searchClauseKind;
    }

    public List<SqmSearchClauseSpecification> getSearchBySpecifications() {
        return this.searchBySpecifications;
    }

    public List<SqmCteTableColumn> getCycleColumns() {
        return this.cycleColumns;
    }

    public SqmCteTableColumn getCycleMarkColumn() {
        return this.cycleMarkColumn;
    }

    public char getCycleValue() {
        return this.cycleValue;
    }

    public char getNoCycleValue() {
        return this.noCycleValue;
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitCteStatement(this);
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        sb.append(this.cteTable.getCteName());
        sb.append(" (");
        List<SqmCteTableColumn> columns = this.cteTable.getColumns();
        sb.append(columns.get(0).getColumnName());
        for (int i = 1; i < columns.size(); ++i) {
            sb.append(", ");
            sb.append(columns.get(i).getColumnName());
        }
        sb.append(") as ");
        if (this.getMaterialization() != CteMaterialization.UNDEFINED) {
            sb.append((Object)this.getMaterialization()).append(' ');
        }
        sb.append('(');
        this.getCteDefinition().appendHqlString(sb);
        sb.append(')');
        if (this.getSearchClauseKind() != null) {
            sb.append(" search ");
            if (this.getSearchClauseKind() == CteSearchClauseKind.DEPTH_FIRST) {
                sb.append(" depth ");
            } else {
                sb.append(" breadth ");
            }
            sb.append(" first by ");
            String separator = "";
            for (SqmSearchClauseSpecification searchBySpecification : this.getSearchBySpecifications()) {
                sb.append(separator);
                sb.append(searchBySpecification.getCteColumn().getColumnName());
                if (searchBySpecification.getSortOrder() != null) {
                    if (searchBySpecification.getSortOrder() == SortOrder.ASCENDING) {
                        sb.append(" asc");
                    } else {
                        sb.append(" desc");
                    }
                    if (searchBySpecification.getNullPrecedence() != null) {
                        if (searchBySpecification.getNullPrecedence() == NullPrecedence.FIRST) {
                            sb.append(" nulls first");
                        } else {
                            sb.append(" nulls last");
                        }
                    }
                }
                separator = ", ";
            }
        }
        if (this.getCycleMarkColumn() != null) {
            sb.append(" cycle ");
            String separator = "";
            for (SqmCteTableColumn cycleColumn : this.getCycleColumns()) {
                sb.append(separator);
                sb.append(cycleColumn.getColumnName());
                separator = ", ";
            }
            sb.append(" set ");
            sb.append(this.getCycleMarkColumn().getColumnName());
            sb.append(" to '");
            sb.append(this.getCycleValue());
            sb.append("' default '");
            sb.append(this.getNoCycleValue());
            sb.append("'");
        }
    }
}

