/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import org.hibernate.metamodel.model.domain.PluralPersistentAttribute;
import org.hibernate.query.criteria.JpaPath;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.domain.AbstractSqmSpecificPluralPartPath;
import org.hibernate.query.sqm.tree.domain.SqmPath;

public class SqmElementAggregateFunction<T>
extends AbstractSqmSpecificPluralPartPath<T> {
    public static final String NAVIGABLE_NAME = "{max-element}";
    private final String functionName;

    public SqmElementAggregateFunction(SqmPath<?> pluralDomainPath, String functionName) {
        super(pluralDomainPath.getNavigablePath().getParent().append(pluralDomainPath.getNavigablePath().getLocalName(), NAVIGABLE_NAME), pluralDomainPath, (PluralPersistentAttribute)pluralDomainPath.getReferencedPathSource());
        this.functionName = functionName;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    @Override
    public SqmPath<?> resolvePathPart(String name, boolean isTerminal, SqmCreationState creationState) {
        JpaPath sqmPath = this.get(name);
        creationState.getProcessingStateStack().getCurrent().getPathRegistry().register((SqmPath<?>)sqmPath);
        return sqmPath;
    }

    @Override
    public SqmPathSource<T> getReferencedPathSource() {
        return this.getPluralAttribute().getElementPathSource();
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitElementAggregateFunction(this);
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        sb.append(this.functionName).append("(");
        this.getLhs().appendHqlString(sb);
        sb.append(')');
    }
}

