/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.tree.expression.AbstractSqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmExpressionHelper;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;

public class SqmParameterizedEntityType<T>
extends AbstractSqmExpression<T>
implements SqmSelectableNode<T> {
    private final SqmExpression discriminatorSource;

    public SqmExpression getDiscriminatorSource() {
        return this.discriminatorSource;
    }

    public SqmParameterizedEntityType(SqmParameter<T> parameterExpression, NodeBuilder nodeBuilder) {
        super(SqmExpressionHelper.toSqmType(parameterExpression.getAnticipatedType(), nodeBuilder), nodeBuilder);
        this.discriminatorSource = parameterExpression;
    }

    @Override
    public void internalApplyInferableType(SqmExpressible<?> type) {
        this.setExpressibleType(type);
        this.discriminatorSource.applyInferableType(type);
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitParameterizedEntityTypeExpression(this);
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        sb.append("type(");
        this.discriminatorSource.appendHqlString(sb);
        sb.append(')');
    }
}

