/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import org.hibernate.query.ReturnableType;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.expression.AbstractSqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmDurationUnit;
import org.hibernate.query.sqm.tree.expression.SqmExpression;

public class SqmToDuration<T>
extends AbstractSqmExpression<T> {
    private final SqmExpression<?> magnitude;
    private final SqmDurationUnit<?> unit;

    public SqmToDuration(SqmExpression<?> magnitude, SqmDurationUnit<?> unit, ReturnableType<T> type, NodeBuilder nodeBuilder) {
        super(type, nodeBuilder);
        this.magnitude = magnitude;
        this.unit = unit;
    }

    public SqmExpression<?> getMagnitude() {
        return this.magnitude;
    }

    public SqmDurationUnit<?> getUnit() {
        return this.unit;
    }

    public <T> T accept(SemanticQueryWalker<T> walker) {
        return walker.visitToDuration(this);
    }

    @Override
    public String asLoggableText() {
        return this.magnitude.asLoggableText() + " " + this.unit.getUnit();
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        this.magnitude.appendHqlString(sb);
        sb.append(' ');
        sb.append((Object)this.unit.getUnit());
    }
}

