/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.expression;

import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.query.sqm.UnaryArithmeticOperator;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.basic.BasicResult;

public class UnaryOperation
implements Expression,
DomainResultProducer {
    private final UnaryArithmeticOperator operator;
    private final Expression operand;
    private final BasicValuedMapping type;

    public UnaryOperation(UnaryArithmeticOperator operator, Expression operand, BasicValuedMapping type) {
        this.operator = operator;
        this.operand = operand;
        this.type = type;
    }

    public UnaryArithmeticOperator getOperator() {
        return this.operator;
    }

    public Expression getOperand() {
        return this.operand;
    }

    @Override
    public MappingModelExpressible getExpressionType() {
        return this.type;
    }

    @Override
    public void accept(SqlAstWalker walker) {
        walker.visitUnaryOperationExpression(this);
    }

    public DomainResult createDomainResult(String resultVariable, DomainResultCreationState creationState) {
        SqlSelection sqlSelection = creationState.getSqlAstCreationState().getSqlExpressionResolver().resolveSqlSelection(this, this.type.getJdbcMapping().getJavaTypeDescriptor(), creationState.getSqlAstCreationState().getCreationContext().getMappingMetamodel().getTypeConfiguration());
        return new BasicResult(sqlSelection.getValuesArrayPosition(), resultVariable, this.type.getJdbcMapping().getJavaTypeDescriptor());
    }

    @Override
    public void applySqlSelections(DomainResultCreationState creationState) {
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        SqlExpressionResolver sqlExpressionResolver = sqlAstCreationState.getSqlExpressionResolver();
        sqlExpressionResolver.resolveSqlSelection(this, this.type.getJdbcMapping().getJavaTypeDescriptor(), sqlAstCreationState.getCreationContext().getMappingMetamodel().getTypeConfiguration());
    }
}

