/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph;

import java.util.List;
import org.hibernate.Incubating;
import org.hibernate.engine.FetchTiming;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.query.spi.NavigablePath;
import org.hibernate.query.sqm.spi.EntityIdentifierNavigablePath;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.DomainResultGraphNode;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.FetchableContainer;

@Incubating
public interface FetchParent
extends DomainResultGraphNode {
    public FetchableContainer getReferencedMappingContainer();

    public FetchableContainer getReferencedMappingType();

    default public NavigablePath resolveNavigablePath(Fetchable fetchable) {
        EntityMappingType fetchableEntityType;
        String fetchableName = fetchable.getFetchableName();
        if ("_identifierMapper".equals(fetchableName)) {
            return new EntityIdentifierNavigablePath(this.getNavigablePath(), fetchableName);
        }
        FetchableContainer referencedMappingContainer = this.getReferencedMappingContainer();
        EntityMappingType fetchParentType = referencedMappingContainer instanceof EmbeddableMappingType || referencedMappingContainer instanceof EmbeddableValuedModelPart ? referencedMappingContainer.findContainingEntityMapping() : (referencedMappingContainer instanceof EntityMappingType ? (EntityMappingType)referencedMappingContainer : fetchableEntityType);
        if (fetchParentType != (fetchableEntityType = fetchable.findContainingEntityMapping())) {
            return this.getNavigablePath().treatAs(fetchableEntityType.getEntityName()).append(fetchableName);
        }
        return this.getNavigablePath().append(fetchableName);
    }

    default public ModelPart getReferencedModePart() {
        return this.getReferencedMappingContainer();
    }

    @Override
    public NavigablePath getNavigablePath();

    public List<Fetch> getFetches();

    public Fetch findFetch(Fetchable var1);

    default public Fetch generateFetchableFetch(Fetchable fetchable, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, String resultVariable, DomainResultCreationState creationState) {
        return fetchable.generateFetch(this, fetchablePath, fetchTiming, selected, resultVariable, creationState);
    }
}

