/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.collection.internal;

import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.query.spi.NavigablePath;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.collection.CollectionInitializer;
import org.hibernate.sql.results.graph.collection.CollectionLoadingLogger;
import org.hibernate.sql.results.graph.collection.internal.DelayedCollectionInitializer;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public abstract class AbstractCollectionInitializer
implements CollectionInitializer {
    private final NavigablePath collectionPath;
    protected final PluralAttributeMapping collectionAttributeMapping;
    protected final FetchParentAccess parentAccess;
    protected final DomainResultAssembler<?> collectionKeyResultAssembler;
    protected PersistentCollection<?> collectionInstance;
    protected CollectionKey collectionKey;

    protected AbstractCollectionInitializer(NavigablePath collectionPath, PluralAttributeMapping collectionAttributeMapping, FetchParentAccess parentAccess, DomainResultAssembler<?> collectionKeyResultAssembler) {
        this.collectionPath = collectionPath;
        this.collectionAttributeMapping = collectionAttributeMapping;
        this.parentAccess = parentAccess;
        this.collectionKeyResultAssembler = collectionKeyResultAssembler;
    }

    @Override
    public void resolveKey(RowProcessingState rowProcessingState) {
        if (this.collectionKey != null) {
            return;
        }
        if (!this.isAttributeAssignableToConcreteDescriptor()) {
            return;
        }
        Object collectionKeyValue = this.collectionKeyResultAssembler == null ? this.parentAccess.getParentKey() : this.collectionKeyResultAssembler.assemble(rowProcessingState);
        if (collectionKeyValue != null) {
            this.collectionKey = new CollectionKey(this.collectionAttributeMapping.getCollectionDescriptor(), collectionKeyValue);
            if (CollectionLoadingLogger.DEBUG_ENABLED) {
                CollectionLoadingLogger.COLL_LOAD_LOGGER.debugf("(%s) Current row collection key : %s", (Object)DelayedCollectionInitializer.class.getSimpleName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), this.collectionKey.getKey()));
            }
        }
    }

    protected boolean isAttributeAssignableToConcreteDescriptor() {
        AbstractEntityPersister declaringType;
        AbstractEntityPersister concreteDescriptor;
        return !(this.parentAccess instanceof EntityInitializer) || !(concreteDescriptor = (AbstractEntityPersister)((EntityInitializer)this.parentAccess).getConcreteDescriptor()).isPolymorphic() || concreteDescriptor == (declaringType = (AbstractEntityPersister)this.collectionAttributeMapping.getDeclaringType()) || declaringType.getEntityMetamodel().getSubclassEntityNames().contains(concreteDescriptor.getEntityMetamodel().getName());
    }

    @Override
    public PersistentCollection<?> getCollectionInstance() {
        return this.collectionInstance;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.collectionPath;
    }

    public PluralAttributeMapping getCollectionAttributeMapping() {
        return this.collectionAttributeMapping;
    }

    @Override
    public PluralAttributeMapping getInitializedPart() {
        return this.getCollectionAttributeMapping();
    }

    protected FetchParentAccess getParentAccess() {
        return this.parentAccess;
    }

    @Override
    public CollectionKey resolveCollectionKey(RowProcessingState rowProcessingState) {
        this.resolveKey(rowProcessingState);
        return this.collectionKey;
    }

    @Override
    public void finishUpRow(RowProcessingState rowProcessingState) {
        this.collectionKey = null;
    }
}

