/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.collection.internal;

import org.hibernate.LockMode;
import org.hibernate.collection.spi.CollectionInitializerProducer;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.query.spi.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.collection.CollectionInitializer;
import org.hibernate.sql.results.graph.collection.internal.BagInitializer;

public class BagInitializerProducer
implements CollectionInitializerProducer {
    private final PluralAttributeMapping bagDescriptor;
    private final Fetch collectionIdFetch;
    private final Fetch elementFetch;

    public BagInitializerProducer(PluralAttributeMapping bagDescriptor, Fetch collectionIdFetch, Fetch elementFetch) {
        this.bagDescriptor = bagDescriptor;
        if (bagDescriptor.getIdentifierDescriptor() != null) {
            assert (collectionIdFetch != null);
            this.collectionIdFetch = collectionIdFetch;
        } else {
            assert (collectionIdFetch == null);
            this.collectionIdFetch = null;
        }
        this.elementFetch = elementFetch;
    }

    @Override
    public CollectionInitializer produceInitializer(NavigablePath navigablePath, PluralAttributeMapping attributeMapping, FetchParentAccess parentAccess, LockMode lockMode, DomainResultAssembler<?> collectionKeyAssembler, DomainResultAssembler<?> collectionValueKeyAssembler, AssemblerCreationState creationState) {
        DomainResultAssembler<?> elementAssembler = this.elementFetch.createAssembler(parentAccess, creationState);
        DomainResultAssembler<?> collectionIdAssembler = this.bagDescriptor.getIdentifierDescriptor() == null ? null : this.collectionIdFetch.createAssembler(parentAccess, creationState);
        return new BagInitializer(this.bagDescriptor, parentAccess, navigablePath, lockMode, collectionKeyAssembler, collectionValueKeyAssembler, elementAssembler, collectionIdAssembler);
    }
}

