/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.collection.internal;

import java.util.List;
import org.hibernate.collection.spi.CollectionInitializerProducer;
import org.hibernate.collection.spi.CollectionSemantics;
import org.hibernate.engine.FetchTiming;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.query.spi.NavigablePath;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.FetchableContainer;
import org.hibernate.sql.results.graph.collection.CollectionInitializer;
import org.hibernate.sql.results.graph.collection.internal.CollectionFetch;
import org.hibernate.sql.results.graph.collection.internal.EagerCollectionAssembler;
import org.hibernate.type.descriptor.java.JavaType;

public class EagerCollectionFetch
extends CollectionFetch
implements FetchParent {
    private final DomainResult<?> collectionKeyResult;
    private final DomainResult<?> collectionValueKeyResult;
    private final Fetch elementFetch;
    private final Fetch indexFetch;
    private final List<Fetch> fetches;
    private final CollectionInitializerProducer initializerProducer;

    public EagerCollectionFetch(NavigablePath fetchedPath, PluralAttributeMapping fetchedAttribute, TableGroup collectionTableGroup, FetchParent fetchParent, DomainResultCreationState creationState) {
        super(fetchedPath, fetchedAttribute, fetchParent);
        FromClauseAccess fromClauseAccess = creationState.getSqlAstCreationState().getFromClauseAccess();
        NavigablePath parentPath = fetchedPath.getParent();
        TableGroup parentTableGroup = fromClauseAccess.findTableGroup(parentPath);
        ForeignKeyDescriptor keyDescriptor = fetchedAttribute.getKeyDescriptor();
        this.collectionKeyResult = keyDescriptor.createTargetDomainResult(fetchedPath, parentTableGroup, creationState);
        this.collectionValueKeyResult = keyDescriptor.createKeyDomainResult(fetchedPath, collectionTableGroup, creationState);
        this.fetches = creationState.visitFetches(this);
        if (fetchedAttribute.getIndexDescriptor() != null) {
            assert (this.fetches.size() == 2);
            this.indexFetch = this.fetches.get(0);
            this.elementFetch = this.fetches.get(1);
        } else if (!this.fetches.isEmpty()) {
            assert (this.fetches.size() == 1);
            this.indexFetch = null;
            this.elementFetch = this.fetches.get(0);
        } else {
            this.indexFetch = null;
            this.elementFetch = null;
        }
        CollectionSemantics<?, ?> collectionSemantics = this.getFetchedMapping().getCollectionDescriptor().getCollectionSemantics();
        this.initializerProducer = collectionSemantics.createInitializerProducer(fetchedPath, fetchedAttribute, fetchParent, true, null, this.indexFetch, this.elementFetch, creationState);
    }

    @Override
    public DomainResultAssembler<?> createAssembler(FetchParentAccess parentAccess, AssemblerCreationState creationState) {
        CollectionInitializer initializer = (CollectionInitializer)creationState.resolveInitializer(this.getNavigablePath(), this.getReferencedModePart(), () -> {
            DomainResultAssembler<?> collectionKeyAssembler = this.collectionKeyResult.createResultAssembler(null, creationState);
            DomainResultAssembler<?> collectionValueKeyAssembler = this.collectionValueKeyResult.createResultAssembler(null, creationState);
            return this.initializerProducer.produceInitializer(this.getNavigablePath(), this.getFetchedMapping(), parentAccess, null, collectionKeyAssembler, collectionValueKeyAssembler, creationState);
        });
        return new EagerCollectionAssembler(this.getFetchedMapping(), initializer);
    }

    @Override
    public FetchTiming getTiming() {
        return FetchTiming.IMMEDIATE;
    }

    @Override
    public boolean hasTableGroup() {
        return true;
    }

    @Override
    public FetchableContainer getReferencedMappingContainer() {
        return this.getFetchedMapping();
    }

    @Override
    public PluralAttributeMapping getReferencedMappingType() {
        return this.getFetchedMapping();
    }

    @Override
    public List<Fetch> getFetches() {
        return this.fetches;
    }

    @Override
    public Fetch findFetch(Fetchable fetchable) {
        if (CollectionPart.Nature.ELEMENT.getName().equals(fetchable.getFetchableName())) {
            return this.elementFetch;
        }
        if (CollectionPart.Nature.INDEX.getName().equals(fetchable.getFetchableName())) {
            return this.indexFetch;
        }
        throw new IllegalArgumentException("Unknown fetchable [" + this.getFetchedMapping().getCollectionDescriptor().getRole() + " -> " + fetchable.getFetchableName() + "]");
    }

    @Override
    public JavaType<?> getResultJavaType() {
        return this.getFetchedMapping().getJavaType();
    }
}

