/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity.internal;

import java.util.function.Consumer;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.query.spi.NavigablePath;
import org.hibernate.query.sqm.spi.EntityIdentifierNavigablePath;
import org.hibernate.sql.results.graph.AbstractFetchParentAccess;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.graph.entity.EntityLoadingLogger;
import org.hibernate.sql.results.graph.entity.LoadingEntityEntry;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public class EntitySelectFetchInitializer
extends AbstractFetchParentAccess
implements EntityInitializer {
    private static final String CONCRETE_NAME = EntitySelectFetchInitializer.class.getSimpleName();
    private final FetchParentAccess parentAccess;
    private final NavigablePath navigablePath;
    private final boolean isEnhancedForLazyLoading;
    protected final EntityPersister concreteDescriptor;
    protected final DomainResultAssembler identifierAssembler;
    private final ToOneAttributeMapping referencedModelPart;
    protected boolean isInitialized;
    protected Object entityInstance;

    public EntitySelectFetchInitializer(FetchParentAccess parentAccess, ToOneAttributeMapping referencedModelPart, NavigablePath fetchedNavigable, EntityPersister concreteDescriptor, DomainResultAssembler identifierAssembler) {
        this.parentAccess = parentAccess;
        this.referencedModelPart = referencedModelPart;
        this.navigablePath = fetchedNavigable;
        this.concreteDescriptor = concreteDescriptor;
        this.identifierAssembler = identifierAssembler;
        this.isEnhancedForLazyLoading = concreteDescriptor.getBytecodeEnhancementMetadata().isEnhancedForLazyLoading();
    }

    @Override
    public ModelPart getInitializedPart() {
        return this.referencedModelPart;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public void resolveKey(RowProcessingState rowProcessingState) {
    }

    @Override
    public void resolveInstance(RowProcessingState rowProcessingState) {
        for (NavigablePath np = this.navigablePath.getParent(); np != null; np = np.getParent()) {
            if (!(np instanceof EntityIdentifierNavigablePath) && !"{fk}".equals(np.getUnaliasedLocalName())) continue;
            this.initializeInstance(rowProcessingState);
            return;
        }
    }

    @Override
    public void initializeInstance(RowProcessingState rowProcessingState) {
        boolean unwrapProxy;
        if (this.entityInstance != null || this.isInitialized) {
            return;
        }
        if (!this.isAttributeAssignableToConcreteDescriptor()) {
            return;
        }
        Object entityIdentifier = this.identifierAssembler.assemble(rowProcessingState);
        if (entityIdentifier == null) {
            this.isInitialized = true;
            return;
        }
        if (EntityLoadingLogger.TRACE_ENABLED) {
            EntityLoadingLogger.LOGGER.tracef("(%s) Beginning Initializer#resolveInstance process for entity (%s) : %s", (Object)StringHelper.collapse(this.getClass().getName()), (Object)this.getNavigablePath(), entityIdentifier);
        }
        SharedSessionContractImplementor session = rowProcessingState.getSession();
        String entityName = this.concreteDescriptor.getEntityName();
        EntityKey entityKey = new EntityKey(entityIdentifier, this.concreteDescriptor);
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        this.entityInstance = persistenceContext.getEntity(entityKey);
        if (this.entityInstance != null) {
            this.isInitialized = true;
            return;
        }
        Initializer initializer = rowProcessingState.getJdbcValuesSourceProcessingState().findInitializer(entityKey);
        if (initializer != null) {
            if (EntityLoadingLogger.DEBUG_ENABLED) {
                EntityLoadingLogger.LOGGER.debugf("(%s) Found an initializer for entity (%s) : %s", (Object)CONCRETE_NAME, (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), entityIdentifier), entityIdentifier);
            }
            initializer.resolveInstance(rowProcessingState);
            this.entityInstance = initializer.getInitializedInstance();
            this.isInitialized = true;
            return;
        }
        LoadingEntityEntry existingLoadingEntry = session.getPersistenceContext().getLoadContexts().findLoadingEntityEntry(entityKey);
        if (existingLoadingEntry != null) {
            if (EntityLoadingLogger.DEBUG_ENABLED) {
                EntityLoadingLogger.LOGGER.debugf("(%s) Found existing loading entry [%s] - using loading instance", (Object)CONCRETE_NAME, (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), entityIdentifier));
            }
            this.entityInstance = existingLoadingEntry.getEntityInstance();
            if (existingLoadingEntry.getEntityInitializer() != this) {
                if (EntityLoadingLogger.DEBUG_ENABLED) {
                    EntityLoadingLogger.LOGGER.debugf("(%s) Entity [%s] being loaded by another initializer [%s] - skipping processing", (Object)CONCRETE_NAME, (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), entityIdentifier), (Object)existingLoadingEntry.getEntityInitializer());
                }
                this.isInitialized = true;
                return;
            }
        }
        if (EntityLoadingLogger.DEBUG_ENABLED) {
            EntityLoadingLogger.LOGGER.debugf("(%s) Invoking session#internalLoad for entity (%s) : %s", (Object)CONCRETE_NAME, (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), entityIdentifier), entityIdentifier);
        }
        this.entityInstance = session.internalLoad(entityName, entityIdentifier, true, this.referencedModelPart.isNullable() || this.referencedModelPart.isIgnoreNotFound());
        if (EntityLoadingLogger.DEBUG_ENABLED) {
            EntityLoadingLogger.LOGGER.debugf("(%s) Entity [%s] : %s has being loaded by session.internalLoad.", (Object)CONCRETE_NAME, (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), entityIdentifier), entityIdentifier);
        }
        boolean bl = unwrapProxy = this.referencedModelPart.isUnwrapProxy() && this.isEnhancedForLazyLoading;
        if (this.entityInstance instanceof HibernateProxy) {
            ((HibernateProxy)this.entityInstance).getHibernateLazyInitializer().setUnwrap(unwrapProxy);
        }
        this.isInitialized = true;
    }

    protected boolean isAttributeAssignableToConcreteDescriptor() {
        AbstractEntityPersister declaringType;
        AbstractEntityPersister concreteDescriptor;
        return !(this.parentAccess instanceof EntityInitializer) || !(concreteDescriptor = (AbstractEntityPersister)((EntityInitializer)this.parentAccess).getConcreteDescriptor()).isPolymorphic() || concreteDescriptor == (declaringType = (AbstractEntityPersister)this.referencedModelPart.getDeclaringType()) || declaringType.getEntityMetamodel().getSubclassEntityNames().contains(concreteDescriptor.getEntityMetamodel().getName());
    }

    @Override
    public void finishUpRow(RowProcessingState rowProcessingState) {
        this.entityInstance = null;
        this.isInitialized = false;
        this.clearResolutionListeners();
    }

    @Override
    public EntityPersister getEntityDescriptor() {
        return this.concreteDescriptor;
    }

    @Override
    public Object getEntityInstance() {
        return this.entityInstance;
    }

    @Override
    public EntityKey getEntityKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getParentKey() {
        return this.parentAccess.getParentKey();
    }

    @Override
    public void registerResolutionListener(Consumer<Object> listener) {
        if (this.entityInstance != null) {
            listener.accept(this.entityInstance);
        } else {
            super.registerResolutionListener(listener);
        }
    }

    @Override
    public EntityPersister getConcreteDescriptor() {
        return this.concreteDescriptor;
    }

    public String toString() {
        return "EntitySelectFetchInitializer(" + LoggingHelper.toLoggableString(this.getNavigablePath()) + ")";
    }
}

