/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor;

import org.hibernate.type.descriptor.JdbcTypeNameMapper;
import org.jboss.logging.Logger;

public interface JdbcBindingLogging {
    public static final String NAME = "org.hibernate.orm.jdbc.bind";
    public static final Logger LOGGER;
    public static final boolean TRACE_ENABLED;
    public static final boolean DEBUG_ENABLED;

    public static void logBinding(int jdbcPosition, int typeCode, Object value) {
        if (!1.$assertionsDisabled && !TRACE_ENABLED) {
            throw new AssertionError();
        }
        LOGGER.tracef("binding parameter [%s] as [%s] - [%s]", jdbcPosition, (Object)JdbcTypeNameMapper.getTypeName(typeCode), value);
    }

    public static void logNullBinding(int jdbcPosition, int typeCode) {
        if (!1.$assertionsDisabled && !TRACE_ENABLED) {
            throw new AssertionError();
        }
        LOGGER.tracef("binding parameter [%s] as [%s] - [null]", jdbcPosition, (Object)JdbcTypeNameMapper.getTypeName(typeCode));
    }

    public static void logBinding(String callableParameterName, int typeCode, Object value) {
        if (!1.$assertionsDisabled && !TRACE_ENABLED) {
            throw new AssertionError();
        }
        LOGGER.tracef("binding parameter [%s] as [%s] - [%s]", (Object)callableParameterName, (Object)JdbcTypeNameMapper.getTypeName(typeCode), value);
    }

    public static void logNullBinding(String callableParameterName, int typeCode) {
        if (!1.$assertionsDisabled && !TRACE_ENABLED) {
            throw new AssertionError();
        }
        LOGGER.tracef("binding parameter [%s] as [%s] - [null]", (Object)callableParameterName, (Object)JdbcTypeNameMapper.getTypeName(typeCode));
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        LOGGER = Logger.getLogger((String)NAME);
        TRACE_ENABLED = LOGGER.isTraceEnabled();
        DEBUG_ENABLED = LOGGER.isDebugEnabled();
    }
}

