/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import jakarta.persistence.TemporalType;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTemporalJavaType;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.TemporalJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.spi.TypeConfiguration;

public class OffsetTimeJavaType
extends AbstractTemporalJavaType<OffsetTime> {
    public static final OffsetTimeJavaType INSTANCE = new OffsetTimeJavaType();

    public OffsetTimeJavaType() {
        super(OffsetTime.class, ImmutableMutabilityPlan.INSTANCE);
    }

    @Override
    public TemporalType getPrecision() {
        return TemporalType.TIME;
    }

    @Override
    public JdbcType getRecommendedJdbcType(JdbcTypeIndicators context) {
        return context.getTypeConfiguration().getJdbcTypeRegistry().getDescriptor(92);
    }

    @Override
    protected <X> TemporalJavaType<X> forTimePrecision(TypeConfiguration typeConfiguration) {
        return this;
    }

    @Override
    public String toString(OffsetTime value) {
        return DateTimeFormatter.ISO_OFFSET_TIME.format(value);
    }

    @Override
    public OffsetTime fromString(CharSequence string) {
        return OffsetTime.from(DateTimeFormatter.ISO_OFFSET_TIME.parse(string));
    }

    @Override
    public <X> X unwrap(OffsetTime offsetTime, Class<X> type, WrapperOptions options) {
        if (offsetTime == null) {
            return null;
        }
        if (OffsetTime.class.isAssignableFrom(type)) {
            return (X)offsetTime;
        }
        if (Time.class.isAssignableFrom(type)) {
            return (X)Time.valueOf(offsetTime.toLocalTime());
        }
        ZonedDateTime zonedDateTime = offsetTime.atDate(LocalDate.of(1970, 1, 1)).toZonedDateTime();
        if (Timestamp.class.isAssignableFrom(type)) {
            return (X)Timestamp.valueOf(zonedDateTime.toLocalDateTime());
        }
        if (Calendar.class.isAssignableFrom(type)) {
            return (X)GregorianCalendar.from(zonedDateTime);
        }
        Instant instant = zonedDateTime.toInstant();
        if (Long.class.isAssignableFrom(type)) {
            return (X)Long.valueOf(instant.toEpochMilli());
        }
        if (Date.class.isAssignableFrom(type)) {
            return (X)Date.from(instant);
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> OffsetTime wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof OffsetTime) {
            return (OffsetTime)value;
        }
        ZoneOffset offset = OffsetDateTime.now().getOffset();
        if (value instanceof Time) {
            return ((Time)value).toLocalTime().atOffset(offset);
        }
        if (value instanceof Timestamp) {
            Timestamp ts = (Timestamp)value;
            return ts.toLocalDateTime().toLocalTime().atOffset(offset);
        }
        if (value instanceof Date) {
            Date date = (Date)value;
            return OffsetTime.ofInstant(date.toInstant(), offset);
        }
        if (value instanceof Long) {
            return OffsetTime.ofInstant(Instant.ofEpochMilli((Long)value), offset);
        }
        if (value instanceof Calendar) {
            Calendar calendar = (Calendar)value;
            return OffsetTime.ofInstant(calendar.toInstant(), calendar.getTimeZone().toZoneId());
        }
        throw this.unknownWrap(value.getClass());
    }

    @Override
    public int getDefaultSqlPrecision(Dialect dialect, JdbcType jdbcType) {
        return 0;
    }
}

