/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java.spi;

import java.lang.reflect.Type;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.hibernate.collection.internal.StandardArraySemantics;
import org.hibernate.collection.internal.StandardBagSemantics;
import org.hibernate.collection.internal.StandardListSemantics;
import org.hibernate.collection.internal.StandardMapSemantics;
import org.hibernate.collection.internal.StandardOrderedMapSemantics;
import org.hibernate.collection.internal.StandardOrderedSetSemantics;
import org.hibernate.collection.internal.StandardSetSemantics;
import org.hibernate.collection.internal.StandardSortedMapSemantics;
import org.hibernate.collection.internal.StandardSortedSetSemantics;
import org.hibernate.type.descriptor.java.BigDecimalJavaType;
import org.hibernate.type.descriptor.java.BigIntegerJavaType;
import org.hibernate.type.descriptor.java.BlobJavaType;
import org.hibernate.type.descriptor.java.BooleanJavaType;
import org.hibernate.type.descriptor.java.ByteArrayJavaType;
import org.hibernate.type.descriptor.java.ByteJavaType;
import org.hibernate.type.descriptor.java.CalendarJavaType;
import org.hibernate.type.descriptor.java.CharacterArrayJavaType;
import org.hibernate.type.descriptor.java.CharacterJavaType;
import org.hibernate.type.descriptor.java.ClassJavaType;
import org.hibernate.type.descriptor.java.ClobJavaType;
import org.hibernate.type.descriptor.java.CurrencyJavaType;
import org.hibernate.type.descriptor.java.DateJavaType;
import org.hibernate.type.descriptor.java.DoubleJavaType;
import org.hibernate.type.descriptor.java.DurationJavaType;
import org.hibernate.type.descriptor.java.FloatTypeDescriptor;
import org.hibernate.type.descriptor.java.InetAddressJavaType;
import org.hibernate.type.descriptor.java.InstantJavaType;
import org.hibernate.type.descriptor.java.IntegerJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.JdbcDateJavaType;
import org.hibernate.type.descriptor.java.JdbcTimeJavaType;
import org.hibernate.type.descriptor.java.JdbcTimestampJavaType;
import org.hibernate.type.descriptor.java.LocalDateJavaType;
import org.hibernate.type.descriptor.java.LocalDateTimeJavaType;
import org.hibernate.type.descriptor.java.LocalTimeJavaType;
import org.hibernate.type.descriptor.java.LocaleJavaType;
import org.hibernate.type.descriptor.java.LongJavaType;
import org.hibernate.type.descriptor.java.NClobJavaType;
import org.hibernate.type.descriptor.java.ObjectJavaType;
import org.hibernate.type.descriptor.java.OffsetDateTimeJavaType;
import org.hibernate.type.descriptor.java.OffsetTimeJavaType;
import org.hibernate.type.descriptor.java.PrimitiveByteArrayJavaType;
import org.hibernate.type.descriptor.java.PrimitiveCharacterArrayJavaType;
import org.hibernate.type.descriptor.java.ShortJavaType;
import org.hibernate.type.descriptor.java.StringJavaType;
import org.hibernate.type.descriptor.java.TimeZoneJavaType;
import org.hibernate.type.descriptor.java.UUIDJavaType;
import org.hibernate.type.descriptor.java.UrlJavaType;
import org.hibernate.type.descriptor.java.YearJavaType;
import org.hibernate.type.descriptor.java.ZoneIdJavaType;
import org.hibernate.type.descriptor.java.ZoneOffsetJavaType;
import org.hibernate.type.descriptor.java.ZonedDateTimeJavaType;
import org.hibernate.type.descriptor.java.spi.CollectionJavaType;
import org.hibernate.type.descriptor.java.spi.MapEntryJavaType;
import org.hibernate.type.descriptor.java.spi.PrimitiveJavaType;

public class JavaTypeBaseline {
    public static void prime(BaselineTarget target) {
        JavaTypeBaseline.primePrimitive(target, ByteJavaType.INSTANCE);
        JavaTypeBaseline.primePrimitive(target, BooleanJavaType.INSTANCE);
        JavaTypeBaseline.primePrimitive(target, CharacterJavaType.INSTANCE);
        JavaTypeBaseline.primePrimitive(target, ShortJavaType.INSTANCE);
        JavaTypeBaseline.primePrimitive(target, IntegerJavaType.INSTANCE);
        JavaTypeBaseline.primePrimitive(target, LongJavaType.INSTANCE);
        JavaTypeBaseline.primePrimitive(target, FloatTypeDescriptor.INSTANCE);
        JavaTypeBaseline.primePrimitive(target, DoubleJavaType.INSTANCE);
        target.addBaselineDescriptor(ObjectJavaType.INSTANCE);
        target.addBaselineDescriptor(BigDecimalJavaType.INSTANCE);
        target.addBaselineDescriptor(BigIntegerJavaType.INSTANCE);
        target.addBaselineDescriptor(StringJavaType.INSTANCE);
        target.addBaselineDescriptor(BlobJavaType.INSTANCE);
        target.addBaselineDescriptor(ClobJavaType.INSTANCE);
        target.addBaselineDescriptor(NClobJavaType.INSTANCE);
        target.addBaselineDescriptor(ByteArrayJavaType.INSTANCE);
        target.addBaselineDescriptor(CharacterArrayJavaType.INSTANCE);
        target.addBaselineDescriptor(PrimitiveByteArrayJavaType.INSTANCE);
        target.addBaselineDescriptor(PrimitiveCharacterArrayJavaType.INSTANCE);
        target.addBaselineDescriptor(DurationJavaType.INSTANCE);
        target.addBaselineDescriptor(InstantJavaType.INSTANCE);
        target.addBaselineDescriptor(LocalDateJavaType.INSTANCE);
        target.addBaselineDescriptor(LocalDateTimeJavaType.INSTANCE);
        target.addBaselineDescriptor(LocalTimeJavaType.INSTANCE);
        target.addBaselineDescriptor(OffsetDateTimeJavaType.INSTANCE);
        target.addBaselineDescriptor(OffsetTimeJavaType.INSTANCE);
        target.addBaselineDescriptor(ZonedDateTimeJavaType.INSTANCE);
        target.addBaselineDescriptor(YearJavaType.INSTANCE);
        target.addBaselineDescriptor(ZoneIdJavaType.INSTANCE);
        target.addBaselineDescriptor(ZoneOffsetJavaType.INSTANCE);
        target.addBaselineDescriptor(CalendarJavaType.INSTANCE);
        target.addBaselineDescriptor(DateJavaType.INSTANCE);
        target.addBaselineDescriptor((Type)((Object)Date.class), JdbcDateJavaType.INSTANCE);
        target.addBaselineDescriptor((Type)((Object)Time.class), JdbcTimeJavaType.INSTANCE);
        target.addBaselineDescriptor((Type)((Object)Timestamp.class), JdbcTimestampJavaType.INSTANCE);
        target.addBaselineDescriptor(TimeZoneJavaType.INSTANCE);
        target.addBaselineDescriptor(ClassJavaType.INSTANCE);
        target.addBaselineDescriptor(CurrencyJavaType.INSTANCE);
        target.addBaselineDescriptor(LocaleJavaType.INSTANCE);
        target.addBaselineDescriptor(UrlJavaType.INSTANCE);
        target.addBaselineDescriptor(UUIDJavaType.INSTANCE);
        target.addBaselineDescriptor(InetAddressJavaType.INSTANCE);
        JavaTypeBaseline.registerCollectionTypes(target);
        target.addBaselineDescriptor(MapEntryJavaType.INSTANCE);
    }

    private static void registerCollectionTypes(BaselineTarget target) {
        target.addBaselineDescriptor(new CollectionJavaType<Collection>(Collection.class, StandardBagSemantics.INSTANCE));
        target.addBaselineDescriptor(new CollectionJavaType<Object[]>(Object[].class, StandardArraySemantics.INSTANCE));
        target.addBaselineDescriptor(new CollectionJavaType<List>(List.class, StandardListSemantics.INSTANCE));
        target.addBaselineDescriptor(new CollectionJavaType<ArrayList>(ArrayList.class, StandardListSemantics.INSTANCE));
        target.addBaselineDescriptor(new CollectionJavaType<Set>(Set.class, StandardSetSemantics.INSTANCE));
        target.addBaselineDescriptor(new CollectionJavaType<HashSet>(HashSet.class, StandardSetSemantics.INSTANCE));
        target.addBaselineDescriptor(new CollectionJavaType<SortedSet>(SortedSet.class, StandardSortedSetSemantics.INSTANCE));
        target.addBaselineDescriptor(new CollectionJavaType<TreeSet>(TreeSet.class, StandardOrderedSetSemantics.INSTANCE));
        target.addBaselineDescriptor(new CollectionJavaType<LinkedHashSet>(LinkedHashSet.class, StandardOrderedSetSemantics.INSTANCE));
        target.addBaselineDescriptor(new CollectionJavaType<Map>(Map.class, StandardMapSemantics.INSTANCE));
        target.addBaselineDescriptor(new CollectionJavaType<HashMap>(HashMap.class, StandardMapSemantics.INSTANCE));
        target.addBaselineDescriptor(new CollectionJavaType<SortedMap>(SortedMap.class, StandardSortedMapSemantics.INSTANCE));
        target.addBaselineDescriptor(new CollectionJavaType<TreeMap>(TreeMap.class, StandardSortedMapSemantics.INSTANCE));
        target.addBaselineDescriptor(new CollectionJavaType<LinkedHashMap>(LinkedHashMap.class, StandardOrderedMapSemantics.INSTANCE));
    }

    private static void primePrimitive(BaselineTarget target, JavaType descriptor) {
        target.addBaselineDescriptor(descriptor);
        target.addBaselineDescriptor(((PrimitiveJavaType)descriptor).getPrimitiveClass(), descriptor);
    }

    public static interface BaselineTarget {
        public void addBaselineDescriptor(JavaType<?> var1);

        public void addBaselineDescriptor(Type var1, JavaType<?> var2);
    }
}

