/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Objects;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.ValueHolder;
import org.hibernate.metamodel.mapping.NaturalIdMapping;
import org.hibernate.persister.entity.EntityPersister;

public class NaturalIdCacheKey
implements Serializable {
    private final Object naturalIdValues;
    private final String entityName;
    private final String tenantId;
    private final int hashCode;
    private transient ValueHolder<String> toString;

    public NaturalIdCacheKey(Object naturalIdValues, EntityPersister persister, SharedSessionContractImplementor session) {
        this(naturalIdValues, persister, persister.getRootEntityName(), session);
    }

    public NaturalIdCacheKey(Object naturalIdValues, EntityPersister persister, String entityName, SharedSessionContractImplementor session) {
        this.entityName = entityName;
        this.tenantId = session.getTenantIdentifier();
        NaturalIdMapping naturalIdMapping = persister.getNaturalIdMapping();
        this.naturalIdValues = naturalIdMapping.disassemble(naturalIdValues, session);
        this.hashCode = naturalIdMapping.calculateHashCode(naturalIdValues, session);
        this.initTransients();
    }

    private void initTransients() {
        this.toString = new ValueHolder<ValueHolder.DeferredInitializer<String>>(() -> {
            StringBuilder toStringBuilder = new StringBuilder().append(this.entityName).append("##NaturalId[");
            if (this.naturalIdValues instanceof Object[]) {
                Object[] values = (Object[])this.naturalIdValues;
                for (int i = 0; i < values.length; ++i) {
                    toStringBuilder.append(values[i]);
                    if (i + 1 >= values.length) continue;
                    toStringBuilder.append(", ");
                }
            } else {
                toStringBuilder.append(this.naturalIdValues);
            }
            return toStringBuilder.toString();
        });
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public Object getNaturalIdValues() {
        return this.naturalIdValues;
    }

    public String toString() {
        return this.toString.getValue();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (this.hashCode != o.hashCode() || !(o instanceof NaturalIdCacheKey)) {
            return false;
        }
        NaturalIdCacheKey other = (NaturalIdCacheKey)o;
        return Objects.equals(this.entityName, other.entityName) && Objects.equals(this.tenantId, other.tenantId) && Objects.deepEquals(this.naturalIdValues, other.naturalIdValues);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.initTransients();
    }
}

