/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.query.IllegalQueryOperationException;
import org.hibernate.query.sqm.BinaryArithmeticOperator;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.query.sqm.FetchClauseType;
import org.hibernate.query.sqm.FrameExclusion;
import org.hibernate.query.sqm.FrameKind;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.expression.BinaryArithmeticExpression;
import org.hibernate.sql.ast.tree.expression.CaseSearchedExpression;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.FunctionExpression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.Over;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.from.FunctionTableReference;
import org.hibernate.sql.ast.tree.from.QueryPartTableReference;
import org.hibernate.sql.ast.tree.from.UnionTableGroup;
import org.hibernate.sql.ast.tree.from.ValuesTableReference;
import org.hibernate.sql.ast.tree.insert.Values;
import org.hibernate.sql.ast.tree.select.QueryGroup;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.ast.tree.select.SortSpecification;
import org.hibernate.sql.exec.spi.JdbcOperation;

public class OracleSqlAstTranslator<T extends JdbcOperation>
extends AbstractSqlAstTranslator<T> {
    public OracleSqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    @Override
    protected AbstractSqlAstTranslator.LockStrategy determineLockingStrategy(QuerySpec querySpec, AbstractSqlAstTranslator.ForUpdateClause forUpdateClause, Boolean followOnLocking) {
        AbstractSqlAstTranslator.LockStrategy strategy = super.determineLockingStrategy(querySpec, forUpdateClause, followOnLocking);
        boolean followOnLockingDisabled = Boolean.FALSE.equals(followOnLocking);
        if (strategy != AbstractSqlAstTranslator.LockStrategy.FOLLOW_ON && querySpec.hasSortSpecifications()) {
            if (followOnLockingDisabled) {
                throw new IllegalQueryOperationException("Locking with ORDER BY is not supported!");
            }
            strategy = AbstractSqlAstTranslator.LockStrategy.FOLLOW_ON;
        }
        if (strategy != AbstractSqlAstTranslator.LockStrategy.FOLLOW_ON && this.isPartOfQueryGroup()) {
            if (followOnLockingDisabled) {
                throw new IllegalQueryOperationException("Locking with set operators is not supported!");
            }
            strategy = AbstractSqlAstTranslator.LockStrategy.FOLLOW_ON;
        }
        if (strategy != AbstractSqlAstTranslator.LockStrategy.FOLLOW_ON && this.hasSetOperations(querySpec)) {
            if (followOnLockingDisabled) {
                throw new IllegalQueryOperationException("Locking with set operators is not supported!");
            }
            strategy = AbstractSqlAstTranslator.LockStrategy.FOLLOW_ON;
        }
        if (strategy != AbstractSqlAstTranslator.LockStrategy.FOLLOW_ON && this.useOffsetFetchClause(querySpec) && !this.isRowsOnlyFetchClauseType(querySpec)) {
            if (followOnLockingDisabled) {
                throw new IllegalQueryOperationException("Locking with FETCH is not supported!");
            }
            strategy = AbstractSqlAstTranslator.LockStrategy.FOLLOW_ON;
        }
        if (strategy != AbstractSqlAstTranslator.LockStrategy.FOLLOW_ON) {
            boolean hasOffset;
            if (querySpec.isRoot() && this.hasLimit() && this.getLimit().getFirstRow() != null) {
                hasOffset = true;
                this.addAppliedParameterBinding(this.getOffsetParameter(), null);
            } else {
                boolean bl = hasOffset = querySpec.getOffsetClauseExpression() != null;
            }
            if (hasOffset) {
                if (followOnLockingDisabled) {
                    throw new IllegalQueryOperationException("Locking with OFFSET is not supported!");
                }
                strategy = AbstractSqlAstTranslator.LockStrategy.FOLLOW_ON;
            }
        }
        return strategy;
    }

    private boolean hasSetOperations(QuerySpec querySpec) {
        return querySpec.getFromClause().queryTableGroups(group -> group instanceof UnionTableGroup ? group : null) != null;
    }

    private boolean isPartOfQueryGroup() {
        return this.getQueryPartStack().findCurrentFirst(part -> part instanceof QueryGroup ? part : null) != null;
    }

    protected boolean shouldEmulateFetchClause(QueryPart queryPart) {
        boolean hasLimit;
        if (this.getQueryPartForRowNumbering() == queryPart) {
            return false;
        }
        boolean bl = hasLimit = queryPart.isRoot() && this.hasLimit() || queryPart.getFetchClauseExpression() != null || queryPart.getOffsetClauseExpression() != null;
        if (!hasLimit) {
            return false;
        }
        if (this.supportsOffsetFetchClause()) {
            return !queryPart.hasSortSpecifications() && !this.hasOffset(queryPart);
        }
        return true;
    }

    @Override
    protected FetchClauseType getFetchClauseTypeForRowNumbering(QueryPart queryPart) {
        boolean hasOffset;
        FetchClauseType fetchClauseType = super.getFetchClauseTypeForRowNumbering(queryPart);
        if (queryPart.isRoot() && this.hasLimit()) {
            hasOffset = this.getLimit().getFirstRow() != null;
        } else {
            boolean bl = hasOffset = queryPart.getOffsetClauseExpression() != null;
        }
        if (queryPart instanceof QuerySpec && !hasOffset && fetchClauseType == FetchClauseType.ROWS_ONLY) {
            return null;
        }
        return fetchClauseType;
    }

    @Override
    protected void emulateFetchOffsetWithWindowFunctions(QueryPart queryPart, Expression offsetExpression, Expression fetchExpression, FetchClauseType fetchClauseType, boolean emulateFetchClause) {
        if (queryPart instanceof QuerySpec && offsetExpression == null && fetchClauseType == FetchClauseType.ROWS_ONLY) {
            QuerySpec querySpec = (QuerySpec)queryPart;
            this.withRowNumbering(querySpec, true, () -> {
                boolean needsWrapper;
                boolean needsParenthesis;
                QueryPart currentQueryPart = this.getQueryPartStack().getCurrent();
                if (currentQueryPart instanceof QueryGroup) {
                    needsParenthesis = false;
                    needsWrapper = !currentQueryPart.hasOffsetOrFetchClause();
                } else {
                    needsParenthesis = !querySpec.isRoot();
                    needsWrapper = true;
                }
                if (needsWrapper) {
                    if (needsParenthesis) {
                        this.appendSql('(');
                    }
                    this.appendSql("select * from ");
                    if (!needsParenthesis) {
                        this.appendSql('(');
                    }
                }
                super.visitQuerySpec(querySpec);
                if (needsWrapper && !needsParenthesis) {
                    this.appendSql(')');
                }
                this.appendSql(" where rownum<=");
                Stack<Clause> clauseStack = this.getClauseStack();
                clauseStack.push(Clause.WHERE);
                try {
                    fetchExpression.accept(this);
                    clauseStack.pop();
                    clauseStack.push(Clause.FOR_UPDATE);
                    this.visitForUpdateClause(querySpec);
                }
                finally {
                    clauseStack.pop();
                }
                if (needsWrapper && needsParenthesis) {
                    this.appendSql(')');
                }
            });
        } else {
            super.emulateFetchOffsetWithWindowFunctions(queryPart, offsetExpression, fetchExpression, fetchClauseType, emulateFetchClause);
        }
    }

    @Override
    protected void visitOrderBy(List<SortSpecification> sortSpecifications) {
        QuerySpec querySpec;
        QueryPart queryPartForRowNumbering = this.getQueryPartForRowNumbering();
        if (queryPartForRowNumbering == null) {
            this.renderOrderBy(true, sortSpecifications);
        } else if (!(this.getFetchClauseTypeForRowNumbering(queryPartForRowNumbering) != null || (querySpec = (QuerySpec)queryPartForRowNumbering).getOffsetClauseExpression() != null || querySpec.isRoot() && this.getOffsetParameter() != null)) {
            this.renderOrderBy(true, sortSpecifications);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void visitValuesList(List<Values> valuesList) {
        if (valuesList.size() < 2) {
            super.visitValuesList(valuesList);
        } else {
            String separator = "";
            Stack<Clause> clauseStack = this.getClauseStack();
            try {
                clauseStack.push(Clause.VALUES);
                for (Values values : valuesList) {
                    this.appendSql(separator);
                    this.renderExpressionsAsSubquery(values.getExpressions());
                    separator = " union all ";
                }
            }
            finally {
                clauseStack.pop();
            }
        }
    }

    @Override
    public void visitValuesTableReference(ValuesTableReference tableReference) {
        this.emulateValuesTableReferenceColumnAliasing(tableReference);
    }

    @Override
    public void visitQueryPartTableReference(QueryPartTableReference tableReference) {
        this.emulateQueryPartTableReferenceColumnAliasing(tableReference);
    }

    @Override
    public void visitFunctionTableReference(FunctionTableReference tableReference) {
        this.append("table(");
        tableReference.getFunctionExpression().accept(this);
        this.append(')');
        this.renderTableReferenceIdentificationVariable(tableReference);
    }

    @Override
    public void visitQueryGroup(QueryGroup queryGroup) {
        if (this.shouldEmulateFetchClause(queryGroup)) {
            this.emulateFetchOffsetWithWindowFunctions(queryGroup, true);
        } else {
            super.visitQueryGroup(queryGroup);
        }
    }

    @Override
    public void visitQuerySpec(QuerySpec querySpec) {
        if (this.shouldEmulateFetchClause(querySpec)) {
            this.emulateFetchOffsetWithWindowFunctions(querySpec, true);
        } else {
            super.visitQuerySpec(querySpec);
        }
    }

    @Override
    public void visitOffsetFetchClause(QueryPart queryPart) {
        if (!this.isRowNumberingCurrentQueryPart()) {
            if (this.supportsOffsetFetchClause()) {
                this.renderOffsetFetchClause(queryPart, true);
            } else {
                this.assertRowsOnlyFetchClauseType(queryPart);
            }
        }
    }

    @Override
    protected void renderRowNumber(SelectClause selectClause, QueryPart queryPart) {
        if (!queryPart.hasSortSpecifications()) {
            this.appendSql("rownum");
        } else {
            super.renderRowNumber(selectClause, queryPart);
        }
    }

    @Override
    public void visitOver(Over<?> over) {
        Expression expression = over.getExpression();
        if (expression instanceof FunctionExpression && "row_number".equals(((FunctionExpression)expression).getFunctionName()) && over.getPartitions().isEmpty() && over.getOrderList().isEmpty() && over.getStartKind() == FrameKind.UNBOUNDED_PRECEDING && over.getEndKind() == FrameKind.CURRENT_ROW && over.getExclusion() == FrameExclusion.NO_OTHERS) {
            this.append("rownum");
            return;
        }
        super.visitOver(over);
    }

    @Override
    protected void renderComparison(Expression lhs, ComparisonOperator operator, Expression rhs) {
        this.renderComparisonEmulateDecode(lhs, operator, rhs);
    }

    @Override
    protected void renderSelectTupleComparison(List<SqlSelection> lhsExpressions, SqlTuple tuple, ComparisonOperator operator) {
        this.emulateSelectTupleComparison(lhsExpressions, tuple.getExpressions(), operator, true);
    }

    @Override
    protected void visitCaseSearchedExpression(CaseSearchedExpression caseSearchedExpression, boolean inSelect) {
        if (this.getDialect().getVersion().isBefore(9)) {
            this.visitDecodeCaseSearchedExpression(caseSearchedExpression);
        } else {
            super.visitCaseSearchedExpression(caseSearchedExpression, inSelect);
        }
    }

    @Override
    protected void renderPartitionItem(Expression expression) {
        if (expression instanceof Literal) {
            this.appendSql("()");
        } else if (expression instanceof Summarization) {
            Summarization summarization = (Summarization)expression;
            this.appendSql(summarization.getKind().sqlText());
            this.appendSql('(');
            this.renderCommaSeparated(summarization.getGroupings());
            this.appendSql(')');
        } else {
            expression.accept(this);
        }
    }

    @Override
    protected boolean supportsRowValueConstructorSyntax() {
        return false;
    }

    @Override
    protected boolean supportsRowValueConstructorSyntaxInInList() {
        return this.getDialect().getVersion().isSameOrAfter(8, 2);
    }

    @Override
    protected boolean supportsRowValueConstructorSyntaxInQuantifiedPredicates() {
        return false;
    }

    @Override
    protected boolean supportsRowValueConstructorSyntaxInInSubQuery() {
        return this.getDialect().getVersion().isSameOrAfter(9);
    }

    @Override
    protected String getFromDual() {
        return " from dual";
    }

    @Override
    protected String getFromDualForSelectOnly() {
        return this.getFromDual();
    }

    private boolean supportsOffsetFetchClause() {
        return this.getDialect().supportsFetchClause(FetchClauseType.ROWS_ONLY);
    }

    @Override
    public void visitBinaryArithmeticExpression(BinaryArithmeticExpression arithmeticExpression) {
        BinaryArithmeticOperator operator = arithmeticExpression.getOperator();
        if (operator == BinaryArithmeticOperator.MODULO) {
            this.append("mod");
            this.appendSql('(');
            arithmeticExpression.getLeftHandOperand().accept(this);
            this.appendSql(',');
            arithmeticExpression.getRightHandOperand().accept(this);
            this.appendSql(')');
            return;
        }
        super.visitBinaryArithmeticExpression(arithmeticExpression);
    }
}

