/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import jakarta.persistence.TemporalType;
import java.util.Arrays;
import java.util.List;
import org.hibernate.dialect.Dialect;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.sqm.TemporalUnit;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.function.SelfRenderingFunctionSqlAstExpression;
import org.hibernate.query.sqm.produce.function.ArgumentTypesValidator;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionArgumentTypeResolvers;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.query.sqm.produce.function.internal.PatternRenderer;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.DurationUnit;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.spi.TypeConfiguration;

public class TimestampdiffFunction
extends AbstractSqmSelfRenderingFunctionDescriptor {
    private final Dialect dialect;

    public TimestampdiffFunction(Dialect dialect, TypeConfiguration typeConfiguration) {
        super("timestampdiff", new ArgumentTypesValidator(StandardArgumentsValidators.exactly(3), FunctionParameterType.TEMPORAL_UNIT, FunctionParameterType.TEMPORAL, FunctionParameterType.TEMPORAL), StandardFunctionReturnTypeResolvers.invariant(typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.LONG)), StandardFunctionArgumentTypeResolvers.invariant(typeConfiguration, FunctionParameterType.TEMPORAL_UNIT, FunctionParameterType.TEMPORAL, FunctionParameterType.TEMPORAL));
        this.dialect = dialect;
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> arguments, SqlAstTranslator<?> walker) {
        DurationUnit field = (DurationUnit)arguments.get(0);
        Expression from = (Expression)arguments.get(1);
        Expression to = (Expression)arguments.get(2);
        this.patternRenderer(field.getUnit(), from, to).render(sqlAppender, arguments, walker);
    }

    private PatternRenderer patternRenderer(TemporalUnit unit, Expression from, Expression to) {
        TemporalType lhsTemporalType = TypeConfiguration.getSqlTemporalType(from.getExpressionType());
        TemporalType rhsTemporalType = TypeConfiguration.getSqlTemporalType(to.getExpressionType());
        return new PatternRenderer(this.dialect.timestampdiffPattern(unit, lhsTemporalType, rhsTemporalType));
    }

    public SelfRenderingFunctionSqlAstExpression expression(ReturnableType<?> impliedResultType, SqlAstNode ... sqlAstArguments) {
        DurationUnit field = (DurationUnit)sqlAstArguments[0];
        return new SelfRenderingFunctionSqlAstExpression(this.getName(), this, Arrays.asList(sqlAstArguments), impliedResultType != null ? impliedResultType : (ReturnableType)((Object)field.getExpressionType().getJdbcMapping()), field.getExpressionType());
    }

    @Override
    public String getArgumentListSignature() {
        return "(TEMPORAL_UNIT field, TEMPORAL start, TEMPORAL end)";
    }
}

