/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel;

import jakarta.persistence.metamodel.PluralAttribute;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import org.hibernate.Incubating;
import org.hibernate.boot.BootLogging;

@Incubating
public enum CollectionClassification {
    ARRAY(PluralAttribute.CollectionType.COLLECTION),
    BAG(PluralAttribute.CollectionType.COLLECTION),
    ID_BAG(PluralAttribute.CollectionType.COLLECTION),
    LIST(PluralAttribute.CollectionType.LIST),
    SET(PluralAttribute.CollectionType.SET),
    SORTED_SET(PluralAttribute.CollectionType.SET),
    ORDERED_SET(PluralAttribute.CollectionType.SET),
    MAP(PluralAttribute.CollectionType.MAP),
    SORTED_MAP(PluralAttribute.CollectionType.MAP),
    ORDERED_MAP(PluralAttribute.CollectionType.MAP);

    private final PluralAttribute.CollectionType jpaClassification;

    private CollectionClassification(PluralAttribute.CollectionType jpaClassification) {
        this.jpaClassification = jpaClassification;
    }

    public PluralAttribute.CollectionType toJpaClassification() {
        return this.jpaClassification;
    }

    public static CollectionClassification interpretSetting(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof CollectionClassification) {
            return (CollectionClassification)((Object)value);
        }
        if (value instanceof String) {
            String string = (String)value;
            for (CollectionClassification collectionClassification : CollectionClassification.values()) {
                if (!collectionClassification.name().equalsIgnoreCase(string)) continue;
                return collectionClassification;
            }
        }
        if (value instanceof Class) {
            Class configuredClass = (Class)value;
            if (List.class.isAssignableFrom(configuredClass)) {
                return LIST;
            }
            if (SortedSet.class.isAssignableFrom(configuredClass)) {
                return SORTED_SET;
            }
            if (Set.class.isAssignableFrom(configuredClass)) {
                return SET;
            }
            if (SortedMap.class.isAssignableFrom(configuredClass)) {
                return SORTED_MAP;
            }
            if (Map.class.isAssignableFrom(configuredClass)) {
                return MAP;
            }
            if (Collection.class.isAssignableFrom(configuredClass)) {
                return BAG;
            }
            BootLogging.LOGGER.debugf("Unexpected Class specified for CollectionClassification resolution (`%s`) - should be one of `%s`, `%s`, `%s`, `%s`, `%s` or `%s`  (or subclass of)", new Object[]{configuredClass.getName(), List.class.getName(), SortedSet.class.getName(), Set.class.getName(), SortedMap.class.isAssignableFrom(configuredClass), Map.class.isAssignableFrom(configuredClass), Collection.class.getName()});
        }
        return null;
    }
}

