/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.io.Serializable;
import java.util.Locale;
import java.util.function.Consumer;
import org.hibernate.MappingException;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.SharedSessionContract;
import org.hibernate.bytecode.spi.ReflectionOptimizer;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.mapping.Any;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.AttributeMetadata;
import org.hibernate.metamodel.mapping.AttributeMetadataAccess;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.internal.DiscriminatedAssociationAttributeMapping;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationHelper;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.metamodel.spi.EmbeddableRepresentationStrategy;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.property.access.internal.PropertyAccessStrategyBackRefImpl;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.type.AnyType;
import org.hibernate.type.BasicType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.spi.TypeConfiguration;

public abstract class AbstractEmbeddableMapping
implements EmbeddableMappingType {
    protected final SessionFactoryImplementor sessionFactory;

    public AbstractEmbeddableMapping(MappingModelCreationProcess creationProcess) {
        this(creationProcess.getCreationContext());
    }

    public AbstractEmbeddableMapping(RuntimeModelCreationContext creationContext) {
        this(creationContext.getSessionFactory());
    }

    protected AbstractEmbeddableMapping(SessionFactoryImplementor sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public JavaType<?> getMappedJavaType() {
        return this.getRepresentationStrategy().getMappedJavaType();
    }

    @Override
    public Object[] getValues(Object compositeInstance) {
        if (compositeInstance == PropertyAccessStrategyBackRefImpl.UNKNOWN) {
            return new Object[this.getNumberOfAttributeMappings()];
        }
        ReflectionOptimizer optimizer = this.getRepresentationStrategy().getReflectionOptimizer();
        if (optimizer != null && optimizer.getAccessOptimizer() != null) {
            return optimizer.getAccessOptimizer().getPropertyValues(compositeInstance);
        }
        Object[] results = new Object[this.getNumberOfAttributeMappings()];
        this.forEachAttributeMapping((position, attribute) -> {
            Getter getter = attribute.getAttributeMetadataAccess().resolveAttributeMetadata(this.findContainingEntityMapping()).getPropertyAccess().getGetter();
            results[position] = getter.get(compositeInstance);
        });
        return results;
    }

    @Override
    public void setValues(Object component, Object[] values) {
        ReflectionOptimizer optimizer = this.getRepresentationStrategy().getReflectionOptimizer();
        if (optimizer != null && optimizer.getAccessOptimizer() != null) {
            optimizer.getAccessOptimizer().setPropertyValues(component, values);
        } else {
            this.forEachAttributeMapping((position, attribute) -> attribute.getPropertyAccess().getSetter().set(component, values[position]));
        }
    }

    protected static boolean finishInitialization(NavigableRole navigableRole, Component bootDescriptor, CompositeType compositeType, String rootTableExpression, String[] rootTableKeyColumnNames, EmbeddableMappingType declarer, EmbeddableRepresentationStrategy representationStrategy, AttributeTypeValidator attributeTypeValidator, ConcreteTableResolver concreteTableResolver, Consumer<AttributeMapping> attributeConsumer, SuccessfulCompletionCallback completionCallback, final MappingModelCreationProcess creationProcess) {
        SessionFactoryImplementor sessionFactory = creationProcess.getCreationContext().getSessionFactory();
        TypeConfiguration typeConfiguration = sessionFactory.getTypeConfiguration();
        JdbcServices jdbcServices = sessionFactory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        Dialect dialect = jdbcEnvironment.getDialect();
        Type[] subtypes = compositeType.getSubtypes();
        int attributeIndex = 0;
        int columnPosition = 0;
        for (Property bootPropertyDescriptor : bootDescriptor.getProperties()) {
            EntityPersister entityPersister;
            AttributeMapping attributeMapping;
            Type subtype = subtypes[attributeIndex];
            attributeTypeValidator.check(bootPropertyDescriptor.getName(), subtype);
            final PropertyAccess propertyAccess = representationStrategy.resolvePropertyAccess(bootPropertyDescriptor);
            if (subtype instanceof BasicType) {
                Integer scale;
                Integer precision;
                Long length;
                String columnDefinition;
                String containingTableExpression;
                String columnExpression;
                BasicValue basicValue = (BasicValue)bootPropertyDescriptor.getValue();
                Selectable selectable = basicValue.getColumn();
                if (rootTableKeyColumnNames == null) {
                    columnExpression = selectable.isFormula() ? selectable.getTemplate(dialect, creationProcess.getCreationContext().getTypeConfiguration(), creationProcess.getSqmFunctionRegistry()) : selectable.getText(dialect);
                    containingTableExpression = selectable instanceof Column ? concreteTableResolver.resolve((Column)selectable, jdbcEnvironment) : rootTableExpression;
                } else {
                    containingTableExpression = rootTableExpression;
                    columnExpression = rootTableKeyColumnNames[columnPosition];
                }
                if (selectable instanceof Column) {
                    Column column = (Column)selectable;
                    columnDefinition = column.getSqlType();
                    length = column.getLength();
                    precision = column.getPrecision();
                    scale = column.getScale();
                } else {
                    columnDefinition = null;
                    length = null;
                    precision = null;
                    scale = null;
                }
                attributeMapping = MappingModelCreationHelper.buildBasicAttributeMapping(bootPropertyDescriptor.getName(), navigableRole.append(bootPropertyDescriptor.getName()), attributeIndex, bootPropertyDescriptor, declarer, (BasicType)subtype, containingTableExpression, columnExpression, selectable.isFormula(), selectable.getCustomReadExpression(), selectable.getCustomWriteExpression(), columnDefinition, length, precision, scale, propertyAccess, compositeType.getCascadeStyle(attributeIndex), creationProcess);
                ++columnPosition;
            } else if (subtype instanceof AnyType) {
                Any bootValueMapping = (Any)bootPropertyDescriptor.getValue();
                final AnyType anyType = (AnyType)subtype;
                final boolean nullable = bootValueMapping.isNullable();
                final boolean insertable = bootPropertyDescriptor.isInsertable();
                final boolean updateable = bootPropertyDescriptor.isUpdateable();
                final boolean includeInOptimisticLocking = bootPropertyDescriptor.isOptimisticLocked();
                final CascadeStyle cascadeStyle = compositeType.getCascadeStyle(attributeIndex);
                final MutabilityPlan<Object> mutabilityPlan = updateable ? new MutabilityPlan<Object>(){

                    @Override
                    public boolean isMutable() {
                        return true;
                    }

                    @Override
                    public Object deepCopy(Object value) {
                        if (value == null) {
                            return null;
                        }
                        return anyType.deepCopy(value, creationProcess.getCreationContext().getSessionFactory());
                    }

                    @Override
                    public Serializable disassemble(Object value, SharedSessionContract session) {
                        throw new NotYetImplementedFor6Exception(this.getClass());
                    }

                    @Override
                    public Object assemble(Serializable cached, SharedSessionContract session) {
                        throw new NotYetImplementedFor6Exception(this.getClass());
                    }
                } : ImmutableMutabilityPlan.INSTANCE;
                AttributeMetadataAccess attributeMetadataAccess = entityMappingType -> new AttributeMetadata(){

                    @Override
                    public PropertyAccess getPropertyAccess() {
                        return propertyAccess;
                    }

                    @Override
                    public MutabilityPlan<?> getMutabilityPlan() {
                        return mutabilityPlan;
                    }

                    @Override
                    public boolean isNullable() {
                        return nullable;
                    }

                    @Override
                    public boolean isInsertable() {
                        return insertable;
                    }

                    @Override
                    public boolean isUpdatable() {
                        return updateable;
                    }

                    @Override
                    public boolean isIncludedInDirtyChecking() {
                        return updateable;
                    }

                    @Override
                    public boolean isIncludedInOptimisticLocking() {
                        return includeInOptimisticLocking;
                    }

                    @Override
                    public CascadeStyle getCascadeStyle() {
                        return cascadeStyle;
                    }
                };
                attributeMapping = new DiscriminatedAssociationAttributeMapping(navigableRole.append(bootPropertyDescriptor.getName()), typeConfiguration.getJavaTypeRegistry().getDescriptor((java.lang.reflect.Type)((Object)Object.class)), declarer, attributeIndex, attributeMetadataAccess, bootPropertyDescriptor.isLazy() ? FetchTiming.DELAYED : FetchTiming.IMMEDIATE, propertyAccess, bootPropertyDescriptor, anyType, bootValueMapping, creationProcess);
            } else if (subtype instanceof CompositeType) {
                String[] subRootTableKeyColumnNames;
                String subTableExpression;
                CompositeType subCompositeType = (CompositeType)subtype;
                int columnSpan = subCompositeType.getColumnSpan(sessionFactory);
                if (rootTableKeyColumnNames == null) {
                    subTableExpression = rootTableExpression;
                    subRootTableKeyColumnNames = null;
                } else {
                    subTableExpression = rootTableExpression;
                    subRootTableKeyColumnNames = new String[columnSpan];
                    System.arraycopy(rootTableKeyColumnNames, columnPosition, subRootTableKeyColumnNames, 0, columnSpan);
                }
                attributeMapping = MappingModelCreationHelper.buildEmbeddedAttributeMapping(bootPropertyDescriptor.getName(), attributeIndex, bootPropertyDescriptor, declarer, subCompositeType, subTableExpression, subRootTableKeyColumnNames, propertyAccess, compositeType.getCascadeStyle(attributeIndex), creationProcess);
                columnPosition += columnSpan;
            } else if (subtype instanceof CollectionType) {
                entityPersister = creationProcess.getEntityPersister(bootDescriptor.getOwner().getEntityName());
                attributeMapping = MappingModelCreationHelper.buildPluralAttributeMapping(bootPropertyDescriptor.getName(), attributeIndex, bootPropertyDescriptor, entityPersister, propertyAccess, compositeType.getCascadeStyle(attributeIndex), compositeType.getFetchMode(attributeIndex), creationProcess);
            } else if (subtype instanceof EntityType) {
                entityPersister = creationProcess.getEntityPersister(bootDescriptor.getOwner().getEntityName());
                attributeMapping = MappingModelCreationHelper.buildSingularAssociationAttributeMapping(bootPropertyDescriptor.getName(), navigableRole.append(bootPropertyDescriptor.getName()), attributeIndex, bootPropertyDescriptor, entityPersister, entityPersister, (EntityType)subtype, representationStrategy.resolvePropertyAccess(bootPropertyDescriptor), compositeType.getCascadeStyle(attributeIndex), creationProcess);
                columnPosition += bootPropertyDescriptor.getColumnSpan();
            } else {
                throw new MappingException(String.format(Locale.ROOT, "Unable to determine attribute nature : %s#%s", bootDescriptor.getOwner().getEntityName(), bootPropertyDescriptor.getName()));
            }
            attributeConsumer.accept(attributeMapping);
            ++attributeIndex;
        }
        completionCallback.success();
        return true;
    }

    @FunctionalInterface
    protected static interface AttributeTypeValidator {
        public void check(String var1, Type var2) throws IllegalAttributeType;
    }

    protected static class IllegalAttributeType
    extends RuntimeException {
        public IllegalAttributeType(String message) {
            super(message);
        }
    }

    @FunctionalInterface
    protected static interface SuccessfulCompletionCallback {
        public void success();
    }

    @FunctionalInterface
    protected static interface ConcreteTableResolver {
        public String resolve(Column var1, JdbcEnvironment var2);
    }
}

