/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.Incubating;
import org.hibernate.LockOptions;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.ast.internal.LoaderSelectBuilder;
import org.hibernate.loader.ast.spi.Loadable;
import org.hibernate.metamodel.UnsupportedMappingException;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.GeneratedValueResolver;
import org.hibernate.metamodel.mapping.InDatabaseGeneratedValueResolver;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.Callback;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcSelect;
import org.hibernate.sql.results.spi.ListResultsConsumer;
import org.hibernate.tuple.GenerationTiming;
import org.hibernate.tuple.InDatabaseValueGenerationStrategy;

@Incubating
public class GeneratedValuesProcessor {
    private final SelectStatement selectStatement;
    private final List<GeneratedValueDescriptor> valueDescriptors = new ArrayList<GeneratedValueDescriptor>();
    private final List<JdbcParameter> jdbcParameters = new ArrayList<JdbcParameter>();
    private final EntityMappingType entityDescriptor;
    private final SessionFactoryImplementor sessionFactory;

    public GeneratedValuesProcessor(EntityMappingType entityDescriptor, GenerationTiming timing, SessionFactoryImplementor sessionFactory) {
        this.entityDescriptor = entityDescriptor;
        this.sessionFactory = sessionFactory;
        ArrayList generatedValuesToSelect = new ArrayList();
        InDatabaseValueGenerationStrategy[] inDatabaseValueGenerationStrategies = entityDescriptor.getEntityPersister().getEntityMetamodel().getInDatabaseValueGenerationStrategies();
        entityDescriptor.visitAttributeMappings(mapping -> {
            InDatabaseValueGenerationStrategy inDatabaseValueGenerationStrategy = inDatabaseValueGenerationStrategies[mapping.getStateArrayPosition()];
            if (inDatabaseValueGenerationStrategy.getGenerationTiming() == GenerationTiming.NEVER) {
                return;
            }
            InDatabaseGeneratedValueResolver generatedValueResolver = new InDatabaseGeneratedValueResolver(timing, generatedValuesToSelect.size());
            this.valueDescriptors.add(new GeneratedValueDescriptor(generatedValueResolver, (AttributeMapping)mapping));
            generatedValuesToSelect.add(mapping);
        });
        this.selectStatement = generatedValuesToSelect.isEmpty() ? null : LoaderSelectBuilder.createSelect((Loadable)entityDescriptor, generatedValuesToSelect, entityDescriptor.getIdentifierMapping(), null, 1, LoadQueryInfluencers.NONE, LockOptions.READ, this.jdbcParameters::add, sessionFactory);
    }

    public void processGeneratedValues(Object entity, Object id, Object[] state, final SharedSessionContractImplementor session) {
        if (this.selectStatement == null) {
            return;
        }
        JdbcServices jdbcServices = this.sessionFactory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
        JdbcParameterBindingsImpl jdbcParamBindings = new JdbcParameterBindingsImpl(this.jdbcParameters.size());
        int offset = jdbcParamBindings.registerParametersForEachJdbcValue(id, Clause.WHERE, this.entityDescriptor.getIdentifierMapping(), this.jdbcParameters, session);
        assert (offset == this.jdbcParameters.size());
        JdbcSelect jdbcSelect = sqlAstTranslatorFactory.buildSelectTranslator(this.sessionFactory, this.selectStatement).translate(jdbcParamBindings, QueryOptions.NONE);
        List<Object[]> results = session.getFactory().getJdbcServices().getJdbcSelectExecutor().list(jdbcSelect, jdbcParamBindings, new ExecutionContext(){

            @Override
            public SharedSessionContractImplementor getSession() {
                return session;
            }

            @Override
            public QueryOptions getQueryOptions() {
                return QueryOptions.NONE;
            }

            @Override
            public String getQueryIdentifier(String sql) {
                return sql;
            }

            @Override
            public QueryParameterBindings getQueryParameterBindings() {
                return QueryParameterBindings.NO_PARAM_BINDINGS;
            }

            @Override
            public Callback getCallback() {
                throw new UnsupportedMappingException("Follow-on locking not supported yet");
            }
        }, row -> row, ListResultsConsumer.UniqueSemantic.FILTER);
        assert (results.size() == 1);
        Object[] dbSelectionResults = results.get(0);
        for (int i = 0; i < this.valueDescriptors.size(); ++i) {
            Object generatedValue;
            GeneratedValueDescriptor descriptor = this.valueDescriptors.get(i);
            state[descriptor.attribute.getStateArrayPosition()] = generatedValue = descriptor.resolver.resolveGeneratedValue(dbSelectionResults, entity, session);
            descriptor.attribute.getAttributeMetadataAccess().resolveAttributeMetadata(this.entityDescriptor).getPropertyAccess().getSetter().set(entity, generatedValue);
        }
    }

    private static class GeneratedValueDescriptor {
        public final GeneratedValueResolver resolver;
        public final AttributeMapping attribute;

        public GeneratedValueDescriptor(GeneratedValueResolver resolver, AttributeMapping attribute) {
            this.resolver = resolver;
            this.attribute = attribute;
        }
    }
}

