/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.IntFunction;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.mapping.IndexedConsumer;
import org.hibernate.metamodel.mapping.AssociationKey;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.PropertyBasedMapping;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.internal.BasicAttributeMapping;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.mapping.internal.NoValueGeneration;
import org.hibernate.metamodel.mapping.internal.SimpleForeignKeyDescriptorSide;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.query.spi.NavigablePath;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupProducer;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.UnknownTableReferenceException;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchOptions;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.type.descriptor.java.JavaType;

public class SimpleForeignKeyDescriptor
implements ForeignKeyDescriptor,
BasicValuedModelPart,
FetchOptions {
    private final SimpleForeignKeyDescriptorSide keySide;
    private final SimpleForeignKeyDescriptorSide targetSide;
    private final boolean refersToPrimaryKey;
    private final boolean hasConstraint;
    private AssociationKey associationKey;

    public SimpleForeignKeyDescriptor(ManagedMappingType keyDeclaringType, BasicValuedModelPart keyModelPart, PropertyAccess keyPropertyAccess, SelectableMapping keySelectableMapping, BasicValuedModelPart targetModelPart, boolean refersToPrimaryKey, boolean hasConstraint) {
        this(keyDeclaringType, keyModelPart, keyPropertyAccess, keySelectableMapping, targetModelPart, refersToPrimaryKey, hasConstraint, false);
    }

    public SimpleForeignKeyDescriptor(ManagedMappingType keyDeclaringType, BasicValuedModelPart keyModelPart, PropertyAccess keyPropertyAccess, SelectableMapping keySelectableMapping, BasicValuedModelPart targetModelPart, boolean refersToPrimaryKey, boolean hasConstraint, boolean swapDirection) {
        assert (keySelectableMapping != null);
        assert (targetModelPart != null);
        keyModelPart = BasicAttributeMapping.withSelectableMapping(keyDeclaringType, keyModelPart, keyPropertyAccess, NoValueGeneration.INSTANCE, keySelectableMapping);
        if (swapDirection) {
            this.keySide = new SimpleForeignKeyDescriptorSide(ForeignKeyDescriptor.Nature.KEY, targetModelPart);
            this.targetSide = new SimpleForeignKeyDescriptorSide(ForeignKeyDescriptor.Nature.TARGET, keyModelPart);
        } else {
            this.keySide = new SimpleForeignKeyDescriptorSide(ForeignKeyDescriptor.Nature.KEY, keyModelPart);
            this.targetSide = new SimpleForeignKeyDescriptorSide(ForeignKeyDescriptor.Nature.TARGET, targetModelPart);
        }
        this.refersToPrimaryKey = refersToPrimaryKey;
        this.hasConstraint = hasConstraint;
    }

    @Override
    public String getKeyTable() {
        return this.keySide.getModelPart().getContainingTableExpression();
    }

    @Override
    public String getTargetTable() {
        return this.targetSide.getModelPart().getContainingTableExpression();
    }

    @Override
    public BasicValuedModelPart getKeyPart() {
        return this.keySide.getModelPart();
    }

    @Override
    public BasicValuedModelPart getTargetPart() {
        return this.targetSide.getModelPart();
    }

    @Override
    public ForeignKeyDescriptor.Side getKeySide() {
        return this.keySide;
    }

    @Override
    public ForeignKeyDescriptor.Side getTargetSide() {
        return this.targetSide;
    }

    @Override
    public ForeignKeyDescriptor withKeySelectionMapping(ManagedMappingType declaringType, TableGroupProducer declaringTableGroupProducer, IntFunction<SelectableMapping> selectableMappingAccess, MappingModelCreationProcess creationProcess) {
        return new SimpleForeignKeyDescriptor(declaringType, this.keySide.getModelPart(), ((PropertyBasedMapping)((Object)this.keySide.getModelPart())).getPropertyAccess(), selectableMappingAccess.apply(0), this.targetSide.getModelPart(), this.refersToPrimaryKey, this.hasConstraint);
    }

    @Override
    public DomainResult<?> createKeyDomainResult(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        return this.createDomainResult(navigablePath, tableGroup, this.keySide.getModelPart(), creationState);
    }

    @Override
    public DomainResult<?> createTargetDomainResult(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        return this.createDomainResult(navigablePath, tableGroup, this.targetSide.getModelPart(), creationState);
    }

    @Override
    public DomainResult<?> createCollectionFetchDomainResult(NavigablePath collectionPath, TableGroup tableGroup, DomainResultCreationState creationState) {
        return this.createDomainResult(collectionPath, tableGroup, this.targetSide.getModelPart(), creationState);
    }

    @Override
    public DomainResult<?> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, ForeignKeyDescriptor.Nature side, DomainResultCreationState creationState) {
        if (side == ForeignKeyDescriptor.Nature.KEY) {
            return this.createDomainResult(navigablePath, tableGroup, this.keySide.getModelPart(), creationState);
        }
        return this.createDomainResult(navigablePath, tableGroup, this.targetSide.getModelPart(), creationState);
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        return this.createDomainResult(navigablePath, tableGroup, this.keySide.getModelPart(), creationState);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState, BiConsumer<SqlSelection, JdbcMapping> selectionConsumer) {
        throw new UnsupportedOperationException();
    }

    private <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, SelectableMapping selectableMapping, DomainResultCreationState creationState) {
        TableReference tableReference;
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        SqlExpressionResolver sqlExpressionResolver = sqlAstCreationState.getSqlExpressionResolver();
        try {
            tableReference = tableGroup.resolveTableReference(navigablePath.append(this.getTargetPart().getFetchableName()), selectableMapping.getContainingTableExpression());
        }
        catch (IllegalStateException tableNotFoundException) {
            throw new UnknownTableReferenceException(selectableMapping.getContainingTableExpression(), String.format(Locale.ROOT, "Unable to determine TableReference (`%s`) for `%s`", selectableMapping.getContainingTableExpression(), this.getNavigableRole().getFullPath()));
        }
        String identificationVariable = tableReference.getIdentificationVariable();
        SqlSelection sqlSelection = sqlExpressionResolver.resolveSqlSelection(sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, selectableMapping.getSelectionExpression()), s -> new ColumnReference(identificationVariable, selectableMapping, creationState.getSqlAstCreationState().getCreationContext().getSessionFactory())), selectableMapping.getJdbcMapping().getJavaTypeDescriptor(), sqlAstCreationState.getCreationContext().getSessionFactory().getTypeConfiguration());
        return new BasicResult(sqlSelection.getValuesArrayPosition(), null, selectableMapping.getJdbcMapping().getJavaTypeDescriptor());
    }

    @Override
    public Predicate generateJoinPredicate(TableReference targetSideReference, TableReference keySideReference, SqlExpressionResolver sqlExpressionResolver, SqlAstCreationContext creationContext) {
        return new ComparisonPredicate(new ColumnReference(targetSideReference, (SelectableMapping)this.targetSide.getModelPart(), creationContext.getSessionFactory()), ComparisonOperator.EQUAL, new ColumnReference(keySideReference, (SelectableMapping)this.keySide.getModelPart(), creationContext.getSessionFactory()));
    }

    @Override
    public Predicate generateJoinPredicate(TableGroup targetSideTableGroup, TableGroup keySideTableGroup, SqlExpressionResolver sqlExpressionResolver, SqlAstCreationContext creationContext) {
        TableReference lhsTableReference = targetSideTableGroup.resolveTableReference(targetSideTableGroup.getNavigablePath(), this.targetSide.getModelPart().getContainingTableExpression());
        TableReference rhsTableKeyReference = keySideTableGroup.resolveTableReference(this.keySide.getModelPart().getContainingTableExpression());
        return this.generateJoinPredicate(lhsTableReference, rhsTableKeyReference, sqlExpressionResolver, creationContext);
    }

    @Override
    public boolean isSimpleJoinPredicate(Predicate predicate) {
        if (!(predicate instanceof ComparisonPredicate)) {
            return false;
        }
        ComparisonPredicate comparisonPredicate = (ComparisonPredicate)predicate;
        if (comparisonPredicate.getOperator() != ComparisonOperator.EQUAL) {
            return false;
        }
        Expression lhsExpr = comparisonPredicate.getLeftHandExpression();
        Expression rhsExpr = comparisonPredicate.getRightHandExpression();
        if (!(lhsExpr instanceof ColumnReference) || !(rhsExpr instanceof ColumnReference)) {
            return false;
        }
        String lhs = ((ColumnReference)lhsExpr).getColumnExpression();
        String rhs = ((ColumnReference)rhsExpr).getColumnExpression();
        String keyExpression = this.keySide.getModelPart().getSelectionExpression();
        String targetExpression = this.targetSide.getModelPart().getSelectionExpression();
        return lhs.equals(keyExpression) && rhs.equals(targetExpression) || lhs.equals(targetExpression) && rhs.equals(keyExpression);
    }

    protected TableReference getTableReference(TableGroup lhs, TableGroup tableGroup, String table) {
        NavigablePath navigablePath = lhs.getNavigablePath().append(this.getTargetPart().getFetchableName());
        if (lhs.getPrimaryTableReference().getTableReference(navigablePath, table) != null) {
            return lhs.getPrimaryTableReference();
        }
        if (tableGroup.getPrimaryTableReference().getTableReference(navigablePath, table) != null) {
            return tableGroup.getPrimaryTableReference();
        }
        TableReference tableReference = lhs.resolveTableReference(navigablePath, table);
        if (tableReference != null) {
            return tableReference;
        }
        throw new IllegalStateException("Could not resolve binding for table `" + table + "`");
    }

    @Override
    public MappingType getPartMappingType() {
        return this.targetSide.getModelPart().getMappedType();
    }

    @Override
    public JavaType<?> getJavaType() {
        return this.targetSide.getModelPart().getJdbcMapping().getJavaTypeDescriptor();
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.targetSide.getModelPart().getNavigableRole();
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        return this.targetSide.getModelPart().findContainingEntityMapping();
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        return value;
    }

    @Override
    public Object getAssociationKeyFromSide(Object targetObject, ForeignKeyDescriptor.Nature nature, SharedSessionContractImplementor session) {
        if (targetObject == null) {
            return null;
        }
        if (this.refersToPrimaryKey && targetObject instanceof HibernateProxy) {
            return ((HibernateProxy)targetObject).getHibernateLazyInitializer().getIdentifier();
        }
        BasicValuedModelPart modelPart = nature == ForeignKeyDescriptor.Nature.KEY ? this.keySide.getModelPart() : this.targetSide.getModelPart();
        return ((PropertyBasedMapping)((Object)modelPart)).getPropertyAccess().getGetter().get(targetObject);
    }

    @Override
    public int forEachDisassembledJdbcValue(Object value, Clause clause, int offset, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        valuesConsumer.consume(offset, value, this.getJdbcMapping());
        return 1;
    }

    @Override
    public void breakDownJdbcValues(Object domainValue, ModelPart.JdbcValueConsumer valueConsumer, SharedSessionContractImplementor session) {
        valueConsumer.consume(domainValue, this.keySide.getModelPart());
    }

    @Override
    public int visitKeySelectables(int offset, SelectableConsumer consumer) {
        consumer.accept(offset, this.keySide.getModelPart());
        return this.getJdbcTypeCount();
    }

    @Override
    public int visitTargetSelectables(int offset, SelectableConsumer consumer) {
        consumer.accept(offset, this.targetSide.getModelPart());
        return this.getJdbcTypeCount();
    }

    @Override
    public boolean hasConstraint() {
        return this.hasConstraint;
    }

    @Override
    public AssociationKey getAssociationKey() {
        if (this.associationKey == null) {
            List<String> associationKeyColumns = Collections.singletonList(this.keySide.getModelPart().getSelectionExpression());
            this.associationKey = new AssociationKey(this.keySide.getModelPart().getContainingTableExpression(), associationKeyColumns);
        }
        return this.associationKey;
    }

    @Override
    public List<JdbcMapping> getJdbcMappings() {
        return Collections.singletonList(this.targetSide.getModelPart().getJdbcMapping());
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        action.accept(offset, this.targetSide.getModelPart().getJdbcMapping());
        return this.getJdbcTypeCount();
    }

    @Override
    public int forEachJdbcValue(Object value, Clause clause, int offset, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        valuesConsumer.consume(offset, value, this.targetSide.getModelPart().getJdbcMapping());
        return this.getJdbcTypeCount();
    }

    @Override
    public String getContainingTableExpression() {
        return this.keySide.getModelPart().getContainingTableExpression();
    }

    @Override
    public String getSelectionExpression() {
        return this.keySide.getModelPart().getSelectionExpression();
    }

    @Override
    public boolean isFormula() {
        return this.keySide.getModelPart().isFormula();
    }

    @Override
    public String getCustomReadExpression() {
        return this.keySide.getModelPart().getCustomReadExpression();
    }

    @Override
    public String getCustomWriteExpression() {
        return this.keySide.getModelPart().getCustomWriteExpression();
    }

    @Override
    public String getColumnDefinition() {
        return this.keySide.getModelPart().getColumnDefinition();
    }

    @Override
    public Long getLength() {
        return this.keySide.getModelPart().getLength();
    }

    @Override
    public Integer getPrecision() {
        return this.keySide.getModelPart().getPrecision();
    }

    @Override
    public Integer getScale() {
        return this.keySide.getModelPart().getScale();
    }

    @Override
    public String getFetchableName() {
        return "{fk}";
    }

    @Override
    public FetchOptions getMappedFetchOptions() {
        return this;
    }

    @Override
    public FetchStyle getStyle() {
        return FetchStyle.JOIN;
    }

    @Override
    public FetchTiming getTiming() {
        return FetchTiming.IMMEDIATE;
    }

    @Override
    public Fetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, String resultVariable, DomainResultCreationState creationState) {
        return null;
    }

    @Override
    public MappingType getMappedType() {
        return null;
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.keySide.getModelPart().getJdbcMapping();
    }

    public String toString() {
        return String.format("SimpleForeignKeyDescriptor : %s.%s -> %s.%s", this.keySide.getModelPart().getContainingTableExpression(), this.keySide.getModelPart().getSelectionExpression(), this.targetSide.getModelPart().getContainingTableExpression(), this.targetSide.getModelPart().getSelectionExpression());
    }
}

