/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.access.NaturalIdDataAccess;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.ExecuteUpdateResultCheckStyle;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.DynamicFilterAliasGenerator;
import org.hibernate.internal.FilterAliasGenerator;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Formula;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.DiscriminatorHelper;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.persister.spi.PersisterCreationContext;
import org.hibernate.query.spi.NavigablePath;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;
import org.hibernate.sql.InFragment;
import org.hibernate.sql.Insert;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SqlAliasBase;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.InListPredicate;
import org.hibernate.sql.ast.tree.predicate.Junction;
import org.hibernate.sql.ast.tree.predicate.NegatedPredicate;
import org.hibernate.sql.ast.tree.predicate.NullnessPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.type.BasicType;
import org.hibernate.type.Type;

public class SingleTableEntityPersister
extends AbstractEntityPersister {
    private final int joinSpan;
    private final String[] qualifiedTableNames;
    private final boolean[] isInverseTable;
    private final boolean[] isNullableTable;
    private final String[][] keyColumnNames;
    private final boolean[] cascadeDeleteEnabled;
    private final String[] spaces;
    private final String[] subclassClosure;
    private final String[] subclassTableNameClosure;
    private final boolean[] isInverseSubclassTable;
    private final boolean[] isNullableSubclassTable;
    private final boolean[] subclassTableSequentialSelect;
    private final String[][] subclassTableKeyColumnClosure;
    private final boolean[] isClassOrSuperclassTable;
    private final boolean[] isClassOrSuperclassJoin;
    private final int[] propertyTableNumbers;
    private final int[] subclassPropertyTableNumberClosure;
    private final Map<Object, String> subclassesByDiscriminatorValue;
    private final boolean forceDiscriminator;
    private final String discriminatorColumnName;
    private final String discriminatorColumnReaders;
    private final String discriminatorColumnReaderTemplate;
    private final String discriminatorFormulaTemplate;
    private final String discriminatorAlias;
    private final BasicType<?> discriminatorType;
    private final Object discriminatorValue;
    private final String discriminatorSQLValue;
    private final boolean discriminatorInsertable;
    private final String[] constraintOrderedTableNames;
    private final String[][] constraintOrderedKeyColumnNames;
    private final String[] fullDiscriminatorSQLValues;
    private final Object[] fullDiscriminatorValues;

    @Deprecated(since="6.0")
    public SingleTableEntityPersister(PersistentClass persistentClass, EntityDataAccess cacheAccessStrategy, NaturalIdDataAccess naturalIdRegionAccessStrategy, PersisterCreationContext creationContext) throws HibernateException {
        this(persistentClass, cacheAccessStrategy, naturalIdRegionAccessStrategy, (RuntimeModelCreationContext)creationContext);
    }

    public SingleTableEntityPersister(PersistentClass persistentClass, EntityDataAccess cacheAccessStrategy, NaturalIdDataAccess naturalIdRegionAccessStrategy, RuntimeModelCreationContext creationContext) throws HibernateException {
        super(persistentClass, cacheAccessStrategy, naturalIdRegionAccessStrategy, creationContext);
        SessionFactoryImplementor factory = creationContext.getSessionFactory();
        Dialect dialect = factory.getJdbcServices().getDialect();
        this.joinSpan = persistentClass.getJoinClosureSpan() + 1;
        this.qualifiedTableNames = new String[this.joinSpan];
        this.isInverseTable = new boolean[this.joinSpan];
        this.isNullableTable = new boolean[this.joinSpan];
        this.keyColumnNames = new String[this.joinSpan][];
        Table table = persistentClass.getRootTable();
        this.qualifiedTableNames[0] = this.determineTableName(table);
        this.isInverseTable[0] = false;
        this.isNullableTable[0] = false;
        this.keyColumnNames[0] = this.getIdentifierColumnNames();
        this.cascadeDeleteEnabled = new boolean[this.joinSpan];
        this.customSQLInsert = new String[this.joinSpan];
        this.customSQLUpdate = new String[this.joinSpan];
        this.customSQLDelete = new String[this.joinSpan];
        this.insertCallable = new boolean[this.joinSpan];
        this.updateCallable = new boolean[this.joinSpan];
        this.deleteCallable = new boolean[this.joinSpan];
        this.insertResultCheckStyles = new ExecuteUpdateResultCheckStyle[this.joinSpan];
        this.updateResultCheckStyles = new ExecuteUpdateResultCheckStyle[this.joinSpan];
        this.deleteResultCheckStyles = new ExecuteUpdateResultCheckStyle[this.joinSpan];
        this.customSQLInsert[0] = persistentClass.getCustomSQLInsert();
        this.insertCallable[0] = this.customSQLInsert[0] != null && persistentClass.isCustomInsertCallable();
        this.insertResultCheckStyles[0] = persistentClass.getCustomSQLInsertCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(this.customSQLInsert[0], this.insertCallable[0]) : persistentClass.getCustomSQLInsertCheckStyle();
        this.customSQLUpdate[0] = persistentClass.getCustomSQLUpdate();
        this.updateCallable[0] = this.customSQLUpdate[0] != null && persistentClass.isCustomUpdateCallable();
        this.updateResultCheckStyles[0] = persistentClass.getCustomSQLUpdateCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(this.customSQLUpdate[0], this.updateCallable[0]) : persistentClass.getCustomSQLUpdateCheckStyle();
        this.customSQLDelete[0] = persistentClass.getCustomSQLDelete();
        this.deleteCallable[0] = this.customSQLDelete[0] != null && persistentClass.isCustomDeleteCallable();
        this.deleteResultCheckStyles[0] = persistentClass.getCustomSQLDeleteCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(this.customSQLDelete[0], this.deleteCallable[0]) : persistentClass.getCustomSQLDeleteCheckStyle();
        List<Join> joinClosure = persistentClass.getJoinClosure();
        int j = 1;
        while (j - 1 < joinClosure.size()) {
            Join join = joinClosure.get(j - 1);
            this.qualifiedTableNames[j] = this.determineTableName(join.getTable());
            this.isInverseTable[j] = join.isInverse();
            this.isNullableTable[j] = join.isOptional();
            this.cascadeDeleteEnabled[j] = join.getKey().isCascadeDeleteEnabled() && dialect.supportsCascadeDelete();
            this.customSQLInsert[j] = join.getCustomSQLInsert();
            this.insertCallable[j] = this.customSQLInsert[j] != null && join.isCustomInsertCallable();
            this.insertResultCheckStyles[j] = join.getCustomSQLInsertCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(this.customSQLInsert[j], this.insertCallable[j]) : join.getCustomSQLInsertCheckStyle();
            this.customSQLUpdate[j] = join.getCustomSQLUpdate();
            this.updateCallable[j] = this.customSQLUpdate[j] != null && join.isCustomUpdateCallable();
            this.updateResultCheckStyles[j] = join.getCustomSQLUpdateCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(this.customSQLUpdate[j], this.updateCallable[j]) : join.getCustomSQLUpdateCheckStyle();
            this.customSQLDelete[j] = join.getCustomSQLDelete();
            this.deleteCallable[j] = this.customSQLDelete[j] != null && join.isCustomDeleteCallable();
            this.deleteResultCheckStyles[j] = join.getCustomSQLDeleteCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(this.customSQLDelete[j], this.deleteCallable[j]) : join.getCustomSQLDeleteCheckStyle();
            this.keyColumnNames[j] = new String[join.getKey().getColumnSpan()];
            List<Column> columns = join.getKey().getColumns();
            for (int i = 0; i < columns.size(); ++i) {
                this.keyColumnNames[j][i] = columns.get(i).getQuotedName(dialect);
            }
            ++j;
        }
        this.constraintOrderedTableNames = new String[this.qualifiedTableNames.length];
        this.constraintOrderedKeyColumnNames = new String[this.qualifiedTableNames.length][];
        int i = this.qualifiedTableNames.length - 1;
        int position = 0;
        while (i >= 0) {
            this.constraintOrderedTableNames[position] = this.qualifiedTableNames[i];
            this.constraintOrderedKeyColumnNames[position] = this.keyColumnNames[i];
            --i;
            ++position;
        }
        this.spaces = ArrayHelper.join(this.qualifiedTableNames, ArrayHelper.toStringArray(persistentClass.getSynchronizedTables()));
        ArrayList<String> subclassTables = new ArrayList<String>();
        ArrayList<String[]> joinKeyColumns = new ArrayList<String[]>();
        ArrayList<Boolean> isConcretes = new ArrayList<Boolean>();
        ArrayList<Boolean> isClassOrSuperclassJoins = new ArrayList<Boolean>();
        ArrayList<Boolean> isDeferreds = new ArrayList<Boolean>();
        ArrayList<Boolean> isInverses = new ArrayList<Boolean>();
        ArrayList<Boolean> isNullables = new ArrayList<Boolean>();
        subclassTables.add(this.qualifiedTableNames[0]);
        joinKeyColumns.add(this.getIdentifierColumnNames());
        isConcretes.add(Boolean.TRUE);
        isClassOrSuperclassJoins.add(Boolean.TRUE);
        isDeferreds.add(Boolean.FALSE);
        isInverses.add(Boolean.FALSE);
        isNullables.add(Boolean.FALSE);
        for (Join join : persistentClass.getSubclassJoinClosure()) {
            isConcretes.add(persistentClass.isClassOrSuperclassTable(join.getTable()));
            isClassOrSuperclassJoins.add(persistentClass.isClassOrSuperclassJoin(join));
            isInverses.add(join.isInverse());
            isNullables.add(join.isOptional());
            boolean isDeferred = join.isSequentialSelect() && !persistentClass.isClassOrSuperclassJoin(join);
            isDeferreds.add(isDeferred);
            String joinTableName = this.determineTableName(join.getTable());
            subclassTables.add(joinTableName);
            String[] keyCols = new String[join.getKey().getColumnSpan()];
            List<Column> columns = join.getKey().getColumns();
            for (int i2 = 0; i2 < columns.size(); ++i2) {
                Column col = columns.get(i2);
                keyCols[i2] = col.getQuotedName(dialect);
            }
            joinKeyColumns.add(keyCols);
        }
        this.subclassTableSequentialSelect = ArrayHelper.toBooleanArray(isDeferreds);
        this.subclassTableNameClosure = ArrayHelper.toStringArray(subclassTables);
        this.subclassTableKeyColumnClosure = ArrayHelper.to2DStringArray(joinKeyColumns);
        this.isClassOrSuperclassTable = ArrayHelper.toBooleanArray(isConcretes);
        this.isClassOrSuperclassJoin = ArrayHelper.toBooleanArray(isClassOrSuperclassJoins);
        this.isInverseSubclassTable = ArrayHelper.toBooleanArray(isInverses);
        this.isNullableSubclassTable = ArrayHelper.toBooleanArray(isNullables);
        if (persistentClass.isPolymorphic()) {
            Value discriminator = persistentClass.getDiscriminator();
            if (discriminator == null) {
                throw new MappingException("discriminator mapping required for single table polymorphic persistence");
            }
            this.forceDiscriminator = persistentClass.isForceDiscriminator();
            Selectable selectable = discriminator.getSelectables().get(0);
            SqmFunctionRegistry functionRegistry = factory.getQueryEngine().getSqmFunctionRegistry();
            if (discriminator.hasFormula()) {
                Formula formula = (Formula)selectable;
                this.discriminatorFormulaTemplate = formula.getTemplate(dialect, factory.getTypeConfiguration(), functionRegistry);
                this.discriminatorColumnName = null;
                this.discriminatorColumnReaders = null;
                this.discriminatorColumnReaderTemplate = null;
                this.discriminatorAlias = "clazz_";
            } else {
                Column column = (Column)selectable;
                this.discriminatorColumnName = column.getQuotedName(dialect);
                this.discriminatorColumnReaders = column.getReadExpr(dialect);
                this.discriminatorColumnReaderTemplate = column.getTemplate(dialect, factory.getTypeConfiguration(), functionRegistry);
                this.discriminatorAlias = column.getAlias(dialect, persistentClass.getRootTable());
                this.discriminatorFormulaTemplate = null;
            }
            this.discriminatorType = DiscriminatorHelper.getDiscriminatorType(persistentClass);
            this.discriminatorValue = DiscriminatorHelper.getDiscriminatorValue(persistentClass);
            this.discriminatorSQLValue = DiscriminatorHelper.getDiscriminatorSQLValue(persistentClass, dialect, factory);
            this.discriminatorInsertable = SingleTableEntityPersister.isDiscriminatorInsertable(persistentClass);
        } else {
            this.forceDiscriminator = false;
            this.discriminatorInsertable = false;
            this.discriminatorColumnName = null;
            this.discriminatorColumnReaders = null;
            this.discriminatorColumnReaderTemplate = null;
            this.discriminatorAlias = null;
            this.discriminatorType = null;
            this.discriminatorValue = null;
            this.discriminatorSQLValue = null;
            this.discriminatorFormulaTemplate = null;
        }
        this.propertyTableNumbers = new int[this.getPropertySpan()];
        List<Property> propertyClosure = persistentClass.getPropertyClosure();
        for (int k = 0; k < propertyClosure.size(); ++k) {
            this.propertyTableNumbers[k] = persistentClass.getJoinNumber(propertyClosure.get(k));
        }
        ArrayList<Integer> propertyJoinNumbers = new ArrayList<Integer>();
        HashMap<Object, String> subclassesByDiscriminatorValueLocal = new HashMap<Object, String>();
        for (Property property : persistentClass.getSubclassPropertyClosure()) {
            Integer join = persistentClass.getJoinNumber(property);
            propertyJoinNumbers.add(join);
        }
        this.subclassPropertyTableNumberClosure = ArrayHelper.toIntArray(propertyJoinNumbers);
        ArrayList<Object> values = new ArrayList<Object>();
        ArrayList<String> sqlValues = new ArrayList<String>();
        int subclassSpan = persistentClass.getSubclassSpan() + 1;
        this.subclassClosure = new String[subclassSpan];
        this.subclassClosure[0] = this.getEntityName();
        if (persistentClass.isPolymorphic()) {
            SingleTableEntityPersister.addSubclassByDiscriminatorValue(subclassesByDiscriminatorValueLocal, this.discriminatorValue, this.getEntityName());
            if (!this.getEntityMetamodel().isAbstract()) {
                values.add(this.discriminatorValue);
                sqlValues.add(this.discriminatorSQLValue);
            }
            List<Subclass> subclasses = persistentClass.getSubclasses();
            for (int k = 0; k < subclasses.size(); ++k) {
                boolean subclassAbstract;
                Subclass subclass = subclasses.get(k);
                this.subclassClosure[k] = subclass.getEntityName();
                Object subclassDiscriminatorValue = DiscriminatorHelper.getDiscriminatorValue(subclass);
                SingleTableEntityPersister.addSubclassByDiscriminatorValue(subclassesByDiscriminatorValueLocal, subclassDiscriminatorValue, subclass.getEntityName());
                boolean bl = subclass.isAbstract() == null ? subclass.hasPojoRepresentation() && ReflectHelper.isAbstractClass(subclass.getMappedClass()) : (subclassAbstract = subclass.isAbstract().booleanValue());
                if (subclassAbstract) continue;
                values.add(subclassDiscriminatorValue);
                sqlValues.add(DiscriminatorHelper.getDiscriminatorSQLValue(subclass, dialect, factory));
            }
        }
        this.subclassesByDiscriminatorValue = CollectionHelper.toSmallMap(subclassesByDiscriminatorValueLocal);
        this.fullDiscriminatorSQLValues = ArrayHelper.toStringArray(sqlValues);
        this.fullDiscriminatorValues = ArrayHelper.toObjectArray(values);
        this.initSubclassPropertyAliasesMap(persistentClass);
        this.postConstruct(creationContext.getMetadata());
    }

    private static boolean isDiscriminatorInsertable(PersistentClass persistentClass) {
        return !persistentClass.isDiscriminatorValueNull() && !persistentClass.isDiscriminatorValueNotNull() && persistentClass.isDiscriminatorInsertable() && !persistentClass.getDiscriminator().hasFormula();
    }

    private static void addSubclassByDiscriminatorValue(Map<Object, String> subclassesByDiscriminatorValue, Object discriminatorValue, String entityName) {
        String mappedEntityName = subclassesByDiscriminatorValue.put(discriminatorValue, entityName);
        if (mappedEntityName != null) {
            throw new MappingException("Entities [" + entityName + "] and [" + mappedEntityName + "] are mapped with the same discriminator value '" + discriminatorValue + "'.");
        }
    }

    @Override
    public boolean isInverseTable(int j) {
        return this.isInverseTable[j];
    }

    @Override
    protected boolean isInverseSubclassTable(int j) {
        return this.isInverseSubclassTable[j];
    }

    @Override
    public String getDiscriminatorColumnName() {
        return this.discriminatorColumnName;
    }

    @Override
    public String getDiscriminatorColumnReaders() {
        return this.discriminatorColumnReaders;
    }

    @Override
    public String getDiscriminatorColumnReaderTemplate() {
        return this.discriminatorColumnReaderTemplate;
    }

    @Override
    public String getDiscriminatorAlias() {
        return this.discriminatorAlias;
    }

    @Override
    public String getDiscriminatorFormulaTemplate() {
        return this.discriminatorFormulaTemplate;
    }

    @Override
    public String getTableName() {
        return this.qualifiedTableNames[0];
    }

    @Override
    public Type getDiscriminatorType() {
        return this.discriminatorType;
    }

    @Override
    public Object getDiscriminatorValue() {
        return this.discriminatorValue;
    }

    @Override
    public String getDiscriminatorSQLValue() {
        return this.discriminatorSQLValue;
    }

    public String[] getSubclassClosure() {
        return this.subclassClosure;
    }

    @Override
    public String getSubclassForDiscriminatorValue(Object value) {
        if (value == null) {
            return this.subclassesByDiscriminatorValue.get(DiscriminatorHelper.NULL_DISCRIMINATOR);
        }
        String result = this.subclassesByDiscriminatorValue.get(value);
        if (result == null) {
            result = this.subclassesByDiscriminatorValue.get(DiscriminatorHelper.NOT_NULL_DISCRIMINATOR);
        }
        return result;
    }

    @Override
    public Serializable[] getPropertySpaces() {
        return this.spaces;
    }

    private boolean isDiscriminatorFormula() {
        return this.discriminatorColumnName == null;
    }

    @Override
    public String getTableName(int j) {
        return this.qualifiedTableNames[j];
    }

    @Override
    public String[] getKeyColumns(int j) {
        return this.keyColumnNames[j];
    }

    @Override
    public boolean isTableCascadeDeleteEnabled(int j) {
        return this.cascadeDeleteEnabled[j];
    }

    @Override
    public boolean isPropertyOfTable(int property, int j) {
        return this.propertyTableNumbers[property] == j;
    }

    @Override
    protected boolean isSubclassTableSequentialSelect(int j) {
        return this.subclassTableSequentialSelect[j] && !this.isClassOrSuperclassTable[j];
    }

    @Override
    public String fromTableFragment(String name) {
        return this.getTableName() + " " + name;
    }

    private boolean needsDiscriminator() {
        return this.forceDiscriminator || this.isInherited();
    }

    @Override
    public String getSubclassPropertyTableName(int i) {
        return this.subclassTableNameClosure[this.subclassPropertyTableNumberClosure[i]];
    }

    @Override
    protected int getSubclassPropertyTableNumber(int i) {
        return this.subclassPropertyTableNumberClosure[i];
    }

    @Override
    public int getTableSpan() {
        return this.joinSpan;
    }

    @Override
    protected void addDiscriminatorToInsert(Insert insert) {
        if (this.discriminatorInsertable) {
            insert.addColumn(this.getDiscriminatorColumnName(), this.discriminatorSQLValue);
        }
    }

    @Override
    protected int[] getPropertyTableNumbers() {
        return this.propertyTableNumbers;
    }

    @Override
    protected String[] getSubclassTableKeyColumns(int j) {
        return this.subclassTableKeyColumnClosure[j];
    }

    @Override
    public String getSubclassTableName(int j) {
        return this.subclassTableNameClosure[j];
    }

    @Override
    protected String[] getSubclassTableNames() {
        return this.subclassTableNameClosure;
    }

    @Override
    public int getSubclassTableSpan() {
        return this.subclassTableNameClosure.length;
    }

    @Override
    protected boolean isClassOrSuperclassTable(int j) {
        return this.isClassOrSuperclassTable[j];
    }

    @Override
    protected boolean isClassOrSuperclassJoin(int j) {
        return this.isClassOrSuperclassJoin[j];
    }

    @Override
    public boolean isNullableTable(int j) {
        return this.isNullableTable[j];
    }

    @Override
    protected boolean isNullableSubclassTable(int j) {
        return this.isNullableSubclassTable[j];
    }

    @Override
    protected boolean hasMultipleTables() {
        return this.getTableSpan() > 1;
    }

    @Override
    public String[] getConstraintOrderedTableNameClosure() {
        return this.constraintOrderedTableNames;
    }

    @Override
    public String[][] getContraintOrderedTableKeyColumnClosure() {
        return this.constraintOrderedKeyColumnNames;
    }

    @Override
    public FilterAliasGenerator getFilterAliasGenerator(String rootAlias) {
        return new DynamicFilterAliasGenerator(this.qualifiedTableNames, rootAlias);
    }

    @Override
    public TableGroup createRootTableGroup(boolean canUseInnerJoins, NavigablePath navigablePath, String explicitSourceAlias, Supplier<Consumer<Predicate>> additionalPredicateCollectorAccess, SqlAliasBase sqlAliasBase, SqlExpressionResolver expressionResolver, FromClauseAccess fromClauseAccess, SqlAstCreationContext creationContext) {
        TableGroup tableGroup = super.createRootTableGroup(canUseInnerJoins, navigablePath, explicitSourceAlias, additionalPredicateCollectorAccess, sqlAliasBase, expressionResolver, fromClauseAccess, creationContext);
        if (additionalPredicateCollectorAccess != null && this.needsDiscriminator()) {
            Predicate discriminatorPredicate = this.createDiscriminatorPredicate(tableGroup.getPrimaryTableReference().getIdentificationVariable(), tableGroup, expressionResolver);
            additionalPredicateCollectorAccess.get().accept(discriminatorPredicate);
        }
        return tableGroup;
    }

    @Override
    public void applyDiscriminator(Consumer<Predicate> predicateConsumer, String alias, TableGroup tableGroup, SqlAstCreationState creationState) {
        if (this.needsDiscriminator()) {
            predicateConsumer.accept(this.createDiscriminatorPredicate(alias, tableGroup, creationState.getSqlExpressionResolver()));
        }
        super.applyDiscriminator(predicateConsumer, alias, tableGroup, creationState);
    }

    private Predicate createDiscriminatorPredicate(String alias, TableGroup tableGroup, SqlExpressionResolver sqlExpressionResolver) {
        boolean hasNullDiscriminator;
        String columnReferenceKey;
        String discriminatorExpression;
        if (this.isDiscriminatorFormula()) {
            discriminatorExpression = this.getDiscriminatorFormulaTemplate();
            columnReferenceKey = SqlExpressionResolver.createColumnReferenceKey(tableGroup.getPrimaryTableReference(), this.getDiscriminatorFormulaTemplate());
        } else {
            discriminatorExpression = this.getDiscriminatorColumnName();
            columnReferenceKey = SqlExpressionResolver.createColumnReferenceKey(tableGroup.getPrimaryTableReference(), this.getDiscriminatorColumnName());
        }
        BasicType discriminatorType = (BasicType)this.getDiscriminatorType();
        Expression sqlExpression = sqlExpressionResolver.resolveSqlExpression(columnReferenceKey, sqlAstProcessingState -> new ColumnReference(alias, discriminatorExpression, this.isDiscriminatorFormula(), null, null, discriminatorType.getJdbcMapping(), this.getFactory()));
        if (this.hasSubclasses()) {
            ArrayList<Expression> values = new ArrayList<Expression>(this.fullDiscriminatorValues.length);
            boolean hasNull = false;
            boolean hasNonNull = false;
            for (Object discriminatorValue : this.fullDiscriminatorValues) {
                if (discriminatorValue == DiscriminatorHelper.NULL_DISCRIMINATOR) {
                    hasNull = true;
                    continue;
                }
                if (discriminatorValue == DiscriminatorHelper.NOT_NULL_DISCRIMINATOR) {
                    hasNonNull = true;
                    continue;
                }
                values.add(new QueryLiteral<Object>(discriminatorValue, discriminatorType));
            }
            InListPredicate p = new InListPredicate(sqlExpression, values);
            if (hasNull || hasNonNull) {
                Junction junction = new Junction(Junction.Nature.DISJUNCTION);
                if (hasNull && hasNonNull) {
                    return junction;
                }
                junction.add(new NullnessPredicate(sqlExpression));
                junction.add(p);
                return junction;
            }
            return p;
        }
        Object value = this.getDiscriminatorValue();
        boolean hasNotNullDiscriminator = value == DiscriminatorHelper.NOT_NULL_DISCRIMINATOR;
        boolean bl = hasNullDiscriminator = value == DiscriminatorHelper.NULL_DISCRIMINATOR;
        if (hasNotNullDiscriminator || hasNullDiscriminator) {
            NullnessPredicate nullnessPredicate = new NullnessPredicate(sqlExpression);
            if (hasNotNullDiscriminator) {
                return new NegatedPredicate(nullnessPredicate);
            }
            return nullnessPredicate;
        }
        return new ComparisonPredicate(sqlExpression, ComparisonOperator.EQUAL, new QueryLiteral<Object>(value, discriminatorType));
    }

    @Override
    public void pruneForSubclasses(TableGroup tableGroup, Set<String> treatedEntityNames) {
        if (!this.needsDiscriminator() && treatedEntityNames.isEmpty()) {
            return;
        }
        NamedTableReference tableReference = (NamedTableReference)tableGroup.getPrimaryTableReference();
        InFragment frag = new InFragment();
        if (this.isDiscriminatorFormula()) {
            frag.setFormula("t", this.getDiscriminatorFormulaTemplate());
        } else {
            frag.setColumn("t", this.getDiscriminatorColumnName());
        }
        MappingMetamodelImplementor mappingMetamodel = this.getFactory().getRuntimeMetamodels().getMappingMetamodel();
        for (String subclass : treatedEntityNames) {
            Queryable queryable = (Queryable)mappingMetamodel.getEntityDescriptor(subclass);
            if (!queryable.isAbstract()) {
                frag.addValue(queryable.getDiscriminatorSQLValue());
            }
            if (!queryable.hasSubclasses()) continue;
            Set<String> actualSubClasses = queryable.getSubclassEntityNames();
            for (String actualSubClass : actualSubClasses) {
                Queryable actualQueryable;
                if (actualSubClass.equals(subclass) || (actualQueryable = (Queryable)mappingMetamodel.getEntityDescriptor(actualSubClass)).hasSubclasses()) continue;
                frag.addValue(actualQueryable.getDiscriminatorSQLValue());
            }
        }
        tableReference.setPrunedTableExpression("(select * from " + this.getTableName() + " t where " + frag.toFragmentString() + ")");
    }

    @Override
    public void visitConstraintOrderedTables(EntityMappingType.ConstraintOrderedTableConsumer consumer) {
        int i = 0;
        while (i < this.constraintOrderedTableNames.length) {
            String tableName = this.constraintOrderedTableNames[i];
            int tablePosition = i++;
            consumer.consume(tableName, () -> columnConsumer -> columnConsumer.accept(tableName, this.constraintOrderedKeyColumnNames[tablePosition]));
        }
    }
}

