/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.complete;

import java.util.Objects;
import java.util.function.BiFunction;
import org.hibernate.engine.FetchTiming;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.query.results.BasicValuedFetchBuilder;
import org.hibernate.query.results.DomainResultCreationStateImpl;
import org.hibernate.query.results.FetchBuilder;
import org.hibernate.query.results.MissingSqlSelectionException;
import org.hibernate.query.results.PositionalSelectionsNotAllowedException;
import org.hibernate.query.results.ResultSetMappingSqlSelection;
import org.hibernate.query.results.ResultsHelper;
import org.hibernate.query.results.complete.CompleteFetchBuilder;
import org.hibernate.query.results.complete.ModelPartReferenceBasic;
import org.hibernate.query.results.dynamic.DynamicFetchBuilderLegacy;
import org.hibernate.query.spi.NavigablePath;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.basic.BasicFetch;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;

public class CompleteFetchBuilderBasicPart
implements CompleteFetchBuilder,
BasicValuedFetchBuilder,
ModelPartReferenceBasic {
    private final NavigablePath navigablePath;
    private final BasicValuedModelPart referencedModelPart;
    private final String selectionAlias;

    public CompleteFetchBuilderBasicPart(NavigablePath navigablePath, BasicValuedModelPart referencedModelPart, String selectionAlias) {
        this.navigablePath = navigablePath;
        this.referencedModelPart = referencedModelPart;
        this.selectionAlias = selectionAlias;
    }

    @Override
    public FetchBuilder cacheKeyInstance() {
        return this;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public BasicValuedModelPart getReferencedPart() {
        return this.referencedModelPart;
    }

    @Override
    public BasicFetch<?> buildFetch(FetchParent parent, NavigablePath fetchPath, JdbcValuesMetadata jdbcResultsMetadata, BiFunction<String, String, DynamicFetchBuilderLegacy> legacyFetchResolver, DomainResultCreationState domainResultCreationState) {
        String selectedAlias;
        int jdbcPosition;
        DomainResultCreationStateImpl creationState = ResultsHelper.impl(domainResultCreationState);
        String mappedTable = this.referencedModelPart.getContainingTableExpression();
        String mappedColumn = this.referencedModelPart.getSelectionExpression();
        TableGroup tableGroup = creationState.getFromClauseAccess().getTableGroup(parent.getNavigablePath());
        TableReference tableReference = tableGroup.resolveTableReference(this.navigablePath, mappedTable);
        if (this.selectionAlias != null) {
            try {
                jdbcPosition = jdbcResultsMetadata.resolveColumnPosition(this.selectionAlias);
            }
            catch (Exception e) {
                throw new MissingSqlSelectionException("ResultSet mapping specified selected-alias `" + this.selectionAlias + "` which was not part of the ResultSet", e);
            }
            selectedAlias = this.selectionAlias;
        } else {
            if (!creationState.arePositionalSelectionsAllowed()) {
                throw new PositionalSelectionsNotAllowedException("Positional SQL selection resolution not allowed");
            }
            jdbcPosition = creationState.getNumberOfProcessedSelections();
            selectedAlias = jdbcResultsMetadata.resolveColumnName(jdbcPosition);
        }
        int valuesArrayPosition = ResultsHelper.jdbcPositionToValuesArrayPosition(jdbcPosition);
        creationState.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, mappedColumn), processingState -> new ResultSetMappingSqlSelection(valuesArrayPosition, this.referencedModelPart));
        return (BasicFetch)parent.generateFetchableFetch(this.referencedModelPart, fetchPath, FetchTiming.IMMEDIATE, true, selectedAlias, domainResultCreationState);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompleteFetchBuilderBasicPart that = (CompleteFetchBuilderBasicPart)o;
        return this.navigablePath.equals(that.navigablePath) && this.referencedModelPart.equals(that.referencedModelPart) && Objects.equals(this.selectionAlias, that.selectionAlias);
    }

    public int hashCode() {
        int result = this.navigablePath.hashCode();
        result = 31 * result + this.referencedModelPart.hashCode();
        result = 31 * result + (this.selectionAlias != null ? this.selectionAlias.hashCode() : 0);
        return result;
    }
}

