/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.dynamic;

import java.util.function.BiFunction;
import org.hibernate.LockMode;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.results.DomainResultCreationStateImpl;
import org.hibernate.query.results.ResultsHelper;
import org.hibernate.query.results.dynamic.DynamicFetchBuilderLegacy;
import org.hibernate.query.results.dynamic.DynamicResultBuilderEntity;
import org.hibernate.query.spi.NavigablePath;
import org.hibernate.sql.ast.spi.SqlAliasBaseConstant;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.entity.EntityResult;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;

public class DynamicResultBuilderEntityCalculated
implements DynamicResultBuilderEntity,
NativeQuery.RootReturn {
    private final NavigablePath navigablePath;
    private final EntityMappingType entityMapping;
    private final String tableAlias;
    private final LockMode explicitLockMode;
    private final SessionFactoryImplementor sessionFactory;

    public DynamicResultBuilderEntityCalculated(EntityMappingType entityMapping, String tableAlias, LockMode explicitLockMode, SessionFactoryImplementor sessionFactory) {
        this.entityMapping = entityMapping;
        this.navigablePath = new NavigablePath(entityMapping.getEntityName());
        this.tableAlias = tableAlias;
        this.explicitLockMode = explicitLockMode;
        this.sessionFactory = sessionFactory;
    }

    @Override
    public Class<?> getJavaType() {
        return this.entityMapping.getJavaType().getJavaTypeClass();
    }

    @Override
    public EntityMappingType getEntityMapping() {
        return this.entityMapping;
    }

    @Override
    public String getTableAlias() {
        return this.tableAlias;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public LockMode getLockMode() {
        return this.explicitLockMode;
    }

    @Override
    public NativeQuery.RootReturn setLockMode(LockMode lockMode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NativeQuery.RootReturn addIdColumnAliases(String ... aliases) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getDiscriminatorAlias() {
        return null;
    }

    @Override
    public NativeQuery.RootReturn setDiscriminatorAlias(String columnAlias) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NativeQuery.RootReturn addProperty(String propertyName, String columnAlias) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NativeQuery.ReturnProperty addProperty(String propertyName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DynamicResultBuilderEntityCalculated cacheKeyInstance() {
        return this;
    }

    @Override
    public EntityResult buildResult(JdbcValuesMetadata jdbcResultsMetadata, int resultPosition, BiFunction<String, String, DynamicFetchBuilderLegacy> legacyFetchResolver, DomainResultCreationState domainResultCreationState) {
        DomainResultCreationStateImpl creationStateImpl = ResultsHelper.impl(domainResultCreationState);
        TableGroup tableGroup = this.entityMapping.createRootTableGroup(true, this.navigablePath, this.tableAlias, null, new SqlAliasBaseConstant(this.tableAlias), creationStateImpl, creationStateImpl.getFromClauseAccess(), creationStateImpl.getCreationContext());
        creationStateImpl.getFromClauseAccess().registerTableGroup(this.navigablePath, tableGroup);
        if (this.explicitLockMode != null) {
            domainResultCreationState.getSqlAstCreationState().registerLockMode(this.tableAlias, this.explicitLockMode);
        }
        return (EntityResult)this.entityMapping.createDomainResult(this.navigablePath, tableGroup, this.tableAlias, domainResultCreationState);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamicResultBuilderEntityCalculated that = (DynamicResultBuilderEntityCalculated)o;
        if (!this.navigablePath.equals(that.navigablePath)) {
            return false;
        }
        if (!this.entityMapping.equals(that.entityMapping)) {
            return false;
        }
        if (!this.tableAlias.equals(that.tableAlias)) {
            return false;
        }
        return this.explicitLockMode == that.explicitLockMode;
    }

    public int hashCode() {
        int result = this.navigablePath.hashCode();
        result = 31 * result + this.entityMapping.hashCode();
        result = 31 * result + this.tableAlias.hashCode();
        result = 31 * result + (this.explicitLockMode != null ? this.explicitLockMode.hashCode() : 0);
        return result;
    }
}

