/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.spi;

import java.io.Serializable;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.query.spi.TreatedNavigablePath;
import org.hibernate.query.sqm.spi.EntityIdentifierNavigablePath;
import org.hibernate.spi.DotIdentifierSequence;

public class NavigablePath
implements DotIdentifierSequence,
Serializable {
    public static final String IDENTIFIER_MAPPER_PROPERTY = "_identifierMapper";
    private final NavigablePath parent;
    private final String fullPath;
    private final String unaliasedLocalName;
    private final String identifierForTableGroup;

    public NavigablePath(NavigablePath parent, String navigableName) {
        this.parent = parent;
        if (IDENTIFIER_MAPPER_PROPERTY.equals(navigableName)) {
            this.fullPath = parent != null ? parent.getFullPath() : "";
            this.unaliasedLocalName = "";
            this.identifierForTableGroup = parent != null ? parent.getIdentifierForTableGroup() : "";
        } else {
            this.unaliasedLocalName = navigableName;
            if (parent != null) {
                String parentFullPath = parent.getFullPath();
                this.fullPath = StringHelper.isEmpty(parentFullPath) ? navigableName : parentFullPath + "." + navigableName;
                this.identifierForTableGroup = StringHelper.isEmpty(parent.getIdentifierForTableGroup()) ? navigableName : parent.getIdentifierForTableGroup() + "." + navigableName;
            } else {
                this.fullPath = navigableName;
                this.identifierForTableGroup = navigableName;
            }
        }
    }

    public NavigablePath(String localName) {
        this(localName, null);
    }

    public NavigablePath(String rootName, String alias) {
        this.parent = null;
        this.fullPath = alias == null ? rootName : rootName + "(" + alias + ")";
        this.unaliasedLocalName = StringHelper.unqualify(rootName);
        this.identifierForTableGroup = rootName;
    }

    public NavigablePath(NavigablePath parent, String property, String alias) {
        String navigableName = alias == null ? property : property + "(" + alias + ")";
        this.parent = parent;
        if (IDENTIFIER_MAPPER_PROPERTY.equals(navigableName)) {
            this.fullPath = parent != null ? parent.getFullPath() : "";
            this.unaliasedLocalName = "";
            this.identifierForTableGroup = parent != null ? parent.getFullPath() : "";
        } else {
            this.unaliasedLocalName = property;
            if (parent != null) {
                String parentFullPath = parent.getFullPath();
                this.fullPath = StringHelper.isEmpty(parentFullPath) ? navigableName : parentFullPath + "." + navigableName;
                this.identifierForTableGroup = StringHelper.isEmpty(parent.getIdentifierForTableGroup()) ? navigableName : parent.getIdentifierForTableGroup() + "." + property;
            } else {
                this.fullPath = navigableName;
                this.identifierForTableGroup = property;
            }
        }
    }

    public NavigablePath() {
        this("");
    }

    public NavigablePath(NavigablePath parent, String fullPath, String unaliasedLocalName, String identifierForTableGroup) {
        this.parent = parent;
        this.fullPath = fullPath;
        this.unaliasedLocalName = unaliasedLocalName;
        this.identifierForTableGroup = identifierForTableGroup;
    }

    public NavigablePath treatAs(String entityName) {
        return new TreatedNavigablePath(this, entityName);
    }

    public NavigablePath treatAs(String entityName, String alias) {
        return new TreatedNavigablePath(this, entityName, alias);
    }

    @Override
    public NavigablePath append(String property) {
        return new NavigablePath(this, property);
    }

    public NavigablePath append(String property, String alias) {
        return new NavigablePath(this, property, alias);
    }

    @Override
    public NavigablePath getParent() {
        return this.parent instanceof TreatedNavigablePath ? this.parent.getParent() : this.parent;
    }

    public NavigablePath getRealParent() {
        return this.parent;
    }

    @Override
    public String getLocalName() {
        return this.parent == null ? this.fullPath : StringHelper.unqualify(this.fullPath);
    }

    public String getUnaliasedLocalName() {
        return this.unaliasedLocalName;
    }

    @Override
    public String getFullPath() {
        return this.fullPath;
    }

    public String getIdentifierForTableGroup() {
        if (this.parent == null) {
            return this.fullPath;
        }
        return this.identifierForTableGroup;
    }

    public boolean isParent(NavigablePath navigablePath) {
        while (navigablePath != null) {
            if (this.equals(navigablePath.getParent())) {
                return true;
            }
            navigablePath = navigablePath.getParent();
        }
        return false;
    }

    public String toString() {
        return this.fullPath;
    }

    public int hashCode() {
        return this.fullPath.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof EntityIdentifierNavigablePath) {
            EntityIdentifierNavigablePath otherPath = (EntityIdentifierNavigablePath)other;
            return otherPath.equals(this);
        }
        if (!(other instanceof NavigablePath)) {
            return false;
        }
        NavigablePath otherPath = (NavigablePath)other;
        if (this.getParent() == null) {
            return otherPath.getParent() == null;
        }
        return this.getParent().equals(otherPath.getParent()) && this.getLocalName().equals(otherPath.getLocalName());
    }
}

