/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hibernate.ScrollMode;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.SubselectFetch;
import org.hibernate.internal.EmptyScrollableResults;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.query.IllegalQueryOperationException;
import org.hibernate.query.TupleTransformer;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.spi.ScrollableResultsImplementor;
import org.hibernate.query.spi.SelectQueryPlan;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmJdbcExecutionContextAdapter;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.spi.SqmParameterMappingModelResolutionAccess;
import org.hibernate.query.sqm.sql.SqmTranslation;
import org.hibernate.query.sqm.sql.SqmTranslator;
import org.hibernate.query.sqm.sql.SqmTranslatorFactory;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiation;
import org.hibernate.query.sqm.tree.select.SqmQueryPart;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmSelection;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcSelect;
import org.hibernate.sql.exec.spi.JdbcSelectExecutor;
import org.hibernate.sql.results.graph.entity.LoadingEntityEntry;
import org.hibernate.sql.results.internal.RowTransformerJpaTupleImpl;
import org.hibernate.sql.results.internal.RowTransformerPassThruImpl;
import org.hibernate.sql.results.internal.RowTransformerSingularReturnImpl;
import org.hibernate.sql.results.internal.RowTransformerTupleTransformerAdapter;
import org.hibernate.sql.results.internal.TupleMetadata;
import org.hibernate.sql.results.spi.ListResultsConsumer;
import org.hibernate.sql.results.spi.RowTransformer;

public class ConcreteSqmSelectQueryPlan<R>
implements SelectQueryPlan<R> {
    private final SqmSelectStatement<?> sqm;
    private final String hql;
    private final DomainParameterXref domainParameterXref;
    private final RowTransformer<R> rowTransformer;
    private final SqmInterpreter<List<R>, Void> listInterpreter;
    private final SqmInterpreter<ScrollableResultsImplementor<R>, ScrollMode> scrollInterpreter;
    private volatile CacheableSqmInterpretation cacheableSqmInterpretation;

    public ConcreteSqmSelectQueryPlan(SqmSelectStatement<?> sqm, final String hql, DomainParameterXref domainParameterXref, Class<R> resultType, TupleMetadata tupleMetadata, QueryOptions queryOptions) {
        this.sqm = sqm;
        this.hql = hql;
        this.domainParameterXref = domainParameterXref;
        this.rowTransformer = this.determineRowTransformer(sqm, resultType, tupleMetadata, queryOptions);
        this.listInterpreter = (unused, executionContext, sqmInterpretation, jdbcParameterBindings) -> {
            SharedSessionContractImplementor session = executionContext.getSession();
            JdbcSelect jdbcSelect = sqmInterpretation.getJdbcSelect();
            try {
                final SubselectFetch.RegistrationHandler subSelectFetchKeyHandler = SubselectFetch.createRegistrationHandler(session.getPersistenceContext().getBatchFetchQueue(), sqmInterpretation.selectStatement, Collections.emptyList(), jdbcParameterBindings);
                session.autoFlushIfRequired(jdbcSelect.getAffectedTableNames());
                List<R> list = session.getFactory().getJdbcServices().getJdbcSelectExecutor().list(jdbcSelect, jdbcParameterBindings, new SqmJdbcExecutionContextAdapter(executionContext, jdbcSelect){

                    @Override
                    public void registerLoadingEntityEntry(EntityKey entityKey, LoadingEntityEntry entry) {
                        subSelectFetchKeyHandler.addKey(entityKey, entry);
                    }

                    @Override
                    public String getQueryIdentifier(String sql) {
                        if ("<criteria>".equals(hql)) {
                            return "[CRITERIA] " + sql;
                        }
                        return hql;
                    }

                    @Override
                    public boolean hasQueryExecutionToBeAddedToStatistics() {
                        return true;
                    }
                }, this.rowTransformer, ListResultsConsumer.UniqueSemantic.FILTER);
                return list;
            }
            finally {
                domainParameterXref.clearExpansions();
            }
        };
        this.scrollInterpreter = (scrollMode, executionContext, sqmInterpretation, jdbcParameterBindings) -> {
            try {
                JdbcSelectExecutor jdbcSelectExecutor = executionContext.getSession().getFactory().getJdbcServices().getJdbcSelectExecutor();
                ScrollableResultsImplementor<R> scrollableResultsImplementor = jdbcSelectExecutor.scroll(sqmInterpretation.getJdbcSelect(), (ScrollMode)((Object)scrollMode), jdbcParameterBindings, new SqmJdbcExecutionContextAdapter(executionContext, sqmInterpretation.jdbcSelect), this.rowTransformer);
                return scrollableResultsImplementor;
            }
            finally {
                domainParameterXref.clearExpansions();
            }
        };
    }

    private RowTransformer<R> determineRowTransformer(SqmSelectStatement<?> sqm, Class<R> resultType, TupleMetadata tupleMetadata, QueryOptions queryOptions) {
        if (resultType == null || resultType.isArray()) {
            if (queryOptions.getTupleTransformer() != null) {
                return this.makeRowTransformerTupleTransformerAdapter(sqm, queryOptions);
            }
            return RowTransformerPassThruImpl.instance();
        }
        List<SqmSelection<?>> selections = ((SqmQueryPart)sqm.getQueryPart()).getFirstQuerySpec().getSelectClause().getSelections();
        if (tupleMetadata != null) {
            if (queryOptions.getTupleTransformer() == null) {
                return new RowTransformerJpaTupleImpl(tupleMetadata);
            }
            throw new IllegalArgumentException("Illegal combination of Tuple resultType and (non-JpaTupleBuilder) TupleTransformer : " + queryOptions.getTupleTransformer());
        }
        if (queryOptions.getTupleTransformer() != null) {
            return this.makeRowTransformerTupleTransformerAdapter(sqm, queryOptions);
        }
        if (selections.size() > 1) {
            throw new IllegalQueryOperationException("Query defined multiple selections, return cannot be typed (other that Object[] or Tuple)");
        }
        return RowTransformerSingularReturnImpl.instance();
    }

    private RowTransformer<R> makeRowTransformerTupleTransformerAdapter(SqmSelectStatement<?> sqm, QueryOptions queryOptions) {
        ArrayList<String> aliases = new ArrayList<String>();
        for (SqmSelection<?> sqmSelection : ((SqmQuerySpec)sqm.getQuerySpec()).getSelectClause().getSelections()) {
            if (sqmSelection.getSelectableNode() instanceof SqmDynamicInstantiation) {
                aliases.add(sqmSelection.getAlias());
                continue;
            }
            sqmSelection.getSelectableNode().visitSubSelectableNodes(subSelection -> aliases.add(subSelection.getAlias()));
        }
        TupleTransformer<?> tupleTransformer = queryOptions.getTupleTransformer();
        return new RowTransformerTupleTransformerAdapter(ArrayHelper.toStringArray(aliases), tupleTransformer);
    }

    @Override
    public List<R> performList(DomainQueryExecutionContext executionContext) {
        if (executionContext.getQueryOptions().getEffectiveLimit().getMaxRowsJpa() == 0) {
            return Collections.emptyList();
        }
        return this.withCacheableSqmInterpretation(executionContext, null, this.listInterpreter);
    }

    @Override
    public ScrollableResultsImplementor<R> performScroll(ScrollMode scrollMode, DomainQueryExecutionContext executionContext) {
        if (executionContext.getQueryOptions().getEffectiveLimit().getMaxRowsJpa() == 0) {
            return EmptyScrollableResults.INSTANCE;
        }
        return this.withCacheableSqmInterpretation(executionContext, scrollMode, this.scrollInterpreter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, X> T withCacheableSqmInterpretation(DomainQueryExecutionContext executionContext, X context, SqmInterpreter<T, X> interpreter) {
        CacheableSqmInterpretation localCopy = this.cacheableSqmInterpretation;
        JdbcParameterBindings jdbcParameterBindings = null;
        if (localCopy == null) {
            ConcreteSqmSelectQueryPlan concreteSqmSelectQueryPlan = this;
            synchronized (concreteSqmSelectQueryPlan) {
                localCopy = this.cacheableSqmInterpretation;
                if (localCopy == null) {
                    localCopy = ConcreteSqmSelectQueryPlan.buildCacheableSqmInterpretation(this.sqm, this.domainParameterXref, executionContext);
                    jdbcParameterBindings = localCopy.firstParameterBindings;
                    localCopy.firstParameterBindings = null;
                    this.cacheableSqmInterpretation = localCopy;
                }
            }
        } else {
            if (localCopy.jdbcSelect.dependsOnParameterBindings()) {
                jdbcParameterBindings = this.createJdbcParameterBindings(localCopy, executionContext);
            }
            if (!localCopy.jdbcSelect.isCompatibleWith(jdbcParameterBindings, executionContext.getQueryOptions())) {
                localCopy = ConcreteSqmSelectQueryPlan.buildCacheableSqmInterpretation(this.sqm, this.domainParameterXref, executionContext);
                jdbcParameterBindings = localCopy.firstParameterBindings;
                localCopy.firstParameterBindings = null;
                this.cacheableSqmInterpretation = localCopy;
            }
        }
        if (jdbcParameterBindings == null) {
            jdbcParameterBindings = this.createJdbcParameterBindings(localCopy, executionContext);
        }
        return interpreter.interpret(context, executionContext, localCopy, jdbcParameterBindings);
    }

    private JdbcParameterBindings createJdbcParameterBindings(final CacheableSqmInterpretation sqmInterpretation, DomainQueryExecutionContext executionContext) {
        SharedSessionContractImplementor session = executionContext.getSession();
        JdbcParameterBindings jdbcParameterBindings = SqmUtil.createJdbcParameterBindings(executionContext.getQueryParameterBindings(), this.domainParameterXref, sqmInterpretation.getJdbcParamsXref(), session.getFactory().getRuntimeMetamodels().getMappingMetamodel(), sqmInterpretation.getTableGroupAccess()::findTableGroup, new SqmParameterMappingModelResolutionAccess(){

            @Override
            public <T> MappingModelExpressible<T> getResolvedMappingModelType(SqmParameter<T> parameter) {
                return sqmInterpretation.getSqmParameterMappingModelTypes().get(parameter);
            }
        }, session);
        sqmInterpretation.getJdbcSelect().bindFilterJdbcParameters(jdbcParameterBindings);
        return jdbcParameterBindings;
    }

    private static CacheableSqmInterpretation buildCacheableSqmInterpretation(SqmSelectStatement<?> sqm, DomainParameterXref domainParameterXref, DomainQueryExecutionContext executionContext) {
        SharedSessionContractImplementor session = executionContext.getSession();
        SessionFactoryImplementor sessionFactory = session.getFactory();
        QueryEngine queryEngine = sessionFactory.getQueryEngine();
        SqmTranslatorFactory sqmTranslatorFactory = queryEngine.getSqmTranslatorFactory();
        SqmTranslator<SelectStatement> sqmConverter = sqmTranslatorFactory.createSelectTranslator(sqm, executionContext.getQueryOptions(), domainParameterXref, executionContext.getQueryParameterBindings(), executionContext.getSession().getLoadQueryInfluencers(), sessionFactory, true);
        final SqmTranslation<SelectStatement> sqmInterpretation = sqmConverter.translate();
        FromClauseAccess tableGroupAccess = sqmConverter.getFromClauseAccess();
        JdbcServices jdbcServices = sessionFactory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
        SqlAstTranslator<JdbcSelect> selectTranslator = sqlAstTranslatorFactory.buildSelectTranslator(sessionFactory, sqmInterpretation.getSqlAst());
        Map<QueryParameterImplementor<?>, Map<SqmParameter<?>, List<List<JdbcParameter>>>> jdbcParamsXref = SqmUtil.generateJdbcParamsXref(domainParameterXref, sqmInterpretation::getJdbcParamsBySqmParam);
        JdbcParameterBindings jdbcParameterBindings = SqmUtil.createJdbcParameterBindings(executionContext.getQueryParameterBindings(), domainParameterXref, jdbcParamsXref, session.getFactory().getRuntimeMetamodels().getMappingMetamodel(), tableGroupAccess::findTableGroup, new SqmParameterMappingModelResolutionAccess(){

            @Override
            public <T> MappingModelExpressible<T> getResolvedMappingModelType(SqmParameter<T> parameter) {
                return sqmInterpretation.getSqmParameterMappingModelTypeResolutions().get(parameter);
            }
        }, session);
        JdbcSelect jdbcSelect = selectTranslator.translate(jdbcParameterBindings, executionContext.getQueryOptions());
        return new CacheableSqmInterpretation(sqmInterpretation.getSqlAst(), jdbcSelect, tableGroupAccess, jdbcParamsXref, sqmInterpretation.getSqmParameterMappingModelTypeResolutions(), jdbcParameterBindings);
    }

    private static class CacheableSqmInterpretation {
        private final SelectStatement selectStatement;
        private final JdbcSelect jdbcSelect;
        private final FromClauseAccess tableGroupAccess;
        private final Map<QueryParameterImplementor<?>, Map<SqmParameter<?>, List<List<JdbcParameter>>>> jdbcParamsXref;
        private final Map<SqmParameter<?>, MappingModelExpressible<?>> sqmParameterMappingModelTypes;
        private transient JdbcParameterBindings firstParameterBindings;

        CacheableSqmInterpretation(SelectStatement selectStatement, JdbcSelect jdbcSelect, FromClauseAccess tableGroupAccess, Map<QueryParameterImplementor<?>, Map<SqmParameter<?>, List<List<JdbcParameter>>>> jdbcParamsXref, Map<SqmParameter<?>, MappingModelExpressible<?>> sqmParameterMappingModelTypes, JdbcParameterBindings firstParameterBindings) {
            this.selectStatement = selectStatement;
            this.jdbcSelect = jdbcSelect;
            this.tableGroupAccess = tableGroupAccess;
            this.jdbcParamsXref = jdbcParamsXref;
            this.sqmParameterMappingModelTypes = sqmParameterMappingModelTypes;
            this.firstParameterBindings = firstParameterBindings;
        }

        SelectStatement getSelectStatement() {
            return this.selectStatement;
        }

        JdbcSelect getJdbcSelect() {
            return this.jdbcSelect;
        }

        FromClauseAccess getTableGroupAccess() {
            return this.tableGroupAccess;
        }

        Map<QueryParameterImplementor<?>, Map<SqmParameter<?>, List<List<JdbcParameter>>>> getJdbcParamsXref() {
            return this.jdbcParamsXref;
        }

        public Map<SqmParameter<?>, MappingModelExpressible<?>> getSqmParameterMappingModelTypes() {
            return this.sqmParameterMappingModelTypes;
        }

        JdbcParameterBindings getFirstParameterBindings() {
            return this.firstParameterBindings;
        }

        void setFirstParameterBindings(JdbcParameterBindings firstParameterBindings) {
            this.firstParameterBindings = firstParameterBindings;
        }
    }

    private static interface SqmInterpreter<T, X> {
        public T interpret(X var1, DomainQueryExecutionContext var2, CacheableSqmInterpretation var3, JdbcParameterBindings var4);
    }
}

