/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import org.hibernate.query.spi.NavigablePath;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.domain.SqmCorrelation;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.from.SqmJoin;
import org.hibernate.query.sqm.tree.from.SqmRoot;

public class SqmCorrelatedRootJoin<T>
extends SqmRoot<T>
implements SqmCorrelation<T, T> {
    SqmCorrelatedRootJoin(NavigablePath navigablePath, SqmPathSource<T> referencedNavigable, NodeBuilder nodeBuilder) {
        super(navigablePath, referencedNavigable, nodeBuilder);
    }

    @Override
    public SqmCorrelatedRootJoin<T> copy(SqmCopyContext context) {
        SqmCorrelatedRootJoin existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmCorrelatedRootJoin<T> path = context.registerCopy(this, new SqmCorrelatedRootJoin<T>(this.getNavigablePath(), this.getReferencedPathSource(), (NodeBuilder)this.nodeBuilder()));
        this.copyTo(path, context);
        return path;
    }

    public static <X, J extends SqmJoin<X, ?>> SqmCorrelatedRootJoin<X> create(J correlationParent, J correlatedJoin) {
        SqmFrom parentPath = (SqmFrom)correlationParent.getParentPath();
        SqmCorrelatedRootJoin rootJoin = parentPath == null ? new SqmCorrelatedRootJoin(correlationParent.getNavigablePath(), correlationParent.getReferencedPathSource(), correlationParent.nodeBuilder()) : new SqmCorrelatedRootJoin(parentPath.getNavigablePath(), parentPath.getReferencedPathSource(), correlationParent.nodeBuilder());
        rootJoin.addSqmJoin(correlatedJoin);
        return rootJoin;
    }

    @Override
    public SqmRoot<T> getCorrelationParent() {
        return this;
    }

    @Override
    public SqmPath<T> getWrappedPath() {
        return this.getCorrelationParent();
    }

    @Override
    public boolean isCorrelated() {
        return true;
    }

    @Override
    public SqmRoot<T> getCorrelatedRoot() {
        return this;
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitCorrelation(this);
    }
}

