/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import java.util.Map;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.MapPersistentAttribute;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.JpaMapJoin;
import org.hibernate.query.criteria.JpaPredicate;
import org.hibernate.query.hql.spi.SqmCreationProcessingState;
import org.hibernate.query.spi.NavigablePath;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmJoinType;
import org.hibernate.query.sqm.tree.domain.AbstractSqmPluralJoin;
import org.hibernate.query.sqm.tree.domain.SqmCorrelatedMapJoin;
import org.hibernate.query.sqm.tree.domain.SqmMapEntryReference;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmTreatedMapJoin;
import org.hibernate.query.sqm.tree.from.SqmFrom;

public class SqmMapJoin<O, K, V>
extends AbstractSqmPluralJoin<O, Map<K, V>, V>
implements JpaMapJoin<O, K, V> {
    public SqmMapJoin(SqmFrom<?, O> lhs, MapPersistentAttribute<O, K, V> pluralValuedNavigable, String alias, SqmJoinType sqmJoinType, boolean fetched, NodeBuilder nodeBuilder) {
        super(lhs, pluralValuedNavigable, alias, sqmJoinType, fetched, nodeBuilder);
    }

    protected SqmMapJoin(SqmFrom<?, O> lhs, NavigablePath navigablePath, MapPersistentAttribute<O, K, V> pluralValuedNavigable, String alias, SqmJoinType joinType, boolean fetched, NodeBuilder nodeBuilder) {
        super(lhs, navigablePath, pluralValuedNavigable, alias, joinType, fetched, nodeBuilder);
    }

    @Override
    public SqmMapJoin<O, K, V> copy(SqmCopyContext context) {
        SqmMapJoin existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmMapJoin<O, K, V> path = context.registerCopy(this, new SqmMapJoin<O, K, V>(this.getLhs().copy(context), this.getNavigablePath(), this.getReferencedPathSource(), this.getExplicitAlias(), this.getSqmJoinType(), this.isFetched(), (NodeBuilder)this.nodeBuilder()));
        this.copyTo(path, context);
        return path;
    }

    @Override
    public MapPersistentAttribute<O, K, V> getReferencedPathSource() {
        return (MapPersistentAttribute)super.getReferencedPathSource();
    }

    @Override
    public MapPersistentAttribute<O, K, V> getModel() {
        return (MapPersistentAttribute)super.getModel();
    }

    @Override
    public MapPersistentAttribute<O, K, V> getAttribute() {
        return (MapPersistentAttribute)super.getAttribute();
    }

    public SqmPath<K> key() {
        SqmPathSource keyPathSource = this.getReferencedPathSource().getKeyPathSource();
        return this.resolvePath(keyPathSource.getPathName(), keyPathSource);
    }

    public Path<V> value() {
        SqmPathSource elementPathSource = this.getReferencedPathSource().getElementPathSource();
        return this.resolvePath(elementPathSource.getPathName(), elementPathSource);
    }

    public Expression<Map.Entry<K, V>> entry() {
        return new SqmMapEntryReference(this, this.nodeBuilder());
    }

    @Override
    public SqmMapJoin<O, K, V> on(JpaExpression<Boolean> restriction) {
        return (SqmMapJoin)super.on((JpaExpression)restriction);
    }

    @Override
    public SqmMapJoin<O, K, V> on(Expression<Boolean> restriction) {
        return (SqmMapJoin)super.on((Expression)restriction);
    }

    @Override
    public SqmMapJoin<O, K, V> on(JpaPredicate ... restrictions) {
        return (SqmMapJoin)super.on(restrictions);
    }

    @Override
    public SqmMapJoin<O, K, V> on(Predicate ... restrictions) {
        return (SqmMapJoin)super.on(restrictions);
    }

    public SqmCorrelatedMapJoin<O, K, V> createCorrelation() {
        return new SqmCorrelatedMapJoin(this);
    }

    public <S extends V> SqmTreatedMapJoin<O, K, V, S> treatAs(Class<S> treatJavaType) {
        return this.treatAs((EntityDomainType)this.nodeBuilder().getDomainModel().entity(treatJavaType));
    }

    public <S extends V> SqmTreatedMapJoin<O, K, V, S> treatAs(EntityDomainType<S> treatTarget) {
        return this.treatAs((EntityDomainType)treatTarget, (String)null);
    }

    public <S extends V> SqmTreatedMapJoin<O, K, V, S> treatAs(Class<S> treatJavaType, String alias) {
        return this.treatAs((EntityDomainType)this.nodeBuilder().getDomainModel().entity(treatJavaType), alias);
    }

    public <S extends V> SqmTreatedMapJoin<O, K, V, S> treatAs(EntityDomainType<S> treatTarget, String alias) {
        SqmTreatedMapJoin treat = (SqmTreatedMapJoin)this.findTreat(treatTarget, alias);
        if (treat == null) {
            return this.addTreat(new SqmTreatedMapJoin(this, treatTarget, alias));
        }
        return treat;
    }

    @Override
    public SqmMapJoin<O, K, V> makeCopy(SqmCreationProcessingState creationProcessingState) {
        return new SqmMapJoin<O, K, V>(creationProcessingState.getPathRegistry().findFromByPath(this.getLhs().getNavigablePath()), this.getReferencedPathSource(), this.getExplicitAlias(), this.getSqmJoinType(), this.isFetched(), (NodeBuilder)this.nodeBuilder());
    }
}

