/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.update;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.update.SqmAssignment;

public class SqmSetClause {
    private final List<SqmAssignment> assignments;

    public SqmSetClause() {
        this.assignments = new ArrayList<SqmAssignment>();
    }

    private SqmSetClause(List<SqmAssignment> assignments) {
        this.assignments = assignments;
    }

    public SqmSetClause copy(SqmCopyContext context) {
        ArrayList<SqmAssignment> assignments = new ArrayList<SqmAssignment>(this.assignments.size());
        for (SqmAssignment assignment : this.assignments) {
            assignments.add(assignment.copy(context));
        }
        return new SqmSetClause(assignments);
    }

    public List<SqmAssignment> getAssignments() {
        return Collections.unmodifiableList(this.assignments);
    }

    public void addAssignment(SqmAssignment assignment) {
        this.assignments.add(assignment);
    }

    public void addAssignment(SqmPath targetPath, SqmExpression value) {
        this.addAssignment(new SqmAssignment(targetPath, value));
    }
}

