/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.spi;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.QueryException;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.RowLockStrategy;
import org.hibernate.dialect.SelectItemReferenceStrategy;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.AbstractDelegatingWrapperOptions;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.FilterJdbcParameter;
import org.hibernate.internal.util.MathHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.internal.util.collections.StandardStack;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.EntityAssociationMapping;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.SqlExpressible;
import org.hibernate.metamodel.mapping.SqlTypedMapping;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.persister.internal.SqlFragmentPredicate;
import org.hibernate.query.IllegalQueryOperationException;
import org.hibernate.query.spi.Limit;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.query.sqm.FetchClauseType;
import org.hibernate.query.sqm.FrameExclusion;
import org.hibernate.query.sqm.FrameKind;
import org.hibernate.query.sqm.FrameMode;
import org.hibernate.query.sqm.NullPrecedence;
import org.hibernate.query.sqm.SetOperator;
import org.hibernate.query.sqm.SortOrder;
import org.hibernate.query.sqm.TemporalUnit;
import org.hibernate.query.sqm.UnaryArithmeticOperator;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.sql.internal.SqmParameterInterpretation;
import org.hibernate.query.sqm.sql.internal.SqmPathInterpretation;
import org.hibernate.query.sqm.tree.expression.Conversion;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlTreeCreationException;
import org.hibernate.sql.ast.SqlTreePrinter;
import org.hibernate.sql.ast.spi.AggregateFunctionChecker;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.MutationStatement;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.cte.CteColumn;
import org.hibernate.sql.ast.tree.cte.CteContainer;
import org.hibernate.sql.ast.tree.cte.CteMaterialization;
import org.hibernate.sql.ast.tree.cte.CteSearchClauseKind;
import org.hibernate.sql.ast.tree.cte.CteStatement;
import org.hibernate.sql.ast.tree.cte.SearchClauseSpecification;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.ast.tree.expression.Any;
import org.hibernate.sql.ast.tree.expression.BinaryArithmeticExpression;
import org.hibernate.sql.ast.tree.expression.CaseSearchedExpression;
import org.hibernate.sql.ast.tree.expression.CaseSimpleExpression;
import org.hibernate.sql.ast.tree.expression.CastTarget;
import org.hibernate.sql.ast.tree.expression.Collation;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.ConvertedQueryLiteral;
import org.hibernate.sql.ast.tree.expression.Distinct;
import org.hibernate.sql.ast.tree.expression.Duration;
import org.hibernate.sql.ast.tree.expression.DurationUnit;
import org.hibernate.sql.ast.tree.expression.EntityTypeLiteral;
import org.hibernate.sql.ast.tree.expression.Every;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.ExtractUnit;
import org.hibernate.sql.ast.tree.expression.Format;
import org.hibernate.sql.ast.tree.expression.JdbcLiteral;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.LiteralAsParameter;
import org.hibernate.sql.ast.tree.expression.ModifiedSubQueryExpression;
import org.hibernate.sql.ast.tree.expression.OrderedSetAggregateFunctionExpression;
import org.hibernate.sql.ast.tree.expression.Over;
import org.hibernate.sql.ast.tree.expression.Overflow;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.sql.ast.tree.expression.SelfRenderingExpression;
import org.hibernate.sql.ast.tree.expression.SqlSelectionExpression;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.SqlTupleContainer;
import org.hibernate.sql.ast.tree.expression.Star;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.expression.TrimSpecification;
import org.hibernate.sql.ast.tree.expression.UnaryOperation;
import org.hibernate.sql.ast.tree.from.DerivedTableReference;
import org.hibernate.sql.ast.tree.from.FromClause;
import org.hibernate.sql.ast.tree.from.FunctionTableReference;
import org.hibernate.sql.ast.tree.from.LazyTableGroup;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.QueryPartTableGroup;
import org.hibernate.sql.ast.tree.from.QueryPartTableReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableGroupProducer;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.from.ValuesTableReference;
import org.hibernate.sql.ast.tree.from.VirtualTableGroup;
import org.hibernate.sql.ast.tree.insert.InsertStatement;
import org.hibernate.sql.ast.tree.insert.Values;
import org.hibernate.sql.ast.tree.predicate.BetweenPredicate;
import org.hibernate.sql.ast.tree.predicate.BooleanExpressionPredicate;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.ExistsPredicate;
import org.hibernate.sql.ast.tree.predicate.FilterPredicate;
import org.hibernate.sql.ast.tree.predicate.GroupedPredicate;
import org.hibernate.sql.ast.tree.predicate.InListPredicate;
import org.hibernate.sql.ast.tree.predicate.InSubQueryPredicate;
import org.hibernate.sql.ast.tree.predicate.Junction;
import org.hibernate.sql.ast.tree.predicate.LikePredicate;
import org.hibernate.sql.ast.tree.predicate.NegatedPredicate;
import org.hibernate.sql.ast.tree.predicate.NullnessPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.predicate.SelfRenderingPredicate;
import org.hibernate.sql.ast.tree.select.QueryGroup;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.ast.tree.select.SortSpecification;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.ExecutionException;
import org.hibernate.sql.exec.internal.AbstractJdbcParameter;
import org.hibernate.sql.exec.internal.JdbcParameterBindingImpl;
import org.hibernate.sql.exec.internal.JdbcParametersImpl;
import org.hibernate.sql.exec.internal.SqlTypedMappingJdbcParameter;
import org.hibernate.sql.exec.spi.AbstractJdbcOperation;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcDelete;
import org.hibernate.sql.exec.spi.JdbcInsert;
import org.hibernate.sql.exec.spi.JdbcLockStrategy;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.sql.exec.spi.JdbcParameterBinder;
import org.hibernate.sql.exec.spi.JdbcParameterBinding;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcSelect;
import org.hibernate.sql.exec.spi.JdbcUpdate;
import org.hibernate.sql.results.graph.DomainResultGraphPrinter;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.hibernate.sql.results.jdbc.internal.JdbcValuesMappingProducerStandard;
import org.hibernate.type.BasicType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;

public abstract class AbstractSqlAstTranslator<T extends JdbcOperation>
implements SqlAstTranslator<T>,
SqlAppender {
    private final SessionFactoryImplementor sessionFactory;
    private final StringBuilder sqlBuffer = new StringBuilder();
    private final List<JdbcParameterBinder> parameterBinders = new ArrayList<JdbcParameterBinder>();
    private final JdbcParametersImpl jdbcParameters = new JdbcParametersImpl();
    private final Set<FilterJdbcParameter> filterJdbcParameters = new HashSet<FilterJdbcParameter>();
    private final Stack<Clause> clauseStack = new StandardStack<Clause>();
    private final Stack<QueryPart> queryPartStack = new StandardStack<QueryPart>();
    private final Dialect dialect;
    private final Statement statement;
    private final Set<String> affectedTableNames = new HashSet<String>();
    private MutationStatement dmlStatement;
    private boolean needsSelectAliases;
    private List<String> columnAliases;
    private Predicate additionalWherePredicate;
    private QueryPart queryPartForRowNumbering;
    private int queryPartForRowNumberingClauseDepth = -1;
    private int queryPartForRowNumberingAliasCounter;
    private int queryGroupAliasCounter;
    private transient AbstractSqmSelfRenderingFunctionDescriptor castFunction;
    private transient LazySessionWrapperOptions lazySessionWrapperOptions;
    private transient BasicType<Integer> integerType;
    private transient BasicType<Boolean> booleanType;
    private SqlAstNodeRenderingMode parameterRenderingMode = SqlAstNodeRenderingMode.DEFAULT;
    private Map<JdbcParameter, JdbcParameterBinding> appliedParameterBindings = Collections.emptyMap();
    private JdbcParameterBindings jdbcParameterBindings;
    private LockOptions lockOptions;
    private Limit limit;
    private JdbcParameter offsetParameter;
    private JdbcParameter limitParameter;
    private ForUpdateClause forUpdate;

    public Dialect getDialect() {
        return this.dialect;
    }

    protected AbstractSqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        this.sessionFactory = sessionFactory;
        this.statement = statement;
        this.dialect = sessionFactory.getJdbcServices().getDialect();
    }

    public SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }

    protected AbstractSqmSelfRenderingFunctionDescriptor castFunction() {
        if (this.castFunction == null) {
            this.castFunction = (AbstractSqmSelfRenderingFunctionDescriptor)this.sessionFactory.getQueryEngine().getSqmFunctionRegistry().findFunctionDescriptor("cast");
        }
        return this.castFunction;
    }

    protected WrapperOptions getWrapperOptions() {
        if (this.lazySessionWrapperOptions == null) {
            this.lazySessionWrapperOptions = new LazySessionWrapperOptions(this.sessionFactory);
        }
        return this.lazySessionWrapperOptions;
    }

    public BasicType<Integer> getIntegerType() {
        if (this.integerType == null) {
            this.integerType = this.sessionFactory.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.INTEGER);
        }
        return this.integerType;
    }

    public BasicType<Boolean> getBooleanType() {
        if (this.booleanType == null) {
            this.booleanType = this.sessionFactory.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.BOOLEAN);
        }
        return this.booleanType;
    }

    public String getSql() {
        return this.sqlBuffer.toString();
    }

    protected void cleanup() {
        if (this.lazySessionWrapperOptions != null) {
            this.lazySessionWrapperOptions.cleanup();
            this.lazySessionWrapperOptions = null;
        }
        this.jdbcParameterBindings = null;
        this.lockOptions = null;
        this.limit = null;
        this.setOffsetParameter(null);
        this.setLimitParameter(null);
    }

    public List<JdbcParameterBinder> getParameterBinders() {
        return this.parameterBinders;
    }

    public Set<FilterJdbcParameter> getFilterJdbcParameters() {
        return this.filterJdbcParameters;
    }

    protected SqlAppender getSqlAppender() {
        return this;
    }

    @Override
    public Set<String> getAffectedTableNames() {
        return this.affectedTableNames;
    }

    protected String getDmlTargetTableAlias() {
        return this.dmlStatement == null ? null : this.dmlStatement.getTargetTable().getIdentificationVariable();
    }

    protected Statement getStatement() {
        return this.statement;
    }

    public MutationStatement getCurrentDmlStatement() {
        return this.dmlStatement;
    }

    protected SqlAstNodeRenderingMode getParameterRenderingMode() {
        return this.parameterRenderingMode;
    }

    protected void addAdditionalWherePredicate(Predicate predicate) {
        this.additionalWherePredicate = Predicate.combinePredicates(this.additionalWherePredicate, predicate);
    }

    @Override
    public boolean supportsFilterClause() {
        return false;
    }

    @Override
    public void appendSql(String fragment) {
        this.sqlBuffer.append(fragment);
    }

    @Override
    public void appendSql(char fragment) {
        this.sqlBuffer.append(fragment);
    }

    @Override
    public void appendSql(int value) {
        this.sqlBuffer.append(value);
    }

    @Override
    public void appendSql(long value) {
        this.sqlBuffer.append(value);
    }

    @Override
    public void appendSql(boolean value) {
        this.sqlBuffer.append(value);
    }

    @Override
    public Appendable append(CharSequence csq) {
        this.sqlBuffer.append(csq);
        return this;
    }

    @Override
    public Appendable append(CharSequence csq, int start, int end) {
        this.sqlBuffer.append(csq, start, end);
        return this;
    }

    @Override
    public Appendable append(char c) {
        this.sqlBuffer.append(c);
        return this;
    }

    protected JdbcServices getJdbcServices() {
        return this.getSessionFactory().getJdbcServices();
    }

    protected void addAppliedParameterBinding(JdbcParameter parameter, JdbcParameterBinding binding) {
        if (this.appliedParameterBindings.isEmpty()) {
            this.appliedParameterBindings = new IdentityHashMap<JdbcParameter, JdbcParameterBinding>();
        }
        if (binding == null) {
            this.appliedParameterBindings.put(parameter, null);
        } else {
            JdbcMapping bindType = binding.getBindType();
            Object value = bindType.getJavaTypeDescriptor().getMutabilityPlan().deepCopy(binding.getBindValue());
            this.appliedParameterBindings.put(parameter, new JdbcParameterBindingImpl(bindType, value));
        }
    }

    protected Map<JdbcParameter, JdbcParameterBinding> getAppliedParameterBindings() {
        return this.appliedParameterBindings;
    }

    protected JdbcLockStrategy getJdbcLockStrategy() {
        return this.lockOptions == null ? JdbcLockStrategy.FOLLOW_ON : JdbcLockStrategy.NONE;
    }

    protected JdbcParameterBindings getJdbcParameterBindings() {
        return this.jdbcParameterBindings;
    }

    protected LockOptions getLockOptions() {
        return this.lockOptions;
    }

    protected Limit getLimit() {
        return this.limit;
    }

    protected boolean hasLimit() {
        return this.limit != null && !this.limit.isEmpty();
    }

    protected boolean hasOffset(QueryPart queryPart) {
        if (queryPart.isRoot() && this.hasLimit() && this.limit.getFirstRow() != null) {
            return true;
        }
        return queryPart.getOffsetClauseExpression() != null;
    }

    protected boolean useOffsetFetchClause(QueryPart queryPart) {
        return !queryPart.isRoot() || this.limit == null || this.limit.isEmpty();
    }

    protected boolean isRowsOnlyFetchClauseType(QueryPart queryPart) {
        if (queryPart.isRoot() && this.hasLimit() || queryPart.getFetchClauseType() == null) {
            return true;
        }
        return queryPart.getFetchClauseType() == FetchClauseType.ROWS_ONLY;
    }

    protected JdbcParameter getOffsetParameter() {
        return this.offsetParameter;
    }

    protected void setOffsetParameter(JdbcParameter offsetParameter) {
        this.offsetParameter = offsetParameter;
    }

    protected JdbcParameter getLimitParameter() {
        return this.limitParameter;
    }

    protected void setLimitParameter(JdbcParameter limitParameter) {
        this.limitParameter = limitParameter;
    }

    protected <R> R interpretExpression(Expression expression, JdbcParameterBindings jdbcParameterBindings) {
        if (expression instanceof Literal) {
            return (R)((Literal)expression).getLiteralValue();
        }
        if (expression instanceof JdbcParameter) {
            if (jdbcParameterBindings == null) {
                throw new IllegalArgumentException("Can't interpret expression because no parameter bindings are available!");
            }
            return (R)this.getParameterBindValue((JdbcParameter)expression);
        }
        if (expression instanceof SqmParameterInterpretation) {
            if (jdbcParameterBindings == null) {
                throw new IllegalArgumentException("Can't interpret expression because no parameter bindings are available!");
            }
            return (R)this.getParameterBindValue((JdbcParameter)((SqmParameterInterpretation)expression).getResolvedExpression());
        }
        throw new UnsupportedOperationException("Can't interpret expression: " + expression);
    }

    protected void renderExpressionAsLiteral(Expression expression, JdbcParameterBindings jdbcParameterBindings) {
        if (expression instanceof Literal) {
            expression.accept(this);
            return;
        }
        if (expression instanceof JdbcParameter) {
            if (jdbcParameterBindings == null) {
                throw new IllegalArgumentException("Can't interpret expression because no parameter bindings are available!");
            }
            JdbcParameter parameter = (JdbcParameter)expression;
            this.renderAsLiteral(parameter, this.getParameterBindValue(parameter));
            return;
        }
        if (expression instanceof SqmParameterInterpretation) {
            if (jdbcParameterBindings == null) {
                throw new IllegalArgumentException("Can't interpret expression because no parameter bindings are available!");
            }
            JdbcParameter parameter = (JdbcParameter)((SqmParameterInterpretation)expression).getResolvedExpression();
            this.renderAsLiteral(parameter, this.getParameterBindValue(parameter));
            return;
        }
        throw new UnsupportedOperationException("Can't render expression as literal: " + expression);
    }

    protected Object getParameterBindValue(JdbcParameter parameter) {
        JdbcParameterBinding binding = parameter == this.getOffsetParameter() ? new JdbcParameterBindingImpl(this.getIntegerType(), this.getLimit().getFirstRow()) : (parameter == this.getLimitParameter() ? new JdbcParameterBindingImpl(this.getIntegerType(), this.getLimit().getMaxRows()) : this.jdbcParameterBindings.getBinding(parameter));
        this.addAppliedParameterBinding(parameter, binding);
        return binding.getBindValue();
    }

    protected Expression getLeftHandExpression(Predicate predicate) {
        if (predicate instanceof NullnessPredicate) {
            return ((NullnessPredicate)predicate).getExpression();
        }
        assert (predicate instanceof ComparisonPredicate);
        return ((ComparisonPredicate)predicate).getLeftHandExpression();
    }

    protected boolean inOverOrWithinGroupClause() {
        return this.clauseStack.findCurrentFirst(clause -> {
            switch (clause) {
                case OVER: 
                case WITHIN_GROUP: {
                    return true;
                }
            }
            return null;
        }) != null;
    }

    protected Stack<Clause> getClauseStack() {
        return this.clauseStack;
    }

    protected Stack<QueryPart> getQueryPartStack() {
        return this.queryPartStack;
    }

    @Override
    public QueryPart getCurrentQueryPart() {
        return this.queryPartStack.getCurrent();
    }

    @Override
    public Stack<Clause> getCurrentClauseStack() {
        return this.clauseStack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T translate(JdbcParameterBindings jdbcParameterBindings, QueryOptions queryOptions) {
        try {
            AbstractJdbcOperation jdbcOperation;
            this.jdbcParameterBindings = jdbcParameterBindings;
            this.lockOptions = queryOptions.getLockOptions().makeCopy();
            Limit limit = this.limit = queryOptions.getLimit() == null ? null : queryOptions.getLimit().makeCopy();
            if (this.statement instanceof DeleteStatement) {
                jdbcOperation = this.translateDelete((DeleteStatement)this.statement);
            } else if (this.statement instanceof UpdateStatement) {
                jdbcOperation = this.translateUpdate((UpdateStatement)this.statement);
            } else if (this.statement instanceof InsertStatement) {
                jdbcOperation = this.translateInsert((InsertStatement)this.statement);
            } else if (this.statement instanceof SelectStatement) {
                jdbcOperation = this.translateSelect((SelectStatement)this.statement);
            } else {
                throw new IllegalArgumentException("Unexpected statement!");
            }
            if (jdbcParameterBindings != null && CollectionHelper.isNotEmpty(this.getFilterJdbcParameters())) {
                for (FilterJdbcParameter filterJdbcParameter : this.getFilterJdbcParameters()) {
                    jdbcParameterBindings.addBinding(filterJdbcParameter.getParameter(), filterJdbcParameter.getBinding());
                }
            }
            JdbcDelete jdbcDelete = jdbcOperation;
            return (T)jdbcDelete;
        }
        finally {
            this.cleanup();
        }
    }

    protected JdbcDelete translateDelete(DeleteStatement sqlAst) {
        this.visitDeleteStatement(sqlAst);
        return new JdbcDelete(this.getSql(), this.getParameterBinders(), this.getAffectedTableNames(), this.getFilterJdbcParameters(), this.getAppliedParameterBindings());
    }

    protected JdbcUpdate translateUpdate(UpdateStatement sqlAst) {
        this.visitUpdateStatement(sqlAst);
        return new JdbcUpdate(this.getSql(), this.getParameterBinders(), this.getAffectedTableNames(), this.getFilterJdbcParameters(), this.getAppliedParameterBindings());
    }

    protected JdbcInsert translateInsert(InsertStatement sqlAst) {
        this.visitInsertStatement(sqlAst);
        return new JdbcInsert(this.getSql(), this.getParameterBinders(), this.getAffectedTableNames(), this.getFilterJdbcParameters(), this.getAppliedParameterBindings());
    }

    protected JdbcSelect translateSelect(SelectStatement sqlAstSelect) {
        DomainResultGraphPrinter.logDomainResultGraph(sqlAstSelect.getDomainResultDescriptors());
        SqlTreePrinter.logSqlAst(sqlAstSelect);
        this.visitSelectStatement(sqlAstSelect);
        int rowsToSkip = this.getRowsToSkip(sqlAstSelect, this.getJdbcParameterBindings());
        return new JdbcSelect(this.getSql(), this.getParameterBinders(), new JdbcValuesMappingProducerStandard(sqlAstSelect.getQuerySpec().getSelectClause().getSqlSelections(), sqlAstSelect.getDomainResultDescriptors()), this.getAffectedTableNames(), this.getFilterJdbcParameters(), rowsToSkip, this.getMaxRows(sqlAstSelect, this.getJdbcParameterBindings(), rowsToSkip), this.getAppliedParameterBindings(), this.getJdbcLockStrategy(), this.getOffsetParameter(), this.getLimitParameter());
    }

    protected int getRowsToSkip(SelectStatement sqlAstSelect, JdbcParameterBindings jdbcParameterBindings) {
        if (this.hasLimit()) {
            if (this.offsetParameter != null && this.needsRowsToSkip()) {
                return (Integer)this.interpretExpression(this.offsetParameter, jdbcParameterBindings);
            }
        } else {
            Expression offsetClauseExpression = sqlAstSelect.getQueryPart().getOffsetClauseExpression();
            if (offsetClauseExpression != null && this.needsRowsToSkip()) {
                return (Integer)this.interpretExpression(offsetClauseExpression, jdbcParameterBindings);
            }
        }
        return 0;
    }

    protected int getMaxRows(SelectStatement sqlAstSelect, JdbcParameterBindings jdbcParameterBindings, int rowsToSkip) {
        if (this.hasLimit()) {
            if (this.limitParameter != null && this.needsMaxRows()) {
                Number fetchCount = (Number)this.interpretExpression(this.limitParameter, jdbcParameterBindings);
                return rowsToSkip + fetchCount.intValue();
            }
        } else {
            Expression fetchClauseExpression = sqlAstSelect.getQueryPart().getFetchClauseExpression();
            if (fetchClauseExpression != null && this.needsMaxRows()) {
                Number fetchCount = (Number)this.interpretExpression(fetchClauseExpression, jdbcParameterBindings);
                return rowsToSkip + fetchCount.intValue();
            }
        }
        return Integer.MAX_VALUE;
    }

    protected boolean needsRowsToSkip() {
        return false;
    }

    protected boolean needsMaxRows() {
        return false;
    }

    protected void prepareLimitOffsetParameters() {
        Limit limit = this.getLimit();
        if (limit.getFirstRow() != null) {
            this.setOffsetParameter(new OffsetJdbcParameter(this.sessionFactory.getTypeConfiguration().getBasicTypeForJavaType(Integer.class)));
        }
        if (limit.getMaxRows() != null) {
            this.setLimitParameter(new LimitJdbcParameter(this.sessionFactory.getTypeConfiguration().getBasicTypeForJavaType(Integer.class)));
        }
    }

    @Override
    public void visitSelectStatement(SelectStatement statement) {
        MutationStatement oldDmlStatement = this.dmlStatement;
        this.dmlStatement = null;
        try {
            this.visitCteContainer(statement);
            statement.getQueryPart().accept(this);
        }
        finally {
            this.dmlStatement = oldDmlStatement;
        }
    }

    @Override
    public void visitDeleteStatement(DeleteStatement statement) {
        MutationStatement oldDmlStatement = this.dmlStatement;
        this.dmlStatement = null;
        try {
            this.visitCteContainer(statement);
            this.dmlStatement = statement;
            this.visitDeleteStatementOnly(statement);
        }
        finally {
            this.dmlStatement = oldDmlStatement;
        }
    }

    @Override
    public void visitUpdateStatement(UpdateStatement statement) {
        MutationStatement oldDmlTargetTableAlias = this.dmlStatement;
        this.dmlStatement = null;
        try {
            this.visitCteContainer(statement);
            this.dmlStatement = statement;
            this.visitUpdateStatementOnly(statement);
        }
        finally {
            this.dmlStatement = oldDmlTargetTableAlias;
        }
    }

    @Override
    public void visitAssignment(Assignment assignment) {
        throw new SqlTreeCreationException("Encountered unexpected assignment clause");
    }

    @Override
    public void visitInsertStatement(InsertStatement statement) {
        MutationStatement oldDmlStatement = this.dmlStatement;
        this.dmlStatement = null;
        try {
            this.visitCteContainer(statement);
            this.visitInsertStatementOnly(statement);
        }
        finally {
            this.dmlStatement = oldDmlStatement;
        }
    }

    protected void visitDeleteStatementOnly(DeleteStatement statement) {
        this.appendSql("delete from ");
        Stack<Clause> clauseStack = this.getClauseStack();
        try {
            clauseStack.push(Clause.DELETE);
            this.renderNamedTableReference(statement.getTargetTable(), LockMode.NONE);
        }
        finally {
            clauseStack.pop();
        }
        this.visitWhereClause(statement.getRestriction());
        this.visitReturningColumns(statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void visitUpdateStatementOnly(UpdateStatement statement) {
        this.appendSql("update ");
        Stack<Clause> clauseStack = this.getClauseStack();
        try {
            clauseStack.push(Clause.UPDATE);
            this.renderNamedTableReference(statement.getTargetTable(), LockMode.NONE);
        }
        finally {
            clauseStack.pop();
        }
        this.appendSql(" set ");
        boolean firstPass = true;
        try {
            clauseStack.push(Clause.SET);
            for (Assignment assignment : statement.getAssignments()) {
                if (firstPass) {
                    firstPass = false;
                } else {
                    this.appendSql(',');
                }
                List<ColumnReference> columnReferences = assignment.getAssignable().getColumnReferences();
                if (columnReferences.size() == 1) {
                    columnReferences.get(0).accept(this);
                    this.appendSql('=');
                    Expression assignedValue = assignment.getAssignedValue();
                    SqlTuple sqlTuple = SqlTupleContainer.getSqlTuple(assignedValue);
                    if (sqlTuple != null) {
                        Expression expression = sqlTuple.getExpressions().get(0);
                        expression.accept(this);
                        continue;
                    }
                    assignedValue.accept(this);
                    continue;
                }
                this.appendSql('(');
                for (ColumnReference columnReference : columnReferences) {
                    columnReference.accept(this);
                }
                this.appendSql(")=");
                assignment.getAssignedValue().accept(this);
            }
        }
        finally {
            clauseStack.pop();
        }
        this.visitWhereClause(statement.getRestriction());
        this.visitReturningColumns(statement);
    }

    protected void visitInsertStatementOnly(InsertStatement statement) {
        this.appendSql("insert into ");
        this.appendSql(statement.getTargetTable().getTableExpression());
        this.appendSql('(');
        boolean firstPass = true;
        List<ColumnReference> targetColumnReferences = statement.getTargetColumnReferences();
        if (targetColumnReferences == null) {
            this.renderImplicitTargetColumnSpec();
        } else {
            for (ColumnReference targetColumnReference : targetColumnReferences) {
                if (firstPass) {
                    firstPass = false;
                } else {
                    this.appendSql(',');
                }
                this.appendSql(targetColumnReference.getColumnExpression());
            }
        }
        this.appendSql(") ");
        if (statement.getSourceSelectStatement() != null) {
            statement.getSourceSelectStatement().accept(this);
        } else {
            this.visitValuesList(statement.getValuesList());
        }
        this.visitReturningColumns(statement);
    }

    private void renderImplicitTargetColumnSpec() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void visitValuesList(List<Values> valuesList) {
        this.appendSql("values");
        boolean firstTuple = true;
        Stack<Clause> clauseStack = this.getClauseStack();
        try {
            clauseStack.push(Clause.VALUES);
            for (Values values : valuesList) {
                if (firstTuple) {
                    firstTuple = false;
                } else {
                    this.appendSql(',');
                }
                this.appendSql(" (");
                boolean firstExpr = true;
                for (Expression expression : values.getExpressions()) {
                    if (firstExpr) {
                        firstExpr = false;
                    } else {
                        this.appendSql(',');
                    }
                    expression.accept(this);
                }
                this.appendSql(')');
            }
        }
        finally {
            clauseStack.pop();
        }
    }

    protected void visitForUpdateClause(QuerySpec querySpec) {
        if (querySpec.isRoot()) {
            if (this.forUpdate != null) {
                Boolean followOnLocking;
                Boolean bl = followOnLocking = this.getLockOptions() == null ? Boolean.FALSE : this.getLockOptions().getFollowOnLocking();
                if (Boolean.TRUE.equals(followOnLocking)) {
                    this.lockOptions = null;
                } else {
                    this.forUpdate.merge(this.getLockOptions());
                    this.forUpdate.applyAliases(this.getDialect().getWriteRowLockStrategy(), querySpec);
                    if (LockMode.READ.lessThan(this.forUpdate.getLockMode())) {
                        LockStrategy lockStrategy = this.determineLockingStrategy(querySpec, this.forUpdate, followOnLocking);
                        switch (lockStrategy) {
                            case CLAUSE: {
                                this.renderForUpdateClause(querySpec, this.forUpdate);
                                break;
                            }
                            case FOLLOW_ON: {
                                this.lockOptions = null;
                            }
                        }
                    }
                }
                this.forUpdate = null;
            } else {
                Boolean followOnLocking;
                LockOptions lockOptions = this.getLockOptions();
                Boolean bl = followOnLocking = this.getLockOptions() == null ? Boolean.FALSE : lockOptions.getFollowOnLocking();
                if (Boolean.TRUE.equals(followOnLocking)) {
                    this.lockOptions = null;
                } else if (lockOptions.getLockMode() != LockMode.NONE) {
                    ForUpdateClause forUpdateClause = new ForUpdateClause();
                    forUpdateClause.merge(this.getLockOptions());
                    forUpdateClause.applyAliases(this.getDialect().getWriteRowLockStrategy(), querySpec);
                    if (LockMode.READ.lessThan(forUpdateClause.getLockMode())) {
                        LockStrategy lockStrategy = this.determineLockingStrategy(querySpec, forUpdateClause, followOnLocking);
                        switch (lockStrategy) {
                            case CLAUSE: {
                                this.renderForUpdateClause(querySpec, forUpdateClause);
                                break;
                            }
                            case FOLLOW_ON: {
                                if (Boolean.FALSE.equals(followOnLocking)) {
                                    throw new UnsupportedOperationException("");
                                }
                                this.lockOptions = null;
                            }
                        }
                    }
                }
            }
        } else if (this.forUpdate != null) {
            this.forUpdate.merge(this.getLockOptions());
            this.forUpdate.applyAliases(this.getDialect().getWriteRowLockStrategy(), querySpec);
            if (LockMode.READ.lessThan(this.forUpdate.getLockMode())) {
                LockStrategy lockStrategy = this.determineLockingStrategy(querySpec, this.forUpdate, null);
                switch (lockStrategy) {
                    case CLAUSE: {
                        this.renderForUpdateClause(querySpec, this.forUpdate);
                        break;
                    }
                    case FOLLOW_ON: {
                        throw new UnsupportedOperationException("Follow-on locking for subqueries is not supported");
                    }
                }
            }
            this.forUpdate = null;
        }
    }

    protected void renderForUpdateClause(QuerySpec querySpec, ForUpdateClause forUpdateClause) {
        int timeoutMillis = forUpdateClause.getTimeoutMillis();
        LockKind lockKind = LockKind.NONE;
        switch (forUpdateClause.getLockMode()) {
            case PESSIMISTIC_WRITE: {
                lockKind = LockKind.UPDATE;
                break;
            }
            case PESSIMISTIC_READ: {
                lockKind = LockKind.SHARE;
                break;
            }
            case UPGRADE_NOWAIT: 
            case PESSIMISTIC_FORCE_INCREMENT: {
                timeoutMillis = 0;
                lockKind = LockKind.UPDATE;
                break;
            }
            case UPGRADE_SKIPLOCKED: {
                timeoutMillis = -2;
                lockKind = LockKind.UPDATE;
                break;
            }
        }
        if (lockKind != LockKind.NONE) {
            if (lockKind == LockKind.SHARE) {
                this.appendSql(this.getForShare(timeoutMillis));
                if (forUpdateClause.hasAliases() && this.getDialect().getReadRowLockStrategy() != RowLockStrategy.NONE) {
                    this.appendSql(" of ");
                    forUpdateClause.appendAliases(this);
                }
            } else {
                this.appendSql(this.getForUpdate());
                if (forUpdateClause.hasAliases() && this.getDialect().getWriteRowLockStrategy() != RowLockStrategy.NONE) {
                    this.appendSql(" of ");
                    forUpdateClause.appendAliases(this);
                }
            }
            this.appendSql(this.getForUpdateWithClause());
            switch (timeoutMillis) {
                case 0: {
                    if (!this.getDialect().supportsNoWait()) break;
                    this.appendSql(this.getNoWait());
                    break;
                }
                case -2: {
                    if (!this.getDialect().supportsSkipLocked()) break;
                    this.appendSql(this.getSkipLocked());
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    if (!this.getDialect().supportsWait()) break;
                    this.appendSql(" wait ");
                    this.appendSql(Math.round((float)timeoutMillis / 1000.0f));
                }
            }
        }
    }

    protected String getForUpdate() {
        return " for update";
    }

    protected String getForShare(int timeoutMillis) {
        return " for update";
    }

    protected String getForUpdateWithClause() {
        return "";
    }

    protected String getNoWait() {
        return " nowait";
    }

    protected String getSkipLocked() {
        return " skip locked";
    }

    protected LockMode getEffectiveLockMode(String alias) {
        if (this.getLockOptions() == null) {
            return LockMode.NONE;
        }
        QueryPart currentQueryPart = this.getQueryPartStack().getCurrent();
        LockMode lockMode = this.getLockOptions().getAliasSpecificLockMode(alias);
        if (currentQueryPart.isRoot() && lockMode == null) {
            lockMode = this.getLockOptions().getLockMode();
        }
        return lockMode == null ? LockMode.NONE : lockMode;
    }

    protected int getEffectiveLockTimeout(LockMode lockMode) {
        if (this.getLockOptions() == null) {
            return -1;
        }
        int timeoutMillis = this.getLockOptions().getTimeOut();
        switch (lockMode) {
            case UPGRADE_NOWAIT: 
            case PESSIMISTIC_FORCE_INCREMENT: {
                timeoutMillis = 0;
                break;
            }
            case UPGRADE_SKIPLOCKED: {
                timeoutMillis = -2;
                break;
            }
        }
        return timeoutMillis;
    }

    protected boolean hasAggregateFunctions(QuerySpec querySpec) {
        return AggregateFunctionChecker.hasAggregateFunctions(querySpec);
    }

    protected LockStrategy determineLockingStrategy(QuerySpec querySpec, ForUpdateClause forUpdateClause, Boolean followOnLocking) {
        LockStrategy strategy = LockStrategy.CLAUSE;
        if (!querySpec.getGroupByClauseExpressions().isEmpty()) {
            if (Boolean.FALSE.equals(followOnLocking)) {
                throw new IllegalQueryOperationException("Locking with GROUP BY is not supported!");
            }
            strategy = LockStrategy.FOLLOW_ON;
        }
        if (querySpec.getHavingClauseRestrictions() != null) {
            if (Boolean.FALSE.equals(followOnLocking)) {
                throw new IllegalQueryOperationException("Locking with HAVING is not supported!");
            }
            strategy = LockStrategy.FOLLOW_ON;
        }
        if (querySpec.getSelectClause().isDistinct()) {
            if (Boolean.FALSE.equals(followOnLocking)) {
                throw new IllegalQueryOperationException("Locking with DISTINCT is not supported!");
            }
            strategy = LockStrategy.FOLLOW_ON;
        }
        if (!this.getDialect().supportsOuterJoinForUpdate()) {
            if (forUpdateClause.hasAliases()) {
                if (querySpec.getFromClause().queryTableGroupJoins(tableGroupJoin -> {
                    TableGroup group = tableGroupJoin.getJoinedGroup();
                    if (forUpdateClause.hasAlias(group.getSourceAlias()) && tableGroupJoin.getJoinType() != SqlAstJoinType.INNER && !(group instanceof VirtualTableGroup)) {
                        if (Boolean.FALSE.equals(followOnLocking)) {
                            throw new IllegalQueryOperationException("Locking with OUTER joins is not supported!");
                        }
                        return Boolean.TRUE;
                    }
                    return null;
                }) != null) {
                    strategy = LockStrategy.FOLLOW_ON;
                }
            } else if (querySpec.getFromClause().queryTableJoins(tableJoin -> {
                if (tableJoin.getJoinType() != SqlAstJoinType.INNER && !(tableJoin.getJoinedNode() instanceof VirtualTableGroup)) {
                    if (Boolean.FALSE.equals(followOnLocking)) {
                        throw new IllegalQueryOperationException("Locking with OUTER joins is not supported!");
                    }
                    return Boolean.TRUE;
                }
                return null;
            }) != null) {
                strategy = LockStrategy.FOLLOW_ON;
            }
        }
        if (this.hasAggregateFunctions(querySpec)) {
            if (Boolean.FALSE.equals(followOnLocking)) {
                throw new IllegalQueryOperationException("Locking with aggregate functions is not supported!");
            }
            strategy = LockStrategy.FOLLOW_ON;
        }
        return strategy;
    }

    protected void visitReturningColumns(MutationStatement mutationStatement) {
        List<ColumnReference> returningColumns = mutationStatement.getReturningColumns();
        int size = returningColumns.size();
        if (size == 0) {
            return;
        }
        this.appendSql(" returning ");
        String separator = "";
        for (int i = 0; i < size; ++i) {
            this.appendSql(separator);
            this.appendSql(returningColumns.get(i).getColumnExpression());
            separator = ",";
        }
    }

    public void visitCteContainer(CteContainer cteContainer) {
        Collection<CteStatement> cteStatements = cteContainer.getCteStatements().values();
        if (cteStatements.isEmpty()) {
            return;
        }
        this.appendSql("with ");
        if (cteContainer.isWithRecursive()) {
            this.appendSql("recursive ");
        }
        String mainSeparator = "";
        for (CteStatement cte : cteStatements) {
            this.appendSql(mainSeparator);
            this.appendSql(cte.getCteTable().getTableExpression());
            this.appendSql(" (");
            String separator = "";
            for (CteColumn cteColumn : cte.getCteTable().getCteColumns()) {
                this.appendSql(separator);
                this.appendSql(cteColumn.getColumnExpression());
                separator = ",";
            }
            this.appendSql(") as ");
            if (cte.getMaterialization() != CteMaterialization.UNDEFINED) {
                this.renderMaterializationHint(cte.getMaterialization());
            }
            this.appendSql('(');
            cte.getCteDefinition().accept(this);
            this.appendSql(')');
            this.renderSearchClause(cte);
            this.renderCycleClause(cte);
            mainSeparator = ",";
        }
        this.appendSql(' ');
    }

    protected void renderMaterializationHint(CteMaterialization materialization) {
    }

    protected void renderSearchClause(CteStatement cte) {
        if (cte.getSearchClauseKind() != null) {
            this.appendSql(" search ");
            if (cte.getSearchClauseKind() == CteSearchClauseKind.DEPTH_FIRST) {
                this.appendSql(" depth ");
            } else {
                this.appendSql(" breadth ");
            }
            this.appendSql(" first by ");
            String separator = "";
            for (SearchClauseSpecification searchBySpecification : cte.getSearchBySpecifications()) {
                this.appendSql(separator);
                this.appendSql(searchBySpecification.getCteColumn().getColumnExpression());
                if (searchBySpecification.getSortOrder() != null) {
                    if (searchBySpecification.getSortOrder() == SortOrder.ASCENDING) {
                        this.appendSql(" asc");
                    } else {
                        this.appendSql(" desc");
                    }
                    if (searchBySpecification.getNullPrecedence() != null) {
                        if (searchBySpecification.getNullPrecedence() == NullPrecedence.FIRST) {
                            this.appendSql(" nulls first");
                        } else {
                            this.appendSql(" nulls last");
                        }
                    }
                }
                separator = ",";
            }
        }
    }

    protected void renderCycleClause(CteStatement cte) {
        if (cte.getCycleMarkColumn() != null) {
            this.appendSql(" cycle ");
            String separator = "";
            for (CteColumn cycleColumn : cte.getCycleColumns()) {
                this.appendSql(separator);
                this.appendSql(cycleColumn.getColumnExpression());
                separator = ",";
            }
            this.appendSql(" set ");
            this.appendSql(cte.getCycleMarkColumn().getColumnExpression());
            this.appendSql(" to '");
            this.appendSql(cte.getCycleValue());
            this.appendSql("' default '");
            this.appendSql(cte.getNoCycleValue());
            this.appendSql('\'');
        }
    }

    @Override
    public void visitQueryGroup(QueryGroup queryGroup) {
        this.renderQueryGroup(queryGroup, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderQueryGroup(QueryGroup queryGroup, boolean renderOrderByAndOffsetFetchClause) {
        QueryPart queryPartForRowNumbering = this.queryPartForRowNumbering;
        int queryPartForRowNumberingClauseDepth = this.queryPartForRowNumberingClauseDepth;
        boolean needsSelectAliases = this.needsSelectAliases;
        try {
            boolean needsParenthesis;
            String queryGroupAlias = null;
            QueryPart currentQueryPart = this.queryPartStack.getCurrent();
            if (currentQueryPart != null && queryPartForRowNumberingClauseDepth != this.clauseStack.depth()) {
                this.queryPartForRowNumbering = null;
                this.queryPartForRowNumberingClauseDepth = -1;
                this.needsSelectAliases = false;
            }
            boolean bl = needsParenthesis = !queryGroup.isRoot();
            if (needsParenthesis) {
                this.appendSql('(');
            }
            if (queryPartForRowNumbering == queryGroup || this.additionalWherePredicate != null && !this.additionalWherePredicate.isEmpty()) {
                this.needsSelectAliases = true;
                queryGroupAlias = "grp_" + this.queryGroupAliasCounter + "_";
                ++this.queryGroupAliasCounter;
                this.appendSql("select ");
                this.appendSql(queryGroupAlias);
                this.appendSql(".* ");
                SelectClause firstSelectClause = queryGroup.getFirstQuerySpec().getSelectClause();
                List<SqlSelection> sqlSelections = firstSelectClause.getSqlSelections();
                int sqlSelectionsSize = sqlSelections.size();
                SelectClause syntheticSelectClause = new SelectClause(sqlSelectionsSize);
                for (int i = 0; i < sqlSelectionsSize; ++i) {
                    syntheticSelectClause.addSqlSelection(new SqlSelectionImpl(i + 1, i, new ColumnReference(queryGroupAlias, "c" + i, false, null, null, this.getIntegerType(), null)));
                }
                this.renderRowNumberingSelectItems(syntheticSelectClause, queryPartForRowNumbering);
                this.appendSql(" from (");
            }
            this.queryPartStack.push(queryGroup);
            List<QueryPart> queryParts = queryGroup.getQueryParts();
            String setOperatorString = " " + queryGroup.getSetOperator().sqlString() + " ";
            Object separator = "";
            for (int i = 0; i < queryParts.size(); ++i) {
                this.appendSql((String)separator);
                queryParts.get(i).accept(this);
                separator = setOperatorString;
            }
            if (renderOrderByAndOffsetFetchClause) {
                this.visitOrderBy(queryGroup.getSortSpecifications());
                this.visitOffsetFetchClause(queryGroup);
            }
            if (queryGroupAlias != null) {
                this.appendSql(") ");
                this.appendSql(queryGroupAlias);
                if (this.additionalWherePredicate != null && !this.additionalWherePredicate.isEmpty()) {
                    this.visitWhereClause(this.additionalWherePredicate);
                }
            }
            if (needsParenthesis) {
                this.appendSql(')');
            }
        }
        finally {
            this.queryPartStack.pop();
            this.queryPartForRowNumbering = queryPartForRowNumbering;
            this.queryPartForRowNumberingClauseDepth = queryPartForRowNumberingClauseDepth;
            this.needsSelectAliases = needsSelectAliases;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitQuerySpec(QuerySpec querySpec) {
        QueryPart queryPartForRowNumbering = this.queryPartForRowNumbering;
        int queryPartForRowNumberingClauseDepth = this.queryPartForRowNumberingClauseDepth;
        boolean needsSelectAliases = this.needsSelectAliases;
        Predicate additionalWherePredicate = this.additionalWherePredicate;
        ForUpdateClause forUpdate = this.forUpdate;
        try {
            boolean needsParenthesis;
            this.additionalWherePredicate = null;
            this.forUpdate = null;
            QueryPart currentQueryPart = this.queryPartStack.getCurrent();
            if (currentQueryPart != null && (queryPartForRowNumbering instanceof QueryGroup || queryPartForRowNumberingClauseDepth != this.clauseStack.depth())) {
                this.queryPartForRowNumbering = null;
                this.queryPartForRowNumberingClauseDepth = -1;
            }
            Object queryGroupAlias = "";
            if (currentQueryPart instanceof QueryGroup) {
                needsParenthesis = querySpec.hasOffsetOrFetchClause();
                if (needsParenthesis && (!this.supportsSimpleQueryGrouping() || currentQueryPart.hasOffsetOrFetchClause())) {
                    queryGroupAlias = " grp_" + this.queryGroupAliasCounter + "_";
                    ++this.queryGroupAliasCounter;
                    this.appendSql("select");
                    this.appendSql((String)queryGroupAlias);
                    this.appendSql(".* from ");
                }
            } else {
                needsParenthesis = !querySpec.isRoot();
            }
            this.queryPartStack.push(querySpec);
            if (needsParenthesis) {
                this.appendSql('(');
            }
            this.visitSelectClause(querySpec.getSelectClause());
            this.visitFromClause(querySpec.getFromClause());
            this.visitWhereClause(querySpec.getWhereClauseRestrictions());
            this.visitGroupByClause(querySpec, this.getDialect().getGroupBySelectItemReferenceStrategy());
            this.visitHavingClause(querySpec);
            this.visitOrderBy(querySpec.getSortSpecifications());
            this.visitOffsetFetchClause(querySpec);
            if (queryPartForRowNumbering == null) {
                this.visitForUpdateClause(querySpec);
            }
            if (needsParenthesis) {
                this.appendSql(')');
                this.appendSql((String)queryGroupAlias);
            }
        }
        finally {
            this.queryPartStack.pop();
            this.queryPartForRowNumbering = queryPartForRowNumbering;
            this.queryPartForRowNumberingClauseDepth = queryPartForRowNumberingClauseDepth;
            this.needsSelectAliases = needsSelectAliases;
            this.additionalWherePredicate = additionalWherePredicate;
            if (queryPartForRowNumbering == null) {
                this.forUpdate = forUpdate;
            }
        }
    }

    protected boolean supportsSimpleQueryGrouping() {
        return true;
    }

    protected final void visitWhereClause(Predicate whereClauseRestrictions) {
        if (whereClauseRestrictions != null && !whereClauseRestrictions.isEmpty() || this.additionalWherePredicate != null) {
            this.appendSql(" where ");
            this.clauseStack.push(Clause.WHERE);
            try {
                if (whereClauseRestrictions != null && !whereClauseRestrictions.isEmpty()) {
                    whereClauseRestrictions.accept(this);
                    if (this.additionalWherePredicate != null) {
                        this.appendSql(" and ");
                        this.additionalWherePredicate.accept(this);
                        this.additionalWherePredicate = null;
                    }
                } else if (this.additionalWherePredicate != null) {
                    this.additionalWherePredicate.accept(this);
                    this.additionalWherePredicate = null;
                }
            }
            finally {
                this.clauseStack.pop();
            }
        }
    }

    protected Expression resolveAliasedExpression(Expression expression) {
        if (this.queryPartStack.getCurrent() == null) {
            assert (expression instanceof SqlSelectionExpression);
            return ((SqlSelectionExpression)expression).getSelection().getExpression();
        }
        return this.resolveAliasedExpression(this.queryPartStack.getCurrent().getFirstQuerySpec().getSelectClause().getSqlSelections(), expression);
    }

    protected Expression resolveAliasedExpression(List<SqlSelection> sqlSelections, Expression expression) {
        if (expression instanceof Literal) {
            Object literalValue = ((Literal)expression).getLiteralValue();
            if (literalValue instanceof Integer) {
                return sqlSelections.get((Integer)literalValue).getExpression();
            }
        } else {
            Expression sqlExpression;
            if (expression instanceof SqlSelectionExpression) {
                return ((SqlSelectionExpression)expression).getSelection().getExpression();
            }
            if (expression instanceof SqmPathInterpretation && (sqlExpression = ((SqmPathInterpretation)expression).getSqlExpression()) instanceof SqlSelectionExpression) {
                return ((SqlSelectionExpression)sqlExpression).getSelection().getExpression();
            }
        }
        return expression;
    }

    protected Expression resolveExpressionToAlias(Expression expression) {
        Expression sqlExpression;
        int index = -1;
        if (expression instanceof SqlSelectionExpression) {
            index = ((SqlSelectionExpression)expression).getSelection().getValuesArrayPosition();
        } else if (expression instanceof SqmPathInterpretation && (sqlExpression = ((SqmPathInterpretation)expression).getSqlExpression()) instanceof SqlSelectionExpression) {
            index = ((SqlSelectionExpression)sqlExpression).getSelection().getValuesArrayPosition();
        }
        if (index == -1) {
            return expression;
        }
        return new ColumnReference((String)null, "c" + index, false, null, null, expression.getExpressionType().getJdbcMappings().get(0), this.sessionFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void visitGroupByClause(QuerySpec querySpec, SelectItemReferenceStrategy referenceStrategy) {
        List<Expression> partitionExpressions = querySpec.getGroupByClauseExpressions();
        if (!partitionExpressions.isEmpty()) {
            try {
                this.clauseStack.push(Clause.GROUP);
                this.appendSql(" group by ");
                this.visitPartitionExpressions(partitionExpressions, referenceStrategy);
            }
            finally {
                this.clauseStack.pop();
            }
        }
    }

    protected final void visitPartitionByClause(List<Expression> partitionExpressions) {
        if (!partitionExpressions.isEmpty()) {
            try {
                this.clauseStack.push(Clause.PARTITION);
                this.appendSql("partition by ");
                this.visitPartitionExpressions(partitionExpressions, SelectItemReferenceStrategy.EXPRESSION);
            }
            finally {
                this.clauseStack.pop();
            }
        }
    }

    protected final void visitPartitionExpressions(List<Expression> partitionExpressions, SelectItemReferenceStrategy referenceStrategy) {
        boolean inlineParametersOfAliasedExpressions;
        Function<Expression, Expression> resolveAliasExpression;
        switch (referenceStrategy) {
            case POSITION: {
                resolveAliasExpression = Function.identity();
                inlineParametersOfAliasedExpressions = false;
                break;
            }
            case ALIAS: {
                resolveAliasExpression = this::resolveExpressionToAlias;
                inlineParametersOfAliasedExpressions = false;
                break;
            }
            default: {
                resolveAliasExpression = this::resolveAliasedExpression;
                inlineParametersOfAliasedExpressions = true;
            }
        }
        this.visitPartitionExpressions(partitionExpressions, resolveAliasExpression, inlineParametersOfAliasedExpressions);
    }

    protected final void visitPartitionExpressions(List<Expression> partitionExpressions, Function<Expression, Expression> resolveAliasExpression, boolean inlineParametersOfAliasedExpressions) {
        String separator = "";
        for (Expression partitionExpression : partitionExpressions) {
            SqlTuple sqlTuple = SqlTupleContainer.getSqlTuple(partitionExpression);
            if (sqlTuple != null) {
                for (Expression expression : sqlTuple.getExpressions()) {
                    this.appendSql(separator);
                    Expression resolved = resolveAliasExpression.apply(expression);
                    if (inlineParametersOfAliasedExpressions && resolved != expression) {
                        SqlAstNodeRenderingMode original = this.parameterRenderingMode;
                        this.parameterRenderingMode = SqlAstNodeRenderingMode.INLINE_ALL_PARAMETERS;
                        this.renderPartitionItem(resolved);
                        this.parameterRenderingMode = original;
                    } else {
                        this.renderPartitionItem(resolved);
                    }
                    separator = ",";
                }
            } else {
                this.appendSql(separator);
                Expression resolved = resolveAliasExpression.apply(partitionExpression);
                if (inlineParametersOfAliasedExpressions && resolved != partitionExpression) {
                    SqlAstNodeRenderingMode sqlAstNodeRenderingMode = this.parameterRenderingMode;
                    this.parameterRenderingMode = SqlAstNodeRenderingMode.INLINE_ALL_PARAMETERS;
                    this.renderPartitionItem(resolved);
                    this.parameterRenderingMode = sqlAstNodeRenderingMode;
                } else {
                    this.renderPartitionItem(resolved);
                }
            }
            separator = ",";
        }
    }

    protected void renderPartitionItem(Expression expression) {
        if (expression instanceof Literal) {
            this.appendSql("()");
        } else if (expression instanceof Summarization) {
            Summarization summarization = (Summarization)expression;
            this.appendSql(summarization.getKind().sqlText());
            this.appendSql('(');
            this.renderCommaSeparated(summarization.getGroupings());
            this.appendSql(')');
        } else {
            expression.accept(this);
        }
    }

    protected final void visitHavingClause(QuerySpec querySpec) {
        Predicate havingClauseRestrictions = querySpec.getHavingClauseRestrictions();
        if (havingClauseRestrictions != null && !havingClauseRestrictions.isEmpty()) {
            this.appendSql(" having ");
            this.clauseStack.push(Clause.HAVING);
            try {
                havingClauseRestrictions.accept(this);
            }
            finally {
                this.clauseStack.pop();
            }
        }
    }

    protected void visitOrderBy(List<SortSpecification> sortSpecifications) {
        if (this.queryPartForRowNumbering == null) {
            this.renderOrderBy(true, sortSpecifications);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderOrderBy(boolean addWhitespace, List<SortSpecification> sortSpecifications) {
        if (sortSpecifications != null && !sortSpecifications.isEmpty()) {
            if (addWhitespace) {
                this.appendSql(' ');
            }
            this.appendSql("order by ");
            this.clauseStack.push(Clause.ORDER);
            try {
                String separator = "";
                for (SortSpecification sortSpecification : sortSpecifications) {
                    this.appendSql(separator);
                    this.visitSortSpecification(sortSpecification);
                    separator = ",";
                }
            }
            finally {
                this.clauseStack.pop();
            }
        }
    }

    protected void emulateSelectTupleComparison(List<SqlSelection> lhsSelections, List<? extends SqlAstNode> rhsExpressions, ComparisonOperator operator, boolean indexOptimized) {
        List<SqlAstNode> lhsExpressions;
        if (lhsSelections.size() == rhsExpressions.size()) {
            lhsExpressions = lhsSelections;
        } else if (lhsSelections.size() == 1) {
            lhsExpressions = SqlTupleContainer.getSqlTuple(lhsSelections.get(0).getExpression()).getExpressions();
        } else {
            ArrayList<SqlSelection> list = new ArrayList<SqlSelection>(rhsExpressions.size());
            for (SqlSelection lhsSelection : lhsSelections) {
                list.addAll(SqlTupleContainer.getSqlTuple(lhsSelection.getExpression()).getExpressions());
            }
            lhsExpressions = list;
        }
        this.emulateTupleComparison(lhsExpressions, rhsExpressions, operator, indexOptimized);
    }

    protected void emulateTupleComparison(List<? extends SqlAstNode> lhsExpressions, List<? extends SqlAstNode> rhsExpressions, ComparisonOperator operator, boolean indexOptimized) {
        boolean isCurrentWhereClause;
        boolean bl = isCurrentWhereClause = this.clauseStack.getCurrent() == Clause.WHERE;
        if (isCurrentWhereClause) {
            this.appendSql('(');
        }
        int size = lhsExpressions.size();
        assert (size == rhsExpressions.size());
        switch (operator) {
            case DISTINCT_FROM: {
                this.appendSql("not ");
            }
            case NOT_DISTINCT_FROM: {
                if (this.supportsIntersect()) {
                    this.appendSql("exists (select ");
                    this.renderCommaSeparatedSelectExpression(lhsExpressions);
                    this.appendSql(this.getFromDualForSelectOnly());
                    this.appendSql(" intersect select ");
                    this.renderCommaSeparatedSelectExpression(rhsExpressions);
                    this.appendSql(this.getFromDualForSelectOnly());
                    this.appendSql(')');
                    break;
                }
                this.appendSql("exists (select 1");
                this.appendSql(this.getFromDual());
                this.appendSql(" where (");
                String separator = "";
                for (int i = 0; i < size; ++i) {
                    this.appendSql(separator);
                    lhsExpressions.get(i).accept(this);
                    this.appendSql('=');
                    rhsExpressions.get(i).accept(this);
                    this.appendSql(" or ");
                    lhsExpressions.get(i).accept(this);
                    this.appendSql(" is null and ");
                    rhsExpressions.get(i).accept(this);
                    this.appendSql(" is null");
                    separator = ") and (";
                }
                this.appendSql("))");
                break;
            }
            case EQUAL: 
            case NOT_EQUAL: {
                String operatorText = operator.sqlText();
                String separator = "";
                for (int i = 0; i < size; ++i) {
                    this.appendSql(separator);
                    lhsExpressions.get(i).accept(this);
                    this.appendSql(operatorText);
                    rhsExpressions.get(i).accept(this);
                    separator = " and ";
                }
                break;
            }
            case LESS_THAN_OR_EQUAL: 
            case GREATER_THAN_OR_EQUAL: 
            case LESS_THAN: 
            case GREATER_THAN: {
                if (indexOptimized) {
                    lhsExpressions.get(0).accept(this);
                    this.appendSql(operator.broader().sqlText());
                    rhsExpressions.get(0).accept(this);
                    this.appendSql(" and not ");
                    String negatedOperatorText = operator.negated().sqlText();
                    this.emulateTupleComparisonSimple(lhsExpressions, rhsExpressions, negatedOperatorText, negatedOperatorText, true);
                    break;
                }
                this.emulateTupleComparisonSimple(lhsExpressions, rhsExpressions, operator.sharper().sqlText(), operator.sqlText(), false);
            }
        }
        if (isCurrentWhereClause) {
            this.appendSql(')');
        }
    }

    protected boolean supportsIntersect() {
        return true;
    }

    protected void renderExpressionsAsSubquery(List<? extends Expression> expressions) {
        this.clauseStack.push(Clause.SELECT);
        try {
            this.appendSql("select ");
            this.renderCommaSeparatedSelectExpression(expressions);
            this.appendSql(this.getFromDualForSelectOnly());
        }
        finally {
            this.clauseStack.pop();
        }
    }

    private void emulateTupleComparisonSimple(List<? extends SqlAstNode> lhsExpressions, List<? extends SqlAstNode> rhsExpressions, String operatorText, String finalOperatorText, boolean optimized) {
        int i;
        int size = lhsExpressions.size();
        int lastIndex = size - 1;
        this.appendSql('(');
        String separator = "";
        if (optimized) {
            i = 1;
        } else {
            lhsExpressions.get(0).accept(this);
            this.appendSql(operatorText);
            rhsExpressions.get(0).accept(this);
            separator = " or ";
            i = 1;
        }
        while (i < lastIndex) {
            this.appendSql(separator);
            lhsExpressions.get(i - 1).accept(this);
            this.appendSql('=');
            rhsExpressions.get(i - 1).accept(this);
            this.appendSql(" and (");
            lhsExpressions.get(i).accept(this);
            this.appendSql(operatorText);
            rhsExpressions.get(i).accept(this);
            separator = " or ";
            ++i;
        }
        this.appendSql(separator);
        lhsExpressions.get(lastIndex - 1).accept(this);
        this.appendSql('=');
        rhsExpressions.get(lastIndex - 1).accept(this);
        this.appendSql(" and ");
        lhsExpressions.get(lastIndex).accept(this);
        this.appendSql(finalOperatorText);
        rhsExpressions.get(lastIndex).accept(this);
        int n = i = optimized ? 1 : 0;
        while (i < lastIndex) {
            this.appendSql(')');
            ++i;
        }
    }

    protected void renderSelectSimpleComparison(List<SqlSelection> lhsExpressions, Expression expression, ComparisonOperator operator) {
        this.renderComparison(lhsExpressions.get(0).getExpression(), operator, expression);
    }

    protected void renderSelectTupleComparison(List<SqlSelection> lhsExpressions, SqlTuple tuple, ComparisonOperator operator) {
        this.renderTupleComparisonStandard(lhsExpressions, tuple, operator);
    }

    protected void renderTupleComparisonStandard(List<SqlSelection> lhsExpressions, SqlTuple tuple, ComparisonOperator operator) {
        this.appendSql('(');
        String separator = "";
        for (SqlSelection lhsExpression : lhsExpressions) {
            this.appendSql(separator);
            lhsExpression.getExpression().accept(this);
            separator = ",";
        }
        this.appendSql(')');
        this.appendSql(operator.sqlText());
        tuple.accept(this);
    }

    protected void renderComparison(Expression lhs, ComparisonOperator operator, Expression rhs) {
        this.renderComparisonStandard(lhs, operator, rhs);
    }

    protected void renderComparisonStandard(Expression lhs, ComparisonOperator operator, Expression rhs) {
        lhs.accept(this);
        this.appendSql(operator.sqlText());
        rhs.accept(this);
    }

    protected void renderComparisonDistinctOperator(Expression lhs, ComparisonOperator operator, Expression rhs) {
        String operatorText;
        boolean notWrapper;
        switch (operator) {
            case DISTINCT_FROM: {
                notWrapper = true;
                operatorText = "<=>";
                break;
            }
            case NOT_DISTINCT_FROM: {
                notWrapper = false;
                operatorText = "<=>";
                break;
            }
            default: {
                notWrapper = false;
                operatorText = operator.sqlText();
            }
        }
        if (notWrapper) {
            this.appendSql("not(");
        }
        lhs.accept(this);
        this.appendSql(operatorText);
        rhs.accept(this);
        if (notWrapper) {
            this.appendSql(')');
        }
    }

    protected void renderComparisonEmulateDecode(Expression lhs, ComparisonOperator operator, Expression rhs) {
        switch (operator) {
            case DISTINCT_FROM: {
                this.appendSql("decode(");
                lhs.accept(this);
                this.appendSql(',');
                rhs.accept(this);
                this.appendSql(",0,1)=1");
                break;
            }
            case NOT_DISTINCT_FROM: {
                this.appendSql("decode(");
                lhs.accept(this);
                this.appendSql(',');
                rhs.accept(this);
                this.appendSql(",0,1)=0");
                break;
            }
            default: {
                lhs.accept(this);
                this.appendSql(operator.sqlText());
                rhs.accept(this);
            }
        }
    }

    protected void renderComparisonEmulateCase(Expression lhs, ComparisonOperator operator, Expression rhs) {
        switch (operator) {
            case DISTINCT_FROM: {
                this.appendSql("case when ");
                lhs.accept(this);
                this.appendSql('=');
                rhs.accept(this);
                this.appendSql(" or ");
                lhs.accept(this);
                this.appendSql(" is null and ");
                rhs.accept(this);
                this.appendSql(" is null then 0 else 1 end=1");
                break;
            }
            case NOT_DISTINCT_FROM: {
                this.appendSql("case when ");
                lhs.accept(this);
                this.appendSql('=');
                rhs.accept(this);
                this.appendSql(" or ");
                lhs.accept(this);
                this.appendSql(" is null and ");
                rhs.accept(this);
                this.appendSql(" is null then 0 else 1 end=0");
                break;
            }
            default: {
                lhs.accept(this);
                this.appendSql(operator.sqlText());
                rhs.accept(this);
            }
        }
    }

    protected void renderComparisonEmulateIntersect(Expression lhs, ComparisonOperator operator, Expression rhs) {
        switch (operator) {
            case DISTINCT_FROM: {
                this.appendSql("not ");
            }
            case NOT_DISTINCT_FROM: {
                this.appendSql("exists (select ");
                this.clauseStack.push(Clause.SELECT);
                this.visitSqlSelectExpression(lhs);
                this.appendSql(this.getFromDualForSelectOnly());
                this.appendSql(" intersect select ");
                this.visitSqlSelectExpression(rhs);
                this.appendSql(this.getFromDualForSelectOnly());
                this.clauseStack.pop();
                this.appendSql(')');
                return;
            }
        }
        lhs.accept(this);
        this.appendSql(operator.sqlText());
        rhs.accept(this);
    }

    @Override
    public void visitSortSpecification(SortSpecification sortSpecification) {
        Expression sortExpression = sortSpecification.getSortExpression();
        NullPrecedence nullPrecedence = sortSpecification.getNullPrecedence();
        SortOrder sortOrder = sortSpecification.getSortOrder();
        SqlTuple sqlTuple = SqlTupleContainer.getSqlTuple(sortExpression);
        if (sqlTuple != null) {
            String separator = "";
            for (Expression expression : sqlTuple.getExpressions()) {
                this.appendSql(separator);
                this.visitSortSpecification(expression, sortOrder, nullPrecedence);
                separator = ",";
            }
        } else {
            this.visitSortSpecification(sortExpression, sortOrder, nullPrecedence);
        }
    }

    protected void visitSortSpecification(Expression sortExpression, SortOrder sortOrder, NullPrecedence nullPrecedence) {
        boolean renderNullPrecedence;
        if (nullPrecedence == null || nullPrecedence == NullPrecedence.NONE) {
            nullPrecedence = this.sessionFactory.getSessionFactoryOptions().getDefaultNullPrecedence();
        }
        boolean bl = renderNullPrecedence = nullPrecedence != null && !nullPrecedence.isDefaultOrdering(sortOrder, this.getDialect().getNullOrdering());
        if (renderNullPrecedence && !this.getDialect().supportsNullPrecedence()) {
            this.emulateSortSpecificationNullPrecedence(sortExpression, nullPrecedence);
        }
        if (this.inOverOrWithinGroupClause()) {
            this.resolveAliasedExpression(sortExpression).accept(this);
        } else {
            sortExpression.accept(this);
        }
        if (sortOrder == SortOrder.ASCENDING) {
            this.appendSql(" asc");
        } else if (sortOrder == SortOrder.DESCENDING) {
            this.appendSql(" desc");
        }
        if (renderNullPrecedence && this.getDialect().supportsNullPrecedence()) {
            this.appendSql(" nulls ");
            this.appendSql(nullPrecedence == NullPrecedence.LAST ? "last" : "first");
        }
    }

    protected void emulateSortSpecificationNullPrecedence(Expression sortExpression, NullPrecedence nullPrecedence) {
        this.appendSql("case when (");
        this.resolveAliasedExpression(sortExpression).accept(this);
        this.appendSql(") is null then ");
        if (nullPrecedence == NullPrecedence.FIRST) {
            this.appendSql("0 else 1");
        } else {
            this.appendSql("1 else 0");
        }
        this.appendSql(" end");
        this.appendSql(',');
    }

    @Override
    public void visitOffsetFetchClause(QueryPart queryPart) {
        if (!this.isRowNumberingCurrentQueryPart()) {
            this.renderOffsetFetchClause(queryPart, true);
        }
    }

    protected void renderOffsetFetchClause(QueryPart queryPart, boolean renderOffsetRowsKeyword) {
        if (queryPart.isRoot() && this.hasLimit()) {
            this.prepareLimitOffsetParameters();
            this.renderOffsetFetchClause(this.getOffsetParameter(), this.getLimitParameter(), FetchClauseType.ROWS_ONLY, renderOffsetRowsKeyword);
        } else {
            this.renderOffsetFetchClause(queryPart.getOffsetClauseExpression(), queryPart.getFetchClauseExpression(), queryPart.getFetchClauseType(), renderOffsetRowsKeyword);
        }
    }

    protected void renderOffsetFetchClause(Expression offsetExpression, Expression fetchExpression, FetchClauseType fetchClauseType, boolean renderOffsetRowsKeyword) {
        if (offsetExpression != null) {
            this.renderOffset(offsetExpression, renderOffsetRowsKeyword);
        }
        if (fetchExpression != null) {
            this.renderFetch(fetchExpression, null, fetchClauseType);
        }
    }

    protected void renderOffset(Expression offsetExpression, boolean renderOffsetRowsKeyword) {
        this.appendSql(" offset ");
        this.clauseStack.push(Clause.OFFSET);
        try {
            this.renderOffsetExpression(offsetExpression);
        }
        finally {
            this.clauseStack.pop();
        }
        if (renderOffsetRowsKeyword) {
            this.appendSql(" rows");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderFetch(Expression fetchExpression, Expression offsetExpressionToAdd, FetchClauseType fetchClauseType) {
        this.appendSql(" fetch first ");
        this.clauseStack.push(Clause.FETCH);
        try {
            if (offsetExpressionToAdd == null) {
                this.renderFetchExpression(fetchExpression);
            } else {
                this.renderFetchPlusOffsetExpression(fetchExpression, offsetExpressionToAdd, 0);
            }
        }
        finally {
            this.clauseStack.pop();
        }
        switch (fetchClauseType) {
            case ROWS_ONLY: {
                this.appendSql(" rows only");
                break;
            }
            case ROWS_WITH_TIES: {
                this.appendSql(" rows with ties");
                break;
            }
            case PERCENT_ONLY: {
                this.appendSql(" percent rows only");
                break;
            }
            case PERCENT_WITH_TIES: {
                this.appendSql(" percent rows with ties");
            }
        }
    }

    protected void renderOffsetExpression(Expression offsetExpression) {
        offsetExpression.accept(this);
    }

    protected void renderFetchExpression(Expression fetchExpression) {
        fetchExpression.accept(this);
    }

    protected void renderTopClause(QuerySpec querySpec, boolean addOffset, boolean needsParenthesis) {
        if (querySpec.isRoot() && this.hasLimit()) {
            this.prepareLimitOffsetParameters();
            this.renderTopClause(this.getOffsetParameter(), this.getLimitParameter(), FetchClauseType.ROWS_ONLY, addOffset, needsParenthesis);
        } else {
            this.renderTopClause(querySpec.getOffsetClauseExpression(), querySpec.getFetchClauseExpression(), querySpec.getFetchClauseType(), addOffset, needsParenthesis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderTopClause(Expression offsetExpression, Expression fetchExpression, FetchClauseType fetchClauseType, boolean addOffset, boolean needsParenthesis) {
        if (fetchExpression != null) {
            this.appendSql("top ");
            if (needsParenthesis) {
                this.appendSql('(');
            }
            Stack<Clause> clauseStack = this.getClauseStack();
            clauseStack.push(Clause.FETCH);
            try {
                if (addOffset && offsetExpression != null) {
                    this.renderFetchPlusOffsetExpression(fetchExpression, offsetExpression, 0);
                } else {
                    this.renderFetchExpression(fetchExpression);
                }
            }
            finally {
                clauseStack.pop();
            }
            if (needsParenthesis) {
                this.appendSql(')');
            }
            this.appendSql(' ');
            switch (fetchClauseType) {
                case ROWS_WITH_TIES: {
                    this.appendSql("with ties ");
                    break;
                }
                case PERCENT_ONLY: {
                    this.appendSql("percent ");
                    break;
                }
                case PERCENT_WITH_TIES: {
                    this.appendSql("percent with ties ");
                }
            }
        }
    }

    protected void renderTopStartAtClause(QuerySpec querySpec) {
        if (querySpec.isRoot() && this.hasLimit()) {
            this.prepareLimitOffsetParameters();
            this.renderTopStartAtClause(this.getOffsetParameter(), this.getLimitParameter(), FetchClauseType.ROWS_ONLY);
        } else {
            this.renderTopStartAtClause(querySpec.getOffsetClauseExpression(), querySpec.getFetchClauseExpression(), querySpec.getFetchClauseType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderTopStartAtClause(Expression offsetExpression, Expression fetchExpression, FetchClauseType fetchClauseType) {
        if (fetchExpression != null) {
            this.appendSql("top ");
            Stack<Clause> clauseStack = this.getClauseStack();
            clauseStack.push(Clause.FETCH);
            try {
                this.renderFetchExpression(fetchExpression);
            }
            finally {
                clauseStack.pop();
            }
            if (offsetExpression != null) {
                clauseStack.push(Clause.OFFSET);
                try {
                    this.appendSql(" start at ");
                    this.renderOffsetExpression(offsetExpression);
                }
                finally {
                    clauseStack.pop();
                }
            }
            this.appendSql(' ');
            switch (fetchClauseType) {
                case ROWS_WITH_TIES: {
                    this.appendSql("with ties ");
                    break;
                }
                case PERCENT_ONLY: {
                    this.appendSql("percent ");
                    break;
                }
                case PERCENT_WITH_TIES: {
                    this.appendSql("percent with ties ");
                }
            }
        }
    }

    protected void renderRowsToClause(QuerySpec querySpec) {
        if (querySpec.isRoot() && this.hasLimit()) {
            this.prepareLimitOffsetParameters();
            this.renderRowsToClause(this.getOffsetParameter(), this.getLimitParameter());
        } else {
            this.assertRowsOnlyFetchClauseType(querySpec);
            this.renderRowsToClause(querySpec.getOffsetClauseExpression(), querySpec.getFetchClauseExpression());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderRowsToClause(Expression offsetClauseExpression, Expression fetchClauseExpression) {
        if (fetchClauseExpression != null) {
            this.appendSql("rows ");
            Stack<Clause> clauseStack = this.getClauseStack();
            clauseStack.push(Clause.FETCH);
            try {
                this.renderFetchExpression(fetchClauseExpression);
            }
            finally {
                clauseStack.pop();
            }
            if (offsetClauseExpression != null) {
                clauseStack.push(Clause.OFFSET);
                try {
                    this.appendSql(" to ");
                    this.renderFetchPlusOffsetExpression(fetchClauseExpression, offsetClauseExpression, 1);
                }
                finally {
                    clauseStack.pop();
                }
            }
            this.appendSql(' ');
        }
    }

    protected void renderFetchPlusOffsetExpression(Expression fetchClauseExpression, Expression offsetClauseExpression, int offset) {
        this.renderFetchExpression(fetchClauseExpression);
        this.appendSql('+');
        this.renderOffsetExpression(offsetClauseExpression);
        if (offset != 0) {
            this.appendSql('+');
            this.appendSql(offset);
        }
    }

    protected void renderFetchPlusOffsetExpressionAsLiteral(Expression fetchClauseExpression, Expression offsetClauseExpression, int offset) {
        Number offsetCount = (Number)this.interpretExpression(offsetClauseExpression, this.jdbcParameterBindings);
        Number fetchCount = (Number)this.interpretExpression(fetchClauseExpression, this.jdbcParameterBindings);
        this.appendSql(fetchCount.intValue() + offsetCount.intValue() + offset);
    }

    protected void renderFetchPlusOffsetExpressionAsSingleParameter(Expression fetchClauseExpression, Expression offsetClauseExpression, int offset) {
        if (fetchClauseExpression instanceof Literal) {
            Number fetchCount = (Number)((Literal)fetchClauseExpression).getLiteralValue();
            if (offsetClauseExpression instanceof Literal) {
                Number offsetCount = (Number)((Literal)offsetClauseExpression).getLiteralValue();
                this.appendSql(fetchCount.intValue() + offsetCount.intValue() + offset);
            } else {
                this.appendSql('?');
                JdbcParameter offsetParameter = (JdbcParameter)offsetClauseExpression;
                int offsetValue = offset + fetchCount.intValue();
                this.jdbcParameters.addParameter(offsetParameter);
                this.parameterBinders.add((statement, startPosition, jdbcParameterBindings, executionContext) -> {
                    JdbcParameterBinding binding = jdbcParameterBindings.getBinding(offsetParameter);
                    if (binding == null) {
                        throw new ExecutionException("JDBC parameter value not bound - " + offsetParameter);
                    }
                    Number bindValue = (Number)binding.getBindValue();
                    offsetParameter.getExpressionType().getJdbcMappings().get(0).getJdbcValueBinder().bind(statement, Integer.valueOf(bindValue.intValue() + offsetValue), startPosition, (WrapperOptions)executionContext.getSession());
                });
            }
        } else {
            this.appendSql('?');
            JdbcParameter offsetParameter = (JdbcParameter)offsetClauseExpression;
            JdbcParameter fetchParameter = (JdbcParameter)fetchClauseExpression;
            OffsetReceivingParameterBinder fetchBinder = new OffsetReceivingParameterBinder(offsetParameter, fetchParameter, offset);
            if (!(offsetParameter instanceof OffsetJdbcParameter)) {
                this.jdbcParameters.addParameter(offsetParameter);
                this.parameterBinders.add((statement, startPosition, jdbcParameterBindings, executionContext) -> {
                    JdbcParameterBinding binding = jdbcParameterBindings.getBinding(offsetParameter);
                    if (binding == null) {
                        throw new ExecutionException("JDBC parameter value not bound - " + offsetParameter);
                    }
                    fetchBinder.dynamicOffset = (Number)binding.getBindValue();
                });
            }
            this.jdbcParameters.addParameter(fetchParameter);
            this.parameterBinders.add(fetchBinder);
        }
    }

    protected void renderFirstSkipClause(QuerySpec querySpec) {
        if (querySpec.isRoot() && this.hasLimit()) {
            this.prepareLimitOffsetParameters();
            this.renderFirstSkipClause(this.getOffsetParameter(), this.getLimitParameter());
        } else {
            this.assertRowsOnlyFetchClauseType(querySpec);
            this.renderFirstSkipClause(querySpec.getOffsetClauseExpression(), querySpec.getFetchClauseExpression());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderFirstSkipClause(Expression offsetExpression, Expression fetchExpression) {
        Stack<Clause> clauseStack = this.getClauseStack();
        if (fetchExpression != null) {
            this.appendSql("first ");
            clauseStack.push(Clause.FETCH);
            try {
                this.renderFetchExpression(fetchExpression);
            }
            finally {
                clauseStack.pop();
            }
            this.appendSql(' ');
        }
        if (offsetExpression != null) {
            this.appendSql("skip ");
            clauseStack.push(Clause.OFFSET);
            try {
                this.renderOffsetExpression(offsetExpression);
            }
            finally {
                clauseStack.pop();
            }
            this.appendSql(' ');
        }
    }

    protected void renderSkipFirstClause(QuerySpec querySpec) {
        if (querySpec.isRoot() && this.hasLimit()) {
            this.prepareLimitOffsetParameters();
            this.renderSkipFirstClause(this.getOffsetParameter(), this.getLimitParameter());
        } else {
            this.assertRowsOnlyFetchClauseType(querySpec);
            this.renderSkipFirstClause(querySpec.getOffsetClauseExpression(), querySpec.getFetchClauseExpression());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderSkipFirstClause(Expression offsetExpression, Expression fetchExpression) {
        Stack<Clause> clauseStack = this.getClauseStack();
        if (offsetExpression != null) {
            this.appendSql("skip ");
            clauseStack.push(Clause.OFFSET);
            try {
                this.renderOffsetExpression(offsetExpression);
            }
            finally {
                clauseStack.pop();
            }
            this.appendSql(' ');
        }
        if (fetchExpression != null) {
            this.appendSql("first ");
            clauseStack.push(Clause.FETCH);
            try {
                this.renderFetchExpression(fetchExpression);
            }
            finally {
                clauseStack.pop();
            }
            this.appendSql(' ');
        }
    }

    protected void renderFirstClause(QuerySpec querySpec) {
        if (querySpec.isRoot() && this.hasLimit()) {
            this.prepareLimitOffsetParameters();
            this.renderFirstClause(this.getOffsetParameter(), this.getLimitParameter());
        } else {
            this.assertRowsOnlyFetchClauseType(querySpec);
            this.renderFirstClause(querySpec.getOffsetClauseExpression(), querySpec.getFetchClauseExpression());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderFirstClause(Expression offsetExpression, Expression fetchExpression) {
        Stack<Clause> clauseStack = this.getClauseStack();
        if (fetchExpression != null) {
            this.appendSql("first ");
            clauseStack.push(Clause.FETCH);
            try {
                this.renderFetchPlusOffsetExpression(fetchExpression, offsetExpression, 0);
            }
            finally {
                clauseStack.pop();
            }
            this.appendSql(' ');
        }
    }

    protected void renderCombinedLimitClause(QueryPart queryPart) {
        if (queryPart.isRoot() && this.hasLimit()) {
            this.prepareLimitOffsetParameters();
            this.renderCombinedLimitClause(this.getOffsetParameter(), this.getLimitParameter());
        } else {
            this.assertRowsOnlyFetchClauseType(queryPart);
            this.renderCombinedLimitClause(queryPart.getOffsetClauseExpression(), queryPart.getFetchClauseExpression());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderCombinedLimitClause(Expression offsetExpression, Expression fetchExpression) {
        if (offsetExpression != null) {
            Stack<Clause> clauseStack = this.getClauseStack();
            this.appendSql(" limit ");
            clauseStack.push(Clause.OFFSET);
            try {
                this.renderOffsetExpression(offsetExpression);
            }
            finally {
                clauseStack.pop();
            }
            this.appendSql(',');
            if (fetchExpression != null) {
                clauseStack.push(Clause.FETCH);
                try {
                    this.renderFetchExpression(fetchExpression);
                }
                finally {
                    clauseStack.pop();
                }
            } else {
                this.appendSql(Integer.MAX_VALUE);
            }
        } else if (fetchExpression != null) {
            Stack<Clause> clauseStack = this.getClauseStack();
            this.appendSql(" limit ");
            clauseStack.push(Clause.FETCH);
            try {
                this.renderFetchExpression(fetchExpression);
            }
            finally {
                clauseStack.pop();
            }
        }
    }

    protected void renderLimitOffsetClause(QueryPart queryPart) {
        if (queryPart.isRoot() && this.hasLimit()) {
            this.prepareLimitOffsetParameters();
            this.renderLimitOffsetClause(this.getOffsetParameter(), this.getLimitParameter());
        } else {
            this.assertRowsOnlyFetchClauseType(queryPart);
            this.renderLimitOffsetClause(queryPart.getOffsetClauseExpression(), queryPart.getFetchClauseExpression());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderLimitOffsetClause(Expression offsetExpression, Expression fetchExpression) {
        if (fetchExpression != null) {
            this.appendSql(" limit ");
            this.clauseStack.push(Clause.FETCH);
            try {
                this.renderFetchExpression(fetchExpression);
            }
            finally {
                this.clauseStack.pop();
            }
        } else if (offsetExpression != null) {
            this.appendSql(" limit ");
            this.appendSql(Integer.MAX_VALUE);
        }
        if (offsetExpression != null) {
            Stack<Clause> clauseStack = this.getClauseStack();
            this.appendSql(" offset ");
            clauseStack.push(Clause.OFFSET);
            try {
                this.renderOffsetExpression(offsetExpression);
            }
            finally {
                clauseStack.pop();
            }
        }
    }

    protected void assertRowsOnlyFetchClauseType(QueryPart queryPart) {
        FetchClauseType fetchClauseType;
        if (!(queryPart.isRoot() && this.hasLimit() || (fetchClauseType = queryPart.getFetchClauseType()) == null || fetchClauseType == FetchClauseType.ROWS_ONLY)) {
            throw new IllegalArgumentException("Can't emulate fetch clause type: " + fetchClauseType);
        }
    }

    protected QueryPart getQueryPartForRowNumbering() {
        return this.queryPartForRowNumbering;
    }

    protected boolean isRowNumberingCurrentQueryPart() {
        return this.queryPartForRowNumbering != null;
    }

    protected void emulateFetchOffsetWithWindowFunctions(QueryPart queryPart, boolean emulateFetchClause) {
        if (queryPart.isRoot() && this.hasLimit()) {
            this.prepareLimitOffsetParameters();
            this.emulateFetchOffsetWithWindowFunctions(queryPart, this.getOffsetParameter(), this.getLimitParameter(), FetchClauseType.ROWS_ONLY, emulateFetchClause);
        } else {
            this.emulateFetchOffsetWithWindowFunctions(queryPart, queryPart.getOffsetClauseExpression(), queryPart.getFetchClauseExpression(), queryPart.getFetchClauseType(), emulateFetchClause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void emulateFetchOffsetWithWindowFunctions(QueryPart queryPart, Expression offsetExpression, Expression fetchExpression, FetchClauseType fetchClauseType, boolean emulateFetchClause) {
        QueryPart queryPartForRowNumbering = this.queryPartForRowNumbering;
        int queryPartForRowNumberingClauseDepth = this.queryPartForRowNumberingClauseDepth;
        boolean needsSelectAliases = this.needsSelectAliases;
        try {
            boolean needsParenthesis;
            this.queryPartForRowNumbering = queryPart;
            this.queryPartForRowNumberingClauseDepth = this.clauseStack.depth();
            this.needsSelectAliases = true;
            String alias = "r_" + this.queryPartForRowNumberingAliasCounter + "_";
            ++this.queryPartForRowNumberingAliasCounter;
            if (queryPart instanceof QueryGroup) {
                needsParenthesis = queryPart.hasOffsetOrFetchClause();
            } else {
                boolean bl = needsParenthesis = !queryPart.isRoot();
            }
            if (needsParenthesis && !queryPart.isRoot()) {
                this.appendSql('(');
            }
            this.appendSql("select ");
            if (this.getClauseStack().isEmpty()) {
                this.appendSql('*');
            } else {
                int size = queryPart.getFirstQuerySpec().getSelectClause().getSqlSelections().size();
                String separator = "";
                for (int i = 0; i < size; ++i) {
                    this.appendSql(separator);
                    this.appendSql(alias);
                    this.appendSql(".c");
                    this.appendSql(i);
                    separator = ",";
                }
            }
            this.appendSql(" from ");
            if (!needsParenthesis || queryPart.isRoot()) {
                this.appendSql('(');
            }
            queryPart.accept(this);
            if (!needsParenthesis || queryPart.isRoot()) {
                this.appendSql(')');
            }
            this.appendSql(' ');
            this.appendSql(alias);
            this.appendSql(" where ");
            Stack<Clause> clauseStack = this.getClauseStack();
            clauseStack.push(Clause.WHERE);
            try {
                Predicate additionalWherePredicate;
                if (emulateFetchClause && fetchExpression != null) {
                    switch (fetchClauseType) {
                        case PERCENT_ONLY: {
                            this.appendSql(alias);
                            this.appendSql(".rn<=");
                            if (offsetExpression != null) {
                                offsetExpression.accept(this);
                                this.appendSql('+');
                            }
                            this.appendSql("ceil(");
                            this.appendSql(alias);
                            this.appendSql(".cnt*");
                            fetchExpression.accept(this);
                            this.appendSql("/100)");
                            break;
                        }
                        case ROWS_ONLY: {
                            this.appendSql(alias);
                            this.appendSql(".rn<=");
                            if (offsetExpression != null) {
                                offsetExpression.accept(this);
                                this.appendSql('+');
                            }
                            fetchExpression.accept(this);
                            break;
                        }
                        case PERCENT_WITH_TIES: {
                            this.appendSql(alias);
                            this.appendSql(".rnk<=");
                            if (offsetExpression != null) {
                                offsetExpression.accept(this);
                                this.appendSql('+');
                            }
                            this.appendSql("ceil(");
                            this.appendSql(alias);
                            this.appendSql(".cnt*");
                            fetchExpression.accept(this);
                            this.appendSql("/100)");
                            break;
                        }
                        case ROWS_WITH_TIES: {
                            this.appendSql(alias);
                            this.appendSql(".rnk<=");
                            if (offsetExpression != null) {
                                offsetExpression.accept(this);
                                this.appendSql('+');
                            }
                            fetchExpression.accept(this);
                        }
                    }
                }
                if (offsetExpression == null) {
                    additionalWherePredicate = this.additionalWherePredicate;
                    if (additionalWherePredicate != null && !additionalWherePredicate.isEmpty()) {
                        this.additionalWherePredicate = null;
                        this.appendSql(" and ");
                        additionalWherePredicate.accept(this);
                    }
                    if (queryPart.isRoot()) {
                        switch (fetchClauseType) {
                            case ROWS_ONLY: 
                            case PERCENT_ONLY: {
                                this.appendSql(" order by ");
                                this.appendSql(alias);
                                this.appendSql(".rn");
                                break;
                            }
                            case ROWS_WITH_TIES: 
                            case PERCENT_WITH_TIES: {
                                this.appendSql(" order by ");
                                this.appendSql(alias);
                                this.appendSql(".rnk");
                            }
                        }
                    }
                } else {
                    if (emulateFetchClause && fetchExpression != null) {
                        this.appendSql(" and ");
                    }
                    this.appendSql(alias);
                    this.appendSql(".rn>");
                    offsetExpression.accept(this);
                    additionalWherePredicate = this.additionalWherePredicate;
                    if (additionalWherePredicate != null && !additionalWherePredicate.isEmpty()) {
                        this.additionalWherePredicate = null;
                        this.appendSql(" and ");
                        additionalWherePredicate.accept(this);
                    }
                    if (queryPart.isRoot()) {
                        this.appendSql(" order by ");
                        this.appendSql(alias);
                        this.appendSql(".rn");
                    }
                }
                if (queryPart instanceof QuerySpec) {
                    clauseStack.pop();
                    clauseStack.push(Clause.FOR_UPDATE);
                    this.visitForUpdateClause((QuerySpec)queryPart);
                }
            }
            finally {
                clauseStack.pop();
            }
            if (needsParenthesis && !queryPart.isRoot()) {
                this.appendSql(')');
            }
        }
        finally {
            this.queryPartForRowNumbering = queryPartForRowNumbering;
            this.queryPartForRowNumberingClauseDepth = queryPartForRowNumberingClauseDepth;
            this.needsSelectAliases = needsSelectAliases;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void withRowNumbering(QueryPart queryPart, boolean needsSelectAliases, Runnable r) {
        QueryPart queryPartForRowNumbering = this.queryPartForRowNumbering;
        int queryPartForRowNumberingClauseDepth = this.queryPartForRowNumberingClauseDepth;
        boolean originalNeedsSelectAliases = this.needsSelectAliases;
        try {
            this.queryPartForRowNumbering = queryPart;
            this.queryPartForRowNumberingClauseDepth = this.clauseStack.depth();
            this.needsSelectAliases = needsSelectAliases;
            r.run();
        }
        finally {
            this.queryPartForRowNumbering = queryPartForRowNumbering;
            this.queryPartForRowNumberingClauseDepth = queryPartForRowNumberingClauseDepth;
            this.needsSelectAliases = originalNeedsSelectAliases;
        }
    }

    @Override
    public void visitSelectClause(SelectClause selectClause) {
        this.clauseStack.push(Clause.SELECT);
        try {
            this.appendSql("select ");
            if (selectClause.isDistinct()) {
                this.appendSql("distinct ");
            }
            this.visitSqlSelections(selectClause);
        }
        finally {
            this.clauseStack.pop();
        }
    }

    protected void visitSqlSelections(SelectClause selectClause) {
        block9: {
            SqlAstNodeRenderingMode original;
            BitSet selectItemsToInline;
            int size;
            List<SqlSelection> sqlSelections;
            block8: {
                sqlSelections = selectClause.getSqlSelections();
                size = sqlSelections.size();
                SelectItemReferenceStrategy referenceStrategy = this.getDialect().getGroupBySelectItemReferenceStrategy();
                selectItemsToInline = referenceStrategy == SelectItemReferenceStrategy.EXPRESSION ? this.getSelectItemsToInline() : null;
                original = this.parameterRenderingMode;
                if (!this.needsSelectAliases && (referenceStrategy != SelectItemReferenceStrategy.ALIAS || !this.hasSelectAliasInGroupByClause())) break block8;
                String separator = "";
                if (this.columnAliases == null) {
                    for (int i = 0; i < size; ++i) {
                        SqlSelection sqlSelection = sqlSelections.get(i);
                        this.appendSql(separator);
                        this.parameterRenderingMode = selectItemsToInline != null && selectItemsToInline.get(i) ? SqlAstNodeRenderingMode.INLINE_ALL_PARAMETERS : SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER;
                        this.visitSqlSelection(sqlSelection);
                        this.parameterRenderingMode = original;
                        this.appendSql(" c");
                        this.appendSql(i);
                        separator = ",";
                    }
                } else {
                    for (int i = 0; i < size; ++i) {
                        SqlSelection sqlSelection = sqlSelections.get(i);
                        this.appendSql(separator);
                        this.parameterRenderingMode = selectItemsToInline != null && selectItemsToInline.get(i) ? SqlAstNodeRenderingMode.INLINE_ALL_PARAMETERS : SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER;
                        this.visitSqlSelection(sqlSelection);
                        this.parameterRenderingMode = original;
                        this.appendSql(' ');
                        this.appendSql(this.columnAliases.get(i));
                        separator = ",";
                    }
                }
                if (this.queryPartForRowNumbering == null) break block9;
                this.renderRowNumberingSelectItems(selectClause, this.queryPartForRowNumbering);
                break block9;
            }
            if (this.columnAliases == null) {
                String separator = "";
                for (int i = 0; i < size; ++i) {
                    SqlSelection sqlSelection = sqlSelections.get(i);
                    this.appendSql(separator);
                    this.parameterRenderingMode = selectItemsToInline != null && selectItemsToInline.get(i) ? SqlAstNodeRenderingMode.INLINE_ALL_PARAMETERS : SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER;
                    this.visitSqlSelection(sqlSelection);
                    this.parameterRenderingMode = original;
                    separator = ",";
                }
            } else {
                String separator = "";
                for (int i = 0; i < size; ++i) {
                    SqlSelection sqlSelection = sqlSelections.get(i);
                    this.appendSql(separator);
                    this.parameterRenderingMode = selectItemsToInline != null && selectItemsToInline.get(i) ? SqlAstNodeRenderingMode.INLINE_ALL_PARAMETERS : SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER;
                    this.visitSqlSelection(sqlSelection);
                    this.appendSql(' ');
                    this.appendSql(this.columnAliases.get(i));
                    this.parameterRenderingMode = original;
                    separator = ",";
                }
            }
        }
    }

    private BitSet getSelectItemsToInline() {
        QuerySpec querySpec = (QuerySpec)this.getQueryPartStack().getCurrent();
        List<SqlSelection> sqlSelections = querySpec.getSelectClause().getSqlSelections();
        BitSet bitSet = new BitSet(sqlSelections.size());
        for (Expression groupByClauseExpression : querySpec.getGroupByClauseExpressions()) {
            SqlSelectionExpression selectItemReference = this.getSelectItemReference(groupByClauseExpression);
            if (selectItemReference == null) continue;
            bitSet.set(sqlSelections.indexOf(selectItemReference.getSelection()));
        }
        return bitSet;
    }

    private boolean hasSelectAliasInGroupByClause() {
        QuerySpec querySpec = (QuerySpec)this.getQueryPartStack().getCurrent();
        for (Expression groupByClauseExpression : querySpec.getGroupByClauseExpressions()) {
            if (this.getSelectItemReference(groupByClauseExpression) == null) continue;
            return true;
        }
        return false;
    }

    protected final SqlSelectionExpression getSelectItemReference(Expression expression) {
        SqlTuple sqlTuple = SqlTupleContainer.getSqlTuple(expression);
        if (sqlTuple != null) {
            for (Expression expression2 : sqlTuple.getExpressions()) {
                Expression sqlExpression;
                if (expression2 instanceof SqlSelectionExpression) {
                    return (SqlSelectionExpression)expression2;
                }
                if (!(expression2 instanceof SqmPathInterpretation) || !((sqlExpression = ((SqmPathInterpretation)expression2).getSqlExpression()) instanceof SqlSelectionExpression)) continue;
                return (SqlSelectionExpression)sqlExpression;
            }
        } else {
            Expression sqlExpression;
            if (expression instanceof SqlSelectionExpression) {
                return (SqlSelectionExpression)expression;
            }
            if (expression instanceof SqmPathInterpretation && (sqlExpression = ((SqmPathInterpretation)expression).getSqlExpression()) instanceof SqlSelectionExpression) {
                return (SqlSelectionExpression)sqlExpression;
            }
        }
        return null;
    }

    protected void renderRowNumberingSelectItems(SelectClause selectClause, QueryPart queryPart) {
        FetchClauseType fetchClauseType = this.getFetchClauseTypeForRowNumbering(queryPart);
        if (fetchClauseType != null) {
            this.appendSql(',');
            switch (fetchClauseType) {
                case PERCENT_ONLY: {
                    this.appendSql("count(*) over () cnt,");
                }
                case ROWS_ONLY: {
                    this.renderRowNumber(selectClause, queryPart);
                    this.appendSql(" rn");
                    break;
                }
                case PERCENT_WITH_TIES: {
                    this.appendSql("count(*) over () cnt,");
                }
                case ROWS_WITH_TIES: {
                    if (queryPart.getOffsetClauseExpression() != null) {
                        this.renderRowNumber(selectClause, queryPart);
                        this.appendSql(" rn,");
                    }
                    if (selectClause.isDistinct()) {
                        this.appendSql("dense_rank()");
                    } else {
                        this.appendSql("rank()");
                    }
                    this.visitOverClause(Collections.emptyList(), this.getSortSpecificationsRowNumbering(selectClause, queryPart));
                    this.appendSql(" rnk");
                }
            }
        }
    }

    protected FetchClauseType getFetchClauseTypeForRowNumbering(QueryPart queryPartForRowNumbering) {
        if (queryPartForRowNumbering.isRoot() && this.hasLimit()) {
            return FetchClauseType.ROWS_ONLY;
        }
        return queryPartForRowNumbering.getFetchClauseType();
    }

    @Override
    public void visitOver(Over<?> over) {
        OrderedSetAggregateFunctionExpression expression;
        Expression overExpression = over.getExpression();
        overExpression.accept(this);
        boolean orderedSetAggregate = overExpression instanceof OrderedSetAggregateFunctionExpression ? (expression = (OrderedSetAggregateFunctionExpression)overExpression).getWithinGroup() != null && !expression.getWithinGroup().isEmpty() : false;
        this.visitOverClause(over.getPartitions(), over.getOrderList(), over.getMode(), over.getStartKind(), over.getStartExpression(), over.getEndKind(), over.getEndExpression(), over.getExclusion(), orderedSetAggregate);
    }

    protected final void visitOverClause(List<Expression> partitionExpressions, List<SortSpecification> sortSpecifications) {
        this.visitOverClause(partitionExpressions, sortSpecifications, FrameMode.ROWS, FrameKind.UNBOUNDED_PRECEDING, null, FrameKind.CURRENT_ROW, null, FrameExclusion.NO_OTHERS, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void visitOverClause(List<Expression> partitionExpressions, List<SortSpecification> sortSpecifications, FrameMode mode, FrameKind startKind, Expression startExpression, FrameKind endKind, Expression endExpression, FrameExclusion exclusion, boolean orderedSetAggregate) {
        try {
            this.clauseStack.push(Clause.OVER);
            this.appendSql(" over(");
            this.visitPartitionByClause(partitionExpressions);
            if (!orderedSetAggregate) {
                this.renderOrderBy(!partitionExpressions.isEmpty(), sortSpecifications);
            }
            if (mode != FrameMode.ROWS || startKind != FrameKind.UNBOUNDED_PRECEDING || endKind != FrameKind.CURRENT_ROW || exclusion != FrameExclusion.NO_OTHERS) {
                if (!partitionExpressions.isEmpty() || !sortSpecifications.isEmpty()) {
                    this.append(' ');
                }
                switch (mode) {
                    case GROUPS: {
                        this.append("groups ");
                        break;
                    }
                    case RANGE: {
                        this.append("range ");
                        break;
                    }
                    case ROWS: {
                        this.append("rows ");
                    }
                }
                if (endKind == FrameKind.CURRENT_ROW) {
                    this.renderFrameKind(startKind, startExpression);
                } else {
                    this.append("between ");
                    this.renderFrameKind(startKind, startExpression);
                    this.append(" and ");
                    this.renderFrameKind(endKind, endExpression);
                }
                switch (exclusion) {
                    case TIES: {
                        this.append(" exclude ties");
                        break;
                    }
                    case CURRENT_ROW: {
                        this.append(" exclude current row");
                        break;
                    }
                    case GROUP: {
                        this.append(" exclude group");
                    }
                }
            }
            this.appendSql(')');
        }
        finally {
            this.clauseStack.pop();
        }
    }

    private void renderFrameKind(FrameKind kind, Expression expression) {
        switch (kind) {
            case CURRENT_ROW: {
                this.append("current row");
                break;
            }
            case UNBOUNDED_PRECEDING: {
                this.append("unbounded preceding");
                break;
            }
            case UNBOUNDED_FOLLOWING: {
                this.append("unbounded following");
                break;
            }
            case OFFSET_PRECEDING: {
                expression.accept(this);
                this.append(" preceding");
                break;
            }
            case OFFSET_FOLLOWING: {
                expression.accept(this);
                this.append(" following");
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported frame kind: " + kind);
            }
        }
    }

    protected void renderRowNumber(SelectClause selectClause, QueryPart queryPart) {
        if (selectClause.isDistinct()) {
            this.appendSql("dense_rank()");
        } else {
            this.appendSql("row_number()");
        }
        this.visitOverClause(Collections.emptyList(), this.getSortSpecificationsRowNumbering(selectClause, queryPart));
    }

    protected final boolean isParameter(Expression expression) {
        return expression instanceof JdbcParameter || expression instanceof SqmParameterInterpretation;
    }

    protected final boolean isLiteral(Expression expression) {
        return expression instanceof Literal;
    }

    protected List<SortSpecification> getSortSpecificationsRowNumbering(SelectClause selectClause, QueryPart queryPart) {
        List<Object> sortSpecifications = queryPart.hasSortSpecifications() ? queryPart.getSortSpecifications() : Collections.emptyList();
        if (selectClause.isDistinct()) {
            ArrayList<SqlSelection> sqlSelections = new ArrayList<SqlSelection>(selectClause.getSqlSelections());
            int specificationsSize = sortSpecifications.size();
            block0: for (int i = sqlSelections.size() - 1; i != 0; --i) {
                Expression selectionExpression = ((SqlSelection)sqlSelections.get(i)).getExpression();
                for (int j = 0; j < specificationsSize; ++j) {
                    Expression expression = this.resolveAliasedExpression(sqlSelections, ((SortSpecification)sortSpecifications.get(j)).getSortExpression());
                    if (!expression.equals(selectionExpression)) continue;
                    sqlSelections.remove(i);
                    continue block0;
                }
            }
            int sqlSelectionsSize = sqlSelections.size();
            if (sqlSelectionsSize == 0) {
                return sortSpecifications;
            }
            ArrayList<SortSpecification> sortSpecificationsRowNumbering = new ArrayList<SortSpecification>(sqlSelectionsSize + specificationsSize);
            sortSpecificationsRowNumbering.addAll(sortSpecifications);
            for (int i = 0; i < sqlSelectionsSize; ++i) {
                sortSpecificationsRowNumbering.add(new SortSpecification(new SqlSelectionExpression((SqlSelection)sqlSelections.get(i)), SortOrder.ASCENDING, NullPrecedence.NONE));
            }
            return sortSpecificationsRowNumbering;
        }
        if (queryPart instanceof QueryGroup) {
            int specificationsSize = sortSpecifications.size();
            ArrayList<SortSpecification> sortSpecificationsRowNumbering = new ArrayList<SortSpecification>(specificationsSize);
            List<SqlSelection> sqlSelections = selectClause.getSqlSelections();
            for (int i = 0; i < specificationsSize; ++i) {
                int position;
                SortSpecification sortSpecification = (SortSpecification)sortSpecifications.get(i);
                if (sortSpecification.getSortExpression() instanceof SqlSelectionExpression) {
                    position = ((SqlSelectionExpression)sortSpecification.getSortExpression()).getSelection().getValuesArrayPosition();
                } else {
                    assert (sortSpecification.getSortExpression() instanceof QueryLiteral);
                    QueryLiteral queryLiteral = (QueryLiteral)sortSpecification.getSortExpression();
                    assert (queryLiteral.getLiteralValue() instanceof Integer);
                    position = (Integer)queryLiteral.getLiteralValue();
                }
                sortSpecificationsRowNumbering.add(new SortSpecification(new SqlSelectionExpression(sqlSelections.get(position)), sortSpecification.getSortOrder(), sortSpecification.getNullPrecedence()));
            }
            return sortSpecificationsRowNumbering;
        }
        return sortSpecifications;
    }

    @Override
    public void visitSqlSelection(SqlSelection sqlSelection) {
        this.visitSqlSelectExpression(sqlSelection.getExpression());
    }

    protected void visitSqlSelectExpression(Expression expression) {
        SqlTuple sqlTuple = SqlTupleContainer.getSqlTuple(expression);
        if (sqlTuple != null) {
            boolean isFirst = true;
            for (Expression expression2 : sqlTuple.getExpressions()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    this.appendSql(',');
                }
                this.renderSelectExpression(expression2);
            }
        } else {
            this.renderSelectExpression(expression);
        }
    }

    protected void renderSelectExpression(Expression expression) {
        this.renderExpressionAsClauseItem(expression);
    }

    protected void renderExpressionAsClauseItem(Expression expression) {
        if (expression instanceof Predicate) {
            this.appendSql("case when ");
            expression.accept(this);
            this.appendSql(" then ");
            Dialect dialect = this.getDialect();
            dialect.appendBooleanValueString(this, true);
            this.appendSql(" else ");
            dialect.appendBooleanValueString(this, false);
            this.appendSql(" end");
        } else {
            expression.accept(this);
        }
    }

    protected void renderSelectExpressionWithCastedOrInlinedPlainParameters(Expression expression) {
        if (expression instanceof Literal) {
            Literal literal = (Literal)expression;
            if (literal.getLiteralValue() == null) {
                this.renderCasted(literal);
            } else {
                this.renderLiteral(literal, true);
            }
        } else if (this.isParameter(expression)) {
            if (this.parameterRenderingMode == SqlAstNodeRenderingMode.INLINE_PARAMETERS || this.parameterRenderingMode == SqlAstNodeRenderingMode.INLINE_ALL_PARAMETERS) {
                this.renderExpressionAsLiteral(expression, this.getJdbcParameterBindings());
            } else {
                this.renderCasted(expression);
            }
        } else if (expression instanceof CaseSimpleExpression) {
            this.visitCaseSimpleExpression((CaseSimpleExpression)expression, true);
        } else if (expression instanceof CaseSearchedExpression) {
            this.visitCaseSearchedExpression((CaseSearchedExpression)expression, true);
        } else {
            this.renderExpressionAsClauseItem(expression);
        }
    }

    protected void renderCasted(Expression expression) {
        ArrayList<Expression> arguments = new ArrayList<Expression>(2);
        arguments.add(expression);
        if (expression instanceof SqlTypedMappingJdbcParameter) {
            SqlTypedMappingJdbcParameter parameter = (SqlTypedMappingJdbcParameter)expression;
            SqlTypedMapping sqlTypedMapping = parameter.getSqlTypedMapping();
            arguments.add(new CastTarget(parameter.getJdbcMapping(), sqlTypedMapping.getColumnDefinition(), sqlTypedMapping.getLength(), sqlTypedMapping.getPrecision(), sqlTypedMapping.getScale()));
        } else {
            arguments.add(new CastTarget(expression.getExpressionType().getJdbcMappings().get(0)));
        }
        this.castFunction().render(this, arguments, this);
    }

    protected void renderLiteral(Literal literal, boolean castParameter) {
        assert (literal.getExpressionType().getJdbcTypeCount() == 1);
        JdbcMapping jdbcMapping = literal.getJdbcMapping();
        JdbcLiteralFormatter<Object> literalFormatter = jdbcMapping.getJdbcType().getJdbcLiteralFormatter(jdbcMapping.getJavaTypeDescriptor());
        if (literalFormatter == null) {
            this.parameterBinders.add(literal);
            LiteralAsParameter jdbcParameter = new LiteralAsParameter(literal);
            if (castParameter) {
                this.renderCasted(jdbcParameter);
            } else {
                this.appendSql('?');
            }
        } else {
            literalFormatter.appendJdbcLiteral(this, literal.getLiteralValue(), this.dialect, this.getWrapperOptions());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitFromClause(FromClause fromClause) {
        if (fromClause == null || fromClause.getRoots().isEmpty()) {
            this.appendSql(this.getFromDualForSelectOnly());
        } else {
            this.appendSql(" from ");
            try {
                this.clauseStack.push(Clause.FROM);
                String separator = "";
                for (TableGroup root : fromClause.getRoots()) {
                    if (root instanceof VirtualTableGroup) continue;
                    this.appendSql(separator);
                    this.renderRootTableGroup(root, null);
                    separator = ",";
                }
            }
            finally {
                this.clauseStack.pop();
            }
        }
    }

    protected void renderRootTableGroup(TableGroup tableGroup, List<TableGroupJoin> tableGroupJoinCollector) {
        LockMode effectiveLockMode = this.getEffectiveLockMode(tableGroup.getSourceAlias());
        boolean usesLockHint = this.renderPrimaryTableReference(tableGroup, effectiveLockMode);
        if (tableGroup.isLateral() && !this.getDialect().supportsLateral()) {
            this.addAdditionalWherePredicate(this.determineLateralEmulationPredicate(tableGroup));
        }
        this.renderTableReferenceJoins(tableGroup);
        this.processNestedTableGroupJoins(tableGroup, tableGroupJoinCollector);
        if (tableGroupJoinCollector != null) {
            tableGroupJoinCollector.addAll(tableGroup.getTableGroupJoins());
        } else {
            this.processTableGroupJoins(tableGroup);
        }
        ModelPartContainer modelPart = tableGroup.getModelPart();
        if (modelPart instanceof AbstractEntityPersister) {
            String[] querySpaces = (String[])((AbstractEntityPersister)modelPart).getQuerySpaces();
            for (int i = 0; i < querySpaces.length; ++i) {
                this.registerAffectedTable(querySpaces[i]);
            }
        }
        if (!usesLockHint && tableGroup.getSourceAlias() != null && LockMode.READ.lessThan(effectiveLockMode)) {
            if (this.forUpdate == null) {
                this.forUpdate = new ForUpdateClause(effectiveLockMode);
            } else {
                this.forUpdate.setLockMode(effectiveLockMode);
            }
            this.forUpdate.applyAliases(this.getDialect().getLockRowIdentifier(effectiveLockMode), tableGroup);
        }
    }

    protected void renderTableGroup(TableGroup tableGroup, Predicate predicate, List<TableGroupJoin> tableGroupJoinCollector) {
        Object lateralEmulationPredicate;
        ArrayList<TableGroupJoin> tableGroupJoins;
        boolean realTableGroup;
        boolean bl = realTableGroup = tableGroup.isRealTableGroup() && (CollectionHelper.isNotEmpty(tableGroup.getTableReferenceJoins()) || this.hasNestedTableGroupsToRender(tableGroup.getNestedTableGroupJoins()));
        if (realTableGroup) {
            this.appendSql('(');
        }
        LockMode effectiveLockMode = this.getEffectiveLockMode(tableGroup.getSourceAlias());
        boolean usesLockHint = this.renderPrimaryTableReference(tableGroup, effectiveLockMode);
        if (realTableGroup) {
            this.renderTableReferenceJoins(tableGroup);
            if (tableGroupJoinCollector == null) {
                tableGroupJoins = new ArrayList<TableGroupJoin>();
                this.processNestedTableGroupJoins(tableGroup, tableGroupJoins);
            } else {
                tableGroupJoins = null;
                this.processNestedTableGroupJoins(tableGroup, tableGroupJoinCollector);
            }
            this.appendSql(')');
        } else {
            tableGroupJoins = null;
        }
        if (predicate != null) {
            this.appendSql(" on ");
            predicate.accept(this);
        }
        if (tableGroup.isLateral() && !this.getDialect().supportsLateral() && (lateralEmulationPredicate = this.determineLateralEmulationPredicate(tableGroup)) != null) {
            if (predicate == null) {
                this.appendSql(" on ");
            } else {
                this.appendSql(" and ");
            }
            lateralEmulationPredicate.accept(this);
        }
        if (!realTableGroup) {
            this.renderTableReferenceJoins(tableGroup);
            this.processNestedTableGroupJoins(tableGroup, tableGroupJoinCollector);
        }
        if (tableGroupJoinCollector != null) {
            tableGroupJoinCollector.addAll(tableGroup.getTableGroupJoins());
        } else {
            if (tableGroupJoins != null) {
                for (TableGroupJoin tableGroupJoin : tableGroupJoins) {
                    this.processTableGroupJoin(tableGroupJoin, null);
                }
            }
            this.processTableGroupJoins(tableGroup);
        }
        ModelPartContainer modelPart = tableGroup.getModelPart();
        if (modelPart instanceof AbstractEntityPersister) {
            String[] querySpaces = (String[])((AbstractEntityPersister)modelPart).getQuerySpaces();
            for (int i = 0; i < querySpaces.length; ++i) {
                this.registerAffectedTable(querySpaces[i]);
            }
        }
        if (!usesLockHint && tableGroup.getSourceAlias() != null && LockMode.READ.lessThan(effectiveLockMode)) {
            if (this.forUpdate == null) {
                this.forUpdate = new ForUpdateClause(effectiveLockMode);
            } else {
                this.forUpdate.setLockMode(effectiveLockMode);
            }
            this.forUpdate.applyAliases(this.getDialect().getLockRowIdentifier(effectiveLockMode), tableGroup);
        }
    }

    protected boolean hasNestedTableGroupsToRender(List<TableGroupJoin> nestedTableGroupJoins) {
        for (TableGroupJoin nestedTableGroupJoin : nestedTableGroupJoins) {
            TableGroup joinedGroup = nestedTableGroupJoin.getJoinedGroup();
            TableGroup realTableGroup = joinedGroup instanceof LazyTableGroup ? ((LazyTableGroup)joinedGroup).getUnderlyingTableGroup() : joinedGroup;
            if (!(realTableGroup instanceof VirtualTableGroup ? this.hasNestedTableGroupsToRender(realTableGroup.getNestedTableGroupJoins()) : realTableGroup != null)) continue;
            return true;
        }
        return false;
    }

    protected boolean renderPrimaryTableReference(TableGroup tableGroup, LockMode lockMode) {
        TableReference tableReference = tableGroup.getPrimaryTableReference();
        if (tableReference instanceof NamedTableReference) {
            return this.renderNamedTableReference((NamedTableReference)tableReference, lockMode);
        }
        DerivedTableReference derivedTableReference = (DerivedTableReference)tableReference;
        if (derivedTableReference.isLateral()) {
            if (this.getDialect().supportsLateral()) {
                this.appendSql("lateral");
            } else if (tableReference instanceof QueryPartTableReference) {
                QueryPartTableReference queryPartTableReference = (QueryPartTableReference)tableReference;
                QueryPart emulationQueryPart = this.stripToSelectClause(queryPartTableReference.getQueryPart());
                QueryPartTableReference emulationTableReference = new QueryPartTableReference(emulationQueryPart, tableReference.getIdentificationVariable(), queryPartTableReference.getColumnNames(), false, this.sessionFactory);
                emulationTableReference.accept(this);
                return false;
            }
        }
        tableReference.accept(this);
        return false;
    }

    protected boolean renderNamedTableReference(NamedTableReference tableReference, LockMode lockMode) {
        this.appendSql(tableReference.getTableExpression());
        this.registerAffectedTable(tableReference);
        Clause currentClause = this.clauseStack.getCurrent();
        if (AbstractSqlAstTranslator.rendersTableReferenceAlias(currentClause)) {
            this.renderTableReferenceIdentificationVariable(tableReference);
        }
        return false;
    }

    @Override
    public void visitValuesTableReference(ValuesTableReference tableReference) {
        this.append('(');
        this.visitValuesList(tableReference.getValuesList());
        this.append(')');
        this.renderDerivedTableReference(tableReference);
    }

    @Override
    public void visitQueryPartTableReference(QueryPartTableReference tableReference) {
        tableReference.getQueryPart().accept(this);
        this.renderDerivedTableReference(tableReference);
    }

    @Override
    public void visitFunctionTableReference(FunctionTableReference tableReference) {
        tableReference.getFunctionExpression().accept(this);
        this.renderDerivedTableReference(tableReference);
    }

    protected void emulateQueryPartTableReferenceColumnAliasing(QueryPartTableReference tableReference) {
        List<String> columnAliases = this.columnAliases;
        this.columnAliases = tableReference.getColumnNames();
        tableReference.getQueryPart().accept(this);
        this.columnAliases = columnAliases;
        this.renderTableReferenceIdentificationVariable(tableReference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void emulateValuesTableReferenceColumnAliasing(ValuesTableReference tableReference) {
        List<Values> valuesList = tableReference.getValuesList();
        this.append('(');
        Stack<Clause> clauseStack = this.getClauseStack();
        clauseStack.push(Clause.VALUES);
        try {
            clauseStack.push(Clause.SELECT);
            try {
                this.appendSql("select ");
                this.renderCommaSeparatedSelectExpression(valuesList.get(0).getExpressions(), tableReference.getColumnNames());
                this.appendSql(this.getFromDualForSelectOnly());
            }
            finally {
                clauseStack.pop();
            }
            for (int i = 1; i < valuesList.size(); ++i) {
                this.appendSql(" union all ");
                this.renderExpressionsAsSubquery(valuesList.get(i).getExpressions());
            }
        }
        finally {
            clauseStack.pop();
        }
        this.append(')');
        this.renderTableReferenceIdentificationVariable(tableReference);
    }

    protected void renderDerivedTableReference(DerivedTableReference tableReference) {
        String identificationVariable = tableReference.getIdentificationVariable();
        if (identificationVariable != null) {
            this.append(' ');
            this.append(tableReference.getIdentificationVariable());
            List<String> columnNames = tableReference.getColumnNames();
            this.append('(');
            this.append(columnNames.get(0));
            for (int i = 1; i < columnNames.size(); ++i) {
                this.append(',');
                this.append(columnNames.get(i));
            }
            this.append(')');
        }
    }

    protected final void renderTableReferenceIdentificationVariable(TableReference tableReference) {
        String identificationVariable = tableReference.getIdentificationVariable();
        if (identificationVariable != null) {
            this.append(' ');
            this.append(tableReference.getIdentificationVariable());
        }
    }

    public static boolean rendersTableReferenceAlias(Clause clause) {
        switch (clause) {
            case DELETE: 
            case UPDATE: {
                return false;
            }
        }
        return true;
    }

    protected void registerAffectedTable(NamedTableReference tableReference) {
        this.registerAffectedTable(tableReference.getTableExpression());
    }

    protected void registerAffectedTable(String tableExpression) {
        this.affectedTableNames.add(tableExpression);
    }

    protected void renderTableReferenceJoins(TableGroup tableGroup) {
        List<TableReferenceJoin> joins = tableGroup.getTableReferenceJoins();
        if (joins == null || joins.isEmpty()) {
            return;
        }
        for (TableReferenceJoin tableJoin : joins) {
            this.appendSql(' ');
            this.appendSql(tableJoin.getJoinType().getText());
            this.appendSql("join ");
            this.renderNamedTableReference(tableJoin.getJoinedTableReference(), LockMode.NONE);
            if (tableJoin.getPredicate() == null || tableJoin.getPredicate().isEmpty()) continue;
            this.appendSql(" on ");
            tableJoin.getPredicate().accept(this);
        }
    }

    protected void processTableGroupJoins(TableGroup source) {
        source.visitTableGroupJoins(tableGroupJoin -> this.processTableGroupJoin((TableGroupJoin)tableGroupJoin, null));
    }

    protected void processNestedTableGroupJoins(TableGroup source, List<TableGroupJoin> tableGroupJoinCollector) {
        source.visitNestedTableGroupJoins(tableGroupJoin -> this.processTableGroupJoin((TableGroupJoin)tableGroupJoin, tableGroupJoinCollector));
    }

    protected void processTableGroupJoin(TableGroupJoin tableGroupJoin, List<TableGroupJoin> tableGroupJoinCollector) {
        TableGroup joinedGroup = tableGroupJoin.getJoinedGroup();
        TableGroup realTableGroup = joinedGroup instanceof LazyTableGroup ? ((LazyTableGroup)joinedGroup).getUnderlyingTableGroup() : joinedGroup;
        if (realTableGroup instanceof VirtualTableGroup) {
            this.processNestedTableGroupJoins(realTableGroup, tableGroupJoinCollector);
            if (tableGroupJoinCollector != null) {
                tableGroupJoinCollector.addAll(realTableGroup.getTableGroupJoins());
            } else {
                this.processTableGroupJoins(realTableGroup);
            }
        } else if (realTableGroup != null) {
            this.renderTableGroupJoin(tableGroupJoin, tableGroupJoinCollector);
        } else if (joinedGroup instanceof LazyTableGroup) {
            this.processNestedTableGroupJoins(joinedGroup, tableGroupJoinCollector);
            if (tableGroupJoinCollector != null) {
                tableGroupJoinCollector.addAll(joinedGroup.getTableGroupJoins());
            } else {
                this.processTableGroupJoins(joinedGroup);
            }
        }
    }

    protected void renderTableGroupJoin(TableGroupJoin tableGroupJoin, List<TableGroupJoin> tableGroupJoinCollector) {
        this.appendSql(' ');
        this.appendSql(tableGroupJoin.getJoinType().getText());
        this.appendSql("join ");
        Object predicate = tableGroupJoin.getPredicate() == null ? (tableGroupJoin.getJoinType() == SqlAstJoinType.CROSS ? null : new BooleanExpressionPredicate(new QueryLiteral<Boolean>(true, this.getBooleanType()))) : tableGroupJoin.getPredicate();
        if (predicate != null && !predicate.isEmpty()) {
            this.renderTableGroup(tableGroupJoin.getJoinedGroup(), (Predicate)predicate, tableGroupJoinCollector);
        } else {
            this.renderTableGroup(tableGroupJoin.getJoinedGroup(), null, tableGroupJoinCollector);
        }
    }

    protected Predicate determineLateralEmulationPredicate(TableGroup tableGroup) {
        if (tableGroup.getPrimaryTableReference() instanceof QueryPartTableReference) {
            QueryPartTableReference tableReference = (QueryPartTableReference)tableGroup.getPrimaryTableReference();
            List<String> columnNames = tableReference.getColumnNames();
            ArrayList<ColumnReference> columnReferences = new ArrayList<ColumnReference>(columnNames.size());
            ArrayList<ColumnReference> subColumnReferences = new ArrayList<ColumnReference>(columnNames.size());
            QueryPart queryPart = tableReference.getQueryPart();
            for (String string : columnNames) {
                columnReferences.add(new ColumnReference(tableReference, string, false, null, null, null, this.sessionFactory));
            }
            if ((columnReferences.size() == 1 || this.supportsRowValueConstructorSyntax()) && this.supportsDistinctFromPredicate() && queryPart.getFetchClauseType() == FetchClauseType.ROWS_ONLY && queryPart.getFetchClauseExpression() instanceof QueryLiteral && Integer.valueOf(1).equals(((QueryLiteral)queryPart.getFetchClauseExpression()).getLiteralValue())) {
                return new ComparisonPredicate(new SqlTuple(columnReferences, tableGroup.getModelPart()), ComparisonOperator.NOT_DISTINCT_FROM, queryPart);
            }
            if (this.supportsIntersect()) {
                QuerySpec lhsReferencesQuery = new QuerySpec(false);
                for (ColumnReference columnReference : columnReferences) {
                    lhsReferencesQuery.getSelectClause().addSqlSelection(new SqlSelectionImpl(1, 0, columnReference));
                }
                ArrayList<QueryPart> arrayList = new ArrayList<QueryPart>(2);
                arrayList.add(lhsReferencesQuery);
                arrayList.add(queryPart);
                return new ExistsPredicate(new QueryGroup(false, SetOperator.INTERSECT, arrayList), false, this.getBooleanType());
            }
            QueryPartTableGroup subTableGroup = new QueryPartTableGroup(tableGroup.getNavigablePath(), (TableGroupProducer)tableGroup.getModelPart(), queryPart, "synth_", columnNames, false, true, this.sessionFactory);
            for (String columnName : columnNames) {
                subColumnReferences.add(new ColumnReference(subTableGroup.getPrimaryTableReference(), columnName, false, null, null, null, this.sessionFactory));
            }
            QuerySpec querySpec = new QuerySpec(false, 1);
            querySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(1, 0, new QueryLiteral<Integer>(1, this.getIntegerType())));
            querySpec.getFromClause().addRoot(subTableGroup);
            querySpec.applyPredicate(new ComparisonPredicate(new SqlTuple(columnReferences, tableGroup.getModelPart()), ComparisonOperator.NOT_DISTINCT_FROM, new SqlTuple(subColumnReferences, tableGroup.getModelPart())));
            return new ExistsPredicate(querySpec, false, this.getBooleanType());
        }
        return null;
    }

    private QueryPart stripToSelectClause(QueryPart queryPart) {
        if (queryPart instanceof QueryGroup) {
            return this.stripToSelectClause((QueryGroup)queryPart);
        }
        return this.stripToSelectClause((QuerySpec)queryPart);
    }

    private QueryGroup stripToSelectClause(QueryGroup queryGroup) {
        ArrayList<QueryPart> parts = new ArrayList<QueryPart>(queryGroup.getQueryParts().size());
        for (QueryPart queryPart : queryGroup.getQueryParts()) {
            parts.add(this.stripToSelectClause(queryPart));
        }
        return new QueryGroup(queryGroup.isRoot(), queryGroup.getSetOperator(), parts);
    }

    private QuerySpec stripToSelectClause(QuerySpec querySpec) {
        if (querySpec.getGroupByClauseExpressions() != null && !querySpec.getGroupByClauseExpressions().isEmpty()) {
            throw new UnsupportedOperationException("Can't emulate lateral join for query spec with group by clause");
        }
        if (querySpec.getHavingClauseRestrictions() != null && !querySpec.getHavingClauseRestrictions().isEmpty()) {
            throw new UnsupportedOperationException("Can't emulate lateral join for query spec with having clause");
        }
        QuerySpec newQuerySpec = new QuerySpec(querySpec.isRoot(), querySpec.getFromClause().getRoots().size());
        for (TableGroup root : querySpec.getFromClause().getRoots()) {
            newQuerySpec.getFromClause().addRoot(root);
        }
        for (SqlSelection selection : querySpec.getSelectClause().getSqlSelections()) {
            if (AggregateFunctionChecker.hasAggregateFunctions(selection.getExpression())) {
                throw new UnsupportedOperationException("Can't emulate lateral join for query spec with aggregate function");
            }
            newQuerySpec.getSelectClause().addSqlSelection(selection);
        }
        return newQuerySpec;
    }

    @Override
    public void visitTableGroup(TableGroup tableGroup) {
        throw new UnsupportedOperationException("This should never be invoked as org.hibernate.query.sqm.sql.BaseSqmToSqlAstConverter.visitTableGroup should handle this!");
    }

    @Override
    public void visitTableGroupJoin(TableGroupJoin tableGroupJoin) {
        throw new UnsupportedOperationException("This should never be invoked as org.hibernate.query.sqm.sql.BaseSqmToSqlAstConverter.visitTableGroup should handle this!");
    }

    @Override
    public void visitNamedTableReference(NamedTableReference tableReference) {
    }

    @Override
    public void visitTableReferenceJoin(TableReferenceJoin tableReferenceJoin) {
    }

    @Override
    public void visitColumnReference(ColumnReference columnReference) {
        String dmlTargetTableAlias = this.getDmlTargetTableAlias();
        if (dmlTargetTableAlias != null && dmlTargetTableAlias.equals(columnReference.getQualifier())) {
            boolean qualifyColumn;
            String tableExpression = this.getCurrentDmlStatement().getTargetTable().getTableExpression();
            boolean bl = qualifyColumn = !this.queryPartStack.isEmpty();
            if (columnReference.isColumnExpressionFormula()) {
                Object replacement = qualifyColumn ? "$1" + tableExpression + ".$3" : "$1$3";
                this.appendSql(columnReference.getColumnExpression().replaceAll("(\\b)(" + dmlTargetTableAlias + "\\.)(\\b)", (String)replacement));
            } else {
                if (qualifyColumn) {
                    this.appendSql(tableExpression);
                    this.appendSql('.');
                }
                this.appendSql(columnReference.getColumnExpression());
            }
        } else {
            this.appendSql(columnReference.getExpressionText());
        }
    }

    @Override
    public void visitExtractUnit(ExtractUnit extractUnit) {
        this.appendSql(this.getDialect().translateExtractField(extractUnit.getUnit()));
    }

    @Override
    public void visitDurationUnit(DurationUnit unit) {
        this.appendSql(this.getDialect().translateDurationField(unit.getUnit()));
    }

    @Override
    public void visitFormat(Format format) {
        this.appendSql('\'');
        this.getDialect().appendDatetimeFormat(this, format.getFormat());
        this.appendSql('\'');
    }

    @Override
    public void visitStar(Star star) {
        this.appendSql('*');
    }

    @Override
    public void visitTrimSpecification(TrimSpecification trimSpecification) {
        this.appendSql(' ');
        this.appendSql(trimSpecification.getSpecification().toSqlText());
        this.appendSql(' ');
    }

    @Override
    public void visitCastTarget(CastTarget castTarget) {
        if (castTarget.getSqlType() != null) {
            this.appendSql(castTarget.getSqlType());
        } else {
            SqlExpressible expressionType = (SqlExpressible)castTarget.getExpressionType();
            this.appendSql(this.sessionFactory.getTypeConfiguration().getDdlTypeRegistry().getDescriptor(expressionType.getJdbcMapping().getJdbcType().getDefaultSqlTypeCode()).getCastTypeName(expressionType, castTarget.getLength(), castTarget.getPrecision(), castTarget.getScale()));
        }
    }

    @Override
    public void visitDistinct(Distinct distinct) {
        this.appendSql("distinct ");
        distinct.getExpression().accept(this);
    }

    @Override
    public void visitOverflow(Overflow overflow) {
        overflow.getSeparatorExpression().accept(this);
        this.appendSql(" on overflow ");
        if (overflow.getFillerExpression() == null) {
            this.appendSql("error");
        } else {
            this.appendSql(" truncate ");
            overflow.getFillerExpression().accept(this);
            if (overflow.isWithCount()) {
                this.appendSql(" with count");
            } else {
                this.appendSql(" without count");
            }
        }
    }

    @Override
    public void visitParameter(JdbcParameter jdbcParameter) {
        switch (this.parameterRenderingMode) {
            case NO_PLAIN_PARAMETER: {
                this.renderCasted(jdbcParameter);
                break;
            }
            case INLINE_PARAMETERS: 
            case INLINE_ALL_PARAMETERS: {
                this.renderExpressionAsLiteral(jdbcParameter, this.jdbcParameterBindings);
                break;
            }
            default: {
                this.appendSql('?');
                this.parameterBinders.add(jdbcParameter.getParameterBinder());
                this.jdbcParameters.addParameter(jdbcParameter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(SqlAstNode sqlAstNode, SqlAstNodeRenderingMode renderingMode) {
        SqlAstNodeRenderingMode original = this.parameterRenderingMode;
        if (original != SqlAstNodeRenderingMode.INLINE_ALL_PARAMETERS) {
            this.parameterRenderingMode = renderingMode;
        }
        try {
            sqlAstNode.accept(this);
        }
        finally {
            this.parameterRenderingMode = original;
        }
    }

    @Override
    public void visitTuple(SqlTuple tuple) {
        this.appendSql('(');
        this.renderCommaSeparated(tuple.getExpressions());
        this.appendSql(')');
    }

    protected final void renderCommaSeparated(Iterable<? extends SqlAstNode> expressions) {
        String separator = "";
        for (SqlAstNode sqlAstNode : expressions) {
            this.appendSql(separator);
            sqlAstNode.accept(this);
            separator = ",";
        }
    }

    protected final void renderCommaSeparatedSelectExpression(Iterable<? extends SqlAstNode> expressions) {
        String separator = "";
        for (SqlAstNode sqlAstNode : expressions) {
            SqlTuple sqlTuple = SqlTupleContainer.getSqlTuple(sqlAstNode);
            if (sqlTuple != null) {
                for (Expression expression : sqlTuple.getExpressions()) {
                    this.appendSql(separator);
                    this.renderSelectExpression(expression);
                    separator = ",";
                }
            } else if (sqlAstNode instanceof Expression) {
                this.appendSql(separator);
                this.renderSelectExpression((Expression)sqlAstNode);
            } else {
                this.appendSql(separator);
                sqlAstNode.accept(this);
            }
            separator = ",";
        }
    }

    protected final void renderCommaSeparatedSelectExpression(Iterable<? extends SqlAstNode> expressions, Iterable<String> aliases) {
        String separator = "";
        Iterator<String> aliasIterator = aliases.iterator();
        for (SqlAstNode sqlAstNode : expressions) {
            SqlTuple sqlTuple = SqlTupleContainer.getSqlTuple(sqlAstNode);
            if (sqlTuple != null) {
                for (Expression expression : sqlTuple.getExpressions()) {
                    this.appendSql(separator);
                    this.renderSelectExpression(expression);
                    separator = ",";
                }
            } else if (sqlAstNode instanceof Expression) {
                this.appendSql(separator);
                this.renderSelectExpression((Expression)sqlAstNode);
            } else {
                this.appendSql(separator);
                sqlAstNode.accept(this);
            }
            separator = ",";
            this.append(' ');
            this.append(aliasIterator.next());
        }
    }

    @Override
    public void visitCollation(Collation collation) {
        this.appendSql(collation.getCollation());
    }

    @Override
    public void visitSqlSelectionExpression(SqlSelectionExpression expression) {
        boolean useSelectionPosition = this.getDialect().supportsOrdinalSelectItemReference();
        if (useSelectionPosition) {
            this.appendSql(expression.getSelection().getJdbcResultSetIndex());
        } else {
            expression.getSelection().getExpression().accept(this);
        }
    }

    @Override
    public void visitEntityTypeLiteral(EntityTypeLiteral expression) {
        EntityPersister entityTypeDescriptor = expression.getEntityTypeDescriptor();
        this.appendSql(((Queryable)entityTypeDescriptor).getDiscriminatorSQLValue());
    }

    @Override
    public void visitBinaryArithmeticExpression(BinaryArithmeticExpression arithmeticExpression) {
        this.appendSql('(');
        arithmeticExpression.getLeftHandOperand().accept(this);
        this.appendSql(arithmeticExpression.getOperator().getOperatorSqlTextString());
        arithmeticExpression.getRightHandOperand().accept(this);
        this.appendSql(')');
    }

    @Override
    public void visitDuration(Duration duration) {
        duration.getMagnitude().accept(this);
        this.appendSql(duration.getUnit().conversionFactor(TemporalUnit.SECOND, this.getDialect()));
    }

    @Override
    public void visitConversion(Conversion conversion) {
        Duration duration = conversion.getDuration();
        duration.getMagnitude().accept(this);
        this.appendSql(duration.getUnit().conversionFactor(conversion.getUnit(), this.getDialect()));
    }

    @Override
    public final void visitCaseSearchedExpression(CaseSearchedExpression caseSearchedExpression) {
        this.visitCaseSearchedExpression(caseSearchedExpression, false);
    }

    protected void visitCaseSearchedExpression(CaseSearchedExpression caseSearchedExpression, boolean inSelect) {
        if (inSelect) {
            this.visitAnsiCaseSearchedExpression(caseSearchedExpression, this::renderSelectExpression);
        } else {
            this.visitAnsiCaseSearchedExpression(caseSearchedExpression, e -> e.accept(this));
        }
    }

    protected void visitAnsiCaseSearchedExpression(CaseSearchedExpression caseSearchedExpression, Consumer<Expression> resultRenderer) {
        this.appendSql("case");
        SqlAstNodeRenderingMode original = this.parameterRenderingMode;
        for (CaseSearchedExpression.WhenFragment whenFragment : caseSearchedExpression.getWhenFragments()) {
            if (original != SqlAstNodeRenderingMode.INLINE_ALL_PARAMETERS) {
                this.parameterRenderingMode = SqlAstNodeRenderingMode.DEFAULT;
            }
            this.appendSql(" when ");
            whenFragment.getPredicate().accept(this);
            this.parameterRenderingMode = original;
            this.appendSql(" then ");
            resultRenderer.accept(whenFragment.getResult());
        }
        Expression otherwise = caseSearchedExpression.getOtherwise();
        if (otherwise != null) {
            this.appendSql(" else ");
            resultRenderer.accept(otherwise);
        }
        this.appendSql(" end");
    }

    protected void visitDecodeCaseSearchedExpression(CaseSearchedExpression caseSearchedExpression) {
        this.appendSql("decode( ");
        SqlAstNodeRenderingMode original = this.parameterRenderingMode;
        List<CaseSearchedExpression.WhenFragment> whenFragments = caseSearchedExpression.getWhenFragments();
        int caseNumber = whenFragments.size();
        CaseSearchedExpression.WhenFragment firstWhenFragment = null;
        for (int i = 0; i < caseNumber; ++i) {
            CaseSearchedExpression.WhenFragment whenFragment = whenFragments.get(i);
            Predicate predicate = whenFragment.getPredicate();
            if (original != SqlAstNodeRenderingMode.INLINE_ALL_PARAMETERS) {
                this.parameterRenderingMode = SqlAstNodeRenderingMode.DEFAULT;
            }
            if (i != 0) {
                this.appendSql(',');
                this.getLeftHandExpression(predicate).accept(this);
                this.parameterRenderingMode = original;
                this.appendSql(',');
                whenFragment.getResult().accept(this);
                continue;
            }
            this.getLeftHandExpression(predicate).accept(this);
            firstWhenFragment = whenFragment;
        }
        this.parameterRenderingMode = original;
        this.appendSql(',');
        firstWhenFragment.getResult().accept(this);
        Expression otherwise = caseSearchedExpression.getOtherwise();
        if (otherwise != null) {
            this.appendSql(',');
            otherwise.accept(this);
        }
        this.appendSql(')');
    }

    @Override
    public final void visitCaseSimpleExpression(CaseSimpleExpression caseSimpleExpression) {
        this.visitAnsiCaseSimpleExpression(caseSimpleExpression, e -> e.accept(this));
    }

    protected void visitCaseSimpleExpression(CaseSimpleExpression caseSimpleExpression, boolean inSelect) {
        if (inSelect) {
            this.visitAnsiCaseSimpleExpression(caseSimpleExpression, this::renderSelectExpression);
        } else {
            this.visitAnsiCaseSimpleExpression(caseSimpleExpression, e -> e.accept(this));
        }
    }

    protected void visitAnsiCaseSimpleExpression(CaseSimpleExpression caseSimpleExpression, Consumer<Expression> resultRenderer) {
        this.appendSql("case ");
        SqlAstNodeRenderingMode original = this.parameterRenderingMode;
        if (original != SqlAstNodeRenderingMode.INLINE_ALL_PARAMETERS) {
            this.parameterRenderingMode = SqlAstNodeRenderingMode.DEFAULT;
        }
        caseSimpleExpression.getFixture().accept(this);
        for (CaseSimpleExpression.WhenFragment whenFragment : caseSimpleExpression.getWhenFragments()) {
            if (original != SqlAstNodeRenderingMode.INLINE_ALL_PARAMETERS) {
                this.parameterRenderingMode = SqlAstNodeRenderingMode.DEFAULT;
            }
            this.appendSql(" when ");
            whenFragment.getCheckValue().accept(this);
            this.parameterRenderingMode = original;
            this.appendSql(" then ");
            resultRenderer.accept(whenFragment.getResult());
        }
        this.parameterRenderingMode = original;
        Expression otherwise = caseSimpleExpression.getOtherwise();
        if (otherwise != null) {
            this.appendSql(" else ");
            resultRenderer.accept(otherwise);
        }
        this.appendSql(" end");
    }

    protected boolean areAllResultsParameters(CaseSearchedExpression caseSearchedExpression) {
        List<CaseSearchedExpression.WhenFragment> whenFragments = caseSearchedExpression.getWhenFragments();
        Expression firstResult = whenFragments.get(0).getResult();
        if (this.isParameter(firstResult)) {
            for (int i = 1; i < whenFragments.size(); ++i) {
                if (this.isParameter(whenFragments.get(i).getResult())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean areAllResultsParameters(CaseSimpleExpression caseSimpleExpression) {
        List<CaseSimpleExpression.WhenFragment> whenFragments = caseSimpleExpression.getWhenFragments();
        Expression firstResult = whenFragments.get(0).getResult();
        if (this.isParameter(firstResult)) {
            for (int i = 1; i < whenFragments.size(); ++i) {
                if (this.isParameter(whenFragments.get(i).getResult())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void visitAny(Any any) {
        this.appendSql("any");
        any.getSubquery().accept(this);
    }

    @Override
    public void visitEvery(Every every) {
        this.appendSql("all");
        every.getSubquery().accept(this);
    }

    @Override
    public void visitSummarization(Summarization every) {
    }

    @Override
    public void visitJdbcLiteral(JdbcLiteral<?> jdbcLiteral) {
        this.visitLiteral(jdbcLiteral);
    }

    @Override
    public void visitQueryLiteral(QueryLiteral<?> queryLiteral) {
        this.visitLiteral(queryLiteral);
    }

    @Override
    public void visitConvertedQueryLiteral(ConvertedQueryLiteral<?, ?> convertedQueryLiteral) {
        this.visitLiteral(convertedQueryLiteral);
    }

    private void visitLiteral(Literal literal) {
        if (literal.getLiteralValue() == null) {
            this.appendSql("null");
        } else {
            this.renderLiteral(literal, false);
        }
    }

    protected void renderAsLiteral(JdbcParameter jdbcParameter, Object literalValue) {
        if (literalValue == null) {
            this.appendSql("null");
        } else {
            assert (jdbcParameter.getExpressionType().getJdbcTypeCount() == 1);
            JdbcMapping jdbcMapping = jdbcParameter.getExpressionType().getJdbcMappings().get(0);
            JdbcLiteralFormatter<Object> literalFormatter = jdbcMapping.getJdbcType().getJdbcLiteralFormatter(jdbcMapping.getJavaTypeDescriptor());
            if (literalFormatter == null) {
                throw new IllegalArgumentException("Can't render parameter as literal, no literal formatter found");
            }
            literalFormatter.appendJdbcLiteral(this, literalValue, this.dialect, this.getWrapperOptions());
        }
    }

    @Override
    public void visitUnaryOperationExpression(UnaryOperation unaryOperationExpression) {
        if (unaryOperationExpression.getOperator() == UnaryArithmeticOperator.UNARY_PLUS) {
            this.appendSql(UnaryArithmeticOperator.UNARY_PLUS.getOperatorChar());
        } else {
            this.appendSql(UnaryArithmeticOperator.UNARY_MINUS.getOperatorChar());
        }
        unaryOperationExpression.getOperand().accept(this);
    }

    @Override
    public void visitModifiedSubQueryExpression(ModifiedSubQueryExpression expression) {
        ModifiedSubQueryExpression.Modifier modifier = expression.getModifier();
        this.appendSql(modifier.getSqlName());
        this.appendSql(" ");
        expression.getSubQuery().accept(this);
    }

    @Override
    public void visitSelfRenderingPredicate(SelfRenderingPredicate selfRenderingPredicate) {
        selfRenderingPredicate.getSelfRenderingExpression().renderToSql(this, this, this.getSessionFactory());
    }

    @Override
    public void visitSelfRenderingExpression(SelfRenderingExpression expression) {
        expression.renderToSql(this, this, this.getSessionFactory());
    }

    @Override
    public void visitBooleanExpressionPredicate(BooleanExpressionPredicate booleanExpressionPredicate) {
        booleanExpressionPredicate.getExpression().accept(this);
        this.appendSql('=');
        if (booleanExpressionPredicate.isNegated()) {
            this.getDialect().appendBooleanValueString(this, false);
        } else {
            this.getDialect().appendBooleanValueString(this, true);
        }
    }

    @Override
    public void visitBetweenPredicate(BetweenPredicate betweenPredicate) {
        betweenPredicate.getExpression().accept(this);
        if (betweenPredicate.isNegated()) {
            this.appendSql(" not");
        }
        this.appendSql(" between ");
        betweenPredicate.getLowerBound().accept(this);
        this.appendSql(" and ");
        betweenPredicate.getUpperBound().accept(this);
    }

    @Override
    public void visitFilterPredicate(FilterPredicate filterPredicate) {
        this.visitJunction(filterPredicate.getFragments());
        List<FilterJdbcParameter> parameters = filterPredicate.getParameters();
        if (parameters != null) {
            for (FilterJdbcParameter filterJdbcParameter : parameters) {
                this.parameterBinders.add(filterJdbcParameter.getBinder());
                this.jdbcParameters.addParameter(filterJdbcParameter.getParameter());
                this.filterJdbcParameters.add(filterJdbcParameter);
            }
        }
    }

    @Override
    public void visitFilterFragmentPredicate(FilterPredicate.FilterFragmentPredicate fragmentPredicate) {
        this.appendSql(fragmentPredicate.getSqlFragment());
    }

    @Override
    public void visitSqlFragmentPredicate(SqlFragmentPredicate predicate) {
        assert (StringHelper.isNotEmpty(predicate.getSqlFragment()));
        this.appendSql(predicate.getSqlFragment());
    }

    @Override
    public void visitGroupedPredicate(GroupedPredicate groupedPredicate) {
        if (groupedPredicate.isEmpty()) {
            return;
        }
        this.appendSql('(');
        groupedPredicate.getSubPredicate().accept(this);
        this.appendSql(')');
    }

    @Override
    public void visitInListPredicate(InListPredicate inListPredicate) {
        Expression listExpression2;
        int itemNumber;
        boolean inClauseParameterPaddingEnabled;
        int bindValueCount;
        List<Expression> listExpressions = inListPredicate.getListExpressions();
        if (listExpressions.isEmpty()) {
            this.appendSql("1=0");
            return;
        }
        Function<Object, Object> itemAccessor = Function.identity();
        SqlTuple lhsTuple = SqlTupleContainer.getSqlTuple(inListPredicate.getTestExpression());
        if (lhsTuple != null) {
            if (lhsTuple.getExpressions().size() == 1) {
                itemAccessor = listExpression -> SqlTupleContainer.getSqlTuple(listExpression).getExpressions().get(0);
            } else if (!this.supportsRowValueConstructorSyntaxInInList()) {
                ComparisonOperator comparisonOperator;
                ComparisonOperator comparisonOperator2 = comparisonOperator = inListPredicate.isNegated() ? ComparisonOperator.NOT_EQUAL : ComparisonOperator.EQUAL;
                if (this.supportsRowValueConstructorSyntaxInInSubQuery() && this.getDialect().supportsUnionAll()) {
                    inListPredicate.getTestExpression().accept(this);
                    if (inListPredicate.isNegated()) {
                        this.appendSql(" not");
                    }
                    this.appendSql(" in(");
                    String separator = "";
                    for (Expression expression : listExpressions) {
                        this.appendSql(separator);
                        this.renderExpressionsAsSubquery(SqlTupleContainer.getSqlTuple(expression).getExpressions());
                        separator = " union all ";
                    }
                    this.appendSql(')');
                } else {
                    String separator = "";
                    for (Expression expression : listExpressions) {
                        this.appendSql(separator);
                        this.emulateTupleComparison(lhsTuple.getExpressions(), SqlTupleContainer.getSqlTuple(expression).getExpressions(), comparisonOperator, true);
                        separator = " or ";
                    }
                }
                return;
            }
        }
        inListPredicate.getTestExpression().accept(this);
        if (inListPredicate.isNegated()) {
            this.appendSql(" not");
        }
        this.appendSql(" in(");
        String separator = "";
        int bindValueMaxCount = bindValueCount = listExpressions.size();
        Dialect dialect = this.getSessionFactory().getJdbcServices().getDialect();
        int inExprLimit = dialect.getInExpressionCountLimit();
        boolean bl = inClauseParameterPaddingEnabled = this.getSessionFactory().getSessionFactoryOptions().inClauseParameterPaddingEnabled() && bindValueCount > 2;
        if (inClauseParameterPaddingEnabled) {
            int bindValuePaddingCount = MathHelper.ceilingPowerOfTwo(bindValueCount);
            if (inExprLimit > 0) {
                if (bindValuePaddingCount > inExprLimit) {
                    bindValueMaxCount = bindValueCount < inExprLimit ? inExprLimit : MathHelper.ceilingPowerOfTwo(bindValueCount % inExprLimit);
                } else if (bindValueCount < bindValuePaddingCount) {
                    bindValueMaxCount = bindValuePaddingCount;
                }
            } else if (bindValueCount < bindValuePaddingCount) {
                bindValueMaxCount = bindValuePaddingCount;
            }
        }
        Iterator<Expression> iterator = listExpressions.iterator();
        for (itemNumber = 0; iterator.hasNext() && (inExprLimit == 0 || itemNumber < inExprLimit); ++itemNumber) {
            listExpression2 = (Expression)itemAccessor.apply(iterator.next());
            this.appendSql(separator);
            listExpression2.accept(this);
            separator = ",";
            if (listExpression2 instanceof JdbcParameter || listExpression2 instanceof SqmParameterInterpretation) continue;
            inExprLimit = 0;
            bindValueMaxCount = bindValueCount;
        }
        if (itemNumber != inExprLimit && bindValueCount == bindValueMaxCount) {
            this.appendSql(')');
            return;
        }
        if (inExprLimit > 0 && bindValueCount > inExprLimit) {
            do {
                this.append(") and ");
                inListPredicate.getTestExpression().accept(this);
                if (inListPredicate.isNegated()) {
                    this.appendSql(" not");
                }
                this.appendSql(" in(");
                separator = "";
                for (itemNumber = 0; iterator.hasNext() && itemNumber < inExprLimit; ++itemNumber) {
                    listExpression2 = iterator.next();
                    this.appendSql(separator);
                    ((Expression)itemAccessor.apply(listExpression2)).accept(this);
                    separator = ",";
                }
            } while (iterator.hasNext());
        }
        Expression lastExpression = (Expression)itemAccessor.apply(listExpressions.get(listExpressions.size() - 1));
        for (int i = inExprLimit > 0 && bindValueCount > inExprLimit ? bindValueCount % inExprLimit : bindValueCount; i < bindValueMaxCount; ++i) {
            this.appendSql(separator);
            lastExpression.accept(this);
            separator = ",";
        }
        this.appendSql(')');
    }

    @Override
    public void visitInSubQueryPredicate(InSubQueryPredicate inSubQueryPredicate) {
        SqlTuple lhsTuple = SqlTupleContainer.getSqlTuple(inSubQueryPredicate.getTestExpression());
        if (lhsTuple != null) {
            if (lhsTuple.getExpressions().size() == 1) {
                lhsTuple.getExpressions().get(0).accept(this);
                if (inSubQueryPredicate.isNegated()) {
                    this.appendSql(" not");
                }
                this.appendSql(" in");
                inSubQueryPredicate.getSubQuery().accept(this);
            } else if (!this.supportsRowValueConstructorSyntaxInInSubQuery()) {
                this.emulateSubQueryRelationalRestrictionPredicate(inSubQueryPredicate, inSubQueryPredicate.isNegated(), inSubQueryPredicate.getSubQuery(), lhsTuple, this::renderSelectTupleComparison, ComparisonOperator.EQUAL);
            } else {
                inSubQueryPredicate.getTestExpression().accept(this);
                if (inSubQueryPredicate.isNegated()) {
                    this.appendSql(" not");
                }
                this.appendSql(" in");
                inSubQueryPredicate.getSubQuery().accept(this);
            }
        } else {
            inSubQueryPredicate.getTestExpression().accept(this);
            if (inSubQueryPredicate.isNegated()) {
                this.appendSql(" not");
            }
            this.appendSql(" in");
            inSubQueryPredicate.getSubQuery().accept(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected <X extends Expression> void emulateSubQueryRelationalRestrictionPredicate(Predicate predicate, boolean negated, QueryPart queryPart, X lhsTuple, SubQueryRelationalRestrictionEmulationRenderer<X> renderer, ComparisonOperator tupleComparisonOperator) {
        if (queryPart instanceof QuerySpec && queryPart.getFetchClauseExpression() == null && queryPart.getOffsetClauseExpression() == null) {
            subQuery = (QuerySpec)queryPart;
            if (negated) {
                this.appendSql("not ");
            }
            queryPartForRowNumbering = this.queryPartForRowNumbering;
            queryPartForRowNumberingClauseDepth = this.queryPartForRowNumberingClauseDepth;
            needsSelectAliases = this.needsSelectAliases;
            try {
                this.queryPartForRowNumbering = null;
                this.queryPartForRowNumberingClauseDepth = -1;
                this.needsSelectAliases = false;
                this.queryPartStack.push(subQuery);
                this.appendSql("exists (select 1");
                this.visitFromClause(subQuery.getFromClause());
                if (!subQuery.getGroupByClauseExpressions().isEmpty() || subQuery.getHavingClauseRestrictions() != null) {
                    this.visitWhereClause(subQuery.getWhereClauseRestrictions());
                    this.visitGroupByClause(subQuery, SelectItemReferenceStrategy.EXPRESSION);
                    this.appendSql(" having ");
                    this.clauseStack.push(Clause.HAVING);
                    try {
                        renderer.renderComparison(subQuery.getSelectClause().getSqlSelections(), lhsTuple, tupleComparisonOperator);
                        havingClauseRestrictions = subQuery.getHavingClauseRestrictions();
                        if (havingClauseRestrictions == null) ** GOTO lbl46
                        this.appendSql(" and (");
                        havingClauseRestrictions.accept(this);
                        this.appendSql(')');
                    }
                    finally {
                        this.clauseStack.pop();
                    }
                } else {
                    this.appendSql(" where ");
                    this.clauseStack.push(Clause.WHERE);
                    try {
                        renderer.renderComparison(subQuery.getSelectClause().getSqlSelections(), lhsTuple, tupleComparisonOperator);
                        whereClauseRestrictions = subQuery.getWhereClauseRestrictions();
                        if (whereClauseRestrictions != null) {
                            this.appendSql(" and (");
                            whereClauseRestrictions.accept(this);
                            this.appendSql(')');
                        }
                    }
                    finally {
                        this.clauseStack.pop();
                    }
                }
                this.appendSql(')');
            }
            finally {
                this.queryPartStack.pop();
                this.queryPartForRowNumbering = queryPartForRowNumbering;
                this.queryPartForRowNumberingClauseDepth = queryPartForRowNumberingClauseDepth;
                this.needsSelectAliases = needsSelectAliases;
            }
        }
        throw new IllegalArgumentException("Can't emulate in predicate with tuples and limit/offset or set operations: " + predicate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void emulateQuantifiedTupleSubQueryPredicate(Predicate predicate, QueryPart queryPart, SqlTuple lhsTuple, ComparisonOperator tupleComparisonOperator) {
        if (queryPart instanceof QuerySpec && queryPart.getFetchClauseExpression() == null && queryPart.getOffsetClauseExpression() == null) {
            QuerySpec subQuery = (QuerySpec)queryPart;
            lhsTuple.accept(this);
            this.appendSql(tupleComparisonOperator.sqlText());
            QueryPart queryPartForRowNumbering = this.queryPartForRowNumbering;
            int queryPartForRowNumberingClauseDepth = this.queryPartForRowNumberingClauseDepth;
            boolean needsSelectAliases = this.needsSelectAliases;
            try {
                this.queryPartForRowNumbering = null;
                this.queryPartForRowNumberingClauseDepth = -1;
                this.needsSelectAliases = false;
                this.queryPartStack.push(subQuery);
                this.appendSql('(');
                this.visitSelectClause(subQuery.getSelectClause());
                this.visitFromClause(subQuery.getFromClause());
                this.visitWhereClause(subQuery.getWhereClauseRestrictions());
                this.visitGroupByClause(subQuery, this.getDialect().getGroupBySelectItemReferenceStrategy());
                this.visitHavingClause(subQuery);
                this.appendSql(" order by ");
                List<SqlSelection> sqlSelections = subQuery.getSelectClause().getSqlSelections();
                String order = tupleComparisonOperator == ComparisonOperator.LESS_THAN || tupleComparisonOperator == ComparisonOperator.LESS_THAN_OR_EQUAL ? "" : " desc";
                this.appendSql('1');
                this.appendSql(order);
                for (int i = 1; i < sqlSelections.size(); ++i) {
                    this.appendSql(',');
                    this.appendSql(i + 1);
                    this.appendSql(order);
                }
                this.renderFetch(new QueryLiteral<Integer>(1, this.getIntegerType()), null, FetchClauseType.ROWS_ONLY);
                this.appendSql(')');
            }
            finally {
                this.queryPartStack.pop();
                this.queryPartForRowNumbering = queryPartForRowNumbering;
                this.queryPartForRowNumberingClauseDepth = queryPartForRowNumberingClauseDepth;
                this.needsSelectAliases = needsSelectAliases;
            }
        } else {
            throw new IllegalArgumentException("Can't emulate in predicate with tuples and limit/offset or set operations: " + predicate);
        }
    }

    @Override
    public void visitExistsPredicate(ExistsPredicate existsPredicate) {
        if (existsPredicate.isNegated()) {
            this.appendSql("not ");
        }
        this.appendSql("exists");
        existsPredicate.getExpression().accept(this);
    }

    @Override
    public void visitJunction(Junction junction) {
        if (junction.isEmpty()) {
            return;
        }
        Junction.Nature nature = junction.getNature();
        String separator = nature == Junction.Nature.CONJUNCTION ? " and " : " or ";
        List<Predicate> predicates = junction.getPredicates();
        this.visitJunctionPredicate(nature, predicates.get(0));
        for (int i = 1; i < predicates.size(); ++i) {
            this.appendSql(separator);
            this.visitJunctionPredicate(nature, predicates.get(i));
        }
    }

    private void visitJunctionPredicate(Junction.Nature nature, Predicate p) {
        if (p instanceof Junction) {
            Junction junction = (Junction)p;
            if (nature == junction.getNature() || nature == Junction.Nature.DISJUNCTION) {
                p.accept(this);
            } else {
                this.appendSql('(');
                p.accept(this);
                this.appendSql(')');
            }
        } else {
            p.accept(this);
        }
    }

    @Override
    public void visitLikePredicate(LikePredicate likePredicate) {
        if (likePredicate.isCaseSensitive()) {
            likePredicate.getMatchExpression().accept(this);
            if (likePredicate.isNegated()) {
                this.appendSql(" not");
            }
            this.appendSql(" like ");
            likePredicate.getPattern().accept(this);
            if (likePredicate.getEscapeCharacter() != null) {
                this.appendSql(" escape ");
                likePredicate.getEscapeCharacter().accept(this);
            }
        } else if (this.getDialect().supportsCaseInsensitiveLike()) {
            likePredicate.getMatchExpression().accept(this);
            if (likePredicate.isNegated()) {
                this.appendSql(" not");
            }
            this.appendSql(' ');
            this.appendSql(this.getDialect().getCaseInsensitiveLike());
            this.appendSql(' ');
            likePredicate.getPattern().accept(this);
            if (likePredicate.getEscapeCharacter() != null) {
                this.appendSql(" escape ");
                likePredicate.getEscapeCharacter().accept(this);
            }
        } else {
            this.renderCaseInsensitiveLikeEmulation(likePredicate.getMatchExpression(), likePredicate.getPattern(), likePredicate.getEscapeCharacter(), likePredicate.isNegated());
        }
    }

    protected void renderCaseInsensitiveLikeEmulation(Expression lhs, Expression rhs, Expression escapeCharacter, boolean negated) {
        this.appendSql(this.getDialect().getLowercaseFunction());
        this.appendSql('(');
        lhs.accept(this);
        this.appendSql(')');
        if (negated) {
            this.appendSql(" not");
        }
        this.appendSql(" like ");
        this.appendSql(this.getDialect().getLowercaseFunction());
        this.appendSql('(');
        rhs.accept(this);
        this.appendSql(')');
        if (escapeCharacter != null) {
            this.appendSql(" escape ");
            escapeCharacter.accept(this);
        }
    }

    @Override
    public void visitNegatedPredicate(NegatedPredicate negatedPredicate) {
        if (negatedPredicate.isEmpty()) {
            return;
        }
        this.appendSql("not(");
        negatedPredicate.getPredicate().accept(this);
        this.appendSql(')');
    }

    @Override
    public void visitNullnessPredicate(NullnessPredicate nullnessPredicate) {
        Expression expression = nullnessPredicate.getExpression();
        String predicateValue = nullnessPredicate.isNegated() ? " is not null" : " is null";
        SqlTuple tuple = SqlTupleContainer.getSqlTuple(expression);
        if (tuple != null) {
            String separator = "";
            if (nullnessPredicate.isNegated() && expression.getExpressionType() instanceof AttributeMapping) {
                this.appendSql('(');
                for (Expression expression2 : tuple.getExpressions()) {
                    this.appendSql(separator);
                    expression2.accept(this);
                    this.appendSql(predicateValue);
                    separator = " or ";
                }
                this.appendSql(')');
            } else {
                for (Expression expression3 : tuple.getExpressions()) {
                    this.appendSql(separator);
                    expression3.accept(this);
                    this.appendSql(predicateValue);
                    separator = " and ";
                }
            }
        } else {
            expression.accept(this);
            this.appendSql(predicateValue);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void visitRelationalPredicate(ComparisonPredicate comparisonPredicate) {
        SqlTuple lhsTuple = SqlTupleContainer.getSqlTuple(comparisonPredicate.getLeftHandExpression());
        if (lhsTuple != null) {
            boolean all;
            QueryPart subquery;
            Expression rhsExpression = comparisonPredicate.getRightHandExpression();
            if (rhsExpression instanceof QueryPart) {
                subquery = (QueryPart)rhsExpression;
                all = true;
            } else if (rhsExpression instanceof Every) {
                subquery = ((Every)rhsExpression).getSubquery();
                all = true;
            } else if (rhsExpression instanceof Any) {
                subquery = ((Any)rhsExpression).getSubquery();
                all = false;
            } else {
                subquery = null;
                all = false;
            }
            ComparisonOperator operator = comparisonPredicate.getOperator();
            if (lhsTuple.getExpressions().size() == 1) {
                if (subquery == null) {
                    this.renderComparison(lhsTuple.getExpressions().get(0), operator, SqlTupleContainer.getSqlTuple(comparisonPredicate.getRightHandExpression()).getExpressions().get(0));
                    return;
                } else {
                    this.renderComparison(lhsTuple.getExpressions().get(0), operator, rhsExpression);
                }
                return;
            } else if (subquery != null && !this.supportsRowValueConstructorSyntaxInQuantifiedPredicates()) {
                if (this.supportsRowValueConstructorSyntax() && all) {
                    switch (operator) {
                        case LESS_THAN_OR_EQUAL: 
                        case GREATER_THAN_OR_EQUAL: 
                        case LESS_THAN: 
                        case GREATER_THAN: {
                            this.emulateQuantifiedTupleSubQueryPredicate(comparisonPredicate, subquery, lhsTuple, operator);
                            return;
                        }
                    }
                }
                this.emulateSubQueryRelationalRestrictionPredicate(comparisonPredicate, all, subquery, lhsTuple, this::renderSelectTupleComparison, all ? operator.negated() : operator);
                return;
            } else if (!this.supportsRowValueConstructorSyntax()) {
                SqlTuple rhsTuple = SqlTupleContainer.getSqlTuple(rhsExpression);
                assert (rhsTuple != null);
                if ((operator == ComparisonOperator.EQUAL || operator == ComparisonOperator.NOT_EQUAL) && this.supportsRowValueConstructorSyntaxInInSubQuery()) {
                    comparisonPredicate.getLeftHandExpression().accept(this);
                    if (operator == ComparisonOperator.NOT_EQUAL) {
                        this.appendSql(" not");
                    }
                    this.appendSql(" in(");
                    this.renderExpressionsAsSubquery(rhsTuple.getExpressions());
                    this.appendSql(')');
                    return;
                } else {
                    this.emulateTupleComparison(lhsTuple.getExpressions(), rhsTuple.getExpressions(), operator, true);
                }
                return;
            } else {
                this.renderComparison(comparisonPredicate.getLeftHandExpression(), operator, rhsExpression);
            }
            return;
        } else {
            SqlTuple rhsTuple = SqlTupleContainer.getSqlTuple(comparisonPredicate.getRightHandExpression());
            if (rhsTuple != null) {
                Expression lhsExpression = comparisonPredicate.getLeftHandExpression();
                if (!(lhsExpression instanceof QueryGroup)) throw new IllegalStateException("Unsupported tuple comparison combination. LHS is neither a tuple nor a tuple subquery but RHS is a tuple: " + comparisonPredicate);
                if (rhsTuple.getExpressions().size() == 1) {
                    this.renderComparison(lhsExpression, comparisonPredicate.getOperator(), rhsTuple.getExpressions().get(0));
                    return;
                } else if (this.supportsRowValueConstructorSyntax()) {
                    this.renderComparison(lhsExpression, comparisonPredicate.getOperator(), comparisonPredicate.getRightHandExpression());
                    return;
                } else {
                    this.emulateSubQueryRelationalRestrictionPredicate(comparisonPredicate, false, (QueryGroup)lhsExpression, rhsTuple, this::renderSelectTupleComparison, comparisonPredicate.getOperator().invert());
                }
                return;
            } else {
                this.renderComparison(comparisonPredicate.getLeftHandExpression(), comparisonPredicate.getOperator(), comparisonPredicate.getRightHandExpression());
            }
        }
    }

    protected boolean supportsQuantifiedPredicates() {
        return true;
    }

    protected boolean supportsDistinctFromPredicate() {
        return true;
    }

    protected boolean supportsRowValueConstructorSyntax() {
        return true;
    }

    protected boolean supportsRowValueConstructorSyntaxInSet() {
        return this.supportsRowValueConstructorSyntax();
    }

    protected boolean supportsRowValueConstructorSyntaxInQuantifiedPredicates() {
        return true;
    }

    protected boolean supportsRowValueConstructorSyntaxInInList() {
        return true;
    }

    protected boolean supportsRowValueConstructorSyntaxInInSubQuery() {
        return this.supportsRowValueConstructorSyntaxInInList();
    }

    protected String getFromDual() {
        return " from (values (0)) dual";
    }

    protected String getFromDualForSelectOnly() {
        return "";
    }

    protected static class ForUpdateClause {
        private LockMode lockMode;
        private int timeoutMillis = -1;
        private Map<String, String[]> keyColumnNames;
        private Map<String, String> aliases;

        public ForUpdateClause(LockMode lockMode) {
            this.lockMode = lockMode;
        }

        public ForUpdateClause() {
            this.lockMode = LockMode.NONE;
        }

        public void applyAliases(RowLockStrategy lockIdentifier, QuerySpec querySpec) {
            if (lockIdentifier != RowLockStrategy.NONE) {
                querySpec.getFromClause().visitTableGroups(tableGroup -> this.applyAliases(lockIdentifier, (TableGroup)tableGroup));
            }
        }

        public void applyAliases(RowLockStrategy lockIdentifier, TableGroup tableGroup) {
            if (this.aliases != null && lockIdentifier != RowLockStrategy.NONE) {
                String tableAlias = tableGroup.getPrimaryTableReference().getIdentificationVariable();
                if (this.aliases.containsKey(tableGroup.getSourceAlias())) {
                    this.addAlias(tableGroup.getSourceAlias(), tableAlias);
                    if (lockIdentifier == RowLockStrategy.COLUMN) {
                        this.addKeyColumnNames(tableGroup);
                    }
                }
            }
        }

        public LockMode getLockMode() {
            return this.lockMode;
        }

        public void setLockMode(LockMode lockMode) {
            if (this.lockMode != LockMode.NONE && lockMode != this.lockMode) {
                throw new QueryException("mixed LockModes");
            }
            this.lockMode = lockMode;
        }

        public void addKeyColumnNames(TableGroup tableGroup) {
            String[] keyColumnNames = this.determineKeyColumnNames(tableGroup.getModelPart());
            if (keyColumnNames == null) {
                throw new IllegalArgumentException("Can't lock table group: " + tableGroup);
            }
            this.addKeyColumnNames(tableGroup.getSourceAlias(), tableGroup.getPrimaryTableReference().getIdentificationVariable(), keyColumnNames);
        }

        private String[] determineKeyColumnNames(ModelPart modelPart) {
            if (modelPart instanceof Loadable) {
                return ((Loadable)modelPart).getIdentifierColumnNames();
            }
            if (modelPart instanceof PluralAttributeMapping) {
                return ((PluralAttributeMapping)modelPart).getCollectionDescriptor().getKeyColumnAliases(null);
            }
            if (modelPart instanceof EntityAssociationMapping) {
                return this.determineKeyColumnNames(((EntityAssociationMapping)modelPart).getAssociatedEntityMappingType());
            }
            return null;
        }

        private void addKeyColumnNames(String alias, String tableAlias, String[] keyColumnNames) {
            if (this.keyColumnNames == null) {
                this.keyColumnNames = new HashMap<String, String[]>();
            }
            this.keyColumnNames.put(tableAlias, keyColumnNames);
        }

        public boolean hasAlias(String alias) {
            return this.aliases != null && this.aliases.containsKey(alias);
        }

        private void addAlias(String alias, String tableAlias) {
            if (this.aliases == null) {
                this.aliases = new HashMap<String, String>();
            }
            this.aliases.put(alias, tableAlias);
        }

        public int getTimeoutMillis() {
            return this.timeoutMillis;
        }

        public boolean hasAliases() {
            return this.aliases != null;
        }

        public void appendAliases(SqlAppender appender) {
            if (this.aliases == null) {
                return;
            }
            if (this.keyColumnNames != null) {
                boolean first = true;
                for (String tableAlias : this.aliases.values()) {
                    String[] keyColumns = this.keyColumnNames.get(tableAlias);
                    if (keyColumns == null) {
                        throw new IllegalArgumentException("alias not found: " + tableAlias);
                    }
                    for (String keyColumn : keyColumns) {
                        if (first) {
                            first = false;
                        } else {
                            appender.appendSql(',');
                        }
                        appender.appendSql(tableAlias);
                        appender.appendSql('.');
                        appender.appendSql(keyColumn);
                    }
                }
            } else {
                boolean first = true;
                for (String tableAlias : this.aliases.values()) {
                    if (first) {
                        first = false;
                    } else {
                        appender.appendSql(',');
                    }
                    appender.appendSql(tableAlias);
                }
            }
        }

        public String getAliases() {
            if (this.aliases == null) {
                return null;
            }
            return this.aliases.toString();
        }

        public void merge(LockOptions lockOptions) {
            if (lockOptions != null) {
                LockMode upgradeType = LockMode.NONE;
                if (lockOptions.getAliasLockCount() == 0) {
                    upgradeType = lockOptions.getLockMode();
                } else {
                    for (Map.Entry<String, LockMode> entry : lockOptions.getAliasSpecificLocks()) {
                        LockMode lockMode = entry.getValue();
                        if (!LockMode.READ.lessThan(lockMode)) continue;
                        this.addAlias(entry.getKey(), null);
                        if (upgradeType != LockMode.NONE && lockMode != upgradeType) {
                            throw new QueryException("mixed LockModes");
                        }
                        upgradeType = lockMode;
                    }
                }
                this.lockMode = upgradeType;
                this.timeoutMillis = lockOptions.getTimeOut();
            }
        }
    }

    protected static enum LockStrategy {
        CLAUSE,
        FOLLOW_ON,
        NONE;

    }

    protected static interface SubQueryRelationalRestrictionEmulationRenderer<X extends Expression> {
        public void renderComparison(List<SqlSelection> var1, X var2, ComparisonOperator var3);
    }

    private static class OffsetReceivingParameterBinder
    implements JdbcParameterBinder {
        private final JdbcParameter offsetParameter;
        private final JdbcParameter fetchParameter;
        private final int staticOffset;
        private Number dynamicOffset;

        public OffsetReceivingParameterBinder(JdbcParameter offsetParameter, JdbcParameter fetchParameter, int staticOffset) {
            this.offsetParameter = offsetParameter;
            this.fetchParameter = fetchParameter;
            this.staticOffset = staticOffset;
        }

        @Override
        public void bindParameterValue(PreparedStatement statement, int startPosition, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) throws SQLException {
            int offsetValue;
            Number bindValue;
            if (this.fetchParameter instanceof LimitJdbcParameter) {
                bindValue = executionContext.getQueryOptions().getEffectiveLimit().getMaxRows();
            } else {
                JdbcParameterBinding binding = jdbcParameterBindings.getBinding(this.fetchParameter);
                if (binding == null) {
                    throw new ExecutionException("JDBC parameter value not bound - " + this.fetchParameter);
                }
                bindValue = (Number)binding.getBindValue();
            }
            if (this.offsetParameter instanceof OffsetJdbcParameter) {
                offsetValue = executionContext.getQueryOptions().getEffectiveLimit().getFirstRow();
            } else {
                offsetValue = this.dynamicOffset.intValue() + this.staticOffset;
                this.dynamicOffset = null;
            }
            this.fetchParameter.getExpressionType().getJdbcMappings().get(0).getJdbcValueBinder().bind(statement, Integer.valueOf(bindValue.intValue() + offsetValue), startPosition, (WrapperOptions)executionContext.getSession());
        }
    }

    private static enum LockKind {
        NONE,
        SHARE,
        UPDATE;

    }

    private static class LimitJdbcParameter
    extends AbstractJdbcParameter {
        public LimitJdbcParameter(BasicType<Integer> type) {
            super(type);
        }

        @Override
        public void bindParameterValue(PreparedStatement statement, int startPosition, JdbcParameterBindings jdbcParamBindings, ExecutionContext executionContext) throws SQLException {
            this.getJdbcMapping().getJdbcValueBinder().bind(statement, executionContext.getQueryOptions().getLimit().getMaxRows(), startPosition, (WrapperOptions)executionContext.getSession());
        }
    }

    private static class OffsetJdbcParameter
    extends AbstractJdbcParameter {
        public OffsetJdbcParameter(BasicType<Integer> type) {
            super(type);
        }

        @Override
        public void bindParameterValue(PreparedStatement statement, int startPosition, JdbcParameterBindings jdbcParamBindings, ExecutionContext executionContext) throws SQLException {
            this.getJdbcMapping().getJdbcValueBinder().bind(statement, executionContext.getQueryOptions().getLimit().getFirstRow(), startPosition, (WrapperOptions)executionContext.getSession());
        }
    }

    private static class LazySessionWrapperOptions
    extends AbstractDelegatingWrapperOptions {
        private final SessionFactoryImplementor sessionFactory;
        private SessionImplementor session;

        public LazySessionWrapperOptions(SessionFactoryImplementor sessionFactory) {
            this.sessionFactory = sessionFactory;
        }

        public void cleanup() {
            if (this.session != null) {
                this.session.close();
                this.session = null;
            }
        }

        @Override
        protected SessionImplementor delegate() {
            if (this.session == null) {
                this.session = (SessionImplementor)this.sessionFactory.openTemporarySession();
            }
            return this.session;
        }

        @Override
        public SharedSessionContractImplementor getSession() {
            return this.delegate();
        }

        @Override
        public SessionFactoryImplementor getSessionFactory() {
            return this.sessionFactory;
        }

        @Override
        public boolean useStreamForLobBinding() {
            return this.sessionFactory.getFastSessionServices().useStreamForLobBinding();
        }

        @Override
        public int getPreferredSqlTypeCodeForBoolean() {
            return this.sessionFactory.getFastSessionServices().getPreferredSqlTypeCodeForBoolean();
        }

        @Override
        public TimeZone getJdbcTimeZone() {
            return this.sessionFactory.getSessionFactoryOptions().getJdbcTimeZone();
        }
    }
}

