/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.from;

import java.util.List;
import java.util.Locale;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.spi.NavigablePath;
import org.hibernate.sql.ast.tree.from.ColumnReferenceQualifier;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.from.UnknownTableReferenceException;

public abstract class AbstractColumnReferenceQualifier
implements ColumnReferenceQualifier {
    protected abstract TableReference getPrimaryTableReference();

    protected abstract List<TableReferenceJoin> getTableReferenceJoins();

    protected abstract SessionFactoryImplementor getSessionFactory();

    @Override
    public TableReference resolveTableReference(NavigablePath navigablePath, String tableExpression, boolean allowFkOptimization) {
        assert (tableExpression != null);
        TableReference tableReference = this.getTableReferenceInternal(navigablePath, tableExpression, allowFkOptimization, true);
        if (tableReference == null) {
            throw new UnknownTableReferenceException(tableExpression, String.format(Locale.ROOT, "Unable to determine TableReference (`%s`) for `%s`", tableExpression, navigablePath.getFullPath()));
        }
        return tableReference;
    }

    @Override
    public TableReference getTableReference(NavigablePath navigablePath, String tableExpression, boolean allowFkOptimization, boolean resolve) {
        return this.getTableReferenceInternal(navigablePath, tableExpression, allowFkOptimization, resolve);
    }

    protected TableReference getTableReferenceInternal(NavigablePath navigablePath, String tableExpression, boolean allowFkOptimization, boolean resolve) {
        TableReference primaryTableReference = this.getPrimaryTableReference().getTableReference(navigablePath, tableExpression, allowFkOptimization, resolve);
        if (primaryTableReference != null) {
            return primaryTableReference;
        }
        for (TableReferenceJoin tableJoin : this.getTableReferenceJoins()) {
            TableReference tableReference = tableJoin.getJoinedTableReference().getTableReference(navigablePath, tableExpression, allowFkOptimization, resolve);
            if (tableReference == null) continue;
            return tableReference;
        }
        return null;
    }
}

