/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.from;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.query.spi.NavigablePath;
import org.hibernate.sql.ast.spi.SqlAliasBase;
import org.hibernate.sql.ast.tree.from.DelegatingTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableGroupProducer;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.from.UnknownTableReferenceException;

public class LazyTableGroup
extends DelegatingTableGroup {
    private final boolean canUseInnerJoins;
    private final NavigablePath navigablePath;
    private final boolean fetched;
    private final TableGroupProducer producer;
    private final String sourceAlias;
    private final SqlAliasBase sqlAliasBase;
    private final Supplier<TableGroup> tableGroupSupplier;
    private final TableGroup parentTableGroup;
    private final BiPredicate<NavigablePath, String> navigablePathChecker;
    private List<TableGroupJoin> tableGroupJoins;
    private List<TableGroupJoin> nestedTableGroupJoins;
    private Consumer<TableGroup> tableGroupConsumer;
    private TableGroup tableGroup;

    public LazyTableGroup(boolean canUseInnerJoins, NavigablePath navigablePath, boolean fetched, Supplier<TableGroup> tableGroupSupplier, BiPredicate<NavigablePath, String> navigablePathChecker, TableGroupProducer tableGroupProducer, String sourceAlias, SqlAliasBase sqlAliasBase, SessionFactoryImplementor sessionFactory, TableGroup parentTableGroup) {
        this.canUseInnerJoins = canUseInnerJoins;
        this.navigablePath = navigablePath;
        this.fetched = fetched;
        this.producer = tableGroupProducer;
        this.sourceAlias = sourceAlias;
        this.sqlAliasBase = sqlAliasBase;
        this.tableGroupSupplier = tableGroupSupplier;
        this.navigablePathChecker = navigablePathChecker;
        this.parentTableGroup = parentTableGroup;
    }

    public TableGroup getUnderlyingTableGroup() {
        return this.tableGroup;
    }

    @Override
    public TableGroup getTableGroup() {
        if (this.tableGroup != null) {
            return this.tableGroup;
        }
        this.tableGroup = this.tableGroupSupplier.get();
        if (this.tableGroupJoins != null) {
            for (TableGroupJoin tableGroupJoin : this.tableGroupJoins) {
                this.tableGroup.addTableGroupJoin(tableGroupJoin);
            }
            this.tableGroupJoins = null;
        }
        if (this.nestedTableGroupJoins != null) {
            for (TableGroupJoin tableGroupJoin : this.nestedTableGroupJoins) {
                this.tableGroup.addNestedTableGroupJoin(tableGroupJoin);
            }
            this.nestedTableGroupJoins = null;
        }
        if (this.tableGroupConsumer != null) {
            this.tableGroupConsumer.accept(this.tableGroup);
            this.tableGroupConsumer = null;
        }
        return this.tableGroup;
    }

    public void setTableGroupInitializerCallback(Consumer<TableGroup> tableGroupConsumer) {
        if (this.tableGroup != null) {
            tableGroupConsumer.accept(this.tableGroup);
        } else {
            this.tableGroupConsumer = tableGroupConsumer;
        }
    }

    @Override
    public void applyAffectedTableNames(Consumer<String> nameCollector) {
        if (this.tableGroup != null) {
            this.tableGroup.applyAffectedTableNames(nameCollector);
        }
    }

    @Override
    public List<TableReferenceJoin> getTableReferenceJoins() {
        return this.tableGroup == null ? Collections.emptyList() : this.tableGroup.getTableReferenceJoins();
    }

    @Override
    public List<TableGroupJoin> getTableGroupJoins() {
        if (this.tableGroup == null) {
            return this.nestedTableGroupJoins == null ? Collections.emptyList() : this.nestedTableGroupJoins;
        }
        return this.tableGroup.getTableGroupJoins();
    }

    @Override
    public List<TableGroupJoin> getNestedTableGroupJoins() {
        if (this.tableGroup == null) {
            return this.tableGroupJoins == null ? Collections.emptyList() : this.tableGroupJoins;
        }
        return this.tableGroup.getNestedTableGroupJoins();
    }

    @Override
    public void addTableGroupJoin(TableGroupJoin join) {
        if (this.tableGroup == null) {
            if (this.tableGroupJoins == null) {
                this.tableGroupJoins = new ArrayList<TableGroupJoin>();
            }
            this.tableGroupJoins.add(join);
        } else {
            this.getTableGroup().addTableGroupJoin(join);
        }
    }

    @Override
    public void addNestedTableGroupJoin(TableGroupJoin join) {
        if (this.tableGroup == null) {
            if (this.nestedTableGroupJoins == null) {
                this.nestedTableGroupJoins = new ArrayList<TableGroupJoin>();
            }
            this.nestedTableGroupJoins.add(join);
        } else {
            this.getTableGroup().addNestedTableGroupJoin(join);
        }
    }

    @Override
    public void visitTableGroupJoins(Consumer<TableGroupJoin> consumer) {
        if (this.tableGroup == null) {
            if (this.tableGroupJoins != null) {
                this.tableGroupJoins.forEach(consumer);
            }
        } else {
            this.tableGroup.visitTableGroupJoins(consumer);
        }
    }

    @Override
    public void visitNestedTableGroupJoins(Consumer<TableGroupJoin> consumer) {
        if (this.tableGroup == null) {
            if (this.nestedTableGroupJoins != null) {
                this.nestedTableGroupJoins.forEach(consumer);
            }
        } else {
            this.tableGroup.visitNestedTableGroupJoins(consumer);
        }
    }

    @Override
    public boolean canUseInnerJoins() {
        return this.canUseInnerJoins;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public String getGroupAlias() {
        return this.sqlAliasBase.getAliasStem();
    }

    @Override
    public TableGroupProducer getModelPart() {
        return this.producer;
    }

    @Override
    public ModelPart getExpressionType() {
        return this.getModelPart();
    }

    @Override
    public String getSourceAlias() {
        return this.sourceAlias;
    }

    @Override
    public boolean isRealTableGroup() {
        return this.tableGroup != null && this.tableGroup.isRealTableGroup();
    }

    @Override
    public boolean isFetched() {
        return this.fetched;
    }

    @Override
    public boolean isLateral() {
        return false;
    }

    @Override
    public TableReference resolveTableReference(NavigablePath navigablePath, String tableExpression, boolean allowFkOptimization) {
        assert (tableExpression != null);
        TableReference tableReference = this.getTableReferenceInternal(navigablePath, tableExpression, allowFkOptimization, true);
        if (tableReference == null) {
            throw new UnknownTableReferenceException(tableExpression, String.format(Locale.ROOT, "Unable to determine TableReference (`%s`) for `%s`", tableExpression, navigablePath.getFullPath()));
        }
        return tableReference;
    }

    @Override
    public TableReference getTableReference(NavigablePath navigablePath, String tableExpression, boolean allowFkOptimization, boolean resolve) {
        return this.getTableReferenceInternal(navigablePath, tableExpression, allowFkOptimization, resolve);
    }

    protected TableReference getTableReferenceInternal(NavigablePath navigablePath, String tableExpression, boolean allowFkOptimization, boolean resolve) {
        TableReference reference;
        if (allowFkOptimization && (navigablePath == null || this.navigablePathChecker.test(navigablePath, tableExpression)) && (reference = this.parentTableGroup.getTableReference(navigablePath, tableExpression, allowFkOptimization, resolve)) != null) {
            return reference;
        }
        return this.getTableGroup().getTableReference(navigablePath, tableExpression, allowFkOptimization, resolve);
    }
}

