/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.from;

import java.util.Locale;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.spi.NavigablePath;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.UnknownTableReferenceException;

public class UnionTableReference
extends NamedTableReference {
    private final String[] subclassTableSpaceExpressions;

    public UnionTableReference(String unionTableExpression, String[] subclassTableSpaceExpressions, String identificationVariable, boolean isOptional, SessionFactoryImplementor sessionFactory) {
        super(unionTableExpression, identificationVariable, isOptional, sessionFactory);
        this.subclassTableSpaceExpressions = subclassTableSpaceExpressions;
    }

    @Override
    public TableReference resolveTableReference(NavigablePath navigablePath, String tableExpression, boolean allowFkOptimization) {
        if (this.hasTableExpression(tableExpression)) {
            return this;
        }
        throw new UnknownTableReferenceException(tableExpression, String.format(Locale.ROOT, "Unable to determine TableReference (`%s`) for `%s`", tableExpression, navigablePath.getFullPath()));
    }

    @Override
    public TableReference getTableReference(NavigablePath navigablePath, String tableExpression, boolean allowFkOptimization, boolean resolve) {
        if (this.hasTableExpression(tableExpression)) {
            return this;
        }
        return null;
    }

    private boolean hasTableExpression(String tableExpression) {
        if (tableExpression.equals(this.getTableExpression())) {
            return true;
        }
        for (String expression : this.subclassTableSpaceExpressions) {
            if (!tableExpression.equals(expression)) continue;
            return true;
        }
        return false;
    }
}

