/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.embeddable;

import java.util.List;
import java.util.function.Supplier;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.internal.StandardEmbeddableInstantiator;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.CompositeIdentifierMapping;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.VirtualModelPart;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.metamodel.spi.EmbeddableRepresentationStrategy;
import org.hibernate.metamodel.spi.ValueAccess;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.query.spi.NavigablePath;
import org.hibernate.sql.results.graph.AbstractFetchParentAccess;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.collection.CollectionInitializer;
import org.hibernate.sql.results.graph.embeddable.EmbeddableInitializer;
import org.hibernate.sql.results.graph.embeddable.EmbeddableLoadingLogger;
import org.hibernate.sql.results.graph.embeddable.EmbeddableResultGraphNode;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.internal.NullValueAssembler;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public abstract class AbstractEmbeddableInitializer
extends AbstractFetchParentAccess
implements EmbeddableInitializer,
ValueAccess {
    private static final Object NULL_MARKER = new Object(){

        public String toString() {
            return "Composite NULL_MARKER";
        }
    };
    private final NavigablePath navigablePath;
    private final EmbeddableValuedModelPart embedded;
    private final EmbeddableMappingType representationEmbeddable;
    private final EmbeddableRepresentationStrategy representationStrategy;
    private final FetchParentAccess fetchParentAccess;
    private final boolean createEmptyCompositesEnabled;
    private final SessionFactoryImplementor sessionFactory;
    private final List<DomainResultAssembler<?>> assemblers;
    private final boolean usesStandardInstatiation;
    private final Object[] rowState;
    private Boolean stateAllNull;
    private Boolean stateInjected;
    private Object compositeInstance;

    public AbstractEmbeddableInitializer(EmbeddableResultGraphNode resultDescriptor, FetchParentAccess fetchParentAccess, AssemblerCreationState creationState) {
        this.navigablePath = resultDescriptor.getNavigablePath();
        this.embedded = resultDescriptor.getReferencedMappingContainer();
        this.fetchParentAccess = fetchParentAccess;
        EmbeddableMappingType embeddableTypeDescriptor = this.embedded.getEmbeddableTypeDescriptor();
        this.representationEmbeddable = this.embedded instanceof CompositeIdentifierMapping ? ((CompositeIdentifierMapping)((Object)this.embedded)).getMappedIdEmbeddableTypeDescriptor() : embeddableTypeDescriptor;
        this.representationStrategy = this.representationEmbeddable.getRepresentationStrategy();
        this.usesStandardInstatiation = this.representationStrategy.getInstantiator() instanceof StandardEmbeddableInstantiator;
        int numOfAttrs = embeddableTypeDescriptor.getNumberOfAttributeMappings();
        this.rowState = new Object[numOfAttrs];
        this.assemblers = CollectionHelper.arrayList(numOfAttrs);
        embeddableTypeDescriptor.visitFetchables(stateArrayContributor -> {
            Fetch fetch = resultDescriptor.findFetch((Fetchable)stateArrayContributor);
            DomainResultAssembler<?> stateAssembler = fetch == null ? new NullValueAssembler(stateArrayContributor.getJavaType()) : fetch.createAssembler(this, creationState);
            this.assemblers.add(stateAssembler);
        }, null);
        this.createEmptyCompositesEnabled = !"{fk}".equals(this.navigablePath.getLocalName()) && !"{id}".equals(this.navigablePath.getLocalName()) && embeddableTypeDescriptor.isCreateEmptyCompositesEnabled();
        this.sessionFactory = creationState.getSqlAstCreationContext().getSessionFactory();
    }

    @Override
    public EmbeddableValuedModelPart getInitializedPart() {
        return this.embedded;
    }

    public FetchParentAccess getFetchParentAccess() {
        return this.fetchParentAccess;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public Object getCompositeInstance() {
        return this.compositeInstance == NULL_MARKER ? null : this.compositeInstance;
    }

    @Override
    public FetchParentAccess findFirstEntityDescriptorAccess() {
        return this.getFetchParentAccess().findFirstEntityDescriptorAccess();
    }

    @Override
    public void resolveKey(RowProcessingState processingState) {
    }

    @Override
    public void resolveInstance(RowProcessingState processingState) {
    }

    @Override
    public void initializeInstance(RowProcessingState processingState) {
        EmbeddableLoadingLogger.INSTANCE.debugf("Initializing composite instance [%s]", (Object)this.navigablePath);
        if (this.compositeInstance == NULL_MARKER) {
            return;
        }
        if (!this.usesStandardInstatiation && this.compositeInstance != null) {
            return;
        }
        this.stateInjected = false;
        this.extractRowState(processingState);
        this.prepareCompositeInstance(processingState);
        this.handleParentInjection(processingState);
        if (this.compositeInstance != NULL_MARKER) {
            this.notifyResolutionListeners(this.compositeInstance);
            if (this.compositeInstance instanceof HibernateProxy) {
                Initializer parentInitializer = processingState.resolveInitializer(this.navigablePath.getParent());
                if (parentInitializer != this) {
                    ((FetchParentAccess)parentInitializer).registerResolutionListener(entity -> {
                        this.representationEmbeddable.setValues(entity, this.rowState);
                        this.stateInjected = true;
                    });
                } else {
                    Object target = this.representationStrategy.getInstantiator().instantiate(this, this.sessionFactory);
                    this.stateInjected = true;
                    ((HibernateProxy)this.compositeInstance).getHibernateLazyInitializer().setImplementation(target);
                }
            } else if (this.stateAllNull == Boolean.FALSE && this.stateInjected != Boolean.TRUE) {
                this.representationEmbeddable.setValues(this.compositeInstance, this.rowState);
                this.stateInjected = true;
            }
        }
    }

    private void prepareCompositeInstance(RowProcessingState processingState) {
        if (this.compositeInstance != null) {
            return;
        }
        if (this.fetchParentAccess != null && this.embedded instanceof VirtualModelPart && !"{id}".equals(this.embedded.getFetchableName()) && !"{fk}".equals(this.navigablePath.getUnaliasedLocalName())) {
            this.fetchParentAccess.resolveInstance(processingState);
            this.compositeInstance = this.fetchParentAccess.getInitializedInstance();
        }
        if (this.compositeInstance == null) {
            this.compositeInstance = this.createCompositeInstance(this.navigablePath, this.representationStrategy, processingState, this.sessionFactory);
        }
        EmbeddableLoadingLogger.INSTANCE.debugf("Created composite instance [%s]", (Object)this.navigablePath);
    }

    private void extractRowState(RowProcessingState processingState) {
        this.stateAllNull = true;
        boolean isKey = "{fk}".equals(this.navigablePath.getLocalName()) || "{id}".equals(this.embedded.getFetchableName());
        for (int i = 0; i < this.assemblers.size(); ++i) {
            DomainResultAssembler<?> assembler = this.assemblers.get(i);
            Object contributorValue = assembler.assemble(processingState, processingState.getJdbcValuesSourceProcessingState().getProcessingOptions());
            this.rowState[i] = contributorValue;
            if (contributorValue != null) {
                this.stateAllNull = false;
                continue;
            }
            if (!isKey) continue;
            this.stateAllNull = true;
            break;
        }
        this.applyMapsId(processingState);
    }

    private void applyMapsId(RowProcessingState processingState) {
        SharedSessionContractImplementor session = processingState.getSession();
        if (this.embedded instanceof CompositeIdentifierMapping) {
            CompositeIdentifierMapping cid = (CompositeIdentifierMapping)((Object)this.embedded);
            EmbeddableMappingType mappedIdEmbeddable = cid.getMappedIdEmbeddableTypeDescriptor();
            if (cid.hasContainingClass()) {
                EmbeddableMappingType virtualIdEmbeddable = this.embedded.getEmbeddableTypeDescriptor();
                if (virtualIdEmbeddable == mappedIdEmbeddable) {
                    return;
                }
                virtualIdEmbeddable.forEachAttributeMapping((position, virtualIdAttribute) -> {
                    AttributeMapping mappedIdAttribute = mappedIdEmbeddable.getAttributeMapping(position);
                    if (virtualIdAttribute instanceof ToOneAttributeMapping && !(mappedIdAttribute instanceof ToOneAttributeMapping)) {
                        Object associationKey;
                        ToOneAttributeMapping toOneAttributeMapping = (ToOneAttributeMapping)virtualIdAttribute;
                        ForeignKeyDescriptor fkDescriptor = toOneAttributeMapping.getForeignKeyDescriptor();
                        this.rowState[position] = associationKey = fkDescriptor.getAssociationKeyFromSide(this.rowState[position], toOneAttributeMapping.getSideNature().inverse(), session);
                    }
                });
            }
        }
    }

    private Object createCompositeInstance(NavigablePath navigablePath, EmbeddableRepresentationStrategy representationStrategy, RowProcessingState processingState, SessionFactoryImplementor sessionFactory) {
        if (!this.createEmptyCompositesEnabled && this.stateAllNull == Boolean.TRUE) {
            return NULL_MARKER;
        }
        Supplier<Object[]> valuesAccess = this.stateAllNull == Boolean.TRUE ? null : () -> this.rowState;
        Object instance = representationStrategy.getInstantiator().instantiate(this, sessionFactory);
        this.stateInjected = true;
        EmbeddableLoadingLogger.INSTANCE.debugf("Created composite instance [%s] : %s", (Object)navigablePath, instance);
        return instance;
    }

    @Override
    public Object[] getValues() {
        return this.stateAllNull != false ? null : this.rowState;
    }

    @Override
    public <T> T getValue(int i, Class<T> clazz) {
        return this.stateAllNull != false ? null : (T)clazz.cast(this.rowState[i]);
    }

    @Override
    public Object getOwner() {
        return this.fetchParentAccess.getInitializedInstance();
    }

    private void handleParentInjection(RowProcessingState processingState) {
        if (this.compositeInstance == null || this.compositeInstance == NULL_MARKER) {
            EmbeddableLoadingLogger.INSTANCE.debugf("Skipping parent injection for null embeddable [%s]", (Object)this.navigablePath);
            return;
        }
        PropertyAccess parentInjectionAccess = this.embedded.getParentInjectionAttributePropertyAccess();
        if (parentInjectionAccess == null) {
            return;
        }
        Object parent = this.determineParentInstance(processingState);
        if (parent == null) {
            EmbeddableLoadingLogger.INSTANCE.debugf("Unable to determine parent for injection into embeddable [%s]", (Object)this.navigablePath);
            return;
        }
        EmbeddableLoadingLogger.INSTANCE.debugf("Injecting parent into embeddable [%s] : `%s` -> `%s`", (Object)this.navigablePath, parent, this.compositeInstance);
        parentInjectionAccess.getSetter().set(this.compositeInstance, parent);
    }

    private Object determineParentInstance(RowProcessingState processingState) {
        if (this.fetchParentAccess != null) {
            FetchParentAccess firstEntityDescriptorAccess = this.fetchParentAccess.findFirstEntityDescriptorAccess();
            return firstEntityDescriptorAccess.getInitializedInstance();
        }
        NavigablePath parentPath = this.navigablePath.getParent();
        if (parentPath == null) {
            return null;
        }
        Initializer parentInitializer = processingState.resolveInitializer(parentPath);
        if (parentInitializer instanceof CollectionInitializer) {
            return ((CollectionInitializer)parentInitializer).getCollectionInstance().getOwner();
        }
        if (parentInitializer instanceof EntityInitializer) {
            return ((EntityInitializer)parentInitializer).getEntityInstance();
        }
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public void finishUpRow(RowProcessingState rowProcessingState) {
        this.compositeInstance = null;
        this.stateAllNull = null;
        this.stateInjected = null;
        this.clearResolutionListeners();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.navigablePath + ") : `" + this.getInitializedPart().getJavaType().getJavaTypeClass() + "`";
    }
}

