/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity.internal;

import org.hibernate.engine.FetchTiming;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.query.spi.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.graph.entity.internal.AbstractNonJoinedEntityFetch;
import org.hibernate.sql.results.graph.entity.internal.EntityAssembler;
import org.hibernate.sql.results.graph.entity.internal.EntityDelayedFetchInitializer;

public class EntityDelayedFetchImpl
extends AbstractNonJoinedEntityFetch {
    private final DomainResult<?> keyResult;
    private final boolean selectByUniqueKey;

    public EntityDelayedFetchImpl(FetchParent fetchParent, ToOneAttributeMapping fetchedAttribute, NavigablePath navigablePath, DomainResult<?> keyResult, boolean selectByUniqueKey) {
        super(navigablePath, fetchedAttribute, fetchParent);
        assert (fetchedAttribute.getNotFoundAction() == null);
        this.keyResult = keyResult;
        this.selectByUniqueKey = selectByUniqueKey;
    }

    @Override
    public FetchTiming getTiming() {
        return FetchTiming.DELAYED;
    }

    @Override
    public boolean hasTableGroup() {
        return false;
    }

    @Override
    public DomainResultAssembler<?> createAssembler(FetchParentAccess parentAccess, AssemblerCreationState creationState) {
        NavigablePath navigablePath = this.getNavigablePath();
        EntityInitializer entityInitializer = (EntityInitializer)creationState.resolveInitializer(navigablePath, this.getEntityValuedModelPart(), () -> new EntityDelayedFetchInitializer(parentAccess, navigablePath, (ToOneAttributeMapping)this.getEntityValuedModelPart(), this.selectByUniqueKey, this.keyResult.createResultAssembler(parentAccess, creationState)));
        return new EntityAssembler(this.getFetchedMapping().getJavaType(), entityInitializer);
    }
}

