/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity.internal;

import org.hibernate.engine.FetchTiming;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.spi.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.graph.entity.internal.AbstractNonJoinedEntityFetch;
import org.hibernate.sql.results.graph.entity.internal.BatchEntitySelectFetchInitializer;
import org.hibernate.sql.results.graph.entity.internal.EntityAssembler;
import org.hibernate.sql.results.graph.entity.internal.EntitySelectFetchByUniqueKeyInitializer;
import org.hibernate.sql.results.graph.entity.internal.EntitySelectFetchInitializer;

public class EntityFetchSelectImpl
extends AbstractNonJoinedEntityFetch {
    private final DomainResult<?> keyResult;
    private final boolean selectByUniqueKey;

    public EntityFetchSelectImpl(FetchParent fetchParent, ToOneAttributeMapping fetchedAttribute, NavigablePath navigablePath, DomainResult<?> keyResult, boolean selectByUniqueKey, DomainResultCreationState creationState) {
        super(navigablePath, fetchedAttribute, fetchParent);
        assert (fetchedAttribute.getNotFoundAction() == null);
        this.keyResult = keyResult;
        this.selectByUniqueKey = selectByUniqueKey;
    }

    @Override
    public FetchTiming getTiming() {
        return FetchTiming.IMMEDIATE;
    }

    @Override
    public boolean hasTableGroup() {
        return false;
    }

    @Override
    public DomainResultAssembler<?> createAssembler(FetchParentAccess parentAccess, AssemblerCreationState creationState) {
        EntityInitializer initializer = (EntityInitializer)creationState.resolveInitializer(this.getNavigablePath(), this.getFetchedMapping(), () -> {
            EntityPersister entityPersister = this.getReferencedMappingContainer().getEntityPersister();
            ToOneAttributeMapping fetchedAttribute = (ToOneAttributeMapping)this.getFetchedMapping();
            if (this.selectByUniqueKey) {
                return new EntitySelectFetchByUniqueKeyInitializer(parentAccess, fetchedAttribute, this.getNavigablePath(), entityPersister, this.keyResult.createResultAssembler(parentAccess, creationState));
            }
            if (entityPersister.isBatchLoadable()) {
                return new BatchEntitySelectFetchInitializer(parentAccess, fetchedAttribute, this.getNavigablePath(), entityPersister, this.keyResult.createResultAssembler(parentAccess, creationState));
            }
            return new EntitySelectFetchInitializer(parentAccess, fetchedAttribute, this.getNavigablePath(), entityPersister, this.keyResult.createResultAssembler(parentAccess, creationState));
        });
        return new EntityAssembler(this.getResultJavaType(), initializer);
    }
}

