/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity.internal;

import org.hibernate.FetchNotFoundException;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.query.spi.NavigablePath;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.type.descriptor.java.JavaType;

public class NotFoundSnapshotAssembler
implements DomainResultAssembler {
    private final NavigablePath navigablePath;
    private final ToOneAttributeMapping toOneMapping;
    private final DomainResultAssembler<?> keyValueAssembler;
    private final DomainResultAssembler<?> targetValueAssembler;

    public NotFoundSnapshotAssembler(NavigablePath navigablePath, ToOneAttributeMapping toOneMapping, DomainResultAssembler<?> keyValueAssembler, DomainResultAssembler<?> targetValueAssembler) {
        assert (toOneMapping.hasNotFoundAction());
        this.navigablePath = navigablePath;
        this.toOneMapping = toOneMapping;
        this.keyValueAssembler = keyValueAssembler;
        this.targetValueAssembler = targetValueAssembler;
    }

    public Object assemble(RowProcessingState rowProcessingState, JdbcValuesSourceProcessingOptions options) {
        Object keyValue = this.keyValueAssembler.assemble(rowProcessingState);
        Object targetValue = this.targetValueAssembler.assemble(rowProcessingState);
        if (keyValue != null && targetValue != null) {
            if (this.toOneMapping.getNotFoundAction() == NotFoundAction.IGNORE) {
                return null;
            }
            throw new FetchNotFoundException(this.toOneMapping.getAssociatedEntityMappingType().getEntityName(), keyValue);
        }
        return targetValue;
    }

    public JavaType<?> getAssembledJavaType() {
        return this.toOneMapping.getJavaType();
    }
}

