/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.instantiation.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.query.sqm.DynamicInstantiationNature;
import org.hibernate.query.sqm.sql.ConversionException;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.instantiation.internal.DynamicInstantiationArgument;
import org.hibernate.sql.results.graph.instantiation.internal.DynamicInstantiationResultImpl;
import org.hibernate.type.descriptor.java.JavaType;
import org.jboss.logging.Logger;

public class DynamicInstantiation<T>
implements DomainResultProducer {
    private static final Logger log = Logger.getLogger(DynamicInstantiation.class);
    private final DynamicInstantiationNature nature;
    private final JavaType<T> targetJavaType;
    private List<DynamicInstantiationArgument> arguments;
    private boolean argumentAdditionsComplete = false;

    public DynamicInstantiation(DynamicInstantiationNature nature, JavaType<T> targetJavaType) {
        this.nature = nature;
        this.targetJavaType = targetJavaType;
    }

    public DynamicInstantiationNature getNature() {
        return this.nature;
    }

    public JavaType<T> getTargetJavaType() {
        return this.targetJavaType;
    }

    public void addArgument(String alias, DomainResultProducer<?> argumentResultProducer, DomainResultCreationState creationState) {
        if (this.argumentAdditionsComplete) {
            throw new ConversionException("Unexpected call to DynamicInstantiation#addAgument after previously complete");
        }
        if (this.arguments == null) {
            this.arguments = new ArrayList<DynamicInstantiationArgument>();
        }
        if (List.class.equals(this.getTargetJavaType().getJavaTypeClass())) {
            if (alias != null && log.isDebugEnabled()) {
                log.debugf("Argument [%s] for dynamic List instantiation declared an 'injection alias' [%s] but such aliases are ignored for dynamic List instantiations", (Object)argumentResultProducer.toString(), (Object)alias);
            }
        } else if (Map.class.equals(this.getTargetJavaType().getJavaTypeClass()) && alias == null) {
            alias = Integer.toString(this.arguments.size());
        }
        this.arguments.add(new DynamicInstantiationArgument(argumentResultProducer, alias));
    }

    public void complete() {
        this.argumentAdditionsComplete = true;
    }

    public List<DynamicInstantiationArgument> getArguments() {
        return this.arguments;
    }

    public String toString() {
        return "DynamicInstantiation(" + this.getTargetJavaType().getJavaType().getTypeName() + ")";
    }

    public DomainResult createDomainResult(String resultVariable, DomainResultCreationState creationState) {
        return new DynamicInstantiationResultImpl<T>(resultVariable, this.getNature(), this.getTargetJavaType(), this.getArguments().stream().map(argument -> argument.buildArgumentDomainResult(creationState)).collect(Collectors.toList()));
    }

    @Override
    public void applySqlSelections(DomainResultCreationState creationState) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }
}

